/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.boxing;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.optimization.boxing.BoxedBasicValue;

public class RedundantBoxedValuesCollection
implements Iterable<BoxedBasicValue> {
    private final Set<BoxedBasicValue> safeToDeleteValues = new HashSet<BoxedBasicValue>();

    public void add(@NotNull BoxedBasicValue value2) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxedValuesCollection", "add"));
        }
        this.safeToDeleteValues.add(value2);
    }

    public void remove(@NotNull BoxedBasicValue value2) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxedValuesCollection", "remove"));
        }
        if (this.safeToDeleteValues.contains(value2)) {
            this.safeToDeleteValues.remove(value2);
            value2.markAsUnsafeToRemove();
            for (BoxedBasicValue mergedValue : value2.getMergedWith()) {
                this.remove(mergedValue);
            }
        }
    }

    public void merge(@NotNull BoxedBasicValue v, @NotNull BoxedBasicValue w) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxedValuesCollection", "merge"));
        }
        if (w == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "w", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxedValuesCollection", "merge"));
        }
        v.addMergedWith(w);
        w.addMergedWith(v);
        if (v.isSafeToRemove() && !w.isSafeToRemove()) {
            this.remove(v);
        }
        if (!v.isSafeToRemove() && w.isSafeToRemove()) {
            this.remove(w);
        }
    }

    public boolean isEmpty() {
        return this.safeToDeleteValues.isEmpty();
    }

    @Override
    @NotNull
    public Iterator<BoxedBasicValue> iterator() {
        Iterator<BoxedBasicValue> iterator2 = this.safeToDeleteValues.iterator();
        if (iterator2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxedValuesCollection", "iterator"));
        }
        return iterator2;
    }
}

