/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.typeEnhacement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.PreconditionsKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.annotations.CompositeAnnotations;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.load.java.typeEnhacement.EnhancedTypeAnnotations;
import org.jetbrains.kotlin.load.java.typeEnhacement.EnhancementResult;
import org.jetbrains.kotlin.load.java.typeEnhacement.JavaTypeQualifiers;
import org.jetbrains.kotlin.load.java.typeEnhacement.MutabilityQualifier;
import org.jetbrains.kotlin.load.java.typeEnhacement.NullabilityQualifier;
import org.jetbrains.kotlin.load.java.typeEnhacement.Result;
import org.jetbrains.kotlin.load.java.typeEnhacement.TypeComponentPosition;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.platform.JavaToKotlinClassMap;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.DelegatingFlexibleType;
import org.jetbrains.kotlin.types.Flexibility;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeImpl;
import org.jetbrains.kotlin.types.TypeCapabilities;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitution;
import org.jetbrains.kotlin.types.TypeSubstitutionKt;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.utils.CollectionsKt;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"K\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\t\u0001\u0002E\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0005\u0005\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0005!1!B\u0001\t\f\u0015\tA!AG\u000b\t\u0005A!!D\u0001\u0019\u0006U!\u0011BA\u0005\u00021\u000bA2\u0001V\u0002\u0002\u001bIA9!D\u0001\u0019\tU\t\u0001\u0004BM\u000b\u0011\u0013iq!\u0003\u0002\n\u0003a-\u0011BA\u0005\u00021\u0019AR\u0001UB\u0001)\u000e\tQB\b\u0003\u0002\u0011\u001bi\u0011\u0001G\u0004\u0016\u0003a!\u0011T\u0003E\u0005\u001b\u001dI!!C\u0001\u0019\f%\u0011\u0011\"\u0001\r\u00071\u0015\u00016\u0011AM\u0005\u0011\u001fi\u0011\u0001g\u0003Q\u0007\u0005IJ\u0001\u0003\u0005\u000e\u0003aE\u0001ka\u0001U\u0007\u0005iY\u0003B\u0001\t\u00135!\u0011BA\u0005\u00021)A\u001a\"F\u0001\u0019\u0015e%\u0001\u0012B\u0007\u00021\u0019\u00016\u0011AM\u0005\u0011!i\u0011\u0001'\u0005Q\u0007\u0005!6!AG\u0019\t\u0005A)\"D\u0001\u0019\u000fU\t\u0001\u0004BM\u000b\u0011\u0013iq!\u0003\u0002\n\u0003a-\u0011BA\u0005\u00021\u0019AR\u0001UB\u00013\u0013Ay!D\u0001\u0019\fA\u001b\u0011\u0001V\u0002\u0002\u001bA!\u0011\u0001C\u0006\u000e\t%\u0011\u0011\"\u0001S\f1'\t\"\u0001\u0002\u0001\t\u0018U\tAuC)\u0004\u0003!aAkA\u0001\u000e!\u0011\t\u0001\u0012D\u0007\u0005\u0013\tI\u0011\u0001j\u0006\u0019\u0014E\u0011A\u0001\u0001E\f+\u0005!;\"U\u0002\u0002\u00111!6!AG\u0016\t\u0005AQ\"\u0004\u0003\n\u0005%\t\u00014\u0004M\n+\u0005AB!'\u0003\t\n5\t\u0001D\u0002)\u0004\u0002e%\u0001\u0002C\u0007\u00021#\u00016!\u0001+\u0004\u00035\u0001B!\u0001\u0005\u000f\u001b\u0011I!!C\u0001%\u0018aM\u0011C\u0001\u0003\u0001\u0011/)\u0012\u0001j\u0006R\u0007\u0005AA\u0002V\u0002\u0002\u001b\u001f!\u0011\u0001#\b\u000e\u0003amQ#\u0001M\t)\u000e\t\u0011\u0013\u0003\u0003B\u0011!\u0001Q\"\u0001M\u0001#\u000e\tQ\u0001\u0001+\u0004\u0003EEA!\u0011\u0005\t\u00045\t\u0001\u0014A)\u0004\u0003\u0015\u0001AkA\u0001"}, strings={"ENHANCED_MUTABILITY_ANNOTATIONS", "Lorg/jetbrains/kotlin/load/java/typeEnhacement/EnhancedTypeAnnotations;", "TypeEnhancementKt", "ENHANCED_NULLABILITY_ANNOTATIONS", "compositeAnnotationsOrSingle", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "", "enhance", "Lorg/jetbrains/kotlin/types/KotlinType;", "qualifiers", "Lkotlin/Function1;", "", "Lorg/jetbrains/kotlin/load/java/typeEnhacement/JavaTypeQualifiers;", "enhanceInflexible", "Lorg/jetbrains/kotlin/load/java/typeEnhacement/Result;", "index", "position", "Lorg/jetbrains/kotlin/load/java/typeEnhacement/TypeComponentPosition;", "enhanceMutability", "Lorg/jetbrains/kotlin/load/java/typeEnhacement/EnhancementResult;", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "enhancePossiblyFlexible", "enhancedMutability", "T", "(Ljava/lang/Object;)Lorg/jetbrains/kotlin/load/java/typeEnhacement/EnhancementResult;", "enhancedNullability", "getEnhancedNullability", "", "noChange", "shouldEnhance"}, moduleName="kotlin-compiler")
public final class TypeEnhancementKt {
    private static final EnhancedTypeAnnotations ENHANCED_NULLABILITY_ANNOTATIONS;
    private static final EnhancedTypeAnnotations ENHANCED_MUTABILITY_ANNOTATIONS;

    @NotNull
    public static final KotlinType enhance(KotlinType $receiver, @NotNull Function1<? super Integer, ? extends JavaTypeQualifiers> qualifiers) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(qualifiers, "qualifiers");
        return TypeEnhancementKt.enhancePossiblyFlexible($receiver, qualifiers, 0).getType();
    }

    /*
     * WARNING - void declaration
     */
    private static final Result enhancePossiblyFlexible(KotlinType $receiver, Function1<? super Integer, ? extends JavaTypeQualifiers> qualifiers, int index2) {
        Result result2;
        if ($receiver.isError()) {
            return new Result($receiver, 1);
        }
        if (FlexibleTypesKt.isFlexible($receiver)) {
            Unit unit;
            Flexibility receiver = FlexibleTypesKt.flexibility($receiver);
            Flexibility $receiver2 = receiver;
            Result lowerResult = TypeEnhancementKt.enhanceInflexible($receiver2.getLowerBound(), qualifiers, index2, TypeComponentPosition.FLEXIBLE_LOWER);
            Result upperResult = TypeEnhancementKt.enhanceInflexible($receiver2.getUpperBound(), qualifiers, index2, TypeComponentPosition.FLEXIBLE_UPPER);
            boolean bl = lowerResult.getSubtreeSize() == upperResult.getSubtreeSize();
            if (PreconditionsKt.getASSERTIONS_ENABLED()) {
                void value2;
                if (value2 == false) {
                    String message = "Different tree sizes of bounds: " + ("lower = (" + $receiver2.getLowerBound() + ", " + lowerResult.getSubtreeSize() + "), ") + ("upper = (" + $receiver2.getUpperBound() + ", " + upperResult.getSubtreeSize() + ")");
                    throw (Throwable)((Object)new AssertionError((Object)message));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
            result2 = new Result(DelegatingFlexibleType.Companion.create(lowerResult.getType(), upperResult.getType(), $receiver2.getExtraCapabilities()), lowerResult.getSubtreeSize());
        } else {
            result2 = TypeEnhancementKt.enhanceInflexible($receiver, qualifiers, index2, TypeComponentPosition.INFLEXIBLE);
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private static final Result enhanceInflexible(KotlinType $receiver, Function1<? super Integer, ? extends JavaTypeQualifiers> qualifiers, int index2, TypeComponentPosition position) {
        void enhancedNullability;
        void enhancedNullabilityAnnotations;
        void enhancedMutabilityAnnotations;
        void globalArgIndex;
        EnhancementResult<Boolean> destination;
        Annotations $receiver2;
        void $receiver222;
        void enhancedClassifier;
        boolean shouldEnhance = TypeEnhancementKt.shouldEnhance(position);
        if (!shouldEnhance && $receiver.getArguments().isEmpty()) {
            return new Result($receiver, 1);
        }
        ClassifierDescriptor classifierDescriptor = $receiver.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            return new Result($receiver, 1);
        }
        ClassifierDescriptor originalClass = classifierDescriptor;
        JavaTypeQualifiers effectiveQualifiers = qualifiers.invoke((Integer)index2);
        EnhancementResult<ClassifierDescriptor> enhancementResult = TypeEnhancementKt.enhanceMutability(originalClass, effectiveQualifiers, position);
        ClassifierDescriptor classifierDescriptor2 = enhancementResult.component1();
        Annotations annotations2 = enhancementResult.component2();
        enhancementResult = null;
        TypeConstructor typeConstructor2 = enhancedClassifier.getTypeConstructor();
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = index2 + 1;
        Iterable iterable = $receiver.getArguments();
        void var13_13 = $receiver222;
        Collection collection = new ArrayList(kotlin.CollectionsKt.collectionSizeOrDefault($receiver222, 10));
        int index3 = 0;
        for (Object item : $receiver2) {
            TypeProjection typeProjection;
            void localArgIndex;
            void arg;
            int n = index3++;
            TypeProjection typeProjection2 = (TypeProjection)item;
            int n2 = n;
            void var26_24 = destination;
            if (arg.isStarProjection()) {
                int n3 = globalArgIndex.element++;
                typeProjection = TypeUtils.makeStarProjection(enhancedClassifier.getTypeConstructor().getParameters().get((int)localArgIndex));
            } else {
                void enhancedType;
                void subtreeSize;
                Result result2 = TypeEnhancementKt.enhancePossiblyFlexible(arg.getType(), qualifiers, globalArgIndex.element);
                KotlinType kotlinType = result2.component1();
                int n4 = result2.component2();
                result2 = null;
                globalArgIndex.element += subtreeSize;
                Variance variance = arg.getProjectionKind();
                Intrinsics.checkExpressionValueIsNotNull((Object)variance, "arg.projectionKind");
                typeProjection = TypeUtilsKt.createProjection((KotlinType)enhancedType, variance, typeConstructor2.getParameters().get((int)localArgIndex));
            }
            TypeProjection typeProjection3 = typeProjection;
            var26_24.add(typeProjection3);
        }
        List enhancedArguments = (List)((Object)destination);
        destination = TypeEnhancementKt.getEnhancedNullability($receiver, effectiveQualifiers, position);
        boolean $receiver222 = destination.component1();
        $receiver2 = destination.component2();
        destination = null;
        Annotations newAnnotations = TypeEnhancementKt.compositeAnnotationsOrSingle(kotlin.CollectionsKt.filterNotNull((Iterable)kotlin.CollectionsKt.listOf($receiver.getAnnotations(), enhancedMutabilityAnnotations, enhancedNullabilityAnnotations)));
        List<TypeParameterDescriptor> list = typeConstructor2.getParameters();
        Intrinsics.checkExpressionValueIsNotNull(list, "typeConstructor.parameters");
        TypeSubstitution newSubstitution = TypeSubstitutionKt.computeNewSubstitution($receiver, list, enhancedArguments);
        TypeConstructor typeConstructor3 = typeConstructor2;
        Intrinsics.checkExpressionValueIsNotNull(typeConstructor3, "typeConstructor");
        MemberScope memberScope2 = enhancedClassifier instanceof ClassDescriptor ? ((ClassDescriptor)enhancedClassifier).getMemberScope(newSubstitution) : enhancedClassifier.getDefaultType().getMemberScope();
        Intrinsics.checkExpressionValueIsNotNull(memberScope2, "if (enhancedClassifier i\u2026ltType().getMemberScope()");
        TypeCapabilities typeCapabilities = $receiver.getCapabilities();
        Intrinsics.checkExpressionValueIsNotNull(typeCapabilities, "capabilities");
        KotlinTypeImpl enhancedType = KotlinTypeImpl.Companion.create(newAnnotations, typeConstructor3, (boolean)enhancedNullability, enhancedArguments, newSubstitution, memberScope2, typeCapabilities);
        return new Result(enhancedType, globalArgIndex.element - index2);
    }

    private static final Annotations compositeAnnotationsOrSingle(List<? extends Annotations> $receiver) {
        Annotations annotations2;
        Collection $receiver2 = $receiver;
        switch ($receiver2.size()) {
            case 0: {
                annotations2 = (Annotations)((Object)PreconditionsKt.error("At least one Annotations object expected"));
                break;
            }
            case 1: {
                annotations2 = kotlin.CollectionsKt.single($receiver);
                break;
            }
            default: {
                annotations2 = new CompositeAnnotations(CollectionsKt.toReadOnlyList((Collection)$receiver));
            }
        }
        return annotations2;
    }

    private static final boolean shouldEnhance(TypeComponentPosition $receiver) {
        return Intrinsics.areEqual((Object)$receiver, (Object)TypeComponentPosition.INFLEXIBLE) ^ true;
    }

    private static final <T> EnhancementResult<T> noChange(T $receiver) {
        return new EnhancementResult<T>($receiver, null);
    }

    private static final <T> EnhancementResult<T> enhancedNullability(T $receiver) {
        return new EnhancementResult<T>($receiver, ENHANCED_NULLABILITY_ANNOTATIONS);
    }

    private static final <T> EnhancementResult<T> enhancedMutability(T $receiver) {
        return new EnhancementResult<T>($receiver, ENHANCED_MUTABILITY_ANNOTATIONS);
    }

    private static final EnhancementResult<ClassifierDescriptor> enhanceMutability(ClassifierDescriptor $receiver, JavaTypeQualifiers qualifiers, TypeComponentPosition position) {
        if (!TypeEnhancementKt.shouldEnhance(position)) {
            return TypeEnhancementKt.noChange($receiver);
        }
        if (!($receiver instanceof ClassDescriptor)) {
            return TypeEnhancementKt.noChange($receiver);
        }
        JavaToKotlinClassMap mapping = JavaToKotlinClassMap.INSTANCE;
        MutabilityQualifier mutabilityQualifier = qualifiers.getMutability();
        if (Intrinsics.areEqual((Object)mutabilityQualifier, (Object)MutabilityQualifier.READ_ONLY)) {
            if (Intrinsics.areEqual((Object)position, (Object)TypeComponentPosition.FLEXIBLE_LOWER) && mapping.isMutable((ClassDescriptor)$receiver)) {
                return TypeEnhancementKt.enhancedMutability(mapping.convertMutableToReadOnly((ClassDescriptor)$receiver));
            }
        } else if (Intrinsics.areEqual((Object)mutabilityQualifier, (Object)MutabilityQualifier.MUTABLE) && Intrinsics.areEqual((Object)position, (Object)TypeComponentPosition.FLEXIBLE_UPPER) && mapping.isReadOnly((ClassDescriptor)$receiver)) {
            return TypeEnhancementKt.enhancedMutability(mapping.convertReadOnlyToMutable((ClassDescriptor)$receiver));
        }
        return TypeEnhancementKt.noChange($receiver);
    }

    private static final EnhancementResult<Boolean> getEnhancedNullability(KotlinType $receiver, JavaTypeQualifiers qualifiers, TypeComponentPosition position) {
        if (!TypeEnhancementKt.shouldEnhance(position)) {
            return TypeEnhancementKt.noChange($receiver.isMarkedNullable());
        }
        NullabilityQualifier nullabilityQualifier = qualifiers.getNullability();
        return Intrinsics.areEqual((Object)nullabilityQualifier, (Object)NullabilityQualifier.NULLABLE) ? TypeEnhancementKt.enhancedNullability(true) : (Intrinsics.areEqual((Object)nullabilityQualifier, (Object)NullabilityQualifier.NOT_NULL) ? TypeEnhancementKt.enhancedNullability(false) : TypeEnhancementKt.noChange($receiver.isMarkedNullable()));
    }

    static {
        FqName fqName2 = JvmAnnotationNames.ENHANCED_NULLABILITY_ANNOTATION;
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "JvmAnnotationNames.ENHANCED_NULLABILITY_ANNOTATION");
        ENHANCED_NULLABILITY_ANNOTATIONS = new EnhancedTypeAnnotations(fqName2);
        FqName fqName3 = JvmAnnotationNames.ENHANCED_MUTABILITY_ANNOTATION;
        Intrinsics.checkExpressionValueIsNotNull(fqName3, "JvmAnnotationNames.ENHANCED_MUTABILITY_ANNOTATION");
        ENHANCED_MUTABILITY_ANNOTATIONS = new EnhancedTypeAnnotations(fqName3);
    }
}

