/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import com.intellij.psi.PsiElement;
import java.util.Iterator;
import java.util.Map;
import kotlin.CollectionsKt;
import kotlin.MapsKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.load.java.components.JavaAnnotationMapper;
import org.jetbrains.kotlin.load.java.descriptors.JavaConstructorDescriptor;
import org.jetbrains.kotlin.load.kotlin.AnnotationUtilKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.types.KotlinType;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"=\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!!!B\u0001\t'\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA\"\u0001\u0007\u00013\u0005A\n!)\u0002R\u0007\u0005A\u0011!\n\u000b\u0005\u0017!\rQ\"\u0001\r\u0003#\u0011!\u0001\u0001#\u0002\u0016\u0003a\u0019\u0011D\u0002E\u0004\u001b\u0011I!!C\u0001%\u0006a!\u0011d\u0001E\u0005\u001b\u0005AR!\n\b\u0005\u0003!-Q\"\u0001\r\u00033\u0015A9!D\u0002\n\u0003\u0011\r\u0001\u0004B\r\u0004\u0011\u0013i\u0011\u0001G\u0003&\u001d\u0011\t\u0001BB\u0007\u00021\tIR\u0001c\u0002\u000e\u0007%\tA1\u0001\r\u00053\rAI!D\u0001\u0019\u000b\u0015JB!\u0001E\u0007\u001b\u0005A\"!G\u0002\t\n5\t\u0001$B\r\n\u0011\u001diq!\u0003\u0002\n\u0003aA\u0011BA\u0005\u00021#Az!\u0007\u0004\t\u00135!\u0011BA\u0005\u00021)A\u001a\u0002"}, strings={"Lorg/jetbrains/kotlin/load/kotlin/JavaAnnotationCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "F", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;", "reportDeprecatedJavaAnnotation", "reportErrorsOnPositionedArguments", "reportOnValueArgument", "argument", "", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedValueArgument;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory0;", "Lorg/jetbrains/kotlin/psi/KtExpression;"}, moduleName="kotlin-compiler")
public final class JavaAnnotationCallChecker
implements CallChecker {
    @Override
    public <F extends CallableDescriptor> void check(@NotNull ResolvedCall<F> resolvedCall, @NotNull BasicCallResolutionContext context) {
        Intrinsics.checkParameterIsNotNull(resolvedCall, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(context, "context");
        CallableDescriptor resultingDescriptor2 = resolvedCall.getResultingDescriptor().getOriginal();
        if (!(resultingDescriptor2 instanceof JavaConstructorDescriptor) || Intrinsics.areEqual((Object)((JavaConstructorDescriptor)resultingDescriptor2).getContainingDeclaration().getKind(), (Object)ClassKind.ANNOTATION_CLASS) ^ true) {
            return;
        }
        this.reportErrorsOnPositionedArguments(resolvedCall, context);
        this.reportDeprecatedJavaAnnotation(resolvedCall, context);
    }

    private final void reportDeprecatedJavaAnnotation(ResolvedCall<?> resolvedCall, BasicCallResolutionContext context) {
        Unit unit;
        FqName fqName2;
        Object it2;
        FqName $receiver;
        KtElement ktElement = resolvedCall.getCall().getCallElement();
        if (!(ktElement instanceof KtAnnotationEntry)) {
            ktElement = null;
        }
        KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)ktElement;
        if (ktAnnotationEntry == null) {
            return;
        }
        KtAnnotationEntry annotationEntry = ktAnnotationEntry;
        KotlinType kotlinType = (KotlinType)context.trace.get(BindingContext.TYPE, annotationEntry.getTypeReference());
        if (kotlinType == null) {
            return;
        }
        KotlinType type2 = kotlinType;
        Map<FqName, FqName> map2 = JavaAnnotationMapper.INSTANCE.getJavaToKotlinNameMap();
        ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor != null) {
            ClassifierDescriptor classifierDescriptor2 = classifierDescriptor;
            Map<FqName, FqName> map3 = map2;
            it2 = (ClassifierDescriptor)((Object)$receiver);
            FqName fqName3 = DescriptorUtils.getFqNameSafe((DeclarationDescriptor)it2);
            map2 = map3;
            fqName2 = fqName3;
        } else {
            fqName2 = null;
        }
        FqName fqName4 = CollectionsKt.get(map2, fqName2);
        if (fqName4 != null) {
            $receiver = fqName4;
            it2 = $receiver;
            context.trace.report(ErrorsJvm.DEPRECATED_JAVA_ANNOTATION.on((KtAnnotationEntry)((PsiElement)annotationEntry), (FqName)it2));
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
    }

    private final void reportErrorsOnPositionedArguments(ResolvedCall<?> resolvedCall, BasicCallResolutionContext context) {
        Map<ValueParameterDescriptor, ResolvedValueArgument> $receiver = AnnotationUtilKt.getJavaAnnotationCallValueArgumentsThatShouldBeNamed(resolvedCall);
        Iterator<Map.Entry<ValueParameterDescriptor, ResolvedValueArgument>> iterator2 = MapsKt.iterator($receiver);
        while (iterator2.hasNext()) {
            Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> element;
            Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> it2 = element = iterator2.next();
            DiagnosticFactory0<KtExpression> diagnosticFactory0 = ErrorsJvm.POSITIONED_VALUE_ARGUMENT_FOR_JAVA_ANNOTATION;
            Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory0, "ErrorsJvm.POSITIONED_VAL\u2026UMENT_FOR_JAVA_ANNOTATION");
            this.reportOnValueArgument(context, it2, diagnosticFactory0);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void reportOnValueArgument(BasicCallResolutionContext context, Map.Entry<? extends ValueParameterDescriptor, ? extends ResolvedValueArgument> argument, DiagnosticFactory0<KtExpression> diagnostic) {
        void $receiver;
        Iterable iterable = CollectionsKt.getValue(argument).getArguments();
        for (Object element : $receiver) {
            ValueArgument it2 = (ValueArgument)element;
            if (it2.getArgumentExpression() == null) continue;
            BindingTrace bindingTrace = context.trace;
            KtExpression ktExpression = it2.getArgumentExpression();
            if (ktExpression == null) {
                Intrinsics.throwNpe();
            }
            bindingTrace.report(diagnostic.on((KtExpression)((PsiElement)ktExpression)));
        }
    }
}

