/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.PreconditionsKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.KotlinLookupLocation;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtMultiDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypedef;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BodyResolver;
import org.jetbrains.kotlin.resolve.DeclarationResolver;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.IdentifierChecker;
import org.jetbrains.kotlin.resolve.OverloadResolver;
import org.jetbrains.kotlin.resolve.OverrideResolver;
import org.jetbrains.kotlin.resolve.QualifiedExpressionResolver;
import org.jetbrains.kotlin.resolve.TopDownAnalysisContext;
import org.jetbrains.kotlin.resolve.TopDownAnalysisMode;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.lazy.DeclarationScopeProvider;
import org.jetbrains.kotlin.resolve.lazy.FileScopeProvider;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.lazy.ImportResolver;
import org.jetbrains.kotlin.resolve.lazy.LazyDeclarationResolver;
import org.jetbrains.kotlin.resolve.lazy.TopLevelDescriptorProvider;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyClassDescriptor;
import org.jetbrains.kotlin.resolve.varianceChecker.VarianceChecker;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"-\u0004)\u0011\u0001D\u0001\u0006\u0003!\u0001Q\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u0003!yQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001\"A\u0003\u0002\t\u0005)\u0011\u0001\u0003\t\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\r\u0001e\t\u0001\u0014AQ7\u0013\rA\u0011!D\u0001\u0019\u0004%\u0019\u0001BA\u0007\u00021\u000bI1\u0001C\u0002\u000e\u0003a\u001d\u0011b\u0001\u0005\u0005\u001b\u0005AJ!C\u0002\t\u000b5\t\u00014B\u0005\u0004\u0011\u0019i\u0011\u0001'\u0004\n\u0007!9Q\"\u0001M\b\u0013\rA\u0001\"D\u0001\u0019\u0012%\u0019\u0001\"C\u0007\u00021'I1\u0001\u0003\u0006\u000e\u0003aU\u0011b\u0001\u0005\f\u001b\u0005A:\"C\u0002\t\u00195\t\u0001\u0014D\u0005\u0004\u00115i\u0011\u0001g\u0007R\u0007\u0005Aa\"\n\n\t\u001e5\t\u0001dD\r\u0004\u0011?i\u0011\u0001\u0007\t\u001a\r!\u0005R\u0002B\u0005\u0003\u0013\u0005A\u001a\u0003G\t\u001a\u0007!\u0011R\"\u0001M\u0013K=!\u0011\u0001C\n\u000e\u0003a\u001d\u0012d\u0001\u0005\u0015\u001b\u0005Ar\"\u0007\u0004\t*5!\u0011BA\u0005\u00021WAR#J\r\u0005\u0003!1R\"\u0001M\u00143\rAA#D\u0001\u0019\u001feI\u0001RF\u0007\b\u0013\tI\u0011\u0001g\f\n\u0005%\t\u0001\u0004\u0007\r\u00183\u0019A\t$\u0004\u0003\n\u0005%\t\u0001$\u0007\r\u0016KY!\u0011\u0001c\r\u000e\u0003a\u001d\u0012$\u0003E\u0017\u001b\u001dI!!C\u0001\u00190%\u0011\u0011\"\u0001\r\u00191]I2\u0001\u0003\u000e\u000e\u0003aU\u0012d\u0001\u0005\u001c\u001b\u0005A:$\n\u0005\u0005\u0003!aR\"\u0001M\u00143\rAA#D\u0001\u0019\u001f%:A!\u0011\u0005\t\u00115\t\u0001\u0014C)\u0004\u0003\u0015\u0001\u0011f\u0002\u0003B\u0011!\u0011Q\"\u0001M\u0003#\u000e\tQ\u0001A\u0015\b\t\u0005C\u0001bC\u0007\u00021/\t6!A\u0003\u0001S\u001d!\u0011\t\u0003\u0005\u000b\u001b\u0005A*\"U\u0002\u0002\u000b\u0001Is\u0001B!\t\u00115i\u0011\u0001g\u0007R\u0007\u0005)\u0001!K\u0004\u0005\u0003\"Aq!D\u0001\u0019\u0010E\u001b\u0011!\u0002\u0001*\u000f\u0011\t\u0005\u0002\u0003\u0004\u000e\u0003a5\u0011kA\u0001\u0006\u0001%:A!\u0011\u0005\t\t5\t\u0001\u0014B)\u0004\u0003\u0015\u0001\u0011f\u0002\u0003B\u0011!\u0019Q\"\u0001M\u0004#\u000e\tQ\u0001A\u0015\b\t\u0005C\u0001\u0002D\u0007\u000213\t6!A\u0003\u0001S\u001d!\u0011\t\u0003\u0005\n\u001b\u0005A\u001a\"U\u0002\u0002\u000b\u0001Is\u0001B!\t\u0011\u0005i\u0011\u0001g\u0001R\u0007\u0005)\u0001!K\u0004\u0005\u0003\"AQ!D\u0001\u0019\fE\u001b\u0011!\u0002\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/LazyTopDownAnalyzer;", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "declarationResolver", "Lorg/jetbrains/kotlin/resolve/DeclarationResolver;", "overrideResolver", "Lorg/jetbrains/kotlin/resolve/OverrideResolver;", "overloadResolver", "Lorg/jetbrains/kotlin/resolve/OverloadResolver;", "varianceChecker", "Lorg/jetbrains/kotlin/resolve/varianceChecker/VarianceChecker;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "lazyDeclarationResolver", "Lorg/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver;", "bodyResolver", "Lorg/jetbrains/kotlin/resolve/BodyResolver;", "topLevelDescriptorProvider", "Lorg/jetbrains/kotlin/resolve/lazy/TopLevelDescriptorProvider;", "fileScopeProvider", "Lorg/jetbrains/kotlin/resolve/lazy/FileScopeProvider;", "declarationScopeProvider", "Lorg/jetbrains/kotlin/resolve/lazy/DeclarationScopeProvider;", "qualifiedExpressionResolver", "Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver;", "identifierChecker", "Lorg/jetbrains/kotlin/resolve/IdentifierChecker;", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/resolve/DeclarationResolver;Lorg/jetbrains/kotlin/resolve/OverrideResolver;Lorg/jetbrains/kotlin/resolve/OverloadResolver;Lorg/jetbrains/kotlin/resolve/varianceChecker/VarianceChecker;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver;Lorg/jetbrains/kotlin/resolve/BodyResolver;Lorg/jetbrains/kotlin/resolve/lazy/TopLevelDescriptorProvider;Lorg/jetbrains/kotlin/resolve/lazy/FileScopeProvider;Lorg/jetbrains/kotlin/resolve/lazy/DeclarationScopeProvider;Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver;Lorg/jetbrains/kotlin/resolve/IdentifierChecker;)V", "analyzeDeclarations", "Lorg/jetbrains/kotlin/resolve/TopDownAnalysisContext;", "topDownAnalysisMode", "Lorg/jetbrains/kotlin/resolve/TopDownAnalysisMode;", "declarations", "", "Lcom/intellij/psi/PsiElement;", "outerDataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "createFunctionDescriptors", "", "c", "functions", "", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "createPropertyDescriptors", "topLevelFqNames", "Lcom/google/common/collect/Multimap;", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/psi/KtElement;", "properties", "Lorg/jetbrains/kotlin/psi/KtProperty;", "registerTopLevelFqName", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "resolveAllHeadersInClasses"}, moduleName="kotlin-compiler")
public final class LazyTopDownAnalyzer {
    private final BindingTrace trace;
    private final DeclarationResolver declarationResolver;
    private final OverrideResolver overrideResolver;
    private final OverloadResolver overloadResolver;
    private final VarianceChecker varianceChecker;
    private final ModuleDescriptor moduleDescriptor;
    private final LazyDeclarationResolver lazyDeclarationResolver;
    private final BodyResolver bodyResolver;
    private final TopLevelDescriptorProvider topLevelDescriptorProvider;
    private final FileScopeProvider fileScopeProvider;
    private final DeclarationScopeProvider declarationScopeProvider;
    private final QualifiedExpressionResolver qualifiedExpressionResolver;
    private final IdentifierChecker identifierChecker;

    @NotNull
    public final TopDownAnalysisContext analyzeDeclarations(@NotNull TopDownAnalysisMode topDownAnalysisMode, @NotNull Collection<? extends PsiElement> declarations, @NotNull DataFlowInfo outerDataFlowInfo) {
        Intrinsics.checkParameterIsNotNull((Object)topDownAnalysisMode, "topDownAnalysisMode");
        Intrinsics.checkParameterIsNotNull(declarations, "declarations");
        Intrinsics.checkParameterIsNotNull(outerDataFlowInfo, "outerDataFlowInfo");
        TopDownAnalysisContext c = new TopDownAnalysisContext(topDownAnalysisMode, outerDataFlowInfo, this.declarationScopeProvider);
        HashMultimap topLevelFqNames = HashMultimap.create();
        ArrayList properties2 = new ArrayList();
        ArrayList functions2 = new ArrayList();
        for (PsiElement psiElement2 : declarations) {
            psiElement2.accept(new KtVisitorVoid(this, c, topLevelFqNames, functions2, properties2){
                final /* synthetic */ LazyTopDownAnalyzer this$0;
                final /* synthetic */ TopDownAnalysisContext $c;
                final /* synthetic */ HashMultimap $topLevelFqNames;
                final /* synthetic */ ArrayList $functions;
                final /* synthetic */ ArrayList $properties;

                private final void registerDeclarations(List<? extends KtDeclaration> declarations) {
                    for (KtDeclaration ktDeclaration : declarations) {
                        ktDeclaration.accept(this);
                    }
                }

                public void visitDeclaration(@NotNull KtDeclaration dcl) {
                    Intrinsics.checkParameterIsNotNull(dcl, "dcl");
                    throw (Throwable)new IllegalArgumentException("Unsupported declaration: " + dcl + " " + dcl.getText());
                }

                public void visitKtFile(@NotNull KtFile file) {
                    Intrinsics.checkParameterIsNotNull(file, "file");
                    if (file.isScript()) {
                        KtScript ktScript = file.getScript();
                        if (ktScript == null) {
                            throw (Throwable)((Object)new AssertionError((Object)("getScript() is null for file: " + file)));
                        }
                        KtScript script = ktScript;
                        DescriptorResolver.registerFileInPackage(LazyTopDownAnalyzer.access$getTrace$p(this.this$0), file);
                        Map<KtScript, ScriptDescriptor> map2 = this.$c.getScripts();
                        TopLevelDescriptorProvider topLevelDescriptorProvider = LazyTopDownAnalyzer.access$getTopLevelDescriptorProvider$p(this.this$0);
                        KtScript ktScript2 = script;
                        Intrinsics.checkExpressionValueIsNotNull(ktScript2, "script");
                        map2.put(script, topLevelDescriptorProvider.getScriptDescriptor(ktScript2));
                    } else {
                        Unit unit;
                        KtPackageDirective packageDirective = file.getPackageDirective();
                        boolean value2 = packageDirective != null;
                        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
                            if (!value2) {
                                String message = "No package in a non-script file: " + file;
                                throw (Throwable)((Object)new AssertionError((Object)message));
                            }
                            unit = Unit.INSTANCE;
                        } else {
                            unit = Unit.INSTANCE;
                        }
                        this.$c.addFile(file);
                        KtPackageDirective ktPackageDirective = packageDirective;
                        if (ktPackageDirective == null) {
                            Intrinsics.throwNpe();
                        }
                        ktPackageDirective.accept(this);
                        DescriptorResolver.registerFileInPackage(LazyTopDownAnalyzer.access$getTrace$p(this.this$0), file);
                        List<KtDeclaration> list = file.getDeclarations();
                        Intrinsics.checkExpressionValueIsNotNull(list, "file.getDeclarations()");
                        this.registerDeclarations(list);
                        this.$topLevelFqNames.put(file.getPackageFqName(), packageDirective);
                    }
                }

                public void visitPackageDirective(@NotNull KtPackageDirective directive) {
                    Intrinsics.checkParameterIsNotNull(directive, "directive");
                    Iterable $receiver = directive.getPackageNames();
                    for (T element : $receiver) {
                        KtSimpleNameExpression it2 = (KtSimpleNameExpression)element;
                        LazyTopDownAnalyzer.access$getIdentifierChecker$p(this.this$0).checkIdentifier(it2.getIdentifier(), LazyTopDownAnalyzer.access$getTrace$p(this.this$0));
                    }
                    LazyTopDownAnalyzer.access$getQualifiedExpressionResolver$p(this.this$0).resolvePackageHeader(directive, LazyTopDownAnalyzer.access$getModuleDescriptor$p(this.this$0), LazyTopDownAnalyzer.access$getTrace$p(this.this$0));
                }

                public void visitImportDirective(@NotNull KtImportDirective importDirective) {
                    Intrinsics.checkParameterIsNotNull(importDirective, "importDirective");
                    FileScopeProvider fileScopeProvider = LazyTopDownAnalyzer.access$getFileScopeProvider$p(this.this$0);
                    KtFile ktFile = importDirective.getContainingKtFile();
                    Intrinsics.checkExpressionValueIsNotNull(ktFile, "importDirective.getContainingKtFile()");
                    ImportResolver importResolver2 = fileScopeProvider.getImportResolver(ktFile);
                    importResolver2.forceResolveImport(importDirective);
                }

                public void visitClassOrObject(@NotNull KtClassOrObject classOrObject) {
                    Intrinsics.checkParameterIsNotNull(classOrObject, "classOrObject");
                    LookupLocation location2 = classOrObject.isTopLevel() ? (LookupLocation)new KotlinLookupLocation(classOrObject) : (LookupLocation)NoLookupLocation.WHEN_RESOLVE_DECLARATION;
                    ClassDescriptor classDescriptor = LazyTopDownAnalyzer.access$getLazyDeclarationResolver$p(this.this$0).getClassDescriptor(classOrObject, location2);
                    if (classDescriptor == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes");
                    }
                    ClassDescriptorWithResolutionScopes descriptor2 = (ClassDescriptorWithResolutionScopes)classDescriptor;
                    this.$c.getDeclaredClasses().put(classOrObject, descriptor2);
                    this.registerDeclarations(classOrObject.getDeclarations());
                    Multimap multimap = this.$topLevelFqNames;
                    Intrinsics.checkExpressionValueIsNotNull(multimap, "topLevelFqNames");
                    LazyTopDownAnalyzer.access$registerTopLevelFqName(this.this$0, multimap, classOrObject, descriptor2);
                    this.checkClassOrObjectDeclarations(classOrObject, descriptor2);
                }

                private final void checkClassOrObjectDeclarations(KtClassOrObject classOrObject, ClassDescriptor classDescriptor) {
                    boolean companionObjectAlreadyFound = false;
                    for (KtDeclaration jetDeclaration : classOrObject.getDeclarations()) {
                        if (jetDeclaration instanceof KtObjectDeclaration && ((KtObjectDeclaration)jetDeclaration).isCompanion()) {
                            if (companionObjectAlreadyFound) {
                                LazyTopDownAnalyzer.access$getTrace$p(this.this$0).report(Errors.MANY_COMPANION_OBJECTS.on((KtObjectDeclaration)jetDeclaration));
                            }
                            companionObjectAlreadyFound = true;
                            continue;
                        }
                        if (!(jetDeclaration instanceof KtSecondaryConstructor)) continue;
                        if (DescriptorUtils.isSingletonOrAnonymousObject(classDescriptor)) {
                            LazyTopDownAnalyzer.access$getTrace$p(this.this$0).report(Errors.CONSTRUCTOR_IN_OBJECT.on((KtDeclaration)((PsiElement)jetDeclaration)));
                            continue;
                        }
                        if (!Intrinsics.areEqual((Object)((Object)classDescriptor.getKind()), (Object)((Object)ClassKind.INTERFACE))) continue;
                        LazyTopDownAnalyzer.access$getTrace$p(this.this$0).report(Errors.CONSTRUCTOR_IN_INTERFACE.on((KtDeclaration)((PsiElement)jetDeclaration)));
                    }
                }

                public void visitClass(@NotNull KtClass klass) {
                    Intrinsics.checkParameterIsNotNull(klass, "klass");
                    this.visitClassOrObject(klass);
                    this.registerPrimaryConstructorParameters(klass);
                }

                private final void registerPrimaryConstructorParameters(KtClass klass) {
                    for (KtParameter jetParameter : klass.getPrimaryConstructorParameters()) {
                        if (!jetParameter.hasValOrVar()) continue;
                        DeclarationDescriptor declarationDescriptor = LazyTopDownAnalyzer.access$getLazyDeclarationResolver$p(this.this$0).resolveToDescriptor(jetParameter);
                        if (declarationDescriptor == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.PropertyDescriptor");
                        }
                        this.$c.getPrimaryConstructorParameterProperties().put(jetParameter, (PropertyDescriptor)declarationDescriptor);
                    }
                }

                public void visitSecondaryConstructor(@NotNull KtSecondaryConstructor constructor) {
                    Intrinsics.checkParameterIsNotNull(constructor, "constructor");
                    DeclarationDescriptor declarationDescriptor = LazyTopDownAnalyzer.access$getLazyDeclarationResolver$p(this.this$0).resolveToDescriptor(constructor);
                    if (declarationDescriptor == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ConstructorDescriptor");
                    }
                    this.$c.getSecondaryConstructors().put(constructor, (ConstructorDescriptor)declarationDescriptor);
                }

                public void visitEnumEntry(@NotNull KtEnumEntry enumEntry) {
                    Intrinsics.checkParameterIsNotNull(enumEntry, "enumEntry");
                    this.visitClassOrObject(enumEntry);
                }

                public void visitObjectDeclaration(@NotNull KtObjectDeclaration declaration) {
                    Intrinsics.checkParameterIsNotNull(declaration, "declaration");
                    this.visitClassOrObject(declaration);
                }

                public void visitAnonymousInitializer(@NotNull KtClassInitializer initializer2) {
                    Intrinsics.checkParameterIsNotNull(initializer2, "initializer");
                    KtClassOrObject ktClassOrObject = PsiTreeUtil.getParentOfType((PsiElement)initializer2, KtClassOrObject.class);
                    if (ktClassOrObject == null) {
                        Intrinsics.throwNpe();
                    }
                    KtClassOrObject classOrObject = ktClassOrObject;
                    DeclarationDescriptor declarationDescriptor = LazyTopDownAnalyzer.access$getLazyDeclarationResolver$p(this.this$0).resolveToDescriptor(classOrObject);
                    if (declarationDescriptor == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes");
                    }
                    this.$c.getAnonymousInitializers().put(initializer2, (ClassDescriptorWithResolutionScopes)declarationDescriptor);
                }

                public void visitTypedef(@NotNull KtTypedef typedef) {
                    Intrinsics.checkParameterIsNotNull(typedef, "typedef");
                    LazyTopDownAnalyzer.access$getTrace$p(this.this$0).report(Errors.UNSUPPORTED.on(typedef, "Typedefs are not supported"));
                }

                public void visitMultiDeclaration(@NotNull KtMultiDeclaration multiDeclaration) {
                    Intrinsics.checkParameterIsNotNull(multiDeclaration, "multiDeclaration");
                }

                public void visitNamedFunction(@NotNull KtNamedFunction function) {
                    Intrinsics.checkParameterIsNotNull(function, "function");
                    this.$functions.add(function);
                }

                public void visitProperty(@NotNull KtProperty property) {
                    Intrinsics.checkParameterIsNotNull(property, "property");
                    this.$properties.add(property);
                }
                {
                    this.this$0 = $outer;
                    this.$c = $captured_local_variable$1;
                    this.$topLevelFqNames = $captured_local_variable$2;
                    this.$functions = $captured_local_variable$3;
                    this.$properties = $captured_local_variable$4;
                }
            });
        }
        this.createFunctionDescriptors(c, functions2);
        Multimap multimap = topLevelFqNames;
        Intrinsics.checkExpressionValueIsNotNull(multimap, "topLevelFqNames");
        this.createPropertyDescriptors(c, multimap, properties2);
        this.resolveAllHeadersInClasses(c);
        Multimap multimap2 = topLevelFqNames;
        Intrinsics.checkExpressionValueIsNotNull(multimap2, "topLevelFqNames");
        this.declarationResolver.checkRedeclarationsInPackages(this.topLevelDescriptorProvider, multimap2);
        this.declarationResolver.checkRedeclarations(c);
        this.overrideResolver.check(c);
        this.varianceChecker.check(c);
        this.declarationResolver.resolveAnnotationsOnFiles(c, this.fileScopeProvider);
        this.overloadResolver.process(c);
        this.bodyResolver.resolveBodies(c);
        return c;
    }

    private final void resolveAllHeadersInClasses(TopDownAnalysisContext c) {
        Iterator<ClassDescriptorWithResolutionScopes> iterator2 = c.getAllClasses().iterator();
        while (iterator2.hasNext()) {
            ClassDescriptorWithResolutionScopes classDescriptor;
            ClassDescriptorWithResolutionScopes classDescriptorWithResolutionScopes = classDescriptor = iterator2.next();
            if (classDescriptorWithResolutionScopes == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.lazy.descriptors.LazyClassDescriptor");
            }
            ((LazyClassDescriptor)classDescriptorWithResolutionScopes).resolveMemberHeaders();
        }
    }

    private final void createPropertyDescriptors(TopDownAnalysisContext c, Multimap<FqName, KtElement> topLevelFqNames, List<? extends KtProperty> properties2) {
        for (KtProperty ktProperty : properties2) {
            DeclarationDescriptor declarationDescriptor = this.lazyDeclarationResolver.resolveToDescriptor(ktProperty);
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.PropertyDescriptor");
            }
            PropertyDescriptor descriptor2 = (PropertyDescriptor)declarationDescriptor;
            c.getProperties().put(ktProperty, descriptor2);
            ForceResolveUtil.forceResolveAllContents(descriptor2.getAnnotations());
            this.registerTopLevelFqName(topLevelFqNames, ktProperty, descriptor2);
        }
    }

    private final void createFunctionDescriptors(TopDownAnalysisContext c, List<? extends KtNamedFunction> functions2) {
        for (KtNamedFunction ktNamedFunction : functions2) {
            DeclarationDescriptor declarationDescriptor = this.lazyDeclarationResolver.resolveToDescriptor(ktNamedFunction);
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor");
            }
            SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)declarationDescriptor;
            c.getFunctions().put(ktNamedFunction, simpleFunctionDescriptor);
            ForceResolveUtil.forceResolveAllContents(simpleFunctionDescriptor.getAnnotations());
            for (ValueParameterDescriptor parameterDescriptor : simpleFunctionDescriptor.getValueParameters()) {
                ForceResolveUtil.forceResolveAllContents(parameterDescriptor.getAnnotations());
            }
        }
    }

    private final void registerTopLevelFqName(Multimap<FqName, KtElement> topLevelFqNames, KtNamedDeclaration declaration, DeclarationDescriptor descriptor2) {
        FqName fqName2;
        if (DescriptorUtils.isTopLevelDeclaration(descriptor2) && (fqName2 = declaration.getFqName()) != null) {
            topLevelFqNames.put(fqName2, declaration);
        }
    }

    public LazyTopDownAnalyzer(@NotNull BindingTrace trace, @NotNull DeclarationResolver declarationResolver, @NotNull OverrideResolver overrideResolver, @NotNull OverloadResolver overloadResolver, @NotNull VarianceChecker varianceChecker, @NotNull ModuleDescriptor moduleDescriptor, @NotNull LazyDeclarationResolver lazyDeclarationResolver, @NotNull BodyResolver bodyResolver, @NotNull TopLevelDescriptorProvider topLevelDescriptorProvider, @NotNull FileScopeProvider fileScopeProvider, @NotNull DeclarationScopeProvider declarationScopeProvider, @NotNull QualifiedExpressionResolver qualifiedExpressionResolver, @NotNull IdentifierChecker identifierChecker) {
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(declarationResolver, "declarationResolver");
        Intrinsics.checkParameterIsNotNull(overrideResolver, "overrideResolver");
        Intrinsics.checkParameterIsNotNull(overloadResolver, "overloadResolver");
        Intrinsics.checkParameterIsNotNull(varianceChecker, "varianceChecker");
        Intrinsics.checkParameterIsNotNull(moduleDescriptor, "moduleDescriptor");
        Intrinsics.checkParameterIsNotNull(lazyDeclarationResolver, "lazyDeclarationResolver");
        Intrinsics.checkParameterIsNotNull(bodyResolver, "bodyResolver");
        Intrinsics.checkParameterIsNotNull(topLevelDescriptorProvider, "topLevelDescriptorProvider");
        Intrinsics.checkParameterIsNotNull(fileScopeProvider, "fileScopeProvider");
        Intrinsics.checkParameterIsNotNull(declarationScopeProvider, "declarationScopeProvider");
        Intrinsics.checkParameterIsNotNull(qualifiedExpressionResolver, "qualifiedExpressionResolver");
        Intrinsics.checkParameterIsNotNull(identifierChecker, "identifierChecker");
        this.trace = trace;
        this.declarationResolver = declarationResolver;
        this.overrideResolver = overrideResolver;
        this.overloadResolver = overloadResolver;
        this.varianceChecker = varianceChecker;
        this.moduleDescriptor = moduleDescriptor;
        this.lazyDeclarationResolver = lazyDeclarationResolver;
        this.bodyResolver = bodyResolver;
        this.topLevelDescriptorProvider = topLevelDescriptorProvider;
        this.fileScopeProvider = fileScopeProvider;
        this.declarationScopeProvider = declarationScopeProvider;
        this.qualifiedExpressionResolver = qualifiedExpressionResolver;
        this.identifierChecker = identifierChecker;
    }

    @NotNull
    public static final /* synthetic */ BindingTrace access$getTrace$p(LazyTopDownAnalyzer $this) {
        return $this.trace;
    }

    @NotNull
    public static final /* synthetic */ TopLevelDescriptorProvider access$getTopLevelDescriptorProvider$p(LazyTopDownAnalyzer $this) {
        return $this.topLevelDescriptorProvider;
    }

    @NotNull
    public static final /* synthetic */ IdentifierChecker access$getIdentifierChecker$p(LazyTopDownAnalyzer $this) {
        return $this.identifierChecker;
    }

    @NotNull
    public static final /* synthetic */ QualifiedExpressionResolver access$getQualifiedExpressionResolver$p(LazyTopDownAnalyzer $this) {
        return $this.qualifiedExpressionResolver;
    }

    @NotNull
    public static final /* synthetic */ ModuleDescriptor access$getModuleDescriptor$p(LazyTopDownAnalyzer $this) {
        return $this.moduleDescriptor;
    }

    @NotNull
    public static final /* synthetic */ FileScopeProvider access$getFileScopeProvider$p(LazyTopDownAnalyzer $this) {
        return $this.fileScopeProvider;
    }

    @NotNull
    public static final /* synthetic */ LazyDeclarationResolver access$getLazyDeclarationResolver$p(LazyTopDownAnalyzer $this) {
        return $this.lazyDeclarationResolver;
    }

    public static final /* synthetic */ void access$registerTopLevelFqName(LazyTopDownAnalyzer $this, @NotNull Multimap<FqName, KtElement> topLevelFqNames, @NotNull KtNamedDeclaration declaration, @NotNull DeclarationDescriptor descriptor2) {
        $this.registerTopLevelFqName(topLevelFqNames, declaration, descriptor2);
    }
}

