/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.CollectionsKt;
import kotlin.MapsKt;
import kotlin.Pair;
import kotlin.SetsKt;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.ModifierCheckerCore$WhenMappings;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\r\u0004)\u0011\u0001D\u0001\u0006\u0003!\u0001Q!\u0001\u0003\u0002\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\t\u0001BE\u0003\u0002\u0019\u0005)\u0011\u0001C\t\u0006\u0003\u0011\rQ!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\u0005\b\u0015\t\u0001\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u0003!\rR!\u0001\u0003\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\t\u0001\u0002E\u0003\u0001\u000b\u0005AY!B\u0001\u0005\u0007\u0015\t\u0001\u0012C\u0003\u0002\t\u0013!1-\u0001\u0007\u00013\u0005A\n!(\u0001!C\u000f!\u0011!U\u0002\u0002\u0011\u0005)\u0003\u0003B\u0001\t\u00195i\u0011\u0002C\u0005\b\u0013\tI\u0011\u0001\u0007\u0004\n\u0005%\t\u0001D\u0002M\t\u0013\tI\u0011\u0001G\u0005\u0019\f\u0015\u0002\u0002\u0012D\u0007\u000215I2\u0001c\u0007\u000e\u0003aq\u0011d\u0001E\u000f\u001b\u0005Ar\"\u0007\u0003\t 5\u0011A\u0012\u0001\r\u0011Km!\u0011\u0001#\t\u000e\u0003ai\u0011d\u0001E\u000f\u001b\u0005Ar\"G\u0002\t#5\t\u00014E\r\u0004\u0011Ii\u0011\u0001g\t\u001a\u0007!\u0015R\"\u0001\r\u00143\u0019A9#\u0004\u0003\n\u0005%\t\u00014\u0005\r\u0015Ka!\u0011\u0001#\u000b\u000e\u0003ai\u0011d\u0001\u0005\u0016\u001b\u0005AZ#G\u0002\t\u001e5\t\u0001dD\r\u0005\u0011Yi!\u0001$\u0001\u0019!e1\u0001RF\u0007\u0005\u0013\tI\u0011\u0001\u0007\u0003\u0019/\u0015\nB!\u0001E\u0018\u001b\u0005A\u0002$G\u0002\t\u001e5\t\u0001dD\r\u0004\u0011ci\u0011\u0001g\t\u001a\t!1RB\u0001G\u00011A)3\u0003B\u0001\t35\t\u0001\u0004G\r\u0004\u0011;i\u0011\u0001G\b\u001a\u0007!ER\"\u0001M\u00123\u0019Ai#\u0004\u0003\n\u0005%\t\u0001\u0004\u0002\r\u0018K1!\u0011\u0001c\r\u000e\u0003aI\u0011d\u0001\u0005\u001b\u001b\u0005Ab!G\u0002\t65\t\u0001DBS\u001d\t\u0005A1$D\u0007\n\u0011%9\u0011BA\u0005\u00021\u0019I!!C\u0001\u0019\raE\u0011BA\u0005\u00021%AZ!G\u0005\t+5)\u0011b\u0001C\u0001\u0013\u0005Ab\u0001g\u000e\u0012\u0003a1\u0011kA\u0001\t9\u0015\u0006C!\u0001E\u001d\u001b5I\u0001\"C\u0004\n\u0005%\t\u0001DB\u0005\u0003\u0013\u0005Ab\u0001'\u0005\n\u0005%\t\u0001$\u0003M\u00063\rA\u0019$D\u0001\u0019\u0013eI\u0001\"F\u0007\u0006\u0013\r!\t!C\u0001\u0019\ra]\u0012#\u0001\r\u0007#\u000e\t\u0001\"HS\u001d\t\u0005AY$D\u0007\n\u0011%9\u0011BA\u0005\u00021\u0019I!!C\u0001\u0019\raE\u0011BA\u0005\u00021%AZ!G\u0005\t+5)\u0011b\u0001C\u0001\u0013\u0005Ab\u0001g\u000e\u0012\u0003a1\u0011kA\u0001\t9\u0015fB!\u0001\u0005\u001f\u001b5I\u0001\"C\u0004\n\u0005%\t\u0001DB\u0005\u0003\u0013\u0005Ab\u0001'\u0005\n\u0005%\t\u0001$\u0003M\u00063%AQ#D\u0003\n\u0007\u0011\u0005\u0011\"\u0001\r\u00071o\t\u0012\u0001\u0007\u0004R\u0007\u0005AA$\n\r\u0005\u0003!uR\"D\u0005\t\u0013\u001dI!!C\u0001\u0019\r%\u0011\u0011\"\u0001\r\u00071#I!!C\u0001\u0019\u0013a-\u0011d\u0001\u0005 \u001b\u0005Ab!G\u0002\t@5\t\u0001DBU\n\t\u0005C\u00012AG\u00041\t\t6!\u0001C\u0003#\u000e\tQ\u0001A\u0015\u001a\t\u0005C\u0001bA\u0007\u0014\u0013\u0019IQ\u0001%\u0003\u0016\u00051\u0005\u0001\u0004\u0002\r\u0005!\u0013)\u0012\"\u0003\u0004\n\u000bA%QC\u0001G\u00011\u0011AB\u0001$\u0001\u0019\ba\u001d\u0011kA\u0001\u0006\u0001%\u001aBa\u0011\u0005\t\u000b5Q\u0011BA\u0005\u00021\u0019IQ!\u0003\u0003\n\u0005%\t\u0001\u0004\u0002M\u00071\u0017\t6\u0001B\u0003\u0001\u001b\t!q\u0001c\u0004*'\u0011\t\u0005\u0002\u0003\u0005\u000e\u001b%A\u0011bB\u0005\u0003\u0013\u0005Ab!\u0003\u0002\n\u0003a1\u0001\u0014C\u0005\u0003\u0013\u0005A\u0012\u0002g\u0003R\u0007\u0005)\u0001!K\n\u0005\u0007\"A\u0019\"\u0004\u0006\n\u0005%\t\u0001DB\u0005\u0006\u0013\u0011I!!C\u0001\u0019\ta5\u00014B)\u0004\t\u0015\u0001QB\u0001\u0003\u000b\u0011\u001fI3\u0003B\"\t\u0011+i!\"\u0003\u0002\n\u0003a1\u0011\"B\u0005\u0005\u0013\tI\u0011\u0001\u0007\u0003\u0019\u000ea-\u0011k\u0001\u0003\u0006\u00015\u0011Aa\u0003E\bSA!\u0011\t\u0003E\f\u001b)I!!C\u0001\u0019\r%)\u0011\u0002B\u0005\u0003\u0013\u0005AB\u0001'\u0004\u0019\fE\u001b\u0011!\u0002\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/ModifierCheckerCore;", "", "()V", "MODIFIER_KEYWORD_SET", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "defaultVisibilityTargets", "Ljava/util/EnumSet;", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "kotlin.jvm.PlatformType", "deprecatedParentTargetMap", "", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "", "getDeprecatedParentTargetMap", "()Ljava/util/Map;", "mutualCompatibility", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/resolve/ModifierCheckerCore$Compatibility;", "possibleParentTargetMap", "getPossibleParentTargetMap", "possibleTargetMap", "getPossibleTargetMap", "redundantTargetMap", "buildCompatibilityMap", "check", "", "listOwner", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "checkCompatibility", "firstNode", "Lcom/intellij/lang/ASTNode;", "secondNode", "owner", "Lcom/intellij/psi/PsiElement;", "incorrectNodes", "", "checkModifierList", "list", "Lorg/jetbrains/kotlin/psi/KtModifierList;", "parentDescriptor", "actualTargets", "", "checkParent", "", "node", "checkTarget", "compatibility", "first", "second", "compatibilityForClassesRegister", "", "([Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;)Ljava/util/Map;", "compatibilityRegister", "(Lorg/jetbrains/kotlin/resolve/ModifierCheckerCore$Compatibility;[Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;)Ljava/util/Map;", "deprecationRegister", "incompatibilityRegister", "redundantRegister", "sufficient", "redundant", "Compatibility"}, moduleName="kotlin-compiler")
public final class ModifierCheckerCore {
    private static final EnumSet<KotlinTarget> defaultVisibilityTargets;
    @NotNull
    public static final Map<KtModifierKeywordToken, ? extends Set<? extends KotlinTarget>> possibleTargetMap;
    private static final Map<KtModifierKeywordToken, ? extends Set<? extends KotlinTarget>> redundantTargetMap;
    @NotNull
    public static final Map<KtModifierKeywordToken, ? extends Set<? extends KotlinTarget>> possibleParentTargetMap;
    @NotNull
    public static final Map<KtModifierKeywordToken, ? extends Set<? extends KotlinTarget>> deprecatedParentTargetMap;
    private static final Map<Pair<? extends KtModifierKeywordToken, ? extends KtModifierKeywordToken>, ? extends Compatibility> mutualCompatibility;
    private static final TokenSet MODIFIER_KEYWORD_SET;
    public static final ModifierCheckerCore INSTANCE;
    public static final ModifierCheckerCore INSTANCE$;

    @NotNull
    public final Map<KtModifierKeywordToken, Set<? extends KotlinTarget>> getPossibleTargetMap() {
        return possibleTargetMap;
    }

    @NotNull
    public final Map<KtModifierKeywordToken, Set<? extends KotlinTarget>> getPossibleParentTargetMap() {
        return possibleParentTargetMap;
    }

    @NotNull
    public final Map<KtModifierKeywordToken, Set<? extends KotlinTarget>> getDeprecatedParentTargetMap() {
        return deprecatedParentTargetMap;
    }

    private final Map<Pair<? extends KtModifierKeywordToken, ? extends KtModifierKeywordToken>, Compatibility> buildCompatibilityMap() {
        HashMap result2 = MapsKt.hashMapOf(new Pair[0]);
        Map map2 = result2;
        KtModifierKeywordToken[] ktModifierKeywordTokenArray = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.IN_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken, "IN_KEYWORD");
        ktModifierKeywordTokenArray[0] = ktModifierKeywordToken;
        KtModifierKeywordToken ktModifierKeywordToken2 = KtTokens.OUT_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken2, "OUT_KEYWORD");
        ktModifierKeywordTokenArray[1] = ktModifierKeywordToken2;
        MapsKt.plusAssign(map2, this.incompatibilityRegister(ktModifierKeywordTokenArray));
        Map map3 = result2;
        KtModifierKeywordToken[] ktModifierKeywordTokenArray2 = new KtModifierKeywordToken[4];
        KtModifierKeywordToken ktModifierKeywordToken3 = KtTokens.PRIVATE_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken3, "PRIVATE_KEYWORD");
        ktModifierKeywordTokenArray2[0] = ktModifierKeywordToken3;
        KtModifierKeywordToken ktModifierKeywordToken4 = KtTokens.PROTECTED_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken4, "PROTECTED_KEYWORD");
        ktModifierKeywordTokenArray2[1] = ktModifierKeywordToken4;
        KtModifierKeywordToken ktModifierKeywordToken5 = KtTokens.PUBLIC_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken5, "PUBLIC_KEYWORD");
        ktModifierKeywordTokenArray2[2] = ktModifierKeywordToken5;
        KtModifierKeywordToken ktModifierKeywordToken6 = KtTokens.INTERNAL_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken6, "INTERNAL_KEYWORD");
        ktModifierKeywordTokenArray2[3] = ktModifierKeywordToken6;
        MapsKt.plusAssign(map3, this.incompatibilityRegister(ktModifierKeywordTokenArray2));
        Map map4 = result2;
        KtModifierKeywordToken[] ktModifierKeywordTokenArray3 = new KtModifierKeywordToken[4];
        KtModifierKeywordToken ktModifierKeywordToken7 = KtTokens.ABSTRACT_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken7, "ABSTRACT_KEYWORD");
        ktModifierKeywordTokenArray3[0] = ktModifierKeywordToken7;
        KtModifierKeywordToken ktModifierKeywordToken8 = KtTokens.OPEN_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken8, "OPEN_KEYWORD");
        ktModifierKeywordTokenArray3[1] = ktModifierKeywordToken8;
        KtModifierKeywordToken ktModifierKeywordToken9 = KtTokens.FINAL_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken9, "FINAL_KEYWORD");
        ktModifierKeywordTokenArray3[2] = ktModifierKeywordToken9;
        KtModifierKeywordToken ktModifierKeywordToken10 = KtTokens.SEALED_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken10, "SEALED_KEYWORD");
        ktModifierKeywordTokenArray3[3] = ktModifierKeywordToken10;
        MapsKt.plusAssign(map4, this.incompatibilityRegister(ktModifierKeywordTokenArray3));
        Map map5 = result2;
        KtModifierKeywordToken[] ktModifierKeywordTokenArray4 = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken11 = KtTokens.DATA_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken11, "DATA_KEYWORD");
        ktModifierKeywordTokenArray4[0] = ktModifierKeywordToken11;
        KtModifierKeywordToken ktModifierKeywordToken12 = KtTokens.OPEN_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken12, "OPEN_KEYWORD");
        ktModifierKeywordTokenArray4[1] = ktModifierKeywordToken12;
        MapsKt.plusAssign(map5, this.incompatibilityRegister(ktModifierKeywordTokenArray4));
        Map map6 = result2;
        KtModifierKeywordToken[] ktModifierKeywordTokenArray5 = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken13 = KtTokens.DATA_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken13, "DATA_KEYWORD");
        ktModifierKeywordTokenArray5[0] = ktModifierKeywordToken13;
        KtModifierKeywordToken ktModifierKeywordToken14 = KtTokens.INNER_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken14, "INNER_KEYWORD");
        ktModifierKeywordTokenArray5[1] = ktModifierKeywordToken14;
        MapsKt.plusAssign(map6, this.incompatibilityRegister(ktModifierKeywordTokenArray5));
        Map map7 = result2;
        KtModifierKeywordToken[] ktModifierKeywordTokenArray6 = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken15 = KtTokens.DATA_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken15, "DATA_KEYWORD");
        ktModifierKeywordTokenArray6[0] = ktModifierKeywordToken15;
        KtModifierKeywordToken ktModifierKeywordToken16 = KtTokens.ABSTRACT_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken16, "ABSTRACT_KEYWORD");
        ktModifierKeywordTokenArray6[1] = ktModifierKeywordToken16;
        MapsKt.plusAssign(map7, this.incompatibilityRegister(ktModifierKeywordTokenArray6));
        Map map8 = result2;
        KtModifierKeywordToken[] ktModifierKeywordTokenArray7 = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken17 = KtTokens.DATA_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken17, "DATA_KEYWORD");
        ktModifierKeywordTokenArray7[0] = ktModifierKeywordToken17;
        KtModifierKeywordToken ktModifierKeywordToken18 = KtTokens.SEALED_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken18, "SEALED_KEYWORD");
        ktModifierKeywordTokenArray7[1] = ktModifierKeywordToken18;
        MapsKt.plusAssign(map8, this.incompatibilityRegister(ktModifierKeywordTokenArray7));
        Map map9 = result2;
        KtModifierKeywordToken ktModifierKeywordToken19 = KtTokens.ABSTRACT_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken19, "ABSTRACT_KEYWORD");
        KtModifierKeywordToken ktModifierKeywordToken20 = KtTokens.OPEN_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken20, "OPEN_KEYWORD");
        MapsKt.plusAssign(map9, this.redundantRegister(ktModifierKeywordToken19, ktModifierKeywordToken20));
        Map map10 = result2;
        KtModifierKeywordToken ktModifierKeywordToken21 = KtTokens.OVERRIDE_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken21, "OVERRIDE_KEYWORD");
        KtModifierKeywordToken ktModifierKeywordToken22 = KtTokens.OPEN_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken22, "OPEN_KEYWORD");
        MapsKt.plusAssign(map10, this.redundantRegister(ktModifierKeywordToken21, ktModifierKeywordToken22));
        Map map11 = result2;
        KtModifierKeywordToken ktModifierKeywordToken23 = KtTokens.SEALED_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken23, "SEALED_KEYWORD");
        KtModifierKeywordToken ktModifierKeywordToken24 = KtTokens.ABSTRACT_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken24, "ABSTRACT_KEYWORD");
        MapsKt.plusAssign(map11, this.redundantRegister(ktModifierKeywordToken23, ktModifierKeywordToken24));
        Map map12 = result2;
        KtModifierKeywordToken[] ktModifierKeywordTokenArray8 = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken25 = KtTokens.CONST_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken25, "CONST_KEYWORD");
        ktModifierKeywordTokenArray8[0] = ktModifierKeywordToken25;
        KtModifierKeywordToken ktModifierKeywordToken26 = KtTokens.ABSTRACT_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken26, "ABSTRACT_KEYWORD");
        ktModifierKeywordTokenArray8[1] = ktModifierKeywordToken26;
        MapsKt.plusAssign(map12, this.incompatibilityRegister(ktModifierKeywordTokenArray8));
        Map map13 = result2;
        KtModifierKeywordToken[] ktModifierKeywordTokenArray9 = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken27 = KtTokens.CONST_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken27, "CONST_KEYWORD");
        ktModifierKeywordTokenArray9[0] = ktModifierKeywordToken27;
        KtModifierKeywordToken ktModifierKeywordToken28 = KtTokens.OPEN_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken28, "OPEN_KEYWORD");
        ktModifierKeywordTokenArray9[1] = ktModifierKeywordToken28;
        MapsKt.plusAssign(map13, this.incompatibilityRegister(ktModifierKeywordTokenArray9));
        Map map14 = result2;
        KtModifierKeywordToken[] ktModifierKeywordTokenArray10 = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken29 = KtTokens.CONST_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken29, "CONST_KEYWORD");
        ktModifierKeywordTokenArray10[0] = ktModifierKeywordToken29;
        KtModifierKeywordToken ktModifierKeywordToken30 = KtTokens.OVERRIDE_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken30, "OVERRIDE_KEYWORD");
        ktModifierKeywordTokenArray10[1] = ktModifierKeywordToken30;
        MapsKt.plusAssign(map14, this.incompatibilityRegister(ktModifierKeywordTokenArray10));
        Map map15 = result2;
        KtModifierKeywordToken[] ktModifierKeywordTokenArray11 = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken31 = KtTokens.PRIVATE_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken31, "PRIVATE_KEYWORD");
        ktModifierKeywordTokenArray11[0] = ktModifierKeywordToken31;
        KtModifierKeywordToken ktModifierKeywordToken32 = KtTokens.OVERRIDE_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken32, "OVERRIDE_KEYWORD");
        ktModifierKeywordTokenArray11[1] = ktModifierKeywordToken32;
        MapsKt.plusAssign(map15, this.incompatibilityRegister(ktModifierKeywordTokenArray11));
        Map map16 = result2;
        KtModifierKeywordToken[] ktModifierKeywordTokenArray12 = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken33 = KtTokens.PRIVATE_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken33, "PRIVATE_KEYWORD");
        ktModifierKeywordTokenArray12[0] = ktModifierKeywordToken33;
        KtModifierKeywordToken ktModifierKeywordToken34 = KtTokens.OPEN_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken34, "OPEN_KEYWORD");
        ktModifierKeywordTokenArray12[1] = ktModifierKeywordToken34;
        MapsKt.plusAssign(map16, this.compatibilityForClassesRegister(ktModifierKeywordTokenArray12));
        Map map17 = result2;
        KtModifierKeywordToken[] ktModifierKeywordTokenArray13 = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken35 = KtTokens.PRIVATE_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken35, "PRIVATE_KEYWORD");
        ktModifierKeywordTokenArray13[0] = ktModifierKeywordToken35;
        KtModifierKeywordToken ktModifierKeywordToken36 = KtTokens.ABSTRACT_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken36, "ABSTRACT_KEYWORD");
        ktModifierKeywordTokenArray13[1] = ktModifierKeywordToken36;
        MapsKt.plusAssign(map17, this.compatibilityForClassesRegister(ktModifierKeywordTokenArray13));
        return result2;
    }

    private final Map<Pair<? extends KtModifierKeywordToken, ? extends KtModifierKeywordToken>, Compatibility> redundantRegister(KtModifierKeywordToken sufficient, KtModifierKeywordToken redundant) {
        return MapsKt.mapOf(TuplesKt.to(new Pair<KtModifierKeywordToken, KtModifierKeywordToken>(sufficient, redundant), Compatibility.REDUNDANT), TuplesKt.to(new Pair<KtModifierKeywordToken, KtModifierKeywordToken>(redundant, sufficient), Compatibility.REVERSE_REDUNDANT));
    }

    private final Map<Pair<? extends KtModifierKeywordToken, ? extends KtModifierKeywordToken>, Compatibility> compatibilityRegister(Compatibility compatibility, KtModifierKeywordToken ... list) {
        HashMap result2 = MapsKt.hashMapOf(new Pair[0]);
        for (int i = 0; i < list.length; ++i) {
            KtModifierKeywordToken first = list[i];
            for (int j = 0; j < list.length; ++j) {
                KtModifierKeywordToken second = list[j];
                if (!(Intrinsics.areEqual(first, second) ^ true)) continue;
                MapsKt.set(result2, new Pair<KtModifierKeywordToken, KtModifierKeywordToken>(first, second), compatibility);
            }
        }
        return result2;
    }

    private final Map<Pair<? extends KtModifierKeywordToken, ? extends KtModifierKeywordToken>, Compatibility> compatibilityForClassesRegister(KtModifierKeywordToken ... list) {
        return this.compatibilityRegister(Compatibility.COMPATIBLE_FOR_CLASSES_ONLY, Arrays.copyOf(list, list.length));
    }

    private final Map<Pair<? extends KtModifierKeywordToken, ? extends KtModifierKeywordToken>, Compatibility> incompatibilityRegister(KtModifierKeywordToken ... list) {
        return this.compatibilityRegister(Compatibility.INCOMPATIBLE, Arrays.copyOf(list, list.length));
    }

    private final Compatibility compatibility(KtModifierKeywordToken first, KtModifierKeywordToken second) {
        if (Intrinsics.areEqual(first, second)) {
            return Compatibility.REPEATED;
        }
        Compatibility compatibility = mutualCompatibility.get(new Pair<KtModifierKeywordToken, KtModifierKeywordToken>(first, second));
        if (compatibility == null) {
            compatibility = Compatibility.COMPATIBLE;
        }
        return compatibility;
    }

    private final void checkCompatibility(BindingTrace trace, ASTNode firstNode, ASTNode secondNode, PsiElement owner, Set<ASTNode> incorrectNodes) {
        IElementType iElementType = firstNode.getElementType();
        if (iElementType == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.lexer.KtModifierKeywordToken");
        }
        KtModifierKeywordToken first = (KtModifierKeywordToken)iElementType;
        IElementType iElementType2 = secondNode.getElementType();
        if (iElementType2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.lexer.KtModifierKeywordToken");
        }
        KtModifierKeywordToken second = (KtModifierKeywordToken)iElementType2;
        Compatibility compatibility = this.compatibility(first, second);
        switch (ModifierCheckerCore$WhenMappings.$EnumSwitchMapping$0[compatibility.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                if (!incorrectNodes.add(secondNode)) break;
                trace.report(Errors.REPEATED_MODIFIER.on(secondNode.getPsi(), first));
                break;
            }
            case 3: {
                trace.report(Errors.REDUNDANT_MODIFIER.on(secondNode.getPsi(), first, second));
                break;
            }
            case 4: {
                trace.report(Errors.REDUNDANT_MODIFIER.on(firstNode.getPsi(), second, first));
                break;
            }
            case 5: {
                trace.report(Errors.DEPRECATED_MODIFIER_PAIR.on(firstNode.getPsi(), first, second));
                trace.report(Errors.DEPRECATED_MODIFIER_PAIR.on(secondNode.getPsi(), second, first));
                break;
            }
            case 6: 
            case 7: {
                if (Intrinsics.areEqual((Object)compatibility, (Object)Compatibility.COMPATIBLE_FOR_CLASSES_ONLY) && owner instanceof KtClassOrObject) {
                    return;
                }
                if (incorrectNodes.add(firstNode)) {
                    trace.report(Errors.INCOMPATIBLE_MODIFIERS.on(firstNode.getPsi(), first, second));
                }
                if (!incorrectNodes.add(secondNode)) break;
                trace.report(Errors.INCOMPATIBLE_MODIFIERS.on(secondNode.getPsi(), second, first));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkTarget(BindingTrace trace, ASTNode node, List<? extends KotlinTarget> actualTargets) {
        boolean bl;
        KtModifierKeywordToken modifier;
        block10: {
            void $receiver;
            boolean bl2;
            block9: {
                void $receiver2;
                IElementType iElementType = node.getElementType();
                if (iElementType == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.lexer.KtModifierKeywordToken");
                }
                modifier = (KtModifierKeywordToken)iElementType;
                Set<KotlinTarget> set = possibleTargetMap.get(modifier);
                if (set == null) {
                    set = SetsKt.emptySet();
                }
                Set<? extends KotlinTarget> possibleTargets = set;
                Iterable iterable = actualTargets;
                for (Object element : $receiver2) {
                    KotlinTarget it2 = (KotlinTarget)((Object)element);
                    if (!possibleTargets.contains((Object)it2)) continue;
                    bl2 = true;
                    break block9;
                }
                bl2 = false;
            }
            if (!bl2) {
                PsiElement psiElement2 = node.getPsi();
                Object object = CollectionsKt.firstOrNull(actualTargets);
                if (object == null || (object = object.getDescription()) == null) {
                    object = "this";
                }
                trace.report(Errors.WRONG_MODIFIER_TARGET.on(psiElement2, modifier, (String)object));
                return false;
            }
            Set<KotlinTarget> set = redundantTargetMap.get(modifier);
            if (set == null) {
                set = SetsKt.emptySet();
            }
            Set<? extends KotlinTarget> redundantTargets = set;
            Iterable iterable = actualTargets;
            for (Object element : $receiver) {
                KotlinTarget it3 = (KotlinTarget)((Object)element);
                if (!redundantTargets.contains((Object)it3)) continue;
                bl = true;
                break block10;
            }
            bl = false;
        }
        if (bl) {
            PsiElement psiElement3 = node.getPsi();
            Object object = CollectionsKt.firstOrNull(actualTargets);
            if (object == null || (object = object.getDescription()) == null) {
                object = "this";
            }
            trace.report(Errors.REDUNDANT_MODIFIER_FOR_TARGET.on(psiElement3, modifier, (String)object));
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkParent(BindingTrace trace, ASTNode node, DeclarationDescriptor parentDescriptor) {
        boolean bl;
        List<KotlinTarget> actualParents;
        KtModifierKeywordToken modifier;
        block11: {
            void $receiver;
            IElementType iElementType = node.getElementType();
            if (iElementType == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.lexer.KtModifierKeywordToken");
            }
            modifier = (KtModifierKeywordToken)iElementType;
            DeclarationDescriptor declarationDescriptor = parentDescriptor;
            actualParents = declarationDescriptor instanceof ClassDescriptor ? KotlinTarget.Companion.classActualTargets((ClassDescriptor)parentDescriptor) : (declarationDescriptor instanceof FunctionDescriptor ? CollectionsKt.listOf(KotlinTarget.FUNCTION) : CollectionsKt.listOf(KotlinTarget.FILE));
            Set<? extends KotlinTarget> deprecatedParents = deprecatedParentTargetMap.get(modifier);
            if (deprecatedParents != null) {
                boolean bl2;
                block10: {
                    void $receiver2;
                    Iterable iterable = actualParents;
                    for (Object element : $receiver2) {
                        KotlinTarget it2 = (KotlinTarget)((Object)element);
                        if (!deprecatedParents.contains((Object)it2)) continue;
                        bl2 = true;
                        break block10;
                    }
                    bl2 = false;
                }
                if (bl2) {
                    PsiElement psiElement2 = node.getPsi();
                    Object object = CollectionsKt.firstOrNull(actualParents);
                    if (object == null || (object = object.getDescription()) == null) {
                        object = "this scope";
                    }
                    trace.report(Errors.DEPRECATED_MODIFIER_CONTAINING_DECLARATION.on(psiElement2, modifier, (String)object));
                    return true;
                }
            }
            Set<? extends KotlinTarget> set = possibleParentTargetMap.get(modifier);
            if (set == null) {
                return true;
            }
            Set<? extends KotlinTarget> possibleParents = set;
            if (Intrinsics.areEqual(possibleParents, KotlinTarget.Companion.getALL_TARGET_SET())) {
                return true;
            }
            Iterable iterable = actualParents;
            for (Object element : $receiver) {
                KotlinTarget it3 = (KotlinTarget)((Object)element);
                if (!possibleParents.contains((Object)it3)) continue;
                bl = true;
                break block11;
            }
            bl = false;
        }
        if (bl) {
            return true;
        }
        PsiElement psiElement3 = node.getPsi();
        Object object = CollectionsKt.firstOrNull(actualParents);
        if (object == null || (object = object.getDescription()) == null) {
            object = "this scope";
        }
        trace.report(Errors.WRONG_MODIFIER_CONTAINING_DECLARATION.on(psiElement3, modifier, (String)object));
        return false;
    }

    private final void checkModifierList(KtModifierList list, BindingTrace trace, DeclarationDescriptor parentDescriptor, List<? extends KotlinTarget> actualTargets) {
        HashSet<ASTNode> incorrectNodes = SetsKt.hashSetOf(new ASTNode[0]);
        ASTNode[] children = list.getNode().getChildren(MODIFIER_KEYWORD_SET);
        for (int i = 0; i < children.length; ++i) {
            ASTNode first;
            ASTNode second = children[i];
            for (int j = 0; j < children.length && !Intrinsics.areEqual(first = children[j], second); ++j) {
                ASTNode aSTNode = first;
                Intrinsics.checkExpressionValueIsNotNull(aSTNode, "first");
                ASTNode aSTNode2 = second;
                Intrinsics.checkExpressionValueIsNotNull(aSTNode2, "second");
                PsiElement psiElement2 = list.getOwner();
                Intrinsics.checkExpressionValueIsNotNull(psiElement2, "list.owner");
                this.checkCompatibility(trace, aSTNode, aSTNode2, psiElement2, (Set<ASTNode>)incorrectNodes);
            }
            if (!(incorrectNodes.contains(second) ^ true)) continue;
            ASTNode aSTNode = second;
            Intrinsics.checkExpressionValueIsNotNull(aSTNode, "second");
            if (!this.checkTarget(trace, aSTNode, actualTargets)) {
                CollectionsKt.plusAssign((Collection)incorrectNodes, second);
                continue;
            }
            ASTNode aSTNode3 = second;
            Intrinsics.checkExpressionValueIsNotNull(aSTNode3, "second");
            if (this.checkParent(trace, aSTNode3, parentDescriptor)) continue;
            CollectionsKt.plusAssign((Collection)incorrectNodes, second);
        }
    }

    public final void check(@NotNull KtModifierListOwner listOwner, @NotNull BindingTrace trace, @Nullable DeclarationDescriptor descriptor2) {
        KtModifierList list;
        Intrinsics.checkParameterIsNotNull(listOwner, "listOwner");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        if (listOwner instanceof KtDeclarationWithBody) {
            for (KtParameter parameter : ((KtDeclarationWithBody)listOwner).getValueParameters()) {
                if (parameter.hasValOrVar()) continue;
                KtModifierListOwner ktModifierListOwner = parameter;
                Intrinsics.checkExpressionValueIsNotNull(ktModifierListOwner, "parameter");
                this.check(ktModifierListOwner, trace, null);
            }
        }
        KtElement ktElement = listOwner;
        DeclarationDescriptor declarationDescriptor = descriptor2;
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            declarationDescriptor = null;
        }
        List<KotlinTarget> actualTargets = AnnotationChecker.Companion.getDeclarationSiteActualTargetList(ktElement, (ClassDescriptor)declarationDescriptor);
        KtModifierList ktModifierList = listOwner.getModifierList();
        if (ktModifierList == null) {
            return;
        }
        KtModifierList ktModifierList2 = list = ktModifierList;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierList2, "list");
        DeclarationDescriptor declarationDescriptor2 = descriptor2;
        this.checkModifierList(ktModifierList2, trace, declarationDescriptor2 != null ? declarationDescriptor2.getContainingDeclaration() : null, actualTargets);
    }

    static {
        new ModifierCheckerCore();
    }

    private ModifierCheckerCore() {
        INSTANCE = this;
        INSTANCE$ = this;
        defaultVisibilityTargets = EnumSet.of((Enum)KotlinTarget.CLASS_ONLY, new KotlinTarget[]{KotlinTarget.OBJECT, KotlinTarget.INTERFACE, KotlinTarget.INNER_CLASS, KotlinTarget.ENUM_CLASS, KotlinTarget.ANNOTATION_CLASS, KotlinTarget.MEMBER_FUNCTION, KotlinTarget.TOP_LEVEL_FUNCTION, KotlinTarget.PROPERTY_GETTER, KotlinTarget.PROPERTY_SETTER, KotlinTarget.MEMBER_PROPERTY, KotlinTarget.TOP_LEVEL_PROPERTY, KotlinTarget.CONSTRUCTOR});
        possibleTargetMap = MapsKt.mapOf(TuplesKt.to(KtTokens.ENUM_KEYWORD, EnumSet.of((Enum)KotlinTarget.ENUM_CLASS)), TuplesKt.to(KtTokens.ABSTRACT_KEYWORD, EnumSet.of((Enum)KotlinTarget.CLASS_ONLY, new KotlinTarget[]{KotlinTarget.LOCAL_CLASS, KotlinTarget.INNER_CLASS, KotlinTarget.INTERFACE, KotlinTarget.MEMBER_PROPERTY, KotlinTarget.MEMBER_FUNCTION})), TuplesKt.to(KtTokens.OPEN_KEYWORD, EnumSet.of((Enum)KotlinTarget.CLASS_ONLY, new KotlinTarget[]{KotlinTarget.LOCAL_CLASS, KotlinTarget.INNER_CLASS, KotlinTarget.INTERFACE, KotlinTarget.MEMBER_PROPERTY, KotlinTarget.MEMBER_FUNCTION})), TuplesKt.to(KtTokens.FINAL_KEYWORD, EnumSet.of((Enum)KotlinTarget.CLASS_ONLY, new KotlinTarget[]{KotlinTarget.LOCAL_CLASS, KotlinTarget.INNER_CLASS, KotlinTarget.ENUM_CLASS, KotlinTarget.OBJECT, KotlinTarget.MEMBER_PROPERTY, KotlinTarget.MEMBER_FUNCTION})), TuplesKt.to(KtTokens.SEALED_KEYWORD, EnumSet.of((Enum)KotlinTarget.CLASS_ONLY, (Enum)KotlinTarget.LOCAL_CLASS, (Enum)KotlinTarget.INNER_CLASS)), TuplesKt.to(KtTokens.INNER_KEYWORD, EnumSet.of((Enum)KotlinTarget.CLASS_ONLY, (Enum)KotlinTarget.INNER_CLASS)), TuplesKt.to(KtTokens.OVERRIDE_KEYWORD, EnumSet.of((Enum)KotlinTarget.MEMBER_PROPERTY, (Enum)KotlinTarget.MEMBER_FUNCTION)), TuplesKt.to(KtTokens.PRIVATE_KEYWORD, defaultVisibilityTargets), TuplesKt.to(KtTokens.PUBLIC_KEYWORD, defaultVisibilityTargets), TuplesKt.to(KtTokens.INTERNAL_KEYWORD, defaultVisibilityTargets), TuplesKt.to(KtTokens.PROTECTED_KEYWORD, EnumSet.of((Enum)KotlinTarget.CLASS_ONLY, new KotlinTarget[]{KotlinTarget.OBJECT, KotlinTarget.INTERFACE, KotlinTarget.INNER_CLASS, KotlinTarget.ENUM_CLASS, KotlinTarget.ANNOTATION_CLASS, KotlinTarget.MEMBER_FUNCTION, KotlinTarget.PROPERTY_GETTER, KotlinTarget.PROPERTY_SETTER, KotlinTarget.MEMBER_PROPERTY, KotlinTarget.CONSTRUCTOR})), TuplesKt.to(KtTokens.IN_KEYWORD, EnumSet.of((Enum)KotlinTarget.TYPE_PARAMETER, (Enum)KotlinTarget.TYPE_PROJECTION)), TuplesKt.to(KtTokens.OUT_KEYWORD, EnumSet.of((Enum)KotlinTarget.TYPE_PARAMETER, (Enum)KotlinTarget.TYPE_PROJECTION)), TuplesKt.to(KtTokens.REIFIED_KEYWORD, EnumSet.of((Enum)KotlinTarget.TYPE_PARAMETER)), TuplesKt.to(KtTokens.VARARG_KEYWORD, EnumSet.of((Enum)KotlinTarget.VALUE_PARAMETER, (Enum)KotlinTarget.PROPERTY_PARAMETER)), TuplesKt.to(KtTokens.COMPANION_KEYWORD, EnumSet.of((Enum)KotlinTarget.OBJECT)), TuplesKt.to(KtTokens.LATEINIT_KEYWORD, EnumSet.of((Enum)KotlinTarget.MEMBER_PROPERTY)), TuplesKt.to(KtTokens.DATA_KEYWORD, EnumSet.of((Enum)KotlinTarget.CLASS_ONLY, (Enum)KotlinTarget.INNER_CLASS, (Enum)KotlinTarget.LOCAL_CLASS)), TuplesKt.to(KtTokens.INLINE_KEYWORD, EnumSet.of((Enum)KotlinTarget.FUNCTION)), TuplesKt.to(KtTokens.NOINLINE_KEYWORD, EnumSet.of((Enum)KotlinTarget.VALUE_PARAMETER)), TuplesKt.to(KtTokens.TAILREC_KEYWORD, EnumSet.of((Enum)KotlinTarget.FUNCTION)), TuplesKt.to(KtTokens.EXTERNAL_KEYWORD, EnumSet.of((Enum)KotlinTarget.FUNCTION, (Enum)KotlinTarget.PROPERTY_GETTER, (Enum)KotlinTarget.PROPERTY_SETTER)), TuplesKt.to(KtTokens.ANNOTATION_KEYWORD, EnumSet.of((Enum)KotlinTarget.ANNOTATION_CLASS)), TuplesKt.to(KtTokens.CROSSINLINE_KEYWORD, EnumSet.of((Enum)KotlinTarget.VALUE_PARAMETER)), TuplesKt.to(KtTokens.CONST_KEYWORD, EnumSet.of((Enum)KotlinTarget.MEMBER_PROPERTY, (Enum)KotlinTarget.TOP_LEVEL_PROPERTY)), TuplesKt.to(KtTokens.OPERATOR_KEYWORD, EnumSet.of((Enum)KotlinTarget.FUNCTION)), TuplesKt.to(KtTokens.INFIX_KEYWORD, EnumSet.of((Enum)KotlinTarget.FUNCTION)));
        redundantTargetMap = MapsKt.mapOf(TuplesKt.to(KtTokens.ABSTRACT_KEYWORD, EnumSet.of((Enum)KotlinTarget.INTERFACE)), TuplesKt.to(KtTokens.OPEN_KEYWORD, EnumSet.of((Enum)KotlinTarget.INTERFACE)), TuplesKt.to(KtTokens.FINAL_KEYWORD, EnumSet.of((Enum)KotlinTarget.ENUM_CLASS, (Enum)KotlinTarget.OBJECT)));
        possibleParentTargetMap = MapsKt.mapOf(TuplesKt.to(KtTokens.INNER_KEYWORD, EnumSet.of((Enum)KotlinTarget.CLASS_ONLY, (Enum)KotlinTarget.INNER_CLASS, (Enum)KotlinTarget.LOCAL_CLASS, (Enum)KotlinTarget.ENUM_CLASS, (Enum)KotlinTarget.ENUM_ENTRY)), TuplesKt.to(KtTokens.OVERRIDE_KEYWORD, EnumSet.of((Enum)KotlinTarget.CLASS_ONLY, new KotlinTarget[]{KotlinTarget.INNER_CLASS, KotlinTarget.LOCAL_CLASS, KotlinTarget.OBJECT, KotlinTarget.OBJECT_LITERAL, KotlinTarget.INTERFACE, KotlinTarget.ENUM_CLASS, KotlinTarget.ENUM_ENTRY})), TuplesKt.to(KtTokens.PROTECTED_KEYWORD, EnumSet.of((Enum)KotlinTarget.CLASS_ONLY, (Enum)KotlinTarget.INNER_CLASS, (Enum)KotlinTarget.LOCAL_CLASS, (Enum)KotlinTarget.ENUM_CLASS, (Enum)KotlinTarget.OBJECT)), TuplesKt.to(KtTokens.INTERNAL_KEYWORD, EnumSet.of((Enum)KotlinTarget.CLASS_ONLY, new KotlinTarget[]{KotlinTarget.INNER_CLASS, KotlinTarget.LOCAL_CLASS, KotlinTarget.OBJECT, KotlinTarget.OBJECT_LITERAL, KotlinTarget.ENUM_CLASS, KotlinTarget.ENUM_ENTRY, KotlinTarget.FILE})), TuplesKt.to(KtTokens.PRIVATE_KEYWORD, EnumSet.of((Enum)KotlinTarget.CLASS_ONLY, new KotlinTarget[]{KotlinTarget.INNER_CLASS, KotlinTarget.LOCAL_CLASS, KotlinTarget.OBJECT, KotlinTarget.OBJECT_LITERAL, KotlinTarget.INTERFACE, KotlinTarget.ENUM_CLASS, KotlinTarget.ENUM_ENTRY, KotlinTarget.FILE})), TuplesKt.to(KtTokens.COMPANION_KEYWORD, EnumSet.of((Enum)KotlinTarget.CLASS_ONLY, (Enum)KotlinTarget.ENUM_CLASS, (Enum)KotlinTarget.INTERFACE)));
        deprecatedParentTargetMap = MapsKt.mapOf(TuplesKt.to(KtTokens.FINAL_KEYWORD, EnumSet.of((Enum)KotlinTarget.INTERFACE)), TuplesKt.to(KtTokens.PROTECTED_KEYWORD, EnumSet.of((Enum)KotlinTarget.OBJECT)));
        mutualCompatibility = this.buildCompatibilityMap();
        MODIFIER_KEYWORD_SET = TokenSet.orSet(KtTokens.SOFT_KEYWORDS, TokenSet.create(KtTokens.IN_KEYWORD));
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\r\u0015\tA\"A\u0003\u0002\u0011!)\u0011\u0001\u0002\u0003\u0005\u0003\u0004a\u0001!\u0007\u0003\n\u0005%\t\u0001\u0004\u0001M\u0001C\u000f!\u0011!U\u0002\u0002\u0011\u0005\t<1\u0001B\u0003\u0007\u000f!I\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/ModifierCheckerCore$Compatibility;", "", "(Ljava/lang/String;I)V", "COMPATIBLE", "REDUNDANT", "REVERSE_REDUNDANT", "REPEATED", "DEPRECATED", "INCOMPATIBLE", "COMPATIBLE_FOR_CLASSES_ONLY"}, moduleName="kotlin-compiler")
    private static final class Compatibility
    extends Enum<Compatibility> {
        public static final /* enum */ Compatibility COMPATIBLE;
        public static final /* enum */ Compatibility REDUNDANT;
        public static final /* enum */ Compatibility REVERSE_REDUNDANT;
        public static final /* enum */ Compatibility REPEATED;
        public static final /* enum */ Compatibility DEPRECATED;
        public static final /* enum */ Compatibility INCOMPATIBLE;
        public static final /* enum */ Compatibility COMPATIBLE_FOR_CLASSES_ONLY;
        private static final /* synthetic */ Compatibility[] $VALUES;

        static {
            Compatibility[] compatibilityArray = new Compatibility[7];
            Compatibility[] compatibilityArray2 = compatibilityArray;
            compatibilityArray[0] = COMPATIBLE = new Compatibility();
            compatibilityArray[1] = REDUNDANT = new Compatibility();
            compatibilityArray[2] = REVERSE_REDUNDANT = new Compatibility();
            compatibilityArray[3] = REPEATED = new Compatibility();
            compatibilityArray[4] = DEPRECATED = new Compatibility();
            compatibilityArray[5] = INCOMPATIBLE = new Compatibility();
            compatibilityArray[6] = COMPATIBLE_FOR_CLASSES_ONLY = new Compatibility();
            $VALUES = compatibilityArray;
        }

        public static Compatibility[] values() {
            return (Compatibility[])$VALUES.clone();
        }

        public static Compatibility valueOf(String string) {
            return Enum.valueOf(Compatibility.class, string);
        }
    }
}

