/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BodiesResolveContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.CoercionStrategy;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.PreliminaryDeclarationVisitor;

public class ScriptBodyResolver {
    private final ExpressionTypingServices expressionTypingServices;

    public ScriptBodyResolver(@NotNull ExpressionTypingServices expressionTypingServices) {
        if (expressionTypingServices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionTypingServices", "org/jetbrains/kotlin/resolve/ScriptBodyResolver", "<init>"));
        }
        this.expressionTypingServices = expressionTypingServices;
    }

    public void resolveScriptBodies(@NotNull BodiesResolveContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/ScriptBodyResolver", "resolveScriptBodies"));
        }
        for (Map.Entry<KtScript, ScriptDescriptor> e : c.getScripts().entrySet()) {
            ScriptDescriptor descriptor2 = e.getValue();
            ForceResolveUtil.forceResolveAllContents(descriptor2);
        }
    }

    @NotNull
    public KotlinType resolveScriptReturnType(@NotNull KtScript script, @NotNull LexicalScope scopeForBodyResolution, @NotNull BindingTrace trace) {
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/kotlin/resolve/ScriptBodyResolver", "resolveScriptReturnType"));
        }
        if (scopeForBodyResolution == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeForBodyResolution", "org/jetbrains/kotlin/resolve/ScriptBodyResolver", "resolveScriptReturnType"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/ScriptBodyResolver", "resolveScriptReturnType"));
        }
        ExpressionTypingContext context = ExpressionTypingContext.newContext(trace, scopeForBodyResolution, DataFlowInfo.EMPTY, TypeUtils.NO_EXPECTED_TYPE);
        PreliminaryDeclarationVisitor.Companion.createForDeclaration(script, trace);
        KotlinType returnType2 = this.expressionTypingServices.getBlockReturnedType(script.getBlockExpression(), CoercionStrategy.NO_COERCION, context).getType();
        if (returnType2 == null) {
            returnType2 = ErrorUtils.createErrorType("getBlockReturnedType returned null");
        }
        KotlinType kotlinType = returnType2;
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ScriptBodyResolver", "resolveScriptReturnType"));
        }
        return kotlinType;
    }
}

