/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.bindingContextUtil;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.SequencesKt;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"i\u0015\tA1A\u0003\u0002\u0011\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\t)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005Aq\"B\u0001\r\u0003\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\f\u0015\tA1A\u0003\u0002\u0011\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u001b\u0013\"1\t\u0002\u0005\u0001\u001b\ta\t\u0001*\u0001\u0012\u0005\u0011\u0001\u0001\"A\t\u0005\t\u0003A\t!F\u0001\u0019\u0004U\t\u0001DAM\u000b\u0011\u000biq!\u0003\u0002\n\u0003\u0011\n\u0011BA\u0005\u0002I\u0003A2\u0001UB\u00013\u0013A9!D\u0001%\u0003A\u001b\u0011!U\u0002\u0002\u0011\u0011!6\u0011B\u0007\r\u0011\u0015i\u0011\u0001g\u0003\u0016\u0003a\u0011\u0011\u0014\u0002\u0005\u0007\u001b\u0005Aj\u0001UB\u0001)\u000e%Qb\u0004\u0005\b\u001b\u0011I!!C\u0001\u0019\u0011a=Q#\u0001M\t3\u0013A\u0011\"D\u0001\u0019\u0005A\u001b\t\u0001VB\u0005\u001b5A\u0019\"\u0004\u0002\r\u0002aQQ#\u0001M\u000b3\u0013A\u0011\"D\u0001\u0019\u0005A\u001b\t\u0001VB\u0005\u001b5A1\"\u0004\u0002\r\u0002a]Q#\u0001M\u000b3\u0013A\u0011\"D\u0001\u0019\u0005A\u001b\t\u0001VB\u0005\u001b1AA\"D\u0001\u0019\u001aU\t\u0001\u0014CM\u0005\u0011%i\u0011\u0001\u0007\u0002Q\u0007\u0003!6\u0011B\u0007\r\u00115i\u0011\u0001'\u0007\u0016\u0003aE\u0011\u0014\u0002\u0005\n\u001b\u0005A\"\u0001UB\u0001)\u000e%Q\u0002\u0004E\u000e\u001b\u0005AJ\"F\u0001\u0019\u0012e%\u0001\"C\u0007\u00021\t\u00016\u0011\u0001+\u0004\n5A\u0002BD\u0007\u00021;\tr\u0001\u0002\u0001\t\u001fU!\u0011BA\u0005\u0002I=Az\"\u0006\u0003\n\u0005%\tAe\u0004M\u00103\u0017A\u0001#\u0004\u0002\r\u0002aE\u0001k!\u0001U\u0007\u0013i)\u0003#\t\u000e\u0003auQ#\u0001\r\u00123\u0013A\u0019#D\u0001\u0019%A\u001b\t!g\u0003\t&5\u0011A\u0012\u0001\r\u0014!\u000e\tAk!\u0003"}, strings={"get", "V", "K", "", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "slice", "Lorg/jetbrains/kotlin/util/slicedMap/ReadOnlySlice;", "key", "(Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/util/slicedMap/ReadOnlySlice;Ljava/lang/Object;)Ljava/lang/Object;", "BindingContextUtilsKt", "getDataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "position", "Lcom/intellij/psi/PsiElement;", "getReferenceTargets", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "context", "getTargetFunction", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "getTargetFunctionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "isUnreachableCode", "", "isUsedAsExpression", "isUsedAsStatement", "recordDataFlowInfo", "", "C", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "expression", "recordScope", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;"}, moduleName="kotlin-compiler")
public final class BindingContextUtilsKt {
    @Nullable
    public static final <K, V> V get(BindingContext $receiver, @NotNull ReadOnlySlice<K, V> slice, K key) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(slice, "slice");
        return $receiver.get(slice, key);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final FunctionDescriptor getTargetFunctionDescriptor(KtReturnExpression $receiver, @NotNull BindingContext context) {
        void $receiver2;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context, "context");
        KtSimpleNameExpression targetLabel = $receiver.getTargetLabel();
        if (targetLabel != null) {
            SimpleFunctionDescriptor simpleFunctionDescriptor;
            PsiElement psiElement2 = (PsiElement)context.get(BindingContext.LABEL_TARGET, targetLabel);
            if (psiElement2 != null) {
                PsiElement $receiver3 = psiElement2;
                PsiElement it2 = $receiver3;
                simpleFunctionDescriptor = (SimpleFunctionDescriptor)context.get(BindingContext.FUNCTION, it2);
            } else {
                simpleFunctionDescriptor = null;
            }
            return simpleFunctionDescriptor;
        }
        PsiElement it2 = $receiver;
        ReadOnlySlice<PsiElement, DeclarationDescriptor> readOnlySlice = BindingContext.DECLARATION_TO_DESCRIPTOR;
        BindingContext bindingContext2 = context;
        KtDeclarationWithBody ktDeclarationWithBody = PsiTreeUtil.getParentOfType((PsiElement)$receiver2, KtDeclarationWithBody.class, false);
        DeclarationDescriptor declarationDescriptor = bindingContext2.get(readOnlySlice, ktDeclarationWithBody);
        FunctionDescriptor containingFunctionDescriptor = DescriptorUtils.getParentOfType(declarationDescriptor, FunctionDescriptor.class, false);
        if (containingFunctionDescriptor == null) {
            return null;
        }
        return SequencesKt.firstOrNull(SequencesKt.dropWhile(SequencesKt.sequence(containingFunctionDescriptor, (Function1)getTargetFunctionDescriptor.2.INSTANCE), getTargetFunctionDescriptor.3.INSTANCE));
    }

    @Nullable
    public static final KtCallableDeclaration getTargetFunction(KtReturnExpression $receiver, @NotNull BindingContext context) {
        KtCallableDeclaration ktCallableDeclaration;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context, "context");
        FunctionDescriptor functionDescriptor = BindingContextUtilsKt.getTargetFunctionDescriptor($receiver, context);
        if (functionDescriptor != null) {
            FunctionDescriptor $receiver2 = functionDescriptor;
            FunctionDescriptor it2 = $receiver2;
            PsiElement psiElement2 = DescriptorToSourceUtils.descriptorToDeclaration(it2);
            if (!(psiElement2 instanceof KtCallableDeclaration)) {
                psiElement2 = null;
            }
            ktCallableDeclaration = (KtCallableDeclaration)psiElement2;
        } else {
            ktCallableDeclaration = null;
        }
        return ktCallableDeclaration;
    }

    public static final boolean isUsedAsExpression(KtExpression $receiver, @NotNull BindingContext context) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Object v = context.get(BindingContext.USED_AS_EXPRESSION, $receiver);
        if (v == null) {
            Intrinsics.throwNpe();
        }
        return (Boolean)v;
    }

    public static final boolean isUsedAsStatement(KtExpression $receiver, @NotNull BindingContext context) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context, "context");
        return !BindingContextUtilsKt.isUsedAsExpression($receiver, context);
    }

    public static final <C extends ResolutionContext<C>> void recordDataFlowInfo(ResolutionContext<C> $receiver, @Nullable KtExpression expression) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if (expression == null) {
            return;
        }
        KotlinTypeInfo typeInfo = (KotlinTypeInfo)$receiver.trace.get(BindingContext.EXPRESSION_TYPE_INFO, expression);
        if (typeInfo != null) {
            BindingTrace bindingTrace = $receiver.trace;
            DataFlowInfo dataFlowInfo = $receiver.dataFlowInfo;
            Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "dataFlowInfo");
            bindingTrace.record(BindingContext.EXPRESSION_TYPE_INFO, expression, typeInfo.replaceDataFlowInfo(dataFlowInfo));
        } else if (Intrinsics.areEqual($receiver.dataFlowInfo, DataFlowInfo.EMPTY) ^ true) {
            BindingTrace bindingTrace = $receiver.trace;
            DataFlowInfo dataFlowInfo = $receiver.dataFlowInfo;
            Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "dataFlowInfo");
            bindingTrace.record(BindingContext.EXPRESSION_TYPE_INFO, expression, TypeInfoFactoryKt.noTypeInfo(dataFlowInfo));
        }
    }

    public static final void recordScope(BindingTrace $receiver, @NotNull LexicalScope scope2, @Nullable KtElement element) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        if (element != null) {
            HierarchicalScope hierarchicalScope = ScopeUtilsKt.takeSnapshot(scope2);
            if (hierarchicalScope == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.scopes.LexicalScope");
            }
            $receiver.record(BindingContext.LEXICAL_SCOPE, element, (LexicalScope)hierarchicalScope);
        }
    }

    @NotNull
    public static final DataFlowInfo getDataFlowInfo(BindingContext $receiver, @NotNull PsiElement position) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(position, "position");
        Iterator<PsiElement> iterator2 = PsiUtilsKt.getParentsWithSelf(position).iterator();
        while (iterator2.hasNext()) {
            Object $receiver2;
            Object object;
            PsiElement element = iterator2.next();
            PsiElement psiElement2 = element;
            if (!(psiElement2 instanceof KtExpression)) {
                psiElement2 = null;
            }
            if ((object = (KtExpression)psiElement2) == null) continue;
            KtExpression ktExpression = object;
            Object it2 = (KtExpression)$receiver2;
            object = (KotlinTypeInfo)$receiver.get(BindingContext.EXPRESSION_TYPE_INFO, it2);
            if (object == null) continue;
            $receiver2 = object;
            it2 = (KotlinTypeInfo)$receiver2;
            return ((KotlinTypeInfo)it2).getDataFlowInfo();
        }
        DataFlowInfo dataFlowInfo = DataFlowInfo.EMPTY;
        Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "DataFlowInfo.EMPTY");
        return dataFlowInfo;
    }

    public static final boolean isUnreachableCode(KtExpression $receiver, @NotNull BindingContext context) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Object v = context.get(BindingContext.UNREACHABLE_CODE, $receiver);
        if (v == null) {
            Intrinsics.throwNpe();
        }
        return (Boolean)v;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final Collection<DeclarationDescriptor> getReferenceTargets(KtExpression $receiver, @NotNull BindingContext context) {
        Collection collection;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context, "context");
        DeclarationDescriptor targetDescriptor = $receiver instanceof KtReferenceExpression ? (DeclarationDescriptor)context.get(BindingContext.REFERENCE_TARGET, $receiver) : (DeclarationDescriptor)null;
        List<DeclarationDescriptor> list = targetDescriptor;
        if (list != null) {
            DeclarationDescriptor $receiver2 = list;
            DeclarationDescriptor it2 = $receiver2;
            list = CollectionsKt.listOf(it2);
            if (list != null) {
                collection = list;
                return collection;
            }
        }
        collection = CollectionsKt.orEmpty((Collection)context.get(BindingContext.AMBIGUOUS_REFERENCE_TARGET, $receiver));
        return collection;
    }
}

