/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallCompleter;
import org.jetbrains.kotlin.resolve.calls.CandidateResolver;
import org.jetbrains.kotlin.resolve.calls.GenericCandidateResolverKt;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.ResolveArgumentsMode;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CallCandidateResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CheckArgumentTypesMode;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionResultsCache;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemCompleter;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemImpl;
import org.jetbrains.kotlin.resolve.calls.inference.InferenceErrorData;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.kotlin.resolve.calls.results.ResolutionStatus;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.validation.SymbolUsageValidator;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.DataFlowAnalyzer;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u0001\u0004)\u0011\u0001D\u0001\u0006\u0003!\u0001Q\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001BD\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0011\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\rQ!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0011\u0017)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!1\u0001\u0004\u0001\u001a\u0003a\u0005\u00115H\u0005\u0004\u0011\u0005i\u0011\u0001g\u0001\n\u0007!\u0011Q\"\u0001M\u0003\u0013\rA1!D\u0001\u0019\b%\u0019\u0001\u0002B\u0007\u00021\u0013Ia\u0001C\u0003\u000e\t%\u0011\u0011\"\u0001\r\u00071\u0017I1\u0001#\u0004\u000e\u0003a9\u0011kA\u0001\t\u0010\u0015\"B!\u0001\u0005\t\u001b\u0005A\n\"\u0005\u0003\u0005\u0001!IQ#\u0001M\n3\rA!\"D\u0001\u0019\u0016e1\u0001bC\u0007\u0005\u0013\tI\u0011\u0001J\u0005\u0019\u0018\u0015\"B!\u0001\u0005\r\u001b\u0005A\n\"\u0005\u0003\u0005\u0001!IQ#\u0001M\n3\rA!\"D\u0001\u0019\u0016e1\u0001bC\u0007\u0005\u0013\tI\u0011\u0001J\u0005\u0019\u0018\u0015R\u0002\u0012D\u0007\u0005\u0013\tI\u0011\u0001J\u0005\u0019\u0018E!A\u0001\u0001\u0005\n+\u0005A\u001a\"G\u0002\t\u00155\t\u0001TC\r\u0007\u0011-iA!\u0003\u0002\n\u0003\u0011J\u0001tC\r\u0004\u00115i\u0011\u0001g\u0007&\u001f\u0011\t\u0001BD\u0007\u0005\u0013\u0005!\u0019\u0001$\u0001\u0019\u0018e\u0019\u0001RD\u0007\u00021=I2\u0001\u0003\u0006\u000e\u0003aUQ\u0005\u0004\u0003\u0002\u0011?i\u0011\u0001'\u0005\u001a\u0007!\u0001R\"\u0001M\u00113\rA!\"D\u0001\u0019\u0016\u0015\u0002C!\u0001\u0005\u0012\u001b\u0005A\n\"\u0005\u0003\u0005\u0001!IQ#\u0001M\n3\u001dA\u0019#D\u0003\n\u0005%\tA%\u0003G\u00011IIb\u0001C\u0006\u000e\t%\u0011\u0011\"\u0001\u0013\n1/I2\u0001\u0003\u0006\u000e\u0003aU\u0011d\u0001\u0005\u000e\u001b\u0005AZ\"\n\u0007\u0005\u0003!\u0015R\"\u0001\r\u00143\rAi\"D\u0001\u0019\u001fe\u0019\u0001rE\u0007\u00021Q)s\u0003B\u0001\t*5\u0011A\u0012\u0001\r\u00163\u0011AY#\u0004\u0002\r\u0002a)\u0012\u0004\u0002\u0005\u0017\u001b\ta\t\u0001G\u000b\u001a\u0007!5R\"\u0001\r\u00103\rA9#D\u0001\u0019)\u0015JB!\u0001\u0005\u0018\u001b\u0005A\n\"\u0005\u0003\u0005\u0001!IQ#\u0001M\n+\u0011I!!C\u0001%\u0013a\u0011\u0012\u0014\u0002E\u0018\u001b\u0005AR\u0003UB\u00013\u0013A9#D\u0001\u0019)A\u001b\u0011!J\r\u0005\u0003!AR\"\u0001M\t#\u0011!\u0001\u0001C\u0005\u0016\u0003aMQ\u0003B\u0005\u0003\u0013\u0005!\u0013\u0002\u0007\n\u001a\n!QQ\"\u0001M\u000b!\u000e\u0005\u0011\u0014\u0002\u0005\u000e\u001b\u0005AZ\u0002U\u0002\u0002S\u001d!\u0011\t\u0003\u0005\u0002\u001b\u0005A\u001a!U\u0002\u0002\u000b\u0001Is\u0001B!\t\u0011\u001bi\u0011\u0001G\u0004R\u0007\u0005)\u0001!\u000b\u0006\u0005\u0003\"AQ!\u0004\u0003\n\u0005%\t\u0001D\u0002M\u0006#\u000e\tQ\u0001A\u0015\b\t\u0005C\u0001BA\u0007\u00021\u000b\t6!A\u0003\u0001S\u001d!\u0011\t\u0003\u0005\u0005\u001b\u0005AJ!U\u0002\u0002\u000b\u0001Is\u0001B!\t\u0011\ri\u0011\u0001g\u0002R\u0007\u0005)\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/calls/CallCompleter;", "", "argumentTypeResolver", "Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;", "candidateResolver", "Lorg/jetbrains/kotlin/resolve/calls/CandidateResolver;", "symbolUsageValidator", "Lorg/jetbrains/kotlin/resolve/validation/SymbolUsageValidator;", "dataFlowAnalyzer", "Lorg/jetbrains/kotlin/types/expressions/DataFlowAnalyzer;", "callCheckers", "", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "(Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;Lorg/jetbrains/kotlin/resolve/calls/CandidateResolver;Lorg/jetbrains/kotlin/resolve/validation/SymbolUsageValidator;Lorg/jetbrains/kotlin/types/expressions/DataFlowAnalyzer;Ljava/lang/Iterable;Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;)V", "completeAllCandidates", "", "D", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;", "results", "Lorg/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResultsImpl;", "completeArguments", "completeCall", "tracing", "Lorg/jetbrains/kotlin/resolve/calls/tasks/TracingStrategy;", "completeCallForArgument", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "completeOneArgument", "valueArgument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "completeResolvedCallAndArguments", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/MutableResolvedCall;", "hasNecessarySafeCall", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "updateRecordedTypeForArgument", "Lorg/jetbrains/kotlin/types/KotlinType;", "updatedType", "recordedType", "argumentExpression", "completeConstraintSystem", "expectedType", "updateResolutionStatusFromConstraintSystem"}, moduleName="kotlin-compiler")
public final class CallCompleter {
    private final ArgumentTypeResolver argumentTypeResolver;
    private final CandidateResolver candidateResolver;
    private final SymbolUsageValidator symbolUsageValidator;
    private final DataFlowAnalyzer dataFlowAnalyzer;
    private final Iterable<? extends CallChecker> callCheckers;
    private final KotlinBuiltIns builtIns;

    @NotNull
    public final <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> completeCall(@NotNull BasicCallResolutionContext context, @NotNull OverloadResolutionResultsImpl<D> results, @NotNull TracingStrategy tracing) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(results, "results");
        Intrinsics.checkParameterIsNotNull(tracing, "tracing");
        ResolvedCall resolvedCall = results.isSingleResult() ? results.getResultingCall() : (MutableResolvedCall)null;
        Call call = context.call;
        Intrinsics.checkExpressionValueIsNotNull(call, "context.call");
        if (!CallResolverUtilKt.isInvokeCallOnVariable(call)) {
            TemporaryBindingTrace temporaryBindingTrace = TemporaryBindingTrace.create(context.trace, "Trace to complete a resulting call");
            BasicCallResolutionContext basicCallResolutionContext = (BasicCallResolutionContext)context.replaceBindingTrace(temporaryBindingTrace);
            Intrinsics.checkExpressionValueIsNotNull(basicCallResolutionContext, "context.replaceBindingTrace(temporaryTrace)");
            this.completeResolvedCallAndArguments((MutableResolvedCall<D>)resolvedCall, results, basicCallResolutionContext, tracing);
            this.completeAllCandidates(context, results);
            temporaryBindingTrace.commit();
        }
        if (resolvedCall != null) {
            context.performContextDependentCallChecks(resolvedCall);
            for (CallChecker callChecker : this.callCheckers) {
                callChecker.check(resolvedCall, context);
            }
            KtExpression ktExpression = resolvedCall instanceof VariableAsFunctionResolvedCall ? ((VariableAsFunctionResolvedCall)((Object)resolvedCall)).getVariableCall().getCall().getCalleeExpression() : resolvedCall.getCall().getCalleeExpression();
            Object d = resolvedCall.getResultingDescriptor();
            Intrinsics.checkExpressionValueIsNotNull(d, "resolvedCall.getResultingDescriptor()");
            BindingTrace bindingTrace = context.trace;
            Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
            KtExpression ktExpression2 = ktExpression;
            if (ktExpression2 == null) {
                Intrinsics.throwNpe();
            }
            PsiElement psiElement2 = ktExpression2;
            Intrinsics.checkExpressionValueIsNotNull(psiElement2, "element!!");
            this.symbolUsageValidator.validateCall(resolvedCall, (CallableDescriptor)d, bindingTrace, psiElement2);
        }
        if (results.isSingleResult() && results.getResultingCall().getStatus().isSuccess()) {
            OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = results.changeStatusToSuccess();
            Intrinsics.checkExpressionValueIsNotNull(overloadResolutionResultsImpl, "results.changeStatusToSuccess()");
            return overloadResolutionResultsImpl;
        }
        return results;
    }

    /*
     * WARNING - void declaration
     */
    private final <D extends CallableDescriptor> void completeAllCandidates(BasicCallResolutionContext context, OverloadResolutionResultsImpl<D> results) {
        void destination;
        void $receiver;
        Iterable $receiver2;
        Collection<ResolvedCall<D>> collection;
        if (context.collectAllCandidates) {
            Collection<ResolvedCall<D>> collection2 = results.getAllCandidates();
            if (collection2 == null) {
                Intrinsics.throwNpe();
            }
            collection = collection2;
            Intrinsics.checkExpressionValueIsNotNull(collection2, "results.getAllCandidates()!!");
        } else {
            Collection<MutableResolvedCall<D>> collection3 = results.getResultingCalls();
            collection = collection3;
            Intrinsics.checkExpressionValueIsNotNull(collection3, "results.getResultingCalls()");
        }
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Collection<org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall<D>>");
        }
        Collection<ResolvedCall<D>> candidates = collection;
        Iterable iterable = candidates;
        Iterator iterator2 = $receiver2;
        Collection collection4 = new ArrayList();
        for (Object element : $receiver) {
            MutableResolvedCall resolvedCall = (MutableResolvedCall)element;
            if (!(!resolvedCall.isCompleted())) continue;
            destination.add(element);
        }
        $receiver2 = (List)destination;
        for (Object element : $receiver2) {
            MutableResolvedCall resolvedCall = (MutableResolvedCall)element;
            TemporaryBindingTrace temporaryBindingTrace = TemporaryBindingTrace.create(context.trace, "Trace to complete a candidate that is not a resulting call");
            BasicCallResolutionContext basicCallResolutionContext = (BasicCallResolutionContext)context.replaceBindingTrace(temporaryBindingTrace);
            Intrinsics.checkExpressionValueIsNotNull(basicCallResolutionContext, "context.replaceBindingTrace(temporaryBindingTrace)");
            TracingStrategy tracingStrategy = TracingStrategy.EMPTY;
            Intrinsics.checkExpressionValueIsNotNull(tracingStrategy, "TracingStrategy.EMPTY");
            this.completeResolvedCallAndArguments(resolvedCall, results, basicCallResolutionContext, tracingStrategy);
        }
    }

    private final <D extends CallableDescriptor> void completeResolvedCallAndArguments(MutableResolvedCall<D> resolvedCall, OverloadResolutionResultsImpl<D> results, BasicCallResolutionContext context, TracingStrategy tracing) {
        if (resolvedCall == null || resolvedCall.isCompleted() || resolvedCall.getConstraintSystem() == null) {
            Unit unit;
            this.completeArguments(context, results);
            MutableResolvedCall<D> mutableResolvedCall = resolvedCall;
            if (mutableResolvedCall != null) {
                mutableResolvedCall.markCallAsCompleted();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            return;
        }
        KotlinType kotlinType = context.expectedType;
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "context.expectedType");
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
        this.completeConstraintSystem(resolvedCall, kotlinType, bindingTrace);
        this.completeArguments(context, results);
        this.updateResolutionStatusFromConstraintSystem(resolvedCall, context, tracing);
        resolvedCall.markCallAsCompleted();
    }

    private final <D extends CallableDescriptor> void completeConstraintSystem(MutableResolvedCall<D> $receiver, KotlinType expectedType, BindingTrace trace) {
        ConstraintSystemCompleter constraintSystemCompleter;
        Function1<Function1<? super ConstraintSystemImpl, ? extends Boolean>, Unit> updateSystemIfSuccessful$ = new Function1<Function1<? super ConstraintSystemImpl, ? extends Boolean>, Unit>($receiver){
            final /* synthetic */ MutableResolvedCall receiver$0;

            public final void invoke(@NotNull Function1<? super ConstraintSystemImpl, ? extends Boolean> update) {
                Intrinsics.checkParameterIsNotNull(update, "update");
                ConstraintSystem constraintSystem = this.receiver$0.getConstraintSystem();
                if (constraintSystem == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemImpl");
                }
                ConstraintSystem constraintSystem2 = ((ConstraintSystemImpl)constraintSystem).copy();
                if (constraintSystem2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemImpl");
                }
                ConstraintSystemImpl copy2 = (ConstraintSystemImpl)constraintSystem2;
                if (update.invoke(copy2).booleanValue()) {
                    this.receiver$0.setConstraintSystem(copy2);
                }
            }
            {
                this.receiver$0 = mutableResolvedCall;
                super(1);
            }
        };
        KotlinType returnType2 = $receiver.getCandidateDescriptor().getReturnType();
        if (returnType2 != null) {
            ConstraintSystem constraintSystem = $receiver.getConstraintSystem();
            if (constraintSystem == null) {
                Intrinsics.throwNpe();
            }
            constraintSystem.addSupertypeConstraint(expectedType, returnType2, ConstraintPositionKind.EXPECTED_TYPE_POSITION.position());
        }
        if ((constraintSystemCompleter = (ConstraintSystemCompleter)trace.get(BindingContext.CONSTRAINT_SYSTEM_COMPLETER, $receiver.getCall().getCalleeExpression())) != null) {
            updateSystemIfSuccessful$.invoke((Function1<ConstraintSystemImpl, Boolean>)((Function1<? super ConstraintSystemImpl, ? extends Boolean>)new Function1<ConstraintSystemImpl, Boolean>($receiver, constraintSystemCompleter){
                final /* synthetic */ MutableResolvedCall receiver$0;
                final /* synthetic */ ConstraintSystemCompleter $constraintSystemCompleter;

                public final boolean invoke(@NotNull ConstraintSystemImpl system) {
                    Intrinsics.checkParameterIsNotNull(system, "system");
                    this.$constraintSystemCompleter.completeConstraintSystem(system, this.receiver$0);
                    return !system.filterConstraintsOut(ConstraintPositionKind.TYPE_BOUND_POSITION).getStatus().hasOnlyErrorsDerivedFrom(ConstraintPositionKind.FROM_COMPLETER);
                }
                {
                    this.receiver$0 = mutableResolvedCall;
                    this.$constraintSystemCompleter = constraintSystemCompleter;
                    super(1);
                }
            }));
        }
        if (returnType2 != null && expectedType == TypeUtils.UNIT_EXPECTED_TYPE) {
            updateSystemIfSuccessful$.invoke((Function1<ConstraintSystemImpl, Boolean>)((Function1<? super ConstraintSystemImpl, ? extends Boolean>)new Function1<ConstraintSystemImpl, Boolean>(this, returnType2){
                final /* synthetic */ CallCompleter this$0;
                final /* synthetic */ KotlinType $returnType;

                public final boolean invoke(@NotNull ConstraintSystemImpl system) {
                    Intrinsics.checkParameterIsNotNull(system, "system");
                    system.addSupertypeConstraint(CallCompleter.access$getBuiltIns$p(this.this$0).getUnitType(), this.$returnType, ConstraintPositionKind.EXPECTED_TYPE_POSITION.position());
                    return system.getStatus().isSuccessful();
                }
                {
                    this.this$0 = callCompleter;
                    this.$returnType = kotlinType;
                    super(1);
                }
            }));
        }
        ConstraintSystem constraintSystem = $receiver.getConstraintSystem();
        if (constraintSystem == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemImpl");
        }
        ConstraintSystemImpl constraintSystem2 = (ConstraintSystemImpl)constraintSystem;
        constraintSystem2.fixVariables();
        ConstraintSystem constraintSystem3 = $receiver.getConstraintSystem();
        if (constraintSystem3 == null) {
            Intrinsics.throwNpe();
        }
        $receiver.setResultingSubstitutor(constraintSystem3.getResultingSubstitutor());
    }

    private final <D extends CallableDescriptor> void updateResolutionStatusFromConstraintSystem(MutableResolvedCall<D> $receiver, BasicCallResolutionContext context, TracingStrategy tracing) {
        CallCandidateResolutionContext<D> contextWithResolvedCall;
        CallCandidateResolutionContext<D> callCandidateResolutionContext = contextWithResolvedCall = CallCandidateResolutionContext.createForCallBeingAnalyzed($receiver, context, tracing);
        Intrinsics.checkExpressionValueIsNotNull(callCandidateResolutionContext, "contextWithResolvedCall");
        CandidateResolver.ValueArgumentsCheckingResult valueArgumentsCheckingResult = this.candidateResolver.checkAllValueArguments(callCandidateResolutionContext, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
        ResolutionStatus status = $receiver.getStatus();
        ConstraintSystem constraintSystem = $receiver.getConstraintSystem();
        if (constraintSystem == null) {
            Intrinsics.throwNpe();
        }
        if (constraintSystem.getStatus().isSuccessful()) {
            if (Intrinsics.areEqual((Object)status, (Object)ResolutionStatus.UNKNOWN_STATUS) || Intrinsics.areEqual((Object)status, (Object)ResolutionStatus.INCOMPLETE_TYPE_INFERENCE)) {
                $receiver.setStatusToSuccess();
            }
            return;
        }
        KotlinType receiverType = $receiver.getExtensionReceiver().exists() ? $receiver.getExtensionReceiver().getType() : (KotlinType)null;
        Object d = $receiver.getCandidateDescriptor();
        ConstraintSystem constraintSystem2 = $receiver.getConstraintSystem();
        if (constraintSystem2 == null) {
            Intrinsics.throwNpe();
        }
        InferenceErrorData errorData = InferenceErrorData.create(d, constraintSystem2, valueArgumentsCheckingResult.getArgumentTypes(), receiverType, context.expectedType);
        tracing.typeInferenceFailed(context.trace, errorData);
        $receiver.addStatus(ResolutionStatus.OTHER_ERROR);
    }

    private final <D extends CallableDescriptor> void completeArguments(BasicCallResolutionContext context, OverloadResolutionResultsImpl<D> results) {
        Function1 getDataFlowInfoForArgument;
        Function1 getArgumentMapping;
        if (Intrinsics.areEqual((Object)context.checkArguments, (Object)CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS) ^ true) {
            return;
        }
        if (results.isSingleResult()) {
            ResolvedCall resolvedCall = results.getResultingCall();
            getArgumentMapping = new Function1<ValueArgument, ArgumentMapping>((MutableResolvedCall)resolvedCall){
                final /* synthetic */ MutableResolvedCall $resolvedCall;

                @NotNull
                public final ArgumentMapping invoke(@NotNull ValueArgument argument) {
                    Intrinsics.checkParameterIsNotNull(argument, "argument");
                    ArgumentMapping argumentMapping = this.$resolvedCall.getArgumentMapping(argument);
                    Intrinsics.checkExpressionValueIsNotNull(argumentMapping, "resolvedCall.getArgumentMapping(argument)");
                    return argumentMapping;
                }
                {
                    this.$resolvedCall = mutableResolvedCall;
                    super(1);
                }
            };
            getDataFlowInfoForArgument = new Function1<ValueArgument, DataFlowInfo>((MutableResolvedCall)resolvedCall){
                final /* synthetic */ MutableResolvedCall $resolvedCall;

                @NotNull
                public final DataFlowInfo invoke(@NotNull ValueArgument argument) {
                    Intrinsics.checkParameterIsNotNull(argument, "argument");
                    DataFlowInfo dataFlowInfo = this.$resolvedCall.getDataFlowInfoForArguments().getInfo(argument);
                    Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "resolvedCall.getDataFlow\u2026ments().getInfo(argument)");
                    return dataFlowInfo;
                }
                {
                    this.$resolvedCall = mutableResolvedCall;
                    super(1);
                }
            };
        } else {
            getArgumentMapping = completeArguments.3.INSTANCE;
            getDataFlowInfoForArgument = new Function1<ValueArgument, DataFlowInfo>(context){
                final /* synthetic */ BasicCallResolutionContext $context;

                @NotNull
                public final DataFlowInfo invoke(@NotNull ValueArgument it2) {
                    Intrinsics.checkParameterIsNotNull(it2, "it");
                    DataFlowInfo dataFlowInfo = this.$context.dataFlowInfo;
                    Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "context.dataFlowInfo");
                    return dataFlowInfo;
                }
                {
                    this.$context = basicCallResolutionContext;
                    super(1);
                }
            };
        }
        Iterator<? extends ValueArgument> iterator2 = context.call.getValueArguments().iterator();
        while (iterator2.hasNext()) {
            BasicCallResolutionContext newContext;
            ArgumentMapping argumentMapping;
            ArgumentMapping argumentMapping2;
            ValueArgument valueArgument;
            ValueArgument valueArgument2 = valueArgument = iterator2.next();
            if (valueArgument2 == null) {
                Intrinsics.throwNpe();
            }
            KotlinType expectedType = (argumentMapping2 = (argumentMapping = (ArgumentMapping)getArgumentMapping.invoke(valueArgument2))) instanceof ArgumentMatch ? CallResolverUtilKt.getEffectiveExpectedType(((ArgumentMatch)argumentMapping).getValueParameter(), valueArgument) : TypeUtils.NO_EXPECTED_TYPE;
            BasicCallResolutionContext basicCallResolutionContext = newContext = (BasicCallResolutionContext)((BasicCallResolutionContext)context.replaceDataFlowInfo((DataFlowInfo)getDataFlowInfoForArgument.invoke(valueArgument))).replaceExpectedType(expectedType);
            Intrinsics.checkExpressionValueIsNotNull(basicCallResolutionContext, "newContext");
            this.completeOneArgument(valueArgument, basicCallResolutionContext);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void completeOneArgument(ValueArgument valueArgument, BasicCallResolutionContext context) {
        KotlinTypeInfo kotlinTypeInfo;
        KotlinTypeInfo kotlinTypeInfo2;
        KtCallableReferenceExpression $receiver;
        Object resolvedCall;
        KotlinType recordedType;
        void $receiver2;
        if (valueArgument.isExternal()) {
            return;
        }
        KtExpression ktExpression = valueArgument.getArgumentExpression();
        if (ktExpression == null) {
            return;
        }
        KtExpression expression = ktExpression;
        KtExpression ktExpression2 = KtPsiUtil.getLastElementDeparenthesized(expression, context.statementFilter);
        if (ktExpression2 == null) {
            return;
        }
        KtExpression deparenthesized = ktExpression2;
        KtExpression ktExpression3 = expression;
        KtExpression it2 = (KtExpression)$receiver2;
        KotlinType updatedType = recordedType = context.trace.getType(it2);
        KtExpression ktExpression4 = deparenthesized;
        Intrinsics.checkExpressionValueIsNotNull(ktExpression4, "deparenthesized");
        OverloadResolutionResultsImpl<?> results = this.completeCallForArgument(ktExpression4, context);
        if (results != null && results.isSingleResult()) {
            KotlinType kotlinType;
            resolvedCall = results.getResultingCall();
            if (resolvedCall.hasInferredReturnType()) {
                Object d = resolvedCall.getResultingDescriptor();
                kotlinType = d != null ? d.getReturnType() : null;
            } else {
                kotlinType = updatedType = (KotlinType)null;
            }
        }
        if (recordedType != null && !recordedType.getConstructor().isDenotable()) {
            KotlinType kotlinType = this.argumentTypeResolver.updateResultArgumentTypeIfNotDenotable(context, expression);
            if (kotlinType == null) {
                kotlinType = updatedType;
            }
            updatedType = kotlinType;
        }
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
        updatedType = this.updateRecordedTypeForArgument(updatedType, recordedType, expression, bindingTrace);
        KtFunction ktFunction = ArgumentTypeResolver.getFunctionLiteralArgumentIfAny(expression, context);
        if (ktFunction != null) {
            resolvedCall = ktFunction;
            KtFunction functionLiteralArgument = (KtFunction)((Object)$receiver);
            kotlinTypeInfo2 = this.argumentTypeResolver.getFunctionLiteralTypeInfo(expression, functionLiteralArgument, context, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
        } else {
            kotlinTypeInfo2 = null;
        }
        KtCallableReferenceExpression ktCallableReferenceExpression = ArgumentTypeResolver.getCallableReferenceExpressionIfAny(expression, context);
        if (ktCallableReferenceExpression != null) {
            $receiver = ktCallableReferenceExpression;
            KtCallableReferenceExpression callableReferenceArgument = $receiver;
            kotlinTypeInfo = this.argumentTypeResolver.getCallableReferenceTypeInfo(expression, callableReferenceArgument, context, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
        } else {
            kotlinTypeInfo = null;
        }
        this.dataFlowAnalyzer.checkType(updatedType, deparenthesized, (ResolutionContext)context);
    }

    /*
     * WARNING - void declaration
     */
    private final OverloadResolutionResultsImpl<?> completeCallForArgument(KtExpression expression, BasicCallResolutionContext context) {
        void tracing;
        void cachedContext;
        BasicCallResolutionContext contextForArgument;
        void cachedResolutionResults;
        ResolutionResultsCache.CachedData cachedData;
        ResolutionResultsCache.CachedData cachedData2 = GenericCandidateResolverKt.getResolutionResultsCachedData(expression, context);
        if (cachedData2 == null) {
            return null;
        }
        ResolutionResultsCache.CachedData cachedData3 = cachedData = cachedData2;
        OverloadResolutionResultsImpl<?> overloadResolutionResultsImpl = cachedData3.component1();
        BasicCallResolutionContext basicCallResolutionContext = cachedData3.component2();
        TracingStrategy tracingStrategy = cachedData3.component3();
        cachedData3 = null;
        void v1 = cachedResolutionResults;
        if (v1 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl<org.jetbrains.kotlin.descriptors.CallableDescriptor>");
        }
        OverloadResolutionResultsImpl cachedResults = (OverloadResolutionResultsImpl)v1;
        BasicCallResolutionContext basicCallResolutionContext2 = contextForArgument = (BasicCallResolutionContext)((BasicCallResolutionContext)((BasicCallResolutionContext)cachedContext.replaceBindingTrace(context.trace)).replaceExpectedType(context.expectedType)).replaceCollectAllCandidates(false);
        Intrinsics.checkExpressionValueIsNotNull(basicCallResolutionContext2, "contextForArgument");
        return this.completeCall(basicCallResolutionContext2, cachedResults, (TracingStrategy)tracing);
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinType updateRecordedTypeForArgument(KotlinType updatedType, KotlinType recordedType, KtExpression argumentExpression, BindingTrace trace) {
        void $receiver;
        if (!ErrorUtils.containsErrorType(recordedType) && Intrinsics.areEqual(recordedType, updatedType) || updatedType == null) {
            return updatedType;
        }
        updateRecordedTypeForArgument.1 deparenthesizeOrGetSelector$ = updateRecordedTypeForArgument.1.INSTANCE;
        ArrayList<KtExpression> expressions = new ArrayList<KtExpression>();
        KtExpression expression = argumentExpression;
        while (expression != null) {
            expressions.add(expression);
            expression = deparenthesizeOrGetSelector$.invoke(expression);
        }
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        Iterable iterable = CollectionsKt.asReversedMutable((List)expressions);
        for (Object element : $receiver) {
            void shouldBeMadeNullable;
            KtExpression expression2 = (KtExpression)element;
            if (!(expression2 instanceof KtParenthesizedExpression || expression2 instanceof KtLabeledExpression || expression2 instanceof KtAnnotatedExpression)) {
                shouldBeMadeNullable.element = this.hasNecessarySafeCall(expression2, trace);
            }
            BindingContextUtils.updateRecordedType(updatedType, expression2, trace, shouldBeMadeNullable.element);
        }
        return trace.getType(argumentExpression);
    }

    private final boolean hasNecessarySafeCall(KtExpression expression, BindingTrace trace) {
        if (!(expression instanceof KtSafeQualifiedExpression)) {
            return false;
        }
        KotlinType expressionType = trace.getType(((KtSafeQualifiedExpression)expression).getReceiverExpression());
        return expressionType != null && TypeUtils.isNullableType(expressionType);
    }

    public CallCompleter(@NotNull ArgumentTypeResolver argumentTypeResolver, @NotNull CandidateResolver candidateResolver, @NotNull SymbolUsageValidator symbolUsageValidator, @NotNull DataFlowAnalyzer dataFlowAnalyzer, @NotNull Iterable<? extends CallChecker> callCheckers, @NotNull KotlinBuiltIns builtIns) {
        Intrinsics.checkParameterIsNotNull(argumentTypeResolver, "argumentTypeResolver");
        Intrinsics.checkParameterIsNotNull(candidateResolver, "candidateResolver");
        Intrinsics.checkParameterIsNotNull(symbolUsageValidator, "symbolUsageValidator");
        Intrinsics.checkParameterIsNotNull(dataFlowAnalyzer, "dataFlowAnalyzer");
        Intrinsics.checkParameterIsNotNull(callCheckers, "callCheckers");
        Intrinsics.checkParameterIsNotNull(builtIns, "builtIns");
        this.argumentTypeResolver = argumentTypeResolver;
        this.candidateResolver = candidateResolver;
        this.symbolUsageValidator = symbolUsageValidator;
        this.dataFlowAnalyzer = dataFlowAnalyzer;
        this.callCheckers = callCheckers;
        this.builtIns = builtIns;
    }

    @NotNull
    public static final /* synthetic */ KotlinBuiltIns access$getBuiltIns$p(CallCompleter $this) {
        return $this.builtIns;
    }
}

