/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.util;

import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.FunctionLiteralArgument;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteralArgument;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.ValueArgumentName;
import org.jetbrains.kotlin.psi.debugText.DebugTextUtilKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;

public class CallMaker {
    @NotNull
    public static Call makeCallWithExpressions(@NotNull KtElement callElement, @NotNull ReceiverValue explicitReceiver, @Nullable ASTNode callOperationNode, @NotNull KtExpression calleeExpression, @NotNull List<KtExpression> argumentExpressions) {
        if (callElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callElement", "org/jetbrains/kotlin/resolve/calls/util/CallMaker", "makeCallWithExpressions"));
        }
        if (explicitReceiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "explicitReceiver", "org/jetbrains/kotlin/resolve/calls/util/CallMaker", "makeCallWithExpressions"));
        }
        if (calleeExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "calleeExpression", "org/jetbrains/kotlin/resolve/calls/util/CallMaker", "makeCallWithExpressions"));
        }
        if (argumentExpressions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentExpressions", "org/jetbrains/kotlin/resolve/calls/util/CallMaker", "makeCallWithExpressions"));
        }
        Call call = CallMaker.makeCallWithExpressions(callElement, explicitReceiver, callOperationNode, calleeExpression, argumentExpressions, Call.CallType.DEFAULT);
        if (call == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/util/CallMaker", "makeCallWithExpressions"));
        }
        return call;
    }

    @NotNull
    public static Call makeCallWithExpressions(@NotNull KtElement callElement, @NotNull ReceiverValue explicitReceiver, @Nullable ASTNode callOperationNode, @NotNull KtExpression calleeExpression, @NotNull List<KtExpression> argumentExpressions, @NotNull Call.CallType callType) {
        if (callElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callElement", "org/jetbrains/kotlin/resolve/calls/util/CallMaker", "makeCallWithExpressions"));
        }
        if (explicitReceiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "explicitReceiver", "org/jetbrains/kotlin/resolve/calls/util/CallMaker", "makeCallWithExpressions"));
        }
        if (calleeExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "calleeExpression", "org/jetbrains/kotlin/resolve/calls/util/CallMaker", "makeCallWithExpressions"));
        }
        if (argumentExpressions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentExpressions", "org/jetbrains/kotlin/resolve/calls/util/CallMaker", "makeCallWithExpressions"));
        }
        if (callType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callType", "org/jetbrains/kotlin/resolve/calls/util/CallMaker", "makeCallWithExpressions"));
        }
        ArrayList<ValueArgument> arguments2 = new ArrayList<ValueArgument>(argumentExpressions.size());
        for (KtExpression argumentExpression : argumentExpressions) {
            arguments2.add(CallMaker.makeValueArgument(argumentExpression, calleeExpression));
        }
        Call call = CallMaker.makeCall(callElement, explicitReceiver, callOperationNode, calleeExpression, arguments2, callType);
        if (call == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/util/CallMaker", "makeCallWithExpressions"));
        }
        return call;
    }

    @NotNull
    public static Call makeCall(KtElement callElement, ReceiverValue explicitReceiver, @Nullable ASTNode callOperationNode, KtExpression calleeExpression, List<? extends ValueArgument> arguments2) {
        Call call = CallMaker.makeCall(callElement, explicitReceiver, callOperationNode, calleeExpression, arguments2, Call.CallType.DEFAULT);
        if (call == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/util/CallMaker", "makeCall"));
        }
        return call;
    }

    @NotNull
    public static Call makeCall(KtElement callElement, ReceiverValue explicitReceiver, @Nullable ASTNode callOperationNode, KtExpression calleeExpression, List<? extends ValueArgument> arguments2, Call.CallType callType) {
        CallImpl callImpl = new CallImpl(callElement, explicitReceiver, callOperationNode, calleeExpression, arguments2, callType);
        if (callImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/util/CallMaker", "makeCall"));
        }
        return callImpl;
    }

    @NotNull
    public static Call makeCall(@NotNull ReceiverValue leftAsReceiver, KtBinaryExpression expression) {
        if (leftAsReceiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftAsReceiver", "org/jetbrains/kotlin/resolve/calls/util/CallMaker", "makeCall"));
        }
        Call call = CallMaker.makeCallWithExpressions(expression, leftAsReceiver, null, expression.getOperationReference(), Collections.singletonList(expression.getRight()));
        if (call == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/util/CallMaker", "makeCall"));
        }
        return call;
    }

    @NotNull
    public static Call makeCall(@NotNull ReceiverValue baseAsReceiver, KtUnaryExpression expression) {
        if (baseAsReceiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseAsReceiver", "org/jetbrains/kotlin/resolve/calls/util/CallMaker", "makeCall"));
        }
        Call call = CallMaker.makeCall(expression, baseAsReceiver, null, expression.getOperationReference(), Collections.emptyList());
        if (call == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/util/CallMaker", "makeCall"));
        }
        return call;
    }

    @NotNull
    public static Call makeArraySetCall(@NotNull ReceiverValue arrayAsReceiver, @NotNull KtArrayAccessExpression arrayAccessExpression, @NotNull KtExpression rightHandSide, @NotNull Call.CallType callType) {
        if (arrayAsReceiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayAsReceiver", "org/jetbrains/kotlin/resolve/calls/util/CallMaker", "makeArraySetCall"));
        }
        if (arrayAccessExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayAccessExpression", "org/jetbrains/kotlin/resolve/calls/util/CallMaker", "makeArraySetCall"));
        }
        if (rightHandSide == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightHandSide", "org/jetbrains/kotlin/resolve/calls/util/CallMaker", "makeArraySetCall"));
        }
        if (callType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callType", "org/jetbrains/kotlin/resolve/calls/util/CallMaker", "makeArraySetCall"));
        }
        ArrayList<KtExpression> arguments2 = Lists.newArrayList(arrayAccessExpression.getIndexExpressions());
        arguments2.add(rightHandSide);
        Call call = CallMaker.makeCallWithExpressions(arrayAccessExpression, arrayAsReceiver, null, arrayAccessExpression, arguments2, callType);
        if (call == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/util/CallMaker", "makeArraySetCall"));
        }
        return call;
    }

    @NotNull
    public static Call makeArrayGetCall(@NotNull ReceiverValue arrayAsReceiver, @NotNull KtArrayAccessExpression arrayAccessExpression, @NotNull Call.CallType callType) {
        if (arrayAsReceiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayAsReceiver", "org/jetbrains/kotlin/resolve/calls/util/CallMaker", "makeArrayGetCall"));
        }
        if (arrayAccessExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayAccessExpression", "org/jetbrains/kotlin/resolve/calls/util/CallMaker", "makeArrayGetCall"));
        }
        if (callType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callType", "org/jetbrains/kotlin/resolve/calls/util/CallMaker", "makeArrayGetCall"));
        }
        Call call = CallMaker.makeCallWithExpressions(arrayAccessExpression, arrayAsReceiver, null, arrayAccessExpression, arrayAccessExpression.getIndexExpressions(), callType);
        if (call == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/util/CallMaker", "makeArrayGetCall"));
        }
        return call;
    }

    @NotNull
    public static ValueArgument makeValueArgument(@NotNull KtExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/util/CallMaker", "makeValueArgument"));
        }
        ValueArgument valueArgument = CallMaker.makeValueArgument(expression, expression);
        if (valueArgument == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/util/CallMaker", "makeValueArgument"));
        }
        return valueArgument;
    }

    @NotNull
    public static ValueArgument makeValueArgument(@Nullable KtExpression expression, @NotNull KtElement reportErrorsOn) {
        if (reportErrorsOn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reportErrorsOn", "org/jetbrains/kotlin/resolve/calls/util/CallMaker", "makeValueArgument"));
        }
        ExpressionValueArgument expressionValueArgument = new ExpressionValueArgument(expression, reportErrorsOn, false);
        if (expressionValueArgument == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/util/CallMaker", "makeValueArgument"));
        }
        return expressionValueArgument;
    }

    @NotNull
    public static ValueArgument makeExternalValueArgument(@NotNull KtExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/util/CallMaker", "makeExternalValueArgument"));
        }
        ExpressionValueArgument expressionValueArgument = new ExpressionValueArgument(expression, expression, true);
        if (expressionValueArgument == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/util/CallMaker", "makeExternalValueArgument"));
        }
        return expressionValueArgument;
    }

    @NotNull
    public static Call makePropertyCall(@NotNull ReceiverValue explicitReceiver, @Nullable ASTNode callOperationNode, @NotNull KtSimpleNameExpression nameExpression) {
        if (explicitReceiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "explicitReceiver", "org/jetbrains/kotlin/resolve/calls/util/CallMaker", "makePropertyCall"));
        }
        if (nameExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameExpression", "org/jetbrains/kotlin/resolve/calls/util/CallMaker", "makePropertyCall"));
        }
        Call call = CallMaker.makeCallWithExpressions(nameExpression, explicitReceiver, callOperationNode, nameExpression, Collections.<KtExpression>emptyList());
        if (call == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/util/CallMaker", "makePropertyCall"));
        }
        return call;
    }

    @NotNull
    public static Call makeCall(final @NotNull ReceiverValue explicitReceiver, final @Nullable ASTNode callOperationNode, final @NotNull KtCallElement callElement) {
        if (explicitReceiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "explicitReceiver", "org/jetbrains/kotlin/resolve/calls/util/CallMaker", "makeCall"));
        }
        if (callElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callElement", "org/jetbrains/kotlin/resolve/calls/util/CallMaker", "makeCall"));
        }
        Call call = new Call(){

            @Override
            public ASTNode getCallOperationNode() {
                return callOperationNode;
            }

            @Override
            @NotNull
            public ReceiverValue getExplicitReceiver() {
                ReceiverValue receiverValue = explicitReceiver;
                if (receiverValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/util/CallMaker$1", "getExplicitReceiver"));
                }
                return receiverValue;
            }

            @Override
            @NotNull
            public ReceiverValue getDispatchReceiver() {
                ReceiverValue receiverValue = ReceiverValue.NO_RECEIVER;
                if (receiverValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/util/CallMaker$1", "getDispatchReceiver"));
                }
                return receiverValue;
            }

            @Override
            @Nullable
            public KtExpression getCalleeExpression() {
                return callElement.getCalleeExpression();
            }

            @Override
            @Nullable
            public KtValueArgumentList getValueArgumentList() {
                return callElement.getValueArgumentList();
            }

            @Override
            @NotNull
            public List<? extends ValueArgument> getValueArguments() {
                List<? extends ValueArgument> list = callElement.getValueArguments();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/util/CallMaker$1", "getValueArguments"));
                }
                return list;
            }

            @Override
            @NotNull
            public List<? extends FunctionLiteralArgument> getFunctionLiteralArguments() {
                List<KtFunctionLiteralArgument> list = callElement.getFunctionLiteralArguments();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/util/CallMaker$1", "getFunctionLiteralArguments"));
                }
                return list;
            }

            @Override
            @NotNull
            public List<KtTypeProjection> getTypeArguments() {
                List<KtTypeProjection> list = callElement.getTypeArguments();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/util/CallMaker$1", "getTypeArguments"));
                }
                return list;
            }

            @Override
            @Nullable
            public KtTypeArgumentList getTypeArgumentList() {
                return callElement.getTypeArgumentList();
            }

            @Override
            @NotNull
            public KtElement getCallElement() {
                KtCallElement ktCallElement = callElement;
                if (ktCallElement == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/util/CallMaker$1", "getCallElement"));
                }
                return ktCallElement;
            }

            public String toString() {
                return DebugTextUtilKt.getDebugText(callElement);
            }

            @Override
            @NotNull
            public Call.CallType getCallType() {
                Call.CallType callType = Call.CallType.DEFAULT;
                if (callType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/util/CallMaker$1", "getCallType"));
                }
                return callType;
            }
        };
        if (call == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/util/CallMaker", "makeCall"));
        }
        return call;
    }

    @NotNull
    public static Call makeCall(@NotNull KtElement callElement, @NotNull ReceiverValue explicitReceiver) {
        if (callElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callElement", "org/jetbrains/kotlin/resolve/calls/util/CallMaker", "makeCall"));
        }
        if (explicitReceiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "explicitReceiver", "org/jetbrains/kotlin/resolve/calls/util/CallMaker", "makeCall"));
        }
        CallImpl callImpl = new CallImpl(callElement, explicitReceiver, null, null, Collections.emptyList());
        if (callImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/util/CallMaker", "makeCall"));
        }
        return callImpl;
    }

    private static class CallImpl
    implements Call {
        private final KtElement callElement;
        private final ReceiverValue explicitReceiver;
        private final ASTNode callOperationNode;
        private final KtExpression calleeExpression;
        private final List<? extends ValueArgument> valueArguments;
        private final Call.CallType callType;

        protected CallImpl(@NotNull KtElement callElement, @NotNull ReceiverValue explicitReceiver, @Nullable ASTNode callOperationNode, @Nullable KtExpression calleeExpression, @NotNull List<? extends ValueArgument> valueArguments2) {
            if (callElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callElement", "org/jetbrains/kotlin/resolve/calls/util/CallMaker$CallImpl", "<init>"));
            }
            if (explicitReceiver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "explicitReceiver", "org/jetbrains/kotlin/resolve/calls/util/CallMaker$CallImpl", "<init>"));
            }
            if (valueArguments2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueArguments", "org/jetbrains/kotlin/resolve/calls/util/CallMaker$CallImpl", "<init>"));
            }
            this(callElement, explicitReceiver, callOperationNode, calleeExpression, valueArguments2, Call.CallType.DEFAULT);
        }

        protected CallImpl(@NotNull KtElement callElement, @NotNull ReceiverValue explicitReceiver, @Nullable ASTNode callOperationNode, @Nullable KtExpression calleeExpression, @NotNull List<? extends ValueArgument> valueArguments2, @NotNull Call.CallType callType) {
            if (callElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callElement", "org/jetbrains/kotlin/resolve/calls/util/CallMaker$CallImpl", "<init>"));
            }
            if (explicitReceiver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "explicitReceiver", "org/jetbrains/kotlin/resolve/calls/util/CallMaker$CallImpl", "<init>"));
            }
            if (valueArguments2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueArguments", "org/jetbrains/kotlin/resolve/calls/util/CallMaker$CallImpl", "<init>"));
            }
            if (callType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callType", "org/jetbrains/kotlin/resolve/calls/util/CallMaker$CallImpl", "<init>"));
            }
            this.callElement = callElement;
            this.explicitReceiver = explicitReceiver;
            this.callOperationNode = callOperationNode;
            this.calleeExpression = calleeExpression;
            this.valueArguments = valueArguments2;
            this.callType = callType;
        }

        @Override
        public ASTNode getCallOperationNode() {
            return this.callOperationNode;
        }

        @Override
        @NotNull
        public ReceiverValue getExplicitReceiver() {
            ReceiverValue receiverValue = this.explicitReceiver;
            if (receiverValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/util/CallMaker$CallImpl", "getExplicitReceiver"));
            }
            return receiverValue;
        }

        @Override
        @NotNull
        public ReceiverValue getDispatchReceiver() {
            ReceiverValue receiverValue = ReceiverValue.NO_RECEIVER;
            if (receiverValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/util/CallMaker$CallImpl", "getDispatchReceiver"));
            }
            return receiverValue;
        }

        @Override
        public KtExpression getCalleeExpression() {
            return this.calleeExpression;
        }

        @Override
        @NotNull
        public List<? extends ValueArgument> getValueArguments() {
            List<? extends ValueArgument> list = this.valueArguments;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/util/CallMaker$CallImpl", "getValueArguments"));
            }
            return list;
        }

        @Override
        @NotNull
        public KtElement getCallElement() {
            KtElement ktElement = this.callElement;
            if (ktElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/util/CallMaker$CallImpl", "getCallElement"));
            }
            return ktElement;
        }

        @Override
        public KtValueArgumentList getValueArgumentList() {
            return null;
        }

        @NotNull
        public List<FunctionLiteralArgument> getFunctionLiteralArguments() {
            List<FunctionLiteralArgument> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/util/CallMaker$CallImpl", "getFunctionLiteralArguments"));
            }
            return list;
        }

        @Override
        @NotNull
        public List<KtTypeProjection> getTypeArguments() {
            List<KtTypeProjection> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/util/CallMaker$CallImpl", "getTypeArguments"));
            }
            return list;
        }

        @Override
        public KtTypeArgumentList getTypeArgumentList() {
            return null;
        }

        public String toString() {
            return this.getCallElement().getText();
        }

        @Override
        @NotNull
        public Call.CallType getCallType() {
            Call.CallType callType = this.callType;
            if (callType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/util/CallMaker$CallImpl", "getCallType"));
            }
            return callType;
        }
    }

    private static class ExpressionValueArgument
    implements ValueArgument {
        private final KtExpression expression;
        private final KtElement reportErrorsOn;
        private final boolean isExternal;

        private ExpressionValueArgument(@Nullable KtExpression expression, @NotNull KtElement reportErrorsOn, boolean isExternal) {
            if (reportErrorsOn == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reportErrorsOn", "org/jetbrains/kotlin/resolve/calls/util/CallMaker$ExpressionValueArgument", "<init>"));
            }
            this.expression = expression;
            this.reportErrorsOn = expression == null ? reportErrorsOn : expression;
            this.isExternal = isExternal;
        }

        @Override
        public boolean isExternal() {
            return this.isExternal;
        }

        @Override
        public KtExpression getArgumentExpression() {
            return this.expression;
        }

        @Override
        public ValueArgumentName getArgumentName() {
            return null;
        }

        @Override
        public boolean isNamed() {
            return false;
        }

        @Override
        @NotNull
        public KtElement asElement() {
            KtElement ktElement = this.reportErrorsOn;
            if (ktElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/util/CallMaker$ExpressionValueArgument", "asElement"));
            }
            return ktElement;
        }

        @Override
        public LeafPsiElement getSpreadElement() {
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExpressionValueArgument argument = (ExpressionValueArgument)o;
            return !(this.expression != null ? !this.expression.equals(argument.expression) : argument.expression != null);
        }

        public int hashCode() {
            return this.expression != null ? this.expression.hashCode() : 0;
        }
    }
}

