/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.validation;

import com.intellij.psi.PsiElement;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.validation.SymbolUsageValidator;
import org.jetbrains.kotlin.types.ErrorUtils;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"+\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u00011\u0001\u0001SB\r\u00021\u0003i\nQBQ\u0003#\u000e\t\u0001\"A\u0013\u0018\t-A\u0019!D\u0001\u0019\u0005e1\u0001RA\u0007\u0005\u0013\u0005!\u0019\u0001$\u0001\u0019\u0007e\u0019\u0001rA\u0007\u00021\u0011I2\u0001#\u0003\u000e\u0003a)\u0011d\u0001E\u0006\u001b\u0005Ab\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/validation/InfixValidator;", "Lorg/jetbrains/kotlin/resolve/validation/SymbolUsageValidator;", "()V", "validateCall", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "targetDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "element", "Lcom/intellij/psi/PsiElement;", "Companion"}, moduleName="kotlin-compiler")
public final class InfixValidator
implements SymbolUsageValidator {
    public static final Companion Companion = org.jetbrains.kotlin.resolve.validation.InfixValidator$Companion.INSTANCE;

    @Override
    public void validateCall(@Nullable ResolvedCall<?> resolvedCall, @NotNull CallableDescriptor targetDescriptor, @NotNull BindingTrace trace, @NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull(targetDescriptor, "targetDescriptor");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(element, "element");
        CallableDescriptor callableDescriptor = targetDescriptor;
        if (!(callableDescriptor instanceof FunctionDescriptor)) {
            callableDescriptor = null;
        }
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)callableDescriptor;
        if (functionDescriptor == null) {
            return;
        }
        FunctionDescriptor functionDescriptor2 = functionDescriptor;
        if (DynamicCallsKt.isDynamic(functionDescriptor2) || ErrorUtils.isError(functionDescriptor2)) {
            return;
        }
        if (Companion.isInfixCall(element) && !functionDescriptor2.isInfix()) {
            PsiElement psiElement2 = element;
            if (!(psiElement2 instanceof KtOperationReferenceExpression)) {
                psiElement2 = null;
            }
            KtOperationReferenceExpression ktOperationReferenceExpression = (KtOperationReferenceExpression)psiElement2;
            if (ktOperationReferenceExpression == null) {
                return;
            }
            KtOperationReferenceExpression operationRefExpression = ktOperationReferenceExpression;
            String containingDeclarationName = DescriptorUtilsKt.getFqNameUnsafe(functionDescriptor2.getContainingDeclaration()).asString();
            trace.report(Errors.INFIX_MODIFIER_REQUIRED.on((KtOperationReferenceExpression)((PsiElement)operationRefExpression), functionDescriptor2, containingDeclarationName));
        }
    }

    @Override
    public void validateTypeUsage(@NotNull ClassifierDescriptor targetDescriptor, @NotNull BindingTrace trace, @NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull(targetDescriptor, "targetDescriptor");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(element, "element");
        SymbolUsageValidator.DefaultImpls.validateTypeUsage(this, targetDescriptor, trace, element);
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u0017\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!-Q\u0001A\u0003\u0002\u0019\u0005!19\u0001\u0007\u00013\u0005A\n!i\u0002\u0005\u0003E\u001b\u0011\u0001C\u0001&\u0011!\rQ\"\u0001\r\u00033\u0011A)!\u0004\u0002\r\u0002a\u0019\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/validation/InfixValidator$Companion;", "", "()V", "isInfixCall", "", "element", "Lcom/intellij/psi/PsiElement;"}, moduleName="kotlin-compiler")
    public static final class Companion {
        public static final Companion INSTANCE;

        public final boolean isInfixCall(@Nullable PsiElement element) {
            PsiElement psiElement2 = element;
            if (!(psiElement2 instanceof KtOperationReferenceExpression)) {
                psiElement2 = null;
            }
            KtOperationReferenceExpression ktOperationReferenceExpression = (KtOperationReferenceExpression)psiElement2;
            if (ktOperationReferenceExpression == null) {
                return false;
            }
            KtOperationReferenceExpression operationRefExpression = ktOperationReferenceExpression;
            PsiElement psiElement3 = operationRefExpression.getParent();
            if (!(psiElement3 instanceof KtBinaryExpression)) {
                psiElement3 = null;
            }
            KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)psiElement3;
            if (ktBinaryExpression == null) {
                return false;
            }
            KtBinaryExpression binaryExpression = ktBinaryExpression;
            return binaryExpression.getOperationReference() == operationRefExpression && !operationRefExpression.isPredefinedOperator();
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }
}

