/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js.ast;

import com.google.dart.compiler.backend.js.JsReservedIdentifiers;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsProgram;
import com.google.dart.compiler.backend.js.ast.JsScope;
import org.jetbrains.annotations.NotNull;

public final class JsRootScope
extends JsScope {
    private final JsProgram program;

    public JsRootScope(JsProgram program) {
        super("Root");
        this.program = program;
    }

    @Override
    public JsProgram getProgram() {
        return this.program;
    }

    @Override
    protected JsName findOwnName(@NotNull String ident) {
        if (ident == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ident", "com/google/dart/compiler/backend/js/ast/JsRootScope", "findOwnName"));
        }
        JsName name = super.findOwnName(ident);
        if (name == null && JsReservedIdentifiers.reservedGlobalSymbols.contains(ident)) {
            name = this.doCreateName(ident);
        }
        return name;
    }
}

