/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.file.PsiPackageImpl;
import com.intellij.psi.impl.file.impl.JavaFileManager;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreJavaFileManager
implements JavaFileManager {
    private static final Logger LOG = Logger.getInstance("#com.intellij.core.CoreJavaFileManager");
    private final List<VirtualFile> myClasspath = new ArrayList<VirtualFile>();
    private final PsiManager myPsiManager;

    public CoreJavaFileManager(PsiManager psiManager) {
        this.myPsiManager = psiManager;
    }

    private List<VirtualFile> roots() {
        return this.myClasspath;
    }

    @Override
    public PsiPackage findPackage(@NotNull String packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/core/CoreJavaFileManager", "findPackage"));
        }
        List<VirtualFile> files = this.findDirectoriesByPackageName(packageName);
        if (!files.isEmpty()) {
            return new PsiPackageImpl(this.myPsiManager, packageName);
        }
        return null;
    }

    private List<VirtualFile> findDirectoriesByPackageName(String packageName) {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        String dirName = packageName.replace(".", "/");
        for (VirtualFile root : this.roots()) {
            VirtualFile classDir = root.findFileByRelativePath(dirName);
            if (classDir == null) continue;
            result2.add(classDir);
        }
        return result2;
    }

    @Nullable
    public PsiPackage getPackage(PsiDirectory dir) {
        VirtualFile file = dir.getVirtualFile();
        for (VirtualFile root : this.myClasspath) {
            String relativePath;
            if (!VfsUtilCore.isAncestor(root, file, false) || (relativePath = FileUtil.getRelativePath(root.getPath(), file.getPath(), '/')) == null) continue;
            return new PsiPackageImpl(this.myPsiManager, relativePath.replace('/', '.'));
        }
        return null;
    }

    @Override
    public PsiClass findClass(@NotNull String qName, @NotNull GlobalSearchScope scope2) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "com/intellij/core/CoreJavaFileManager", "findClass"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/core/CoreJavaFileManager", "findClass"));
        }
        for (VirtualFile root : this.roots()) {
            PsiClass psiClass = CoreJavaFileManager.findClassInClasspathRoot(qName, root, this.myPsiManager, scope2);
            if (psiClass == null) continue;
            return psiClass;
        }
        return null;
    }

    @Nullable
    public static PsiClass findClassInClasspathRoot(@NotNull String qName, @NotNull VirtualFile root, @NotNull PsiManager psiManager, @NotNull GlobalSearchScope scope2) {
        String pathComponent;
        VirtualFile child;
        int dot;
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "com/intellij/core/CoreJavaFileManager", "findClassInClasspathRoot"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/core/CoreJavaFileManager", "findClassInClasspathRoot"));
        }
        if (psiManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiManager", "com/intellij/core/CoreJavaFileManager", "findClassInClasspathRoot"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/core/CoreJavaFileManager", "findClassInClasspathRoot"));
        }
        String pathRest = qName;
        VirtualFile cur = root;
        while ((dot = pathRest.indexOf(46)) >= 0 && (child = cur.findChild(pathComponent = pathRest.substring(0, dot))) != null) {
            pathRest = pathRest.substring(dot + 1);
            cur = child;
        }
        String classNameWithInnerClasses = pathRest;
        String topLevelClassName = CoreJavaFileManager.substringBeforeFirstDot(classNameWithInnerClasses);
        VirtualFile vFile = cur.findChild(topLevelClassName + ".class");
        if (vFile == null) {
            vFile = cur.findChild(topLevelClassName + ".java");
        }
        if (vFile == null) {
            return null;
        }
        if (!vFile.isValid()) {
            LOG.error("Invalid child of valid parent: " + vFile.getPath() + "; " + root.isValid() + " path=" + root.getPath());
            return null;
        }
        if (!scope2.contains(vFile)) {
            return null;
        }
        PsiFile file = psiManager.findFile(vFile);
        if (!(file instanceof PsiClassOwner)) {
            return null;
        }
        return CoreJavaFileManager.findClassInPsiFile(classNameWithInnerClasses, (PsiClassOwner)file);
    }

    @NotNull
    private static String substringBeforeFirstDot(@NotNull String classNameWithInnerClasses) {
        if (classNameWithInnerClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classNameWithInnerClasses", "com/intellij/core/CoreJavaFileManager", "substringBeforeFirstDot"));
        }
        int dot = classNameWithInnerClasses.indexOf(46);
        if (dot < 0) {
            String string = classNameWithInnerClasses;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreJavaFileManager", "substringBeforeFirstDot"));
            }
            return string;
        }
        String string = classNameWithInnerClasses.substring(0, dot);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreJavaFileManager", "substringBeforeFirstDot"));
        }
        return string;
    }

    @Nullable
    private static PsiClass findClassInPsiFile(@NotNull String classNameWithInnerClassesDotSeparated, @NotNull PsiClassOwner file) {
        if (classNameWithInnerClassesDotSeparated == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classNameWithInnerClassesDotSeparated", "com/intellij/core/CoreJavaFileManager", "findClassInPsiFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/core/CoreJavaFileManager", "findClassInPsiFile"));
        }
        for (PsiClass topLevelClass : file.getClasses()) {
            PsiClass candidate = CoreJavaFileManager.findClassByTopLevelClass(classNameWithInnerClassesDotSeparated, topLevelClass);
            if (candidate == null) continue;
            return candidate;
        }
        return null;
    }

    @Nullable
    private static PsiClass findClassByTopLevelClass(@NotNull String className, @NotNull PsiClass topLevelClass) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/core/CoreJavaFileManager", "findClassByTopLevelClass"));
        }
        if (topLevelClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topLevelClass", "com/intellij/core/CoreJavaFileManager", "findClassByTopLevelClass"));
        }
        if (className.indexOf(46) < 0) {
            return className.equals(topLevelClass.getName()) ? topLevelClass : null;
        }
        Iterator<String> segments = StringUtil.split(className, ".").iterator();
        if (!segments.hasNext() || !segments.next().equals(topLevelClass.getName())) {
            return null;
        }
        PsiClass curClass = topLevelClass;
        while (segments.hasNext()) {
            String innerClassName = segments.next();
            PsiClass innerClass = curClass.findInnerClassByName(innerClassName, false);
            if (innerClass == null) {
                return null;
            }
            curClass = innerClass;
        }
        return curClass;
    }

    @Override
    @NotNull
    public PsiClass[] findClasses(@NotNull String qName, @NotNull GlobalSearchScope scope2) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "com/intellij/core/CoreJavaFileManager", "findClasses"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/core/CoreJavaFileManager", "findClasses"));
        }
        ArrayList<PsiClass> result2 = new ArrayList<PsiClass>();
        for (VirtualFile file : this.roots()) {
            PsiClass psiClass = CoreJavaFileManager.findClassInClasspathRoot(qName, file, this.myPsiManager, scope2);
            if (psiClass == null) continue;
            result2.add(psiClass);
        }
        PsiClass[] psiClassArray = result2.toArray(new PsiClass[result2.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreJavaFileManager", "findClasses"));
        }
        return psiClassArray;
    }

    @Override
    @NotNull
    public Collection<String> getNonTrivialPackagePrefixes() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreJavaFileManager", "getNonTrivialPackagePrefixes"));
        }
        return list;
    }

    public void addToClasspath(VirtualFile root) {
        this.myClasspath.add(root);
    }
}

