/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.parser;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderUtil;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.java.parser.DeclarationParser;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.SmartList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatementParser {
    private static final TokenSet TRY_CLOSERS_SET = TokenSet.create(JavaTokenType.CATCH_KEYWORD, JavaTokenType.FINALLY_KEYWORD);
    private final JavaParser myParser;

    public StatementParser(@NotNull JavaParser javaParser) {
        if (javaParser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaParser", "com/intellij/lang/java/parser/StatementParser", "<init>"));
        }
        this.myParser = javaParser;
    }

    @Nullable
    public PsiBuilder.Marker parseCodeBlock(PsiBuilder builder) {
        return this.parseCodeBlock(builder, false);
    }

    @Nullable
    public PsiBuilder.Marker parseCodeBlock(PsiBuilder builder, boolean isStatement) {
        if (builder.getTokenType() != JavaTokenType.LBRACE) {
            return null;
        }
        if (isStatement && JavaParserUtil.isParseStatementCodeBlocksDeep(builder)) {
            return this.parseCodeBlockDeep(builder, false);
        }
        PsiBuilder.Marker codeBlock = builder.mark();
        builder.advanceLexer();
        boolean greedyBlock = false;
        int braceCount = 1;
        while (true) {
            IElementType type2;
            IElementType tokenType;
            if ((tokenType = builder.getTokenType()) == null) {
                greedyBlock = true;
                break;
            }
            if (tokenType == JavaTokenType.LBRACE) {
                ++braceCount;
            } else if (tokenType == JavaTokenType.RBRACE) {
                --braceCount;
            }
            builder.advanceLexer();
            if (braceCount == 0) break;
            if (braceCount != 1 || tokenType != JavaTokenType.SEMICOLON && tokenType != JavaTokenType.RBRACE) continue;
            PsiBuilder.Marker position = builder.mark();
            SmartList<IElementType> list = new SmartList<IElementType>();
            while (ElementType.PRIMITIVE_TYPE_BIT_SET.contains(type2 = builder.getTokenType()) || ElementType.MODIFIER_BIT_SET.contains(type2) || type2 == JavaTokenType.IDENTIFIER && list.size() > 0 || type2 == JavaTokenType.LT || type2 == JavaTokenType.GT || type2 == JavaTokenType.GTGT || type2 == JavaTokenType.GTGTGT || type2 == JavaTokenType.COMMA || type2 == JavaTokenType.DOT || type2 == JavaTokenType.EXTENDS_KEYWORD || type2 == JavaTokenType.IMPLEMENTS_KEYWORD) {
                list.add(type2);
                builder.advanceLexer();
            }
            if (builder.getTokenType() == JavaTokenType.LPARENTH && list.size() >= 2) {
                IElementType last = (IElementType)list.get(list.size() - 1);
                IElementType prevLast = (IElementType)list.get(list.size() - 2);
                if (last == JavaTokenType.IDENTIFIER && (prevLast == JavaTokenType.IDENTIFIER || ElementType.PRIMITIVE_TYPE_BIT_SET.contains(prevLast))) {
                    position.rollbackTo();
                    greedyBlock = true;
                    break;
                }
            }
            position.drop();
        }
        codeBlock.collapse(JavaElementType.CODE_BLOCK);
        if (greedyBlock) {
            codeBlock.setCustomEdgeTokenBinders(null, WhitespacesBinders.GREEDY_RIGHT_BINDER);
        }
        return codeBlock;
    }

    @Nullable
    public PsiBuilder.Marker parseCodeBlockDeep(PsiBuilder builder, boolean parseUntilEof) {
        if (builder.getTokenType() != JavaTokenType.LBRACE) {
            return null;
        }
        PsiBuilder.Marker codeBlock = builder.mark();
        builder.advanceLexer();
        this.parseStatements(builder, parseUntilEof ? BraceMode.TILL_LAST : BraceMode.TILL_FIRST);
        boolean greedyBlock = !JavaParserUtil.expectOrError(builder, JavaTokenType.RBRACE, "expected.rbrace");
        builder.getTokenType();
        JavaParserUtil.done(codeBlock, JavaElementType.CODE_BLOCK);
        if (greedyBlock) {
            codeBlock.setCustomEdgeTokenBinders(null, WhitespacesBinders.GREEDY_RIGHT_BINDER);
        }
        return codeBlock;
    }

    public void parseStatements(PsiBuilder builder) {
        this.parseStatements(builder, null);
    }

    private void parseStatements(PsiBuilder builder, @Nullable BraceMode braceMode) {
        while (builder.getTokenType() != null) {
            PsiBuilder.Marker statement = this.parseStatement(builder);
            if (statement != null) continue;
            IElementType tokenType = builder.getTokenType();
            if (tokenType == JavaTokenType.RBRACE) {
                if (braceMode == BraceMode.TILL_FIRST) {
                    return;
                }
                if (braceMode == BraceMode.TILL_LAST && builder.lookAhead(1) == null) {
                    return;
                }
            }
            PsiBuilder.Marker error = builder.mark();
            builder.advanceLexer();
            if (tokenType == JavaTokenType.ELSE_KEYWORD) {
                error.error(JavaErrorMessages.message("else.without.if", new Object[0]));
                continue;
            }
            if (tokenType == JavaTokenType.CATCH_KEYWORD) {
                error.error(JavaErrorMessages.message("catch.without.try", new Object[0]));
                continue;
            }
            if (tokenType == JavaTokenType.FINALLY_KEYWORD) {
                error.error(JavaErrorMessages.message("finally.without.try", new Object[0]));
                continue;
            }
            error.error(JavaErrorMessages.message("unexpected.token", new Object[0]));
        }
    }

    @Nullable
    public PsiBuilder.Marker parseStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement;
        IElementType tokenType = builder.getTokenType();
        if (tokenType == JavaTokenType.IF_KEYWORD) {
            return this.parseIfStatement(builder);
        }
        if (tokenType == JavaTokenType.WHILE_KEYWORD) {
            return this.parseWhileStatement(builder);
        }
        if (tokenType == JavaTokenType.FOR_KEYWORD) {
            return this.parseForStatement(builder);
        }
        if (tokenType == JavaTokenType.DO_KEYWORD) {
            return this.parseDoWhileStatement(builder);
        }
        if (tokenType == JavaTokenType.SWITCH_KEYWORD) {
            return this.parseSwitchStatement(builder);
        }
        if (tokenType == JavaTokenType.CASE_KEYWORD || tokenType == JavaTokenType.DEFAULT_KEYWORD) {
            return this.parseSwitchLabelStatement(builder);
        }
        if (tokenType == JavaTokenType.BREAK_KEYWORD) {
            return StatementParser.parseBreakStatement(builder);
        }
        if (tokenType == JavaTokenType.CONTINUE_KEYWORD) {
            return StatementParser.parseContinueStatement(builder);
        }
        if (tokenType == JavaTokenType.RETURN_KEYWORD) {
            return this.parseReturnStatement(builder);
        }
        if (tokenType == JavaTokenType.THROW_KEYWORD) {
            return this.parseThrowStatement(builder);
        }
        if (tokenType == JavaTokenType.SYNCHRONIZED_KEYWORD) {
            return this.parseSynchronizedStatement(builder);
        }
        if (tokenType == JavaTokenType.TRY_KEYWORD) {
            return this.parseTryStatement(builder);
        }
        if (tokenType == JavaTokenType.ASSERT_KEYWORD) {
            return this.parseAssertStatement(builder);
        }
        if (tokenType == JavaTokenType.LBRACE) {
            return this.parseBlockStatement(builder);
        }
        if (tokenType instanceof ILazyParseableElementType) {
            builder.advanceLexer();
            return null;
        }
        if (tokenType == JavaTokenType.SEMICOLON) {
            PsiBuilder.Marker empty2 = builder.mark();
            builder.advanceLexer();
            JavaParserUtil.done(empty2, JavaElementType.EMPTY_STATEMENT);
            return empty2;
        }
        if (tokenType == JavaTokenType.IDENTIFIER || tokenType == JavaTokenType.AT) {
            PsiBuilder.Marker refPos = builder.mark();
            this.myParser.getDeclarationParser().parseAnnotations(builder);
            StatementParser.skipQualifiedName(builder);
            IElementType suspectedLT = builder.getTokenType();
            IElementType next = builder.lookAhead(1);
            refPos.rollbackTo();
            if (suspectedLT == JavaTokenType.LT || suspectedLT == JavaTokenType.DOT && next == JavaTokenType.AT) {
                PsiBuilder.Marker declStatement = builder.mark();
                PsiBuilder.Marker decl = this.myParser.getDeclarationParser().parse(builder, DeclarationParser.Context.CODE_BLOCK);
                if (decl == null) {
                    PsiBuilder.Marker marker = this.myParser.getReferenceParser().parseType(builder, 0);
                    JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
                    if (marker == null) {
                        builder.advanceLexer();
                    }
                }
                JavaParserUtil.done(declStatement, JavaElementType.DECLARATION_STATEMENT);
                return declStatement;
            }
        }
        PsiBuilder.Marker pos = builder.mark();
        PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder);
        if (expr != null) {
            int count = 1;
            PsiBuilder.Marker list = expr.precede();
            PsiBuilder.Marker statement2 = list.precede();
            while (builder.getTokenType() == JavaTokenType.COMMA) {
                PsiBuilder.Marker commaPos = builder.mark();
                builder.advanceLexer();
                PsiBuilder.Marker expr1 = this.myParser.getExpressionParser().parse(builder);
                if (expr1 == null) {
                    commaPos.rollbackTo();
                    break;
                }
                commaPos.drop();
                ++count;
            }
            if (count > 1) {
                pos.drop();
                JavaParserUtil.done(list, JavaElementType.EXPRESSION_LIST);
                JavaParserUtil.semicolon(builder);
                JavaParserUtil.done(statement2, JavaElementType.EXPRESSION_LIST_STATEMENT);
                return statement2;
            }
            if (JavaParserUtil.exprType(expr) != JavaElementType.REFERENCE_EXPRESSION) {
                PsiBuilderUtil.drop(list, pos);
                JavaParserUtil.semicolon(builder);
                JavaParserUtil.done(statement2, JavaElementType.EXPRESSION_STATEMENT);
                return statement2;
            }
            pos.rollbackTo();
        } else {
            pos.drop();
        }
        PsiBuilder.Marker decl = this.myParser.getDeclarationParser().parse(builder, DeclarationParser.Context.CODE_BLOCK);
        if (decl != null) {
            statement = decl.precede();
            JavaParserUtil.done(statement, JavaElementType.DECLARATION_STATEMENT);
            return statement;
        }
        if (builder.getTokenType() == JavaTokenType.IDENTIFIER && builder.lookAhead(1) == JavaTokenType.COLON) {
            statement = builder.mark();
            PsiBuilderUtil.advance(builder, 2);
            this.parseStatement(builder);
            JavaParserUtil.done(statement, JavaElementType.LABELED_STATEMENT);
            return statement;
        }
        if (expr != null) {
            statement = builder.mark();
            this.myParser.getExpressionParser().parse(builder);
            JavaParserUtil.semicolon(builder);
            JavaParserUtil.done(statement, JavaElementType.EXPRESSION_STATEMENT);
            return statement;
        }
        return null;
    }

    private static void skipQualifiedName(PsiBuilder builder) {
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.IDENTIFIER)) {
            return;
        }
        while (builder.getTokenType() == JavaTokenType.DOT && builder.lookAhead(1) == JavaTokenType.IDENTIFIER) {
            PsiBuilderUtil.advance(builder, 2);
        }
    }

    @NotNull
    private PsiBuilder.Marker parseIfStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        if (!this.parseExpressionInParenth(builder)) {
            JavaParserUtil.done(statement, JavaElementType.IF_STATEMENT);
            PsiBuilder.Marker marker = statement;
            if (marker == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/parser/StatementParser", "parseIfStatement"));
            }
            return marker;
        }
        PsiBuilder.Marker thenStatement = this.parseStatement(builder);
        if (thenStatement == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.statement", new Object[0]));
            JavaParserUtil.done(statement, JavaElementType.IF_STATEMENT);
            PsiBuilder.Marker marker = statement;
            if (marker == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/parser/StatementParser", "parseIfStatement"));
            }
            return marker;
        }
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.ELSE_KEYWORD)) {
            JavaParserUtil.done(statement, JavaElementType.IF_STATEMENT);
            PsiBuilder.Marker marker = statement;
            if (marker == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/parser/StatementParser", "parseIfStatement"));
            }
            return marker;
        }
        PsiBuilder.Marker elseStatement = this.parseStatement(builder);
        if (elseStatement == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.statement", new Object[0]));
        }
        JavaParserUtil.done(statement, JavaElementType.IF_STATEMENT);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/parser/StatementParser", "parseIfStatement"));
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseWhileStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        if (!this.parseExpressionInParenth(builder)) {
            JavaParserUtil.done(statement, JavaElementType.WHILE_STATEMENT);
            PsiBuilder.Marker marker = statement;
            if (marker == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/parser/StatementParser", "parseWhileStatement"));
            }
            return marker;
        }
        PsiBuilder.Marker bodyStatement = this.parseStatement(builder);
        if (bodyStatement == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.statement", new Object[0]));
        }
        JavaParserUtil.done(statement, JavaElementType.WHILE_STATEMENT);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/parser/StatementParser", "parseWhileStatement"));
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseForStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.LPARENTH)) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.lparen", new Object[0]));
            JavaParserUtil.done(statement, JavaElementType.FOR_STATEMENT);
            PsiBuilder.Marker marker = statement;
            if (marker == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/parser/StatementParser", "parseForStatement"));
            }
            return marker;
        }
        PsiBuilder.Marker afterParenth = builder.mark();
        PsiBuilder.Marker param = this.myParser.getDeclarationParser().parseParameter(builder, false, false);
        if (param == null || JavaParserUtil.exprType(param) != JavaElementType.PARAMETER || builder.getTokenType() != JavaTokenType.COLON) {
            afterParenth.rollbackTo();
            PsiBuilder.Marker marker = this.parseForLoopFromInitialization(builder, statement);
            if (marker == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/parser/StatementParser", "parseForStatement"));
            }
            return marker;
        }
        afterParenth.drop();
        PsiBuilder.Marker marker = this.parseForEachFromColon(builder, statement);
        if (marker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/parser/StatementParser", "parseForStatement"));
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseForLoopFromInitialization(PsiBuilder builder, PsiBuilder.Marker statement) {
        PsiBuilder.Marker bodyStatement;
        PsiBuilder.Marker init = this.parseStatement(builder);
        if (init == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.statement", new Object[0]));
            if (!PsiBuilderUtil.expect(builder, JavaTokenType.RPARENTH)) {
                JavaParserUtil.done(statement, JavaElementType.FOR_STATEMENT);
                PsiBuilder.Marker marker = statement;
                if (marker == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/parser/StatementParser", "parseForLoopFromInitialization"));
                }
                return marker;
            }
        } else {
            this.myParser.getExpressionParser().parse(builder);
            if (!PsiBuilderUtil.expect(builder, JavaTokenType.SEMICOLON)) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.semicolon", new Object[0]));
                if (!PsiBuilderUtil.expect(builder, JavaTokenType.RPARENTH)) {
                    JavaParserUtil.done(statement, JavaElementType.FOR_STATEMENT);
                    PsiBuilder.Marker marker = statement;
                    if (marker == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/parser/StatementParser", "parseForLoopFromInitialization"));
                    }
                    return marker;
                }
            } else {
                this.parseExpressionOrExpressionList(builder);
                if (!PsiBuilderUtil.expect(builder, JavaTokenType.RPARENTH)) {
                    JavaParserUtil.error(builder, JavaErrorMessages.message("expected.rparen", new Object[0]));
                    JavaParserUtil.done(statement, JavaElementType.FOR_STATEMENT);
                    PsiBuilder.Marker marker = statement;
                    if (marker == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/parser/StatementParser", "parseForLoopFromInitialization"));
                    }
                    return marker;
                }
            }
        }
        if ((bodyStatement = this.parseStatement(builder)) == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.statement", new Object[0]));
        }
        JavaParserUtil.done(statement, JavaElementType.FOR_STATEMENT);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/parser/StatementParser", "parseForLoopFromInitialization"));
        }
        return marker;
    }

    private void parseExpressionOrExpressionList(PsiBuilder builder) {
        PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder);
        if (expr == null) {
            return;
        }
        if (builder.getTokenType() != JavaTokenType.COMMA) {
            PsiBuilder.Marker expressionStatement = expr.precede();
            JavaParserUtil.done(expressionStatement, JavaElementType.EXPRESSION_STATEMENT);
        } else {
            PsiBuilder.Marker expressionList = expr.precede();
            PsiBuilder.Marker expressionStatement = expressionList.precede();
            do {
                builder.advanceLexer();
                PsiBuilder.Marker nextExpression = this.myParser.getExpressionParser().parse(builder);
                if (nextExpression != null) continue;
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.expression", new Object[0]));
            } while (builder.getTokenType() == JavaTokenType.COMMA);
            JavaParserUtil.done(expressionList, JavaElementType.EXPRESSION_LIST);
            JavaParserUtil.done(expressionStatement, JavaElementType.EXPRESSION_LIST_STATEMENT);
        }
    }

    @NotNull
    private PsiBuilder.Marker parseForEachFromColon(PsiBuilder builder, PsiBuilder.Marker statement) {
        builder.advanceLexer();
        PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder);
        if (expr == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.expression", new Object[0]));
        }
        if (PsiBuilderUtil.expect(builder, JavaTokenType.RPARENTH)) {
            PsiBuilder.Marker bodyStatement = this.parseStatement(builder);
            if (bodyStatement == null) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.statement", new Object[0]));
            }
        } else {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.rparen", new Object[0]));
        }
        JavaParserUtil.done(statement, JavaElementType.FOREACH_STATEMENT);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/parser/StatementParser", "parseForEachFromColon"));
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseDoWhileStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        PsiBuilder.Marker body = this.parseStatement(builder);
        if (body == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.statement", new Object[0]));
            JavaParserUtil.done(statement, JavaElementType.DO_WHILE_STATEMENT);
            PsiBuilder.Marker marker = statement;
            if (marker == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/parser/StatementParser", "parseDoWhileStatement"));
            }
            return marker;
        }
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.WHILE_KEYWORD)) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.while", new Object[0]));
            JavaParserUtil.done(statement, JavaElementType.DO_WHILE_STATEMENT);
            PsiBuilder.Marker marker = statement;
            if (marker == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/parser/StatementParser", "parseDoWhileStatement"));
            }
            return marker;
        }
        if (this.parseExpressionInParenth(builder)) {
            JavaParserUtil.semicolon(builder);
        }
        JavaParserUtil.done(statement, JavaElementType.DO_WHILE_STATEMENT);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/parser/StatementParser", "parseDoWhileStatement"));
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseSwitchStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        if (!this.parseExpressionInParenth(builder)) {
            JavaParserUtil.done(statement, JavaElementType.SWITCH_STATEMENT);
            PsiBuilder.Marker marker = statement;
            if (marker == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/parser/StatementParser", "parseSwitchStatement"));
            }
            return marker;
        }
        PsiBuilder.Marker body = this.parseCodeBlock(builder, true);
        if (body == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.lbrace", new Object[0]));
        }
        JavaParserUtil.done(statement, JavaElementType.SWITCH_STATEMENT);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/parser/StatementParser", "parseSwitchStatement"));
        }
        return marker;
    }

    @Nullable
    private PsiBuilder.Marker parseSwitchLabelStatement(PsiBuilder builder) {
        PsiBuilder.Marker expr;
        PsiBuilder.Marker statement = builder.mark();
        boolean isCase = builder.getTokenType() == JavaTokenType.CASE_KEYWORD;
        builder.advanceLexer();
        if (isCase && (expr = this.myParser.getExpressionParser().parse(builder)) == null) {
            statement.rollbackTo();
            return null;
        }
        JavaParserUtil.expectOrError(builder, JavaTokenType.COLON, "expected.colon");
        JavaParserUtil.done(statement, JavaElementType.SWITCH_LABEL_STATEMENT);
        return statement;
    }

    @NotNull
    private static PsiBuilder.Marker parseBreakStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        PsiBuilderUtil.expect(builder, JavaTokenType.IDENTIFIER);
        JavaParserUtil.semicolon(builder);
        JavaParserUtil.done(statement, JavaElementType.BREAK_STATEMENT);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/parser/StatementParser", "parseBreakStatement"));
        }
        return marker;
    }

    @NotNull
    private static PsiBuilder.Marker parseContinueStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        PsiBuilderUtil.expect(builder, JavaTokenType.IDENTIFIER);
        JavaParserUtil.semicolon(builder);
        JavaParserUtil.done(statement, JavaElementType.CONTINUE_STATEMENT);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/parser/StatementParser", "parseContinueStatement"));
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseReturnStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        this.myParser.getExpressionParser().parse(builder);
        JavaParserUtil.semicolon(builder);
        JavaParserUtil.done(statement, JavaElementType.RETURN_STATEMENT);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/parser/StatementParser", "parseReturnStatement"));
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseThrowStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder);
        if (expr == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.expression", new Object[0]));
            JavaParserUtil.done(statement, JavaElementType.THROW_STATEMENT);
            PsiBuilder.Marker marker = statement;
            if (marker == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/parser/StatementParser", "parseThrowStatement"));
            }
            return marker;
        }
        JavaParserUtil.semicolon(builder);
        JavaParserUtil.done(statement, JavaElementType.THROW_STATEMENT);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/parser/StatementParser", "parseThrowStatement"));
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseSynchronizedStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        if (!this.parseExpressionInParenth(builder)) {
            JavaParserUtil.done(statement, JavaElementType.SYNCHRONIZED_STATEMENT);
            PsiBuilder.Marker marker = statement;
            if (marker == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/parser/StatementParser", "parseSynchronizedStatement"));
            }
            return marker;
        }
        PsiBuilder.Marker body = this.parseCodeBlock(builder, true);
        if (body == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.lbrace", new Object[0]));
        }
        JavaParserUtil.done(statement, JavaElementType.SYNCHRONIZED_STATEMENT);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/parser/StatementParser", "parseSynchronizedStatement"));
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseTryStatement(PsiBuilder builder) {
        PsiBuilder.Marker finallyBlock;
        PsiBuilder.Marker tryBlock;
        boolean hasResourceList;
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        boolean bl = hasResourceList = builder.getTokenType() == JavaTokenType.LPARENTH;
        if (hasResourceList) {
            this.myParser.getDeclarationParser().parseResourceList(builder);
        }
        if ((tryBlock = this.parseCodeBlock(builder, true)) == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.lbrace", new Object[0]));
            JavaParserUtil.done(statement, JavaElementType.TRY_STATEMENT);
            PsiBuilder.Marker marker = statement;
            if (marker == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/parser/StatementParser", "parseTryStatement"));
            }
            return marker;
        }
        if (!hasResourceList && !TRY_CLOSERS_SET.contains(builder.getTokenType())) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.catch.or.finally", new Object[0]));
            JavaParserUtil.done(statement, JavaElementType.TRY_STATEMENT);
            PsiBuilder.Marker marker = statement;
            if (marker == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/parser/StatementParser", "parseTryStatement"));
            }
            return marker;
        }
        while (builder.getTokenType() == JavaTokenType.CATCH_KEYWORD && this.parseCatchBlock(builder)) {
        }
        if (PsiBuilderUtil.expect(builder, JavaTokenType.FINALLY_KEYWORD) && (finallyBlock = this.parseCodeBlock(builder, true)) == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.lbrace", new Object[0]));
        }
        JavaParserUtil.done(statement, JavaElementType.TRY_STATEMENT);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/parser/StatementParser", "parseTryStatement"));
        }
        return marker;
    }

    public boolean parseCatchBlock(PsiBuilder builder) {
        assert (builder.getTokenType() == JavaTokenType.CATCH_KEYWORD) : builder.getTokenType();
        PsiBuilder.Marker section = builder.mark();
        builder.advanceLexer();
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.LPARENTH)) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.lparen", new Object[0]));
            JavaParserUtil.done(section, JavaElementType.CATCH_SECTION);
            return false;
        }
        PsiBuilder.Marker param = this.myParser.getDeclarationParser().parseParameter(builder, false, true);
        if (param == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.parameter", new Object[0]));
        }
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.RPARENTH)) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.rparen", new Object[0]));
            JavaParserUtil.done(section, JavaElementType.CATCH_SECTION);
            return false;
        }
        PsiBuilder.Marker body = this.parseCodeBlock(builder, true);
        if (body == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.lbrace", new Object[0]));
            JavaParserUtil.done(section, JavaElementType.CATCH_SECTION);
            return false;
        }
        JavaParserUtil.done(section, JavaElementType.CATCH_SECTION);
        return true;
    }

    @NotNull
    private PsiBuilder.Marker parseAssertStatement(PsiBuilder builder) {
        PsiBuilder.Marker expr2;
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder);
        if (expr == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.boolean.expression", new Object[0]));
            JavaParserUtil.done(statement, JavaElementType.ASSERT_STATEMENT);
            PsiBuilder.Marker marker = statement;
            if (marker == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/parser/StatementParser", "parseAssertStatement"));
            }
            return marker;
        }
        if (PsiBuilderUtil.expect(builder, JavaTokenType.COLON) && (expr2 = this.myParser.getExpressionParser().parse(builder)) == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.expression", new Object[0]));
            JavaParserUtil.done(statement, JavaElementType.ASSERT_STATEMENT);
            PsiBuilder.Marker marker = statement;
            if (marker == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/parser/StatementParser", "parseAssertStatement"));
            }
            return marker;
        }
        JavaParserUtil.semicolon(builder);
        JavaParserUtil.done(statement, JavaElementType.ASSERT_STATEMENT);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/parser/StatementParser", "parseAssertStatement"));
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseBlockStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        this.parseCodeBlock(builder, true);
        JavaParserUtil.done(statement, JavaElementType.BLOCK_STATEMENT);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/parser/StatementParser", "parseBlockStatement"));
        }
        return marker;
    }

    private boolean parseExpressionInParenth(PsiBuilder builder) {
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.LPARENTH)) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.lparen", new Object[0]));
            return false;
        }
        PsiBuilder.Marker beforeExpr = builder.mark();
        PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder);
        if (expr == null || builder.getTokenType() == JavaTokenType.SEMICOLON) {
            beforeExpr.rollbackTo();
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.expression", new Object[0]));
            if (builder.getTokenType() != JavaTokenType.RPARENTH) {
                return false;
            }
        } else {
            beforeExpr.drop();
            if (builder.getTokenType() != JavaTokenType.RPARENTH) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.rparen", new Object[0]));
                return false;
            }
        }
        builder.advanceLexer();
        return true;
    }

    private static enum BraceMode {
        TILL_FIRST,
        TILL_LAST;

    }
}

