/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.bridges.Bridge;
import org.jetbrains.kotlin.backend.common.bridges.ImplKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.codegen.AnnotationCodegen;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.BridgeForBuiltinSpecial;
import org.jetbrains.kotlin.codegen.BuiltinSpecialBridgesUtil;
import org.jetbrains.kotlin.codegen.CallGenerator;
import org.jetbrains.kotlin.codegen.CallableMethod;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.CompilationException;
import org.jetbrains.kotlin.codegen.DefaultParameterValueLoader;
import org.jetbrains.kotlin.codegen.DefaultParameterValueSubstitutor;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.FrameMap;
import org.jetbrains.kotlin.codegen.FunctionGenerationStrategy;
import org.jetbrains.kotlin.codegen.ImplementationBodyCodegen;
import org.jetbrains.kotlin.codegen.JvmStaticGenerator;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.annotation.AnnotatedWithOnlyTargetedAnnotations;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.context.CodegenContextUtil;
import org.jetbrains.kotlin.codegen.context.DelegatingFacadeContext;
import org.jetbrains.kotlin.codegen.context.MethodContext;
import org.jetbrains.kotlin.codegen.context.PackageFacadeContext;
import org.jetbrains.kotlin.codegen.intrinsics.TypeIntrinsics;
import org.jetbrains.kotlin.codegen.optimization.OptimizationMethodVisitor;
import org.jetbrains.kotlin.codegen.serialization.JvmSerializationBindings;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.JetTypeMapper;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.jvm.RuntimeAssertionInfo;
import org.jetbrains.kotlin.load.java.BuiltinMethodsWithSpecialGenericSignature;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.load.java.SpecialBuiltinMembers;
import org.jetbrains.kotlin.load.kotlin.nativeDeclarations.NativeKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOriginKt;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterKind;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;
import org.jetbrains.org.objectweb.asm.util.TraceMethodVisitor;

public class FunctionCodegen {
    public final GenerationState state;
    private final JetTypeMapper typeMapper;
    private final BindingContext bindingContext;
    private final CodegenContext owner;
    private final ClassBuilder v;
    private final MemberCodegen<?> memberCodegen;

    public FunctionCodegen(@NotNull CodegenContext owner, @NotNull ClassBuilder v, @NotNull GenerationState state2, @NotNull MemberCodegen<?> memberCodegen) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/codegen/FunctionCodegen", "<init>"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/FunctionCodegen", "<init>"));
        }
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/FunctionCodegen", "<init>"));
        }
        if (memberCodegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberCodegen", "org/jetbrains/kotlin/codegen/FunctionCodegen", "<init>"));
        }
        this.owner = owner;
        this.v = v;
        this.state = state2;
        this.typeMapper = state2.getTypeMapper();
        this.bindingContext = state2.getBindingContext();
        this.memberCodegen = memberCodegen;
    }

    public void gen(@NotNull KtNamedFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/codegen/FunctionCodegen", "gen"));
        }
        SimpleFunctionDescriptor functionDescriptor = this.bindingContext.get(BindingContext.FUNCTION, function);
        assert (functionDescriptor != null) : "No descriptor for function " + function.getText() + "\n" + "in " + function.getContainingFile().getVirtualFile();
        if (this.owner.getContextKind() != OwnerKind.DEFAULT_IMPLS || function.hasBody()) {
            this.generateMethod(JvmDeclarationOriginKt.OtherOrigin(function, functionDescriptor), functionDescriptor, new FunctionGenerationStrategy.FunctionDefault(this.state, functionDescriptor, function));
        }
        this.generateDefaultIfNeeded(this.owner.intoFunction(functionDescriptor), functionDescriptor, this.owner.getContextKind(), DefaultParameterValueLoader.DEFAULT, function);
        this.generateOverloadsWithDefaultValues(function, functionDescriptor, functionDescriptor);
    }

    public void generateOverloadsWithDefaultValues(@Nullable KtNamedFunction function, @NotNull FunctionDescriptor functionDescriptor, @NotNull FunctionDescriptor delegateFunctionDescriptor) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateOverloadsWithDefaultValues"));
        }
        if (delegateFunctionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateFunctionDescriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateOverloadsWithDefaultValues"));
        }
        new DefaultParameterValueSubstitutor(this.state).generateOverloadsIfNeeded(function, functionDescriptor, delegateFunctionDescriptor, this.owner.getContextKind(), this.v);
    }

    public void generateMethod(@NotNull JvmDeclarationOrigin origin, @NotNull FunctionDescriptor descriptor2, @NotNull FunctionGenerationStrategy strategy) {
        if (origin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "origin", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateMethod"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateMethod"));
        }
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateMethod"));
        }
        this.generateMethod(origin, descriptor2, this.owner.intoFunction(descriptor2), strategy);
    }

    public void generateMethod(@NotNull JvmDeclarationOrigin origin, @NotNull FunctionDescriptor functionDescriptor, @NotNull MethodContext methodContext, @NotNull FunctionGenerationStrategy strategy) {
        if (origin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "origin", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateMethod"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateMethod"));
        }
        if (methodContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodContext", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateMethod"));
        }
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateMethod"));
        }
        OwnerKind contextKind = methodContext.getContextKind();
        if (DescriptorUtils.isInterface(functionDescriptor.getContainingDeclaration()) && functionDescriptor.getVisibility() == Visibilities.PRIVATE && contextKind != OwnerKind.DEFAULT_IMPLS) {
            return;
        }
        JvmMethodSignature jvmSignature = this.typeMapper.mapSignature(functionDescriptor, contextKind);
        Method asmMethod = jvmSignature.getAsmMethod();
        int flags = AsmUtil.getMethodAsmFlags(functionDescriptor, contextKind);
        boolean isNative = NativeKt.hasNativeAnnotation(functionDescriptor);
        if (isNative && this.owner instanceof DelegatingFacadeContext) {
            return;
        }
        MethodVisitor mv = this.v.newMethod(origin, flags, asmMethod.getName(), asmMethod.getDescriptor(), jvmSignature.getGenericsSignature(), FunctionCodegen.getThrownExceptions(functionDescriptor, this.typeMapper));
        String implClassName = CodegenContextUtil.getImplementationClassShortName(this.owner);
        if (implClassName != null) {
            this.v.getSerializationBindings().put(JvmSerializationBindings.IMPL_CLASS_NAME_FOR_CALLABLE, functionDescriptor, implClassName);
        }
        if (CodegenContextUtil.isImplClassOwner(this.owner)) {
            this.v.getSerializationBindings().put(JvmSerializationBindings.METHOD_FOR_FUNCTION, functionDescriptor, asmMethod);
        }
        this.generateMethodAnnotations(functionDescriptor, asmMethod, mv);
        this.generateParameterAnnotations(functionDescriptor, mv, this.typeMapper.mapSignature(functionDescriptor));
        this.generateBridges(functionDescriptor);
        boolean staticInCompanionObject = AnnotationUtilKt.isPlatformStaticInCompanionObject(functionDescriptor);
        if (staticInCompanionObject) {
            ImplementationBodyCodegen parentBodyCodegen = (ImplementationBodyCodegen)this.memberCodegen.getParentCodegen();
            parentBodyCodegen.addAdditionalTask(new JvmStaticGenerator(functionDescriptor, origin, this.state));
        }
        if (this.state.getClassBuilderMode() == ClassBuilderMode.LIGHT_CLASSES || AsmUtil.isAbstractMethod(functionDescriptor, contextKind)) {
            FunctionCodegen.generateLocalVariableTable(mv, jvmSignature, functionDescriptor, FunctionCodegen.getThisTypeForFunction(functionDescriptor, methodContext, this.typeMapper), new Label(), new Label(), contextKind);
            mv.visitEnd();
            return;
        }
        if (!isNative) {
            FunctionCodegen.generateMethodBody(mv, functionDescriptor, methodContext, jvmSignature, strategy, this.memberCodegen);
        } else if (staticInCompanionObject) {
            mv.visitCode();
            FunctionDescriptor staticFunctionDescriptor = JvmStaticGenerator.createStaticFunctionDescriptor(functionDescriptor);
            JvmMethodSignature jvmMethodSignature = this.typeMapper.mapSignature(this.memberCodegen.getContext().accessibleDescriptor(staticFunctionDescriptor, null));
            Type owningType = this.typeMapper.mapClass((ClassifierDescriptor)staticFunctionDescriptor.getContainingDeclaration());
            FunctionCodegen.generateDelegateToMethodBody(false, mv, jvmMethodSignature.getAsmMethod(), owningType.getInternalName());
        }
        FunctionCodegen.endVisit(mv, null, origin.getElement());
        methodContext.recordSyntheticAccessorIfNeeded(functionDescriptor, this.bindingContext);
    }

    private void generateMethodAnnotations(@NotNull FunctionDescriptor functionDescriptor, Method asmMethod, MethodVisitor mv) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateMethodAnnotations"));
        }
        AnnotationCodegen annotationCodegen = AnnotationCodegen.forMethod(mv, this.typeMapper);
        if (functionDescriptor instanceof PropertyAccessorDescriptor) {
            AnnotationUseSiteTarget target = functionDescriptor instanceof PropertySetterDescriptor ? AnnotationUseSiteTarget.PROPERTY_SETTER : AnnotationUseSiteTarget.PROPERTY_GETTER;
            annotationCodegen.genAnnotations(functionDescriptor, asmMethod.getReturnType(), target);
        } else {
            annotationCodegen.genAnnotations(functionDescriptor, asmMethod.getReturnType());
        }
        this.writePackageFacadeMethodAnnotationsIfNeeded(mv);
    }

    private void writePackageFacadeMethodAnnotationsIfNeeded(MethodVisitor mv) {
        PackageFacadeContext packageFacadeContext;
        Type delegateToClassType;
        if (this.owner instanceof PackageFacadeContext && (delegateToClassType = (packageFacadeContext = (PackageFacadeContext)this.owner).getPublicFacadeType()) != null) {
            String className = delegateToClassType.getClassName();
            AnnotationVisitor av = mv.visitAnnotation(AsmUtil.asmDescByFqNameWithoutInnerClasses(JvmAnnotationNames.KOTLIN_DELEGATED_METHOD), true);
            av.visit("implementationClassName", className);
            av.visitEnd();
        }
    }

    private void generateParameterAnnotations(@NotNull FunctionDescriptor functionDescriptor, @NotNull MethodVisitor mv, @NotNull JvmMethodSignature jvmSignature) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateParameterAnnotations"));
        }
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateParameterAnnotations"));
        }
        if (jvmSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmSignature", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateParameterAnnotations"));
        }
        Iterator<ValueParameterDescriptor> iterator2 = functionDescriptor.getValueParameters().iterator();
        List<JvmMethodParameterSignature> kotlinParameterTypes = jvmSignature.getValueParameters();
        for (int i = 0; i < kotlinParameterTypes.size(); ++i) {
            ReceiverParameterDescriptor receiver;
            AnnotationCodegen annotationCodegen;
            JvmMethodParameterSignature parameterSignature = kotlinParameterTypes.get(i);
            JvmMethodParameterKind kind = parameterSignature.getKind();
            if (kind.isSkippedInGenericSignature()) {
                this.markEnumOrInnerConstructorParameterAsSynthetic(mv, i);
                continue;
            }
            if (kind == JvmMethodParameterKind.VALUE) {
                ValueParameterDescriptor parameter = iterator2.next();
                if (parameter.getIndex() != i) {
                    this.v.getSerializationBindings().put(JvmSerializationBindings.INDEX_FOR_VALUE_PARAMETER, parameter, i);
                }
                annotationCodegen = AnnotationCodegen.forParameter(i, mv, this.typeMapper);
                if (functionDescriptor instanceof PropertySetterDescriptor) {
                    PropertyDescriptor propertyDescriptor = ((PropertySetterDescriptor)functionDescriptor).getCorrespondingProperty();
                    AnnotatedWithOnlyTargetedAnnotations targetedAnnotations = new AnnotatedWithOnlyTargetedAnnotations(propertyDescriptor);
                    annotationCodegen.genAnnotations(targetedAnnotations, parameterSignature.getAsmType(), AnnotationUseSiteTarget.SETTER_PARAMETER);
                }
                if (functionDescriptor instanceof ConstructorDescriptor) {
                    annotationCodegen.genAnnotations(parameter, parameterSignature.getAsmType(), AnnotationUseSiteTarget.CONSTRUCTOR_PARAMETER);
                    continue;
                }
                annotationCodegen.genAnnotations(parameter, parameterSignature.getAsmType());
                continue;
            }
            if (kind != JvmMethodParameterKind.RECEIVER || (receiver = (functionDescriptor instanceof PropertyAccessorDescriptor ? ((PropertyAccessorDescriptor)functionDescriptor).getCorrespondingProperty() : functionDescriptor).getExtensionReceiverParameter()) == null) continue;
            annotationCodegen = AnnotationCodegen.forParameter(i, mv, this.typeMapper);
            AnnotatedWithOnlyTargetedAnnotations targetedAnnotations = new AnnotatedWithOnlyTargetedAnnotations(receiver.getType());
            annotationCodegen.genAnnotations(targetedAnnotations, parameterSignature.getAsmType(), AnnotationUseSiteTarget.RECEIVER);
        }
    }

    private void markEnumOrInnerConstructorParameterAsSynthetic(MethodVisitor mv, int i) {
        if (this.state.getClassBuilderMode() == ClassBuilderMode.LIGHT_CLASSES) {
            return;
        }
        AnnotationVisitor av = mv.visitParameterAnnotation(i, "Ljava/lang/Synthetic;", true);
        if (av != null) {
            av.visitEnd();
        }
    }

    @Nullable
    private static Type getThisTypeForFunction(@NotNull FunctionDescriptor functionDescriptor, @NotNull MethodContext context, @NotNull JetTypeMapper typeMapper) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "getThisTypeForFunction"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/FunctionCodegen", "getThisTypeForFunction"));
        }
        if (typeMapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMapper", "org/jetbrains/kotlin/codegen/FunctionCodegen", "getThisTypeForFunction"));
        }
        ReceiverParameterDescriptor dispatchReceiver = functionDescriptor.getDispatchReceiverParameter();
        if (functionDescriptor instanceof ConstructorDescriptor) {
            return typeMapper.mapType(functionDescriptor);
        }
        if (dispatchReceiver != null) {
            return typeMapper.mapType(dispatchReceiver.getType());
        }
        if (ExpressionTypingUtils.isFunctionLiteral(functionDescriptor) || ExpressionTypingUtils.isLocalFunction(functionDescriptor) || ExpressionTypingUtils.isFunctionExpression(functionDescriptor)) {
            return typeMapper.mapType(context.getThisDescriptor());
        }
        return null;
    }

    public static void generateMethodBody(@NotNull MethodVisitor mv, @NotNull FunctionDescriptor functionDescriptor, @NotNull MethodContext context, @NotNull JvmMethodSignature signature, @NotNull FunctionGenerationStrategy strategy, @NotNull MemberCodegen<?> parentCodegen) {
        String name;
        int indexOfLambdaOrdinal;
        Label methodEnd;
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateMethodBody"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateMethodBody"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateMethodBody"));
        }
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateMethodBody"));
        }
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateMethodBody"));
        }
        if (parentCodegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentCodegen", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateMethodBody"));
        }
        mv.visitCode();
        Label methodBegin = new Label();
        mv.visitLabel(methodBegin);
        JetTypeMapper typeMapper = parentCodegen.typeMapper;
        if (BuiltinSpecialBridgesUtil.shouldHaveTypeSafeBarrier(functionDescriptor, FunctionCodegen.getSignatureMapper(typeMapper))) {
            FunctionCodegen.generateTypeCheckBarrierIfNeeded(new InstructionAdapter(mv), functionDescriptor, signature.getReturnType(), null);
        }
        int functionFakeIndex = -1;
        int lambdaFakeIndex = -1;
        if (context.getParentContext() instanceof DelegatingFacadeContext) {
            FunctionCodegen.generateFacadeDelegateMethodBody(mv, signature.getAsmMethod(), (DelegatingFacadeContext)((Object)context.getParentContext()));
            methodEnd = new Label();
        } else {
            FrameMap frameMap = FunctionCodegen.createFrameMap(parentCodegen.state, functionDescriptor, signature, AsmUtil.isStaticMethod(context.getContextKind(), functionDescriptor));
            if (context.isInlineFunction()) {
                functionFakeIndex = frameMap.enterTemp(Type.INT_TYPE);
            }
            if (context.isInliningLambda()) {
                lambdaFakeIndex = frameMap.enterTemp(Type.INT_TYPE);
            }
            Label methodEntry = new Label();
            mv.visitLabel(methodEntry);
            context.setMethodStartLabel(methodEntry);
            if (!JetTypeMapper.isAccessor(functionDescriptor)) {
                AsmUtil.genNotNullAssertionsForParameters(new InstructionAdapter(mv), parentCodegen.state, functionDescriptor, frameMap);
            }
            methodEnd = new Label();
            context.setMethodEndLabel(methodEnd);
            strategy.generateBody(mv, frameMap, signature, context, parentCodegen);
        }
        mv.visitLabel(methodEnd);
        Type thisType = FunctionCodegen.getThisTypeForFunction(functionDescriptor, context, typeMapper);
        FunctionCodegen.generateLocalVariableTable(mv, signature, functionDescriptor, thisType, methodBegin, methodEnd, context.getContextKind());
        if (context.isInlineFunction() && functionFakeIndex != -1) {
            mv.visitLocalVariable("$i$f$" + functionDescriptor.getName().asString(), Type.INT_TYPE.getDescriptor(), null, methodBegin, methodEnd, functionFakeIndex);
        }
        if (context.isInliningLambda() && thisType != null && lambdaFakeIndex != -1 && (indexOfLambdaOrdinal = (name = thisType.getClassName()).lastIndexOf("$")) > 0) {
            int lambdaOrdinal = Integer.parseInt(name.substring(indexOfLambdaOrdinal + 1));
            mv.visitLocalVariable("$i$a$" + lambdaOrdinal, Type.INT_TYPE.getDescriptor(), null, methodBegin, methodEnd, lambdaFakeIndex);
        }
    }

    private static void generateLocalVariableTable(@NotNull MethodVisitor mv, @NotNull JvmMethodSignature jvmMethodSignature, @NotNull FunctionDescriptor functionDescriptor, @Nullable Type thisType, @NotNull Label methodBegin, @NotNull Label methodEnd, @NotNull OwnerKind ownerKind) {
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateLocalVariableTable"));
        }
        if (jvmMethodSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmMethodSignature", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateLocalVariableTable"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateLocalVariableTable"));
        }
        if (methodBegin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodBegin", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateLocalVariableTable"));
        }
        if (methodEnd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodEnd", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateLocalVariableTable"));
        }
        if (ownerKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerKind", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateLocalVariableTable"));
        }
        Iterator<ValueParameterDescriptor> valueParameters = functionDescriptor.getValueParameters().iterator();
        List<JvmMethodParameterSignature> params = jvmMethodSignature.getValueParameters();
        int shift = 0;
        boolean isStatic = AsmUtil.isStaticMethod(ownerKind, functionDescriptor);
        if (!isStatic) {
            if (thisType != null) {
                mv.visitLocalVariable("this", thisType.getDescriptor(), null, methodBegin, methodEnd, shift);
            }
            ++shift;
        }
        for (int i = 0; i < params.size(); ++i) {
            String parameterName;
            JvmMethodParameterSignature param = params.get(i);
            JvmMethodParameterKind kind = param.getKind();
            if (kind == JvmMethodParameterKind.VALUE) {
                ValueParameterDescriptor parameter = valueParameters.next();
                parameterName = parameter.getName().asString();
            } else {
                String lowercaseKind = kind.name().toLowerCase();
                parameterName = FunctionCodegen.needIndexForVar(kind) ? "$" + lowercaseKind + "$" + i : "$" + lowercaseKind;
            }
            Type type2 = param.getAsmType();
            mv.visitLocalVariable(parameterName, type2.getDescriptor(), null, methodBegin, methodEnd, shift);
            shift += type2.getSize();
        }
    }

    private static void generateFacadeDelegateMethodBody(@NotNull MethodVisitor mv, @NotNull Method asmMethod, @NotNull DelegatingFacadeContext context) {
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateFacadeDelegateMethodBody"));
        }
        if (asmMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asmMethod", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateFacadeDelegateMethodBody"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateFacadeDelegateMethodBody"));
        }
        FunctionCodegen.generateDelegateToMethodBody(true, mv, asmMethod, context.getDelegateToClassType().getInternalName());
    }

    private static void generateDelegateToMethodBody(boolean isStatic, @NotNull MethodVisitor mv, @NotNull Method asmMethod, @NotNull String classToDelegateTo) {
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateDelegateToMethodBody"));
        }
        if (asmMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asmMethod", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateDelegateToMethodBody"));
        }
        if (classToDelegateTo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classToDelegateTo", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateDelegateToMethodBody"));
        }
        InstructionAdapter iv = new InstructionAdapter(mv);
        Type[] argTypes = asmMethod.getArgumentTypes();
        Label label = new Label();
        iv.visitLabel(label);
        iv.visitLineNumber(1, label);
        int k = isStatic ? 0 : 1;
        for (Type argType : argTypes) {
            iv.load(k, argType);
            k += argType.getSize();
        }
        iv.invokestatic(classToDelegateTo, asmMethod.getName(), asmMethod.getDescriptor(), false);
        iv.areturn(asmMethod.getReturnType());
    }

    private static boolean needIndexForVar(JvmMethodParameterKind kind) {
        return kind == JvmMethodParameterKind.CAPTURED_LOCAL_VARIABLE || kind == JvmMethodParameterKind.ENUM_NAME_OR_ORDINAL || kind == JvmMethodParameterKind.SUPER_CALL_PARAM;
    }

    public static void endVisit(MethodVisitor mv, @Nullable String description, @Nullable PsiElement method) {
        try {
            mv.visitMaxs(-1, -1);
            mv.visitEnd();
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable t) {
            String bytecode = FunctionCodegen.renderByteCodeIfAvailable(mv);
            throw new CompilationException("wrong code generated" + (description != null ? " for " + description : "") + t.getClass().getName() + " " + t.getMessage() + (bytecode != null ? "\nbytecode:\n" + bytecode : ""), t, method);
        }
    }

    private static String renderByteCodeIfAvailable(MethodVisitor mv) {
        String bytecode = null;
        if (mv instanceof OptimizationMethodVisitor) {
            mv = ((OptimizationMethodVisitor)mv).getTraceMethodVisitorIfPossible();
        }
        if (mv instanceof TraceMethodVisitor) {
            TraceMethodVisitor traceMethodVisitor = (TraceMethodVisitor)mv;
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            traceMethodVisitor.p.print(pw);
            pw.close();
            bytecode = sw.toString();
        }
        return bytecode;
    }

    public void generateBridges(@NotNull FunctionDescriptor descriptor2) {
        boolean isSpecial;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateBridges"));
        }
        if (descriptor2 instanceof ConstructorDescriptor) {
            return;
        }
        if (this.owner.getContextKind() == OwnerKind.DEFAULT_IMPLS) {
            return;
        }
        if (DescriptorUtils.isInterface(descriptor2.getContainingDeclaration())) {
            return;
        }
        if (FunctionCodegen.isMethodOfAny(descriptor2)) {
            return;
        }
        if (CallResolverUtilKt.isOrOverridesSynthesized(descriptor2)) {
            return;
        }
        boolean bl = isSpecial = SpecialBuiltinMembers.getOverriddenBuiltinWithDifferentJvmDescriptor(descriptor2) != null;
        if (!isSpecial) {
            Set<Bridge<Method>> bridgesToGenerate = ImplKt.generateBridgesForFunctionDescriptor(descriptor2, FunctionCodegen.getSignatureMapper(this.typeMapper));
            if (!bridgesToGenerate.isEmpty()) {
                PsiElement origin = descriptor2.getKind() == CallableMemberDescriptor.Kind.DECLARATION ? DescriptorToSourceUtils.getSourceFromDescriptor(descriptor2) : null;
                boolean isSpecialBridge = BuiltinMethodsWithSpecialGenericSignature.getOverriddenBuiltinFunctionWithErasedValueParametersInJava(descriptor2) != null;
                for (Bridge<Method> bridge : bridgesToGenerate) {
                    this.generateBridge(origin, descriptor2, bridge.getFrom(), bridge.getTo(), isSpecialBridge, false);
                }
            }
        } else {
            Set<BridgeForBuiltinSpecial<Method>> specials = BuiltinSpecialBridgesUtil.generateBridgesForBuiltinSpecial(descriptor2, FunctionCodegen.getSignatureMapper(this.typeMapper));
            if (!specials.isEmpty()) {
                PsiElement origin = descriptor2.getKind() == CallableMemberDescriptor.Kind.DECLARATION ? DescriptorToSourceUtils.getSourceFromDescriptor(descriptor2) : null;
                for (BridgeForBuiltinSpecial<Method> bridge : specials) {
                    this.generateBridge(origin, descriptor2, bridge.getFrom(), bridge.getTo(), bridge.isSpecial(), bridge.isDelegateToSuper());
                }
            }
            if (!descriptor2.getKind().isReal() && AsmUtil.isAbstractMethod(descriptor2, OwnerKind.IMPLEMENTATION)) {
                FunctionDescriptor overridden = SpecialBuiltinMembers.getOverriddenBuiltinWithDifferentJvmDescriptor(descriptor2);
                assert (overridden != null);
                Method method = this.typeMapper.mapSignature(descriptor2).getAsmMethod();
                int flags = 0x400 | AsmUtil.getVisibilityAccessFlag(descriptor2);
                this.v.newMethod(JvmDeclarationOriginKt.OtherOrigin(overridden), flags, method.getName(), method.getDescriptor(), null, null);
            }
        }
    }

    @NotNull
    private static Function1<FunctionDescriptor, Method> getSignatureMapper(final @NotNull JetTypeMapper typeMapper) {
        if (typeMapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMapper", "org/jetbrains/kotlin/codegen/FunctionCodegen", "getSignatureMapper"));
        }
        Function1<FunctionDescriptor, Method> function1 = new Function1<FunctionDescriptor, Method>(){

            @Override
            public Method invoke(FunctionDescriptor descriptor2) {
                return typeMapper.mapSignature(descriptor2).getAsmMethod();
            }
        };
        if (function1 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/FunctionCodegen", "getSignatureMapper"));
        }
        return function1;
    }

    private static boolean isMethodOfAny(@NotNull FunctionDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "isMethodOfAny"));
        }
        String name = descriptor2.getName().asString();
        List<ValueParameterDescriptor> parameters2 = descriptor2.getValueParameters();
        if (parameters2.isEmpty()) {
            return name.equals("hashCode") || name.equals("toString");
        }
        if (parameters2.size() == 1 && name.equals("equals")) {
            return KotlinBuiltIns.isNullableAny(parameters2.get(0).getType());
        }
        return false;
    }

    @NotNull
    public static String[] getThrownExceptions(@NotNull FunctionDescriptor function, final @NotNull JetTypeMapper mapper) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/codegen/FunctionCodegen", "getThrownExceptions"));
        }
        if (mapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "org/jetbrains/kotlin/codegen/FunctionCodegen", "getThrownExceptions"));
        }
        AnnotationDescriptor annotation2 = function.getAnnotations().findAnnotation(new FqName("kotlin.throws"));
        if (annotation2 == null) {
            annotation2 = function.getAnnotations().findAnnotation(new FqName("kotlin.jvm.Throws"));
        }
        if (annotation2 == null) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/FunctionCodegen", "getThrownExceptions"));
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        Collection<ConstantValue<?>> values = annotation2.getAllValueArguments().values();
        if (values.isEmpty()) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/FunctionCodegen", "getThrownExceptions"));
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        ConstantValue<?> value = values.iterator().next();
        if (!(value instanceof ArrayValue)) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/FunctionCodegen", "getThrownExceptions"));
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        ArrayValue arrayValue = (ArrayValue)value;
        List<String> strings = ContainerUtil.mapNotNull((Collection)arrayValue.getValue(), new Function<ConstantValue<?>, String>(){

            @Override
            public String fun(ConstantValue<?> constant) {
                if (constant instanceof KClassValue) {
                    KClassValue classValue = (KClassValue)constant;
                    ClassDescriptor classDescriptor = DescriptorUtils.getClassDescriptorForType(classValue.getValue());
                    return mapper.mapClass(classDescriptor).getInternalName();
                }
                return null;
            }
        });
        String[] stringArray = ArrayUtil.toStringArray(strings);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/FunctionCodegen", "getThrownExceptions"));
        }
        return stringArray;
    }

    void generateDefaultIfNeeded(@NotNull MethodContext owner, @NotNull FunctionDescriptor functionDescriptor, @NotNull OwnerKind kind, @NotNull DefaultParameterValueLoader loadStrategy, @Nullable KtNamedFunction function) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateDefaultIfNeeded"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateDefaultIfNeeded"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateDefaultIfNeeded"));
        }
        if (loadStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loadStrategy", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateDefaultIfNeeded"));
        }
        DeclarationDescriptor contextClass = ((CallableMemberDescriptor)owner.getContextDescriptor()).getContainingDeclaration();
        if (kind != OwnerKind.DEFAULT_IMPLS && DescriptorUtils.isInterface(contextClass)) {
            return;
        }
        if (!FunctionCodegen.isDefaultNeeded(functionDescriptor)) {
            return;
        }
        int flags = AsmUtil.getVisibilityAccessFlag(functionDescriptor) | AsmUtil.getDeprecatedAccessFlag(functionDescriptor) | 0x1000;
        if (!(functionDescriptor instanceof ConstructorDescriptor)) {
            flags |= 0x48;
        }
        Method defaultMethod = this.typeMapper.mapDefaultMethod(functionDescriptor, kind);
        MethodVisitor mv = this.v.newMethod(JvmDeclarationOriginKt.Synthetic(function, functionDescriptor), flags &= 0xFFFFFFFD, defaultMethod.getName(), defaultMethod.getDescriptor(), null, FunctionCodegen.getThrownExceptions(functionDescriptor, this.typeMapper));
        AnnotationCodegen.forMethod(mv, this.typeMapper).genAnnotations(functionDescriptor, defaultMethod.getReturnType());
        if (this.state.getClassBuilderMode() == ClassBuilderMode.FULL) {
            if (this.owner instanceof DelegatingFacadeContext) {
                mv.visitCode();
                FunctionCodegen.generateFacadeDelegateMethodBody(mv, defaultMethod, (DelegatingFacadeContext)((Object)this.owner));
                FunctionCodegen.endVisit(mv, "default method delegation", DescriptorToSourceUtils.getSourceFromDescriptor(functionDescriptor));
            } else {
                mv.visitCode();
                FunctionCodegen.generateDefaultImplBody(owner, functionDescriptor, mv, loadStrategy, function, this.memberCodegen);
                FunctionCodegen.endVisit(mv, "default method", DescriptorToSourceUtils.getSourceFromDescriptor(functionDescriptor));
            }
        }
    }

    public static void generateDefaultImplBody(@NotNull MethodContext methodContext, @NotNull FunctionDescriptor functionDescriptor, @NotNull MethodVisitor mv, @NotNull DefaultParameterValueLoader loadStrategy, @Nullable KtNamedFunction function, @NotNull MemberCodegen<?> parentCodegen) {
        int capturedArgumentsCount;
        if (methodContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodContext", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateDefaultImplBody"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateDefaultImplBody"));
        }
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateDefaultImplBody"));
        }
        if (loadStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loadStrategy", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateDefaultImplBody"));
        }
        if (parentCodegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentCodegen", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateDefaultImplBody"));
        }
        GenerationState state2 = parentCodegen.state;
        JvmMethodSignature signature = state2.getTypeMapper().mapSignature(functionDescriptor, methodContext.getContextKind());
        boolean isStatic = AsmUtil.isStaticMethod(methodContext.getContextKind(), functionDescriptor);
        FrameMap frameMap = FunctionCodegen.createFrameMap(state2, functionDescriptor, signature, isStatic);
        ExpressionCodegen codegen = new ExpressionCodegen(mv, frameMap, signature.getReturnType(), methodContext, state2, parentCodegen);
        CallGenerator generator = codegen.getOrCreateCallGenerator(functionDescriptor, function);
        FunctionCodegen.loadExplicitArgumentsOnStack(AsmTypes.OBJECT_TYPE, isStatic, signature, generator);
        List<JvmMethodParameterSignature> mappedParameters = signature.getValueParameters();
        for (capturedArgumentsCount = 0; capturedArgumentsCount < mappedParameters.size() && mappedParameters.get(capturedArgumentsCount).getKind() != JvmMethodParameterKind.VALUE; ++capturedArgumentsCount) {
        }
        InstructionAdapter iv = new InstructionAdapter(mv);
        int maskIndex = 0;
        List<ValueParameterDescriptor> valueParameters = functionDescriptor.getValueParameters();
        for (int index2 = 0; index2 < valueParameters.size(); ++index2) {
            if (index2 % 32 == 0) {
                maskIndex = frameMap.enterTemp(Type.INT_TYPE);
            }
            ValueParameterDescriptor parameterDescriptor = valueParameters.get(index2);
            Type type2 = mappedParameters.get(capturedArgumentsCount + index2).getAsmType();
            int parameterIndex = frameMap.getIndex(parameterDescriptor);
            if (parameterDescriptor.declaresDefaultValue()) {
                iv.load(maskIndex, Type.INT_TYPE);
                iv.iconst(1 << index2 % 32);
                iv.and(Type.INT_TYPE);
                Label loadArg = new Label();
                iv.ifeq(loadArg);
                StackValue.local(parameterIndex, type2).store(loadStrategy.genValue(parameterDescriptor, codegen), iv);
                iv.mark(loadArg);
            }
            generator.putValueIfNeeded(parameterDescriptor, type2, StackValue.local(parameterIndex, type2));
        }
        CallableMethod method = state2.getTypeMapper().mapToCallableMethod(functionDescriptor, false);
        generator.genCallWithoutAssertions(method, codegen);
        iv.areturn(signature.getReturnType());
    }

    @NotNull
    private static FrameMap createFrameMap(@NotNull GenerationState state2, @NotNull FunctionDescriptor function, @NotNull JvmMethodSignature signature, boolean isStatic) {
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/FunctionCodegen", "createFrameMap"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/codegen/FunctionCodegen", "createFrameMap"));
        }
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/kotlin/codegen/FunctionCodegen", "createFrameMap"));
        }
        FrameMap frameMap = new FrameMap();
        if (!isStatic) {
            frameMap.enterTemp(AsmTypes.OBJECT_TYPE);
        }
        for (JvmMethodParameterSignature jvmMethodParameterSignature : signature.getValueParameters()) {
            if (jvmMethodParameterSignature.getKind() == JvmMethodParameterKind.RECEIVER) {
                ReceiverParameterDescriptor receiverParameter = function.getExtensionReceiverParameter();
                if (receiverParameter == null) continue;
                frameMap.enter(receiverParameter, state2.getTypeMapper().mapType(receiverParameter));
                continue;
            }
            if (jvmMethodParameterSignature.getKind() == JvmMethodParameterKind.VALUE) continue;
            frameMap.enterTemp(jvmMethodParameterSignature.getAsmType());
        }
        for (ValueParameterDescriptor valueParameterDescriptor : function.getValueParameters()) {
            frameMap.enter(valueParameterDescriptor, state2.getTypeMapper().mapType(valueParameterDescriptor));
        }
        FrameMap frameMap2 = frameMap;
        if (frameMap2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/FunctionCodegen", "createFrameMap"));
        }
        return frameMap2;
    }

    private static void loadExplicitArgumentsOnStack(@NotNull Type ownerType, boolean isStatic, @NotNull JvmMethodSignature signature, @NotNull CallGenerator callGenerator) {
        if (ownerType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerType", "org/jetbrains/kotlin/codegen/FunctionCodegen", "loadExplicitArgumentsOnStack"));
        }
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/kotlin/codegen/FunctionCodegen", "loadExplicitArgumentsOnStack"));
        }
        if (callGenerator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callGenerator", "org/jetbrains/kotlin/codegen/FunctionCodegen", "loadExplicitArgumentsOnStack"));
        }
        int var = 0;
        if (!isStatic) {
            callGenerator.putValueIfNeeded(null, ownerType, StackValue.local(var, ownerType));
            var += ownerType.getSize();
        }
        for (JvmMethodParameterSignature parameterSignature : signature.getValueParameters()) {
            if (parameterSignature.getKind() == JvmMethodParameterKind.VALUE) continue;
            Type type2 = parameterSignature.getAsmType();
            callGenerator.putValueIfNeeded(null, type2, StackValue.local(var, type2));
            var += type2.getSize();
        }
    }

    private static boolean isDefaultNeeded(FunctionDescriptor functionDescriptor) {
        boolean needed = false;
        if (functionDescriptor != null) {
            for (ValueParameterDescriptor parameterDescriptor : functionDescriptor.getValueParameters()) {
                if (!parameterDescriptor.declaresDefaultValue()) continue;
                needed = true;
                break;
            }
        }
        return needed;
    }

    private void generateBridge(@Nullable PsiElement origin, @NotNull FunctionDescriptor descriptor2, @NotNull Method bridge, @NotNull Method delegateTo, boolean isSpecialBridge, boolean isStubDeclarationWithDelegationToSuper) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateBridge"));
        }
        if (bridge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bridge", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateBridge"));
        }
        if (delegateTo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateTo", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateBridge"));
        }
        boolean isSpecialOrDelegationToSuper = isSpecialBridge || isStubDeclarationWithDelegationToSuper;
        int flags = 0x41 | (!isSpecialOrDelegationToSuper ? 4096 : 0) | (isSpecialBridge ? 16 : 0);
        MethodVisitor mv = this.v.newMethod(JvmDeclarationOriginKt.Bridge(descriptor2, origin), flags, bridge.getName(), bridge.getDescriptor(), null, null);
        if (this.state.getClassBuilderMode() != ClassBuilderMode.FULL) {
            return;
        }
        mv.visitCode();
        Type[] argTypes = bridge.getArgumentTypes();
        Type[] originalArgTypes = delegateTo.getArgumentTypes();
        InstructionAdapter iv = new InstructionAdapter(mv);
        MemberCodegen.markLineNumberForDescriptor(this.owner.getThisDescriptor(), iv);
        if (delegateTo.getArgumentTypes().length == 1 && isSpecialBridge) {
            FunctionCodegen.generateTypeCheckBarrierIfNeeded(iv, descriptor2, bridge.getReturnType(), delegateTo.getArgumentTypes()[0]);
        }
        iv.load(0, AsmTypes.OBJECT_TYPE);
        int reg = 1;
        for (int i = 0; i < argTypes.length; ++i) {
            StackValue.local(reg, argTypes[i]).put(originalArgTypes[i], iv);
            reg += argTypes[i].getSize();
        }
        if (isStubDeclarationWithDelegationToSuper) {
            ClassDescriptor parentClass = DescriptorUtils.getSuperClassDescriptor((ClassDescriptor)descriptor2.getContainingDeclaration());
            assert (parentClass != null);
            String parentInternalName = this.typeMapper.mapClass(parentClass).getInternalName();
            iv.invokespecial(parentInternalName, delegateTo.getName(), delegateTo.getDescriptor());
        } else {
            iv.invokevirtual(this.v.getThisName(), delegateTo.getName(), delegateTo.getDescriptor());
        }
        StackValue.coerce(delegateTo.getReturnType(), bridge.getReturnType(), iv);
        iv.areturn(bridge.getReturnType());
        FunctionCodegen.endVisit(mv, "bridge method", origin);
    }

    private static void generateTypeCheckBarrierIfNeeded(@NotNull InstructionAdapter iv, @NotNull FunctionDescriptor descriptor2, @NotNull Type returnType2, final @Nullable Type delegateParameterType) {
        if (iv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iv", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateTypeCheckBarrierIfNeeded"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateTypeCheckBarrierIfNeeded"));
        }
        if (returnType2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateTypeCheckBarrierIfNeeded"));
        }
        BuiltinMethodsWithSpecialGenericSignature.DefaultValue defaultValue = BuiltinMethodsWithSpecialGenericSignature.getDefaultValueForOverriddenBuiltinFunction(descriptor2);
        if (defaultValue == null) {
            return;
        }
        assert (descriptor2.getValueParameters().size() == 1) : "Should be descriptor with one value parameter, but found: " + descriptor2;
        boolean isCheckForAny = delegateParameterType == null || AsmTypes.OBJECT_TYPE.equals(delegateParameterType);
        final KotlinType kotlinType = descriptor2.getValueParameters().get(0).getType();
        if (isCheckForAny && TypeUtils.isNullableType(kotlinType)) {
            return;
        }
        iv.load(1, AsmTypes.OBJECT_TYPE);
        Label afterBarrier = new Label();
        if (isCheckForAny) {
            assert (!TypeUtils.isNullableType(kotlinType)) : "Only bridges for not-nullable types are necessary";
            iv.ifnonnull(afterBarrier);
        } else {
            CodegenUtilKt.generateIsCheck(iv, kotlinType, (Function1<? super InstructionAdapter, ? extends Unit>)new Function1<InstructionAdapter, Unit>(){

                @Override
                public Unit invoke(InstructionAdapter adapter) {
                    TypeIntrinsics.instanceOf(adapter, kotlinType, AsmUtil.boxType(delegateParameterType));
                    return Unit.INSTANCE;
                }
            });
            iv.ifne(afterBarrier);
        }
        StackValue.constant(defaultValue.getValue(), returnType2).put(returnType2, iv);
        iv.areturn(returnType2);
        iv.visitLabel(afterBarrier);
    }

    public void genDelegate(@NotNull FunctionDescriptor functionDescriptor, FunctionDescriptor overriddenDescriptor, StackValue field) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "genDelegate"));
        }
        this.genDelegate(functionDescriptor, overriddenDescriptor.getOriginal(), (ClassDescriptor)overriddenDescriptor.getContainingDeclaration(), field);
    }

    public void genDelegate(final @NotNull FunctionDescriptor delegateFunction, final FunctionDescriptor delegatedTo, final ClassDescriptor toClass, final StackValue field) {
        if (delegateFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateFunction", "org/jetbrains/kotlin/codegen/FunctionCodegen", "genDelegate"));
        }
        this.generateMethod(JvmDeclarationOriginKt.Delegation(DescriptorToSourceUtils.descriptorToDeclaration(delegatedTo), delegateFunction), delegateFunction, new FunctionGenerationStrategy(){

            @Override
            public void generateBody(@NotNull MethodVisitor mv, @NotNull FrameMap frameMap, @NotNull JvmMethodSignature signature, @NotNull MethodContext context, @NotNull MemberCodegen<?> parentCodegen) {
                if (mv == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/kotlin/codegen/FunctionCodegen$4", "generateBody"));
                }
                if (frameMap == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameMap", "org/jetbrains/kotlin/codegen/FunctionCodegen$4", "generateBody"));
                }
                if (signature == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/kotlin/codegen/FunctionCodegen$4", "generateBody"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/FunctionCodegen$4", "generateBody"));
                }
                if (parentCodegen == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentCodegen", "org/jetbrains/kotlin/codegen/FunctionCodegen$4", "generateBody"));
                }
                Method delegateToMethod = FunctionCodegen.this.typeMapper.mapSignature(delegatedTo).getAsmMethod();
                Method delegateMethod = FunctionCodegen.this.typeMapper.mapSignature(delegateFunction).getAsmMethod();
                Type[] argTypes = delegateMethod.getArgumentTypes();
                Type[] originalArgTypes = delegateToMethod.getArgumentTypes();
                InstructionAdapter iv = new InstructionAdapter(mv);
                iv.load(0, AsmTypes.OBJECT_TYPE);
                field.put(field.type, iv);
                int reg = 1;
                for (int i = 0; i < argTypes.length; ++i) {
                    StackValue.local(reg, argTypes[i]).put(originalArgTypes[i], iv);
                    reg += argTypes[i].getSize();
                }
                String internalName = FunctionCodegen.this.typeMapper.mapType(toClass).getInternalName();
                if (toClass.getKind() == ClassKind.INTERFACE) {
                    iv.invokeinterface(internalName, delegateToMethod.getName(), delegateToMethod.getDescriptor());
                } else {
                    iv.invokevirtual(internalName, delegateToMethod.getName(), delegateToMethod.getDescriptor());
                }
                StackValue stackValue = AsmUtil.genNotNullAssertions(FunctionCodegen.this.state, StackValue.onStack(delegateToMethod.getReturnType()), RuntimeAssertionInfo.create(delegateFunction.getReturnType(), delegatedTo.getReturnType(), new RuntimeAssertionInfo.DataFlowExtras.OnlyMessage(delegatedTo.getName() + "(...)")));
                stackValue.put(delegateMethod.getReturnType(), iv);
                iv.areturn(delegateMethod.getReturnType());
            }
        });
    }
}

