/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDelegationSpecifier;
import org.jetbrains.kotlin.psi.KtDelegatorByExpressionSpecifier;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

public final class DelegationResolver<T extends CallableMemberDescriptor> {
    @NotNull
    private final KtClassOrObject classOrObject;
    @NotNull
    private final ClassDescriptor ownerDescriptor;
    @NotNull
    private final Collection<? extends CallableDescriptor> existingMembers;
    @NotNull
    private final BindingTrace trace;
    @NotNull
    private final MemberExtractor<T> memberExtractor;
    @NotNull
    private final TypeResolver typeResolver;

    @NotNull
    public static <T extends CallableMemberDescriptor> Collection<T> generateDelegatedMembers(@NotNull KtClassOrObject classOrObject, @NotNull ClassDescriptor ownerDescriptor, @NotNull Collection<? extends CallableDescriptor> existingMembers, @NotNull BindingTrace trace, @NotNull MemberExtractor<T> memberExtractor, @NotNull TypeResolver typeResolver) {
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/resolve/DelegationResolver", "generateDelegatedMembers"));
        }
        if (ownerDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerDescriptor", "org/jetbrains/kotlin/resolve/DelegationResolver", "generateDelegatedMembers"));
        }
        if (existingMembers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existingMembers", "org/jetbrains/kotlin/resolve/DelegationResolver", "generateDelegatedMembers"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DelegationResolver", "generateDelegatedMembers"));
        }
        if (memberExtractor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberExtractor", "org/jetbrains/kotlin/resolve/DelegationResolver", "generateDelegatedMembers"));
        }
        if (typeResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeResolver", "org/jetbrains/kotlin/resolve/DelegationResolver", "generateDelegatedMembers"));
        }
        Collection<T> collection = super.generateDelegatedMembers();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DelegationResolver", "generateDelegatedMembers"));
        }
        return collection;
    }

    private DelegationResolver(@NotNull KtClassOrObject classOrObject, @NotNull ClassDescriptor ownerDescriptor, @NotNull Collection<? extends CallableDescriptor> existingMembers, @NotNull BindingTrace trace, @NotNull MemberExtractor<T> extractor, @NotNull TypeResolver resolver2) {
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/resolve/DelegationResolver", "<init>"));
        }
        if (ownerDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerDescriptor", "org/jetbrains/kotlin/resolve/DelegationResolver", "<init>"));
        }
        if (existingMembers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existingMembers", "org/jetbrains/kotlin/resolve/DelegationResolver", "<init>"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DelegationResolver", "<init>"));
        }
        if (extractor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extractor", "org/jetbrains/kotlin/resolve/DelegationResolver", "<init>"));
        }
        if (resolver2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "org/jetbrains/kotlin/resolve/DelegationResolver", "<init>"));
        }
        this.classOrObject = classOrObject;
        this.ownerDescriptor = ownerDescriptor;
        this.existingMembers = existingMembers;
        this.trace = trace;
        this.memberExtractor = extractor;
        this.typeResolver = resolver2;
    }

    @NotNull
    private Collection<T> generateDelegatedMembers() {
        HashSet delegatedMembers = new HashSet();
        for (KtDelegationSpecifier delegationSpecifier : this.classOrObject.getDelegationSpecifiers()) {
            KotlinType delegatedTraitType;
            KtDelegatorByExpressionSpecifier specifier;
            KtTypeReference typeReference;
            if (!(delegationSpecifier instanceof KtDelegatorByExpressionSpecifier) || (typeReference = (specifier = (KtDelegatorByExpressionSpecifier)delegationSpecifier).getTypeReference()) == null || (delegatedTraitType = this.typeResolver.resolve(typeReference)) == null || delegatedTraitType.isError()) continue;
            Collection delegatesForTrait = this.generateDelegatesForTrait(delegatedMembers, delegatedTraitType);
            delegatedMembers.addAll(delegatesForTrait);
        }
        HashSet hashSet = delegatedMembers;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DelegationResolver", "generateDelegatedMembers"));
        }
        return hashSet;
    }

    @NotNull
    private Collection<T> generateDelegatesForTrait(@NotNull Collection<T> existingDelegates, @NotNull KotlinType delegatedTraitType) {
        if (existingDelegates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existingDelegates", "org/jetbrains/kotlin/resolve/DelegationResolver", "generateDelegatesForTrait"));
        }
        if (delegatedTraitType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegatedTraitType", "org/jetbrains/kotlin/resolve/DelegationResolver", "generateDelegatesForTrait"));
        }
        HashSet<CallableMemberDescriptor> result2 = new HashSet<CallableMemberDescriptor>();
        Collection<T> candidates = this.generateDelegationCandidates(delegatedTraitType);
        for (CallableMemberDescriptor candidate : candidates) {
            if (DelegationResolver.existingMemberOverridesDelegatedMember(candidate, this.existingMembers) || this.checkClashWithOtherDelegatedMember(existingDelegates, candidate)) continue;
            result2.add(candidate);
        }
        HashSet<CallableMemberDescriptor> hashSet = result2;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DelegationResolver", "generateDelegatesForTrait"));
        }
        return hashSet;
    }

    @NotNull
    private Collection<T> generateDelegationCandidates(@NotNull KotlinType delegatedTraitType) {
        if (delegatedTraitType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegatedTraitType", "org/jetbrains/kotlin/resolve/DelegationResolver", "generateDelegationCandidates"));
        }
        Collection<T> descriptorsToDelegate = this.overridableMembersNotFromSuperClassOfTrait(delegatedTraitType);
        ArrayList<CallableMemberDescriptor> result2 = new ArrayList<CallableMemberDescriptor>(descriptorsToDelegate.size());
        for (CallableMemberDescriptor memberDescriptor : descriptorsToDelegate) {
            Modality newModality = memberDescriptor.getModality() == Modality.ABSTRACT ? Modality.OPEN : memberDescriptor.getModality();
            CallableMemberDescriptor copy = memberDescriptor.copy(this.ownerDescriptor, newModality, Visibilities.INHERITED, CallableMemberDescriptor.Kind.DELEGATION, false);
            result2.add(copy);
        }
        ArrayList<CallableMemberDescriptor> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DelegationResolver", "generateDelegationCandidates"));
        }
        return arrayList;
    }

    private static boolean existingMemberOverridesDelegatedMember(@NotNull CallableMemberDescriptor candidate, @NotNull Collection<? extends CallableDescriptor> existingMembers) {
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "org/jetbrains/kotlin/resolve/DelegationResolver", "existingMemberOverridesDelegatedMember"));
        }
        if (existingMembers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existingMembers", "org/jetbrains/kotlin/resolve/DelegationResolver", "existingMemberOverridesDelegatedMember"));
        }
        for (CallableDescriptor callableDescriptor : existingMembers) {
            if (!DelegationResolver.haveSameSignatures(callableDescriptor, candidate)) continue;
            return true;
        }
        return false;
    }

    private boolean checkClashWithOtherDelegatedMember(@NotNull Collection<T> delegatedMembers, @NotNull T candidate) {
        if (delegatedMembers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegatedMembers", "org/jetbrains/kotlin/resolve/DelegationResolver", "checkClashWithOtherDelegatedMember"));
        }
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "org/jetbrains/kotlin/resolve/DelegationResolver", "checkClashWithOtherDelegatedMember"));
        }
        for (CallableMemberDescriptor alreadyDelegatedMember : delegatedMembers) {
            if (!DelegationResolver.haveSameSignatures(alreadyDelegatedMember, candidate)) continue;
            this.trace.report(Errors.MANY_IMPL_MEMBER_NOT_IMPLEMENTED.on(this.classOrObject, this.classOrObject, alreadyDelegatedMember));
            return true;
        }
        return false;
    }

    @NotNull
    private Collection<T> overridableMembersNotFromSuperClassOfTrait(@NotNull KotlinType trait) {
        if (trait == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trait", "org/jetbrains/kotlin/resolve/DelegationResolver", "overridableMembersNotFromSuperClassOfTrait"));
        }
        final Collection<T> membersToSkip = this.getMembersFromClassSupertypeOfTrait(trait);
        Collection<CallableMemberDescriptor> collection = Collections2.filter(this.memberExtractor.getMembersByType(trait), new Predicate<CallableMemberDescriptor>(){

            @Override
            public boolean apply(CallableMemberDescriptor descriptor2) {
                if (!descriptor2.getModality().isOverridable()) {
                    return false;
                }
                for (CallableMemberDescriptor memberToSkip : membersToSkip) {
                    if (!DelegationResolver.haveSameSignatures(memberToSkip, descriptor2)) continue;
                    return false;
                }
                return true;
            }
        });
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DelegationResolver", "overridableMembersNotFromSuperClassOfTrait"));
        }
        return collection;
    }

    private static boolean haveSameSignatures(@NotNull CallableDescriptor memberOne, @NotNull CallableDescriptor memberTwo) {
        if (memberOne == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberOne", "org/jetbrains/kotlin/resolve/DelegationResolver", "haveSameSignatures"));
        }
        if (memberTwo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberTwo", "org/jetbrains/kotlin/resolve/DelegationResolver", "haveSameSignatures"));
        }
        return OverridingUtil.DEFAULT.isOverridableBy(memberOne, memberTwo).getResult() == OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE;
    }

    @NotNull
    private Collection<T> getMembersFromClassSupertypeOfTrait(@NotNull KotlinType traitType) {
        if (traitType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traitType", "org/jetbrains/kotlin/resolve/DelegationResolver", "getMembersFromClassSupertypeOfTrait"));
        }
        KotlinType classSupertype = null;
        for (KotlinType supertype : TypeUtils.getAllSupertypes(traitType)) {
            if (!DelegationResolver.isNotTrait(supertype.getConstructor().getDeclarationDescriptor())) continue;
            classSupertype = supertype;
            break;
        }
        Collection collection = classSupertype != null ? this.memberExtractor.getMembersByType(classSupertype) : Collections.emptyList();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DelegationResolver", "getMembersFromClassSupertypeOfTrait"));
        }
        return collection;
    }

    private static boolean isNotTrait(@Nullable DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof ClassDescriptor) {
            ClassKind kind = ((ClassDescriptor)descriptor2).getKind();
            return kind != ClassKind.INTERFACE;
        }
        return false;
    }

    public static interface TypeResolver {
        @Nullable
        public KotlinType resolve(@NotNull KtTypeReference var1);
    }

    public static interface MemberExtractor<T extends CallableMemberDescriptor> {
        @NotNull
        public Collection<T> getMembersByType(@NotNull KotlinType var1);
    }
}

