/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.CollectionsKt;
import kotlin.Pair;
import kotlin.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.KotlinRetention;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnnotationUseSiteTarget;
import org.jetbrains.kotlin.resolve.AdditionalAnnotationChecker;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.types.TypeUtils;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"1\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001C\u0001\u0006\u0001\u0015\t\u0001\u0002E\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\t\r\fA\u0002A\r\u00021\u0003\t;\u0001B\u0001R\u0007\u0005A\u0011!\n\f\u0005\u0017!\u0019Q\"\u0001M\u00043\u0019AA!\u0004\u0003\n\u0005%\t\u0001$\u0002M\u00053\u0019AY!\u0004\u0003\n\u0005%\t\u0001D\u0002M\u00053\rAi!D\u0001\u0019\u000f%RA!\u0011\u0005\t\u00045!\u0011BA\u0005\u00021\u000bA\"!U\u0002\u0002\u000b\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/FileClassAnnotationsChecker;", "Lorg/jetbrains/kotlin/resolve/AdditionalAnnotationChecker;", "()V", "ALWAYS_APPLICABLE", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/name/FqName;", "checkEntries", "", "entries", "", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "actualTargets", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;"}, moduleName="kotlin-compiler")
public final class FileClassAnnotationsChecker
implements AdditionalAnnotationChecker {
    private static final HashSet<FqName> ALWAYS_APPLICABLE;
    public static final FileClassAnnotationsChecker INSTANCE;
    public static final FileClassAnnotationsChecker INSTANCE$;

    @Override
    public void checkEntries(@NotNull List<? extends KtAnnotationEntry> entries, @NotNull List<? extends KotlinTarget> actualTargets, @NotNull BindingTrace trace) {
        boolean bl;
        ClassDescriptor classDescriptor;
        ArrayList<Pair> fileAnnotationsToCheck;
        block6: {
            Intrinsics.checkParameterIsNotNull(entries, "entries");
            Intrinsics.checkParameterIsNotNull(actualTargets, "actualTargets");
            Intrinsics.checkParameterIsNotNull(trace, "trace");
            fileAnnotationsToCheck = CollectionsKt.arrayListOf(new Pair[0]);
            for (KtAnnotationEntry pair : entries) {
                AnnotationDescriptor descriptor2;
                KtAnnotationUseSiteTarget ktAnnotationUseSiteTarget = pair.getUseSiteTarget();
                if (Intrinsics.areEqual((Object)(ktAnnotationUseSiteTarget != null ? ktAnnotationUseSiteTarget.getAnnotationUseSiteTarget() : null), (Object)AnnotationUseSiteTarget.FILE) ^ true) continue;
                if ((AnnotationDescriptor)trace.get(BindingContext.ANNOTATION, pair) == null) {
                    continue;
                }
                if (TypeUtils.getClassDescriptor(descriptor2.getType()) == null) {
                    continue;
                }
                ClassDescriptor classDescriptor2 = classDescriptor;
                Intrinsics.checkExpressionValueIsNotNull(classDescriptor2, "classDescriptor");
                Set<KotlinTarget> applicableTargets = AnnotationChecker.Companion.applicableTargetSet(classDescriptor2);
                if (applicableTargets == null || !applicableTargets.contains((Object)KotlinTarget.FILE)) continue;
                fileAnnotationsToCheck.add(new Pair<KtAnnotationEntry, ClassDescriptor>(pair, classDescriptor));
            }
            Iterable iterable = fileAnnotationsToCheck;
            for (KtAnnotationEntry element : iterable) {
                Pair it2 = (Pair)((Object)element);
                if (!Intrinsics.areEqual(DescriptorUtilsKt.getClassId((ClassDescriptor)it2.getSecond()).asSingleFqName(), JvmFileClassUtil.INSTANCE.getJVM_MULTIFILE_CLASS())) continue;
                bl = true;
                break block6;
            }
            bl = false;
        }
        if (!bl) {
            return;
        }
        for (Pair pair : fileAnnotationsToCheck) {
            KtAnnotationEntry entry = (KtAnnotationEntry)pair.component1();
            classDescriptor = (ClassDescriptor)pair.component2();
            FqName classFqName = DescriptorUtilsKt.getClassId(classDescriptor).asSingleFqName();
            if (ALWAYS_APPLICABLE.contains(classFqName) || !(Intrinsics.areEqual((Object)DescriptorUtilsKt.getAnnotationRetention(classDescriptor), (Object)KotlinRetention.SOURCE) ^ true)) continue;
            trace.report(ErrorsJvm.ANNOTATION_IS_NOT_APPLICABLE_TO_MULTIFILE_CLASSES.on((KtAnnotationEntry)((PsiElement)entry), classFqName));
        }
    }

    static {
        new FileClassAnnotationsChecker();
    }

    private FileClassAnnotationsChecker() {
        INSTANCE = this;
        INSTANCE$ = this;
        ALWAYS_APPLICABLE = SetsKt.hashSetOf(JvmFileClassUtil.INSTANCE.getJVM_NAME(), JvmFileClassUtil.INSTANCE.getJVM_MULTIFILE_CLASS());
    }
}

