/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.js;

import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.serialization.AnnotationSerializer;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.SerializerExtension;
import org.jetbrains.kotlin.serialization.StringTableImpl;
import org.jetbrains.kotlin.serialization.js.JsProtoBuf;
import org.jetbrains.kotlin.types.KotlinType;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"_\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005a\u0011\u0001\u0004\u0001\u001a\u0003a\u0005\u0011UA)\u0004\u0003!\tQ\u0005\u0002\u0003\f\u0011\u000fi\u0011\u0001G\u0002&\u0019\u0011Y\u0001\u0002B\u0007\u00021\u0013I2\u0001C\u0003\u000e\u0003a-\u0011d\u0001\u0005\u0007\u001b\u0005Aj!\n\u0007\u0005\u0017!9Q\"\u0001M\u00053\rAQ!D\u0001\u0019\u0010e\u0019\u0001BB\u0007\u00021!)C\u0002B\u0006\t\u00125\t\u0001\u0014B\r\u0004\u0011\u0015i\u0011\u0001G\u0005\u001a\u0007!1Q\"\u0001M\nK1!1\u0002\u0003\u0006\u000e\u0003a%\u0011d\u0001\u0005\u0006\u001b\u0005A*\"G\u0002\t\r5\t\u0001dC\u0013\r\t-A9\"D\u0001\u0019\ne\u0019\u0001\u0002D\u0007\u000213I2\u0001\u0003\u0004\u000e\u0003aiQ\u0005\u0004\u0003\f\u00117i\u0011\u0001'\u0003\u001a\u0007!)Q\"\u0001\r\u000f3\rAa!D\u0001\u0019\u001e%:A!\u0011\u0005\t\u00045\t\u0001DA)\u0004\u0003\u0015\u0001\u0011f\u0002\u0003B\u0011!\u0015Q\"\u0001\r\u0004#\u000e\tQ\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/serialization/js/KotlinJavascriptSerializerExtension;", "Lorg/jetbrains/kotlin/serialization/SerializerExtension;", "()V", "annotationSerializer", "Lorg/jetbrains/kotlin/serialization/AnnotationSerializer;", "stringTable", "Lorg/jetbrains/kotlin/serialization/StringTableImpl;", "getStringTable", "serializeClass", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "proto", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Class$Builder;", "serializeConstructor", "Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Constructor$Builder;", "serializeFunction", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Function$Builder;", "serializeProperty", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Property$Builder;", "serializeType", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Type$Builder;", "serializeValueParameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$ValueParameter$Builder;"}, moduleName="kotlin-compiler")
public final class KotlinJavascriptSerializerExtension
extends SerializerExtension {
    private final StringTableImpl stringTable = new StringTableImpl();
    private final AnnotationSerializer annotationSerializer = new AnnotationSerializer(this.stringTable);

    @Override
    @NotNull
    public StringTableImpl getStringTable() {
        return this.stringTable;
    }

    @Override
    public void serializeClass(@NotNull ClassDescriptor descriptor2, @NotNull ProtoBuf.Class.Builder proto) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        for (AnnotationDescriptor annotation2 : descriptor2.getAnnotations()) {
            proto.addExtension(JsProtoBuf.classAnnotation, this.annotationSerializer.serializeAnnotation(annotation2));
        }
    }

    @Override
    public void serializeConstructor(@NotNull ConstructorDescriptor descriptor2, @NotNull ProtoBuf.Constructor.Builder proto) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        for (AnnotationDescriptor annotation2 : descriptor2.getAnnotations()) {
            proto.addExtension(JsProtoBuf.constructorAnnotation, this.annotationSerializer.serializeAnnotation(annotation2));
        }
    }

    @Override
    public void serializeFunction(@NotNull FunctionDescriptor descriptor2, @NotNull ProtoBuf.Function.Builder proto) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        for (AnnotationDescriptor annotation2 : descriptor2.getAnnotations()) {
            proto.addExtension(JsProtoBuf.functionAnnotation, this.annotationSerializer.serializeAnnotation(annotation2));
        }
    }

    @Override
    public void serializeProperty(@NotNull PropertyDescriptor descriptor2, @NotNull ProtoBuf.Property.Builder proto) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        for (AnnotationDescriptor annotation2 : descriptor2.getAnnotations()) {
            proto.addExtension(JsProtoBuf.propertyAnnotation, this.annotationSerializer.serializeAnnotation(annotation2));
        }
        ConstantValue<?> constantValue = descriptor2.getCompileTimeInitializer();
        if (constantValue == null) {
            return;
        }
        ConstantValue<?> constantInitializer = constantValue;
        if (!(constantInitializer instanceof NullValue)) {
            ConstantValue<?> constantValue2 = constantInitializer;
            Intrinsics.checkExpressionValueIsNotNull(constantValue2, "constantInitializer");
            proto.setExtension(JsProtoBuf.compileTimeValue, this.annotationSerializer.valueProto(constantValue2).build());
        }
    }

    @Override
    public void serializeValueParameter(@NotNull ValueParameterDescriptor descriptor2, @NotNull ProtoBuf.ValueParameter.Builder proto) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        for (AnnotationDescriptor annotation2 : descriptor2.getAnnotations()) {
            proto.addExtension(JsProtoBuf.parameterAnnotation, this.annotationSerializer.serializeAnnotation(annotation2));
        }
    }

    @Override
    public void serializeType(@NotNull KotlinType type2, @NotNull ProtoBuf.Type.Builder proto) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        for (AnnotationDescriptor annotation2 : type2.getAnnotations()) {
            proto.addExtension(JsProtoBuf.typeAnnotation, this.annotationSerializer.serializeAnnotation(annotation2));
        }
    }
}

