/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.ArraysKt;
import kotlin.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.IntSpreadBuilder;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public final class BinaryVersion {
    private static final int UNKNOWN = -1;
    private final int major;
    private final int minor;
    private final int patch;
    @NotNull
    private final List<? extends Integer> rest;
    public static final Companion Companion = kotlin.reflect.jvm.internal.impl.serialization.deserialization.BinaryVersion$Companion.INSTANCE;

    static {
        UNKNOWN = -1;
    }

    @NotNull
    public final int[] toArray() {
        IntSpreadBuilder intSpreadBuilder = new IntSpreadBuilder(4);
        intSpreadBuilder.add(this.major);
        intSpreadBuilder.add(this.minor);
        intSpreadBuilder.add(this.patch);
        intSpreadBuilder.addSpread(CollectionsKt.toIntArray((Collection<? extends Integer>)this.rest));
        return intSpreadBuilder.toArray();
    }

    @NotNull
    public String toString() {
        int item;
        int it2;
        int[] $receiver = this.toArray();
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < $receiver.length && (it2 = (item = $receiver[i])) != BinaryVersion.Companion.getUNKNOWN(); ++i) {
            list.add(item);
        }
        List versions = list;
        return versions.isEmpty() ? "unknown" : CollectionsKt.joinToString$default((Iterable)versions, (CharSequence)".", null, null, 0, null, null, 62);
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int getPatch() {
        return this.patch;
    }

    @NotNull
    public final List<Integer> getRest() {
        return this.rest;
    }

    private BinaryVersion(int major, int minor, int patch, List<? extends Integer> rest) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.rest = rest;
    }

    /* synthetic */ BinaryVersion(int n, int n2, int n3, List list, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 8) != 0) {
            list = CollectionsKt.listOf();
        }
        this(n, n2, n3, list);
    }

    public /* synthetic */ BinaryVersion(int major, int minor, int patch, @NotNull List rest, DefaultConstructorMarker $constructor_marker) {
        this(major, minor, patch, rest);
    }

    public final int component1() {
        return this.major;
    }

    public final int component2() {
        return this.minor;
    }

    public final int component3() {
        return this.patch;
    }

    @NotNull
    public final List<Integer> component4() {
        return this.rest;
    }

    @NotNull
    public final BinaryVersion copy(int major, int minor, int patch, @NotNull List<? extends Integer> rest) {
        Intrinsics.checkParameterIsNotNull(rest, "rest");
        return new BinaryVersion(major, minor, patch, rest);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ BinaryVersion copy$default(BinaryVersion binaryVersion, int n, int n2, int n3, List list, int n4) {
        if ((n4 & 1) != 0) {
            n = binaryVersion.major;
        }
        if ((n4 & 2) != 0) {
            n2 = binaryVersion.minor;
        }
        if ((n4 & 4) != 0) {
            n3 = binaryVersion.patch;
        }
        if ((n4 & 8) != 0) {
            list = binaryVersion.rest;
        }
        return binaryVersion.copy(n, n2, n3, list);
    }

    public int hashCode() {
        List<? extends Integer> list = this.rest;
        return ((this.major * 31 + this.minor) * 31 + this.patch) * 31 + (list != null ? ((Object)list).hashCode() : 0);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof BinaryVersion)) break block3;
                BinaryVersion binaryVersion = (BinaryVersion)object;
                if (!(this.major == binaryVersion.major) || !(this.minor == binaryVersion.minor) || !(this.patch == binaryVersion.patch) || !Intrinsics.areEqual(this.rest, binaryVersion.rest)) break block3;
            }
            return true;
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final BinaryVersion create(@NotNull int[] version) {
        Intrinsics.checkParameterIsNotNull(version, "version");
        return Companion.create(version);
    }

    @JvmStatic
    @NotNull
    public static final BinaryVersion create(int major, int minor, int patch) {
        return Companion.create(major, minor, patch);
    }

    public static final class Companion {
        public static final Companion INSTANCE;

        private final int getUNKNOWN() {
            return UNKNOWN;
        }

        @JvmStatic
        @NotNull
        public final BinaryVersion create(@NotNull int[] version) {
            List list;
            int[] $receiver;
            BinaryVersion binaryVersion;
            Intrinsics.checkParameterIsNotNull(version, "version");
            Integer n = ArraysKt.getOrNull(version, 0);
            Integer n2 = ArraysKt.getOrNull(version, 1);
            Integer n3 = ArraysKt.getOrNull(version, 2);
            int[] nArray = version;
            int n4 = n3 != null ? ((Number)n3).intValue() : this.getUNKNOWN();
            int n5 = n2 != null ? ((Number)n2).intValue() : this.getUNKNOWN();
            int n6 = n != null ? ((Number)n).intValue() : this.getUNKNOWN();
            BinaryVersion binaryVersion2 = binaryVersion;
            BinaryVersion binaryVersion3 = binaryVersion;
            int n7 = $receiver.length;
            BinaryVersion binaryVersion4 = binaryVersion3;
            BinaryVersion binaryVersion5 = binaryVersion2;
            int n8 = n6;
            int n9 = n5;
            int n10 = n4;
            if (n7 > 3) {
                $receiver = version;
                int n11 = 3;
                List<Integer> list2 = ArraysKt.asList(version);
                n4 = n10;
                n5 = n9;
                n6 = n8;
                binaryVersion2 = binaryVersion5;
                binaryVersion3 = binaryVersion4;
                int n12 = $receiver.length;
                binaryVersion4 = binaryVersion3;
                binaryVersion5 = binaryVersion2;
                n8 = n6;
                n9 = n5;
                n10 = n4;
                list = CollectionsKt.toList((Iterable)list2.subList(n11, n12));
            } else {
                list = CollectionsKt.listOf();
            }
            binaryVersion5(n8, n9, n10, list, null);
            return binaryVersion4;
        }

        @JvmStatic
        @NotNull
        public final BinaryVersion create(int major, int minor, int patch) {
            return new BinaryVersion(major, minor, patch, null, 8, null);
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }
}

