/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.common;

import java.io.File;
import java.rmi.ConnectException;
import java.rmi.Remote;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.Pair;
import kotlin.PreconditionsKt;
import kotlin.Sequence;
import kotlin.SequencesKt;
import kotlin.StringsKt;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import kotlin.text.MatchGroup;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.daemon.common.ClientUtilsKt;
import org.jetbrains.kotlin.daemon.common.CompileService;
import org.jetbrains.kotlin.daemon.common.CompilerId;
import org.jetbrains.kotlin.daemon.common.DaemonParamsKt;
import org.jetbrains.kotlin.daemon.common.DaemonReportCategory;
import org.jetbrains.kotlin.daemon.common.LoopbackNetworkInterface;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"A\u0015\u0001Q!\u0001\u0005\u0005\u000b\u0005!!!B\u0001\r\u0003\u0015\t\u0001bB\u0003\u0002\t\r)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001C\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0011\u0017iy\u0002#\u0002\u000e\u0011%\u0011\u0011\"\u0001M\u0004\u0013\rI!\u0001$\u0001\u0019\u0002a\u0019\u0011d\u0001\u0005\u0005\u001b\u0005A:\u0001V\u0002\u0003\u001bWAI!D\u0001\u0019\be\u0019\u0001\"B\u0007\u00021\u000fI2\u0001\u0003\u0003\u000e\u0003a\u001d\u0011d\u0001E\u0006\u001b\u0005A:!\u0007\u0003\u0005\u0003!1Q\"\u0001M\u0004)\u000e\u0011Q\u0002\u0007\u0003B!!5QB\u0001G\u00011\u001dI2\u0001c\u0003\u000e\u0003a\u0005\u0011\u0004\u0004E\b\u001b)I!!C\u0001\u0019\u0012%\u0011\u0011\"\u0001M\u0004\u0013\tI\u0011\u0001G\u0005\u0019\u0011Q\u001b!!d\u0016\t\u00145!\u0011BA\u0005\u00021\u001dA\"\"G\u0002\t\u00165\t\u0001dC\r\u0004\u0011/i\u0011\u0001\u0007\u0007\u001a\u001b\u0011\t\u0001\u0012D\u0007\u000b\u0013\tI\u0011\u0001G\u0006\n\u0005%\t\u0001\u0014A\u0005\u0003\u0013\u0005AR\u0002\u0007\u0005\u001a\u001b\u0011\t\u0001rB\u0007\u000b\u0013\tI\u0011\u0001'\u0005\n\u0005%\t\u0001tA\u0005\u0003\u0013\u0005A\u0012\u0002\u0007\u0005U\u0007\t\tB\u0002\u0002!I\u0003!\u0001Q\"\u0001M\u0001#\u000e!Q\u0001A\u0007\u0003\t\u0005A\u0019\u0001V\u0002\u0003"}, strings={"MAX_PORT_NUMBER", "", "getMAX_PORT_NUMBER", "()I", "ClientUtilsKt", "makePortFromRunFilenameExtractor", "Lkotlin/Function1;", "", "digest", "makeRunFilenameString", "timestamp", "port", "escapeSequence", "tryConnectToDaemon", "Lorg/jetbrains/kotlin/daemon/common/CompileService;", "report", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/daemon/common/DaemonReportCategory;", "", "walkDaemons", "Lkotlin/Sequence;", "registryDir", "Ljava/io/File;", "compilerId", "Lorg/jetbrains/kotlin/daemon/common/CompilerId;", "filter", ""}, moduleName="kotlin-compiler")
public final class ClientUtilsKt {
    private static final int MAX_PORT_NUMBER = 65535;

    public static final int getMAX_PORT_NUMBER() {
        return MAX_PORT_NUMBER;
    }

    @NotNull
    public static final String makeRunFilenameString(@NotNull String timestamp, @NotNull String digest, @NotNull String port, @NotNull String escapeSequence) {
        Intrinsics.checkParameterIsNotNull(timestamp, "timestamp");
        Intrinsics.checkParameterIsNotNull(digest, "digest");
        Intrinsics.checkParameterIsNotNull(port, "port");
        Intrinsics.checkParameterIsNotNull(escapeSequence, "escapeSequence");
        return DaemonParamsKt.getCOMPILE_DAEMON_DEFAULT_FILES_PREFIX() + escapeSequence + "." + timestamp + escapeSequence + "." + digest + escapeSequence + "." + port + escapeSequence + ".run";
    }

    @NotNull
    public static /* bridge */ /* synthetic */ String makeRunFilenameString$default(String string, String string2, String string3, String string4, int n) {
        if ((n & 8) != 0) {
            string4 = "";
        }
        return ClientUtilsKt.makeRunFilenameString(string, string2, string3, string4);
    }

    @NotNull
    public static final Function1<String, Integer> makePortFromRunFilenameExtractor(@NotNull String digest) {
        Intrinsics.checkParameterIsNotNull(digest, "digest");
        Regex regex = StringsKt.toRegex(ClientUtilsKt.makeRunFilenameString("[0-9TZ:\\.\\+-]+", digest, "(\\d+)", "\\"));
        return new Function1<String, Integer>(regex){
            final /* synthetic */ Regex $regex;

            @Nullable
            public final Integer invoke(@NotNull String it2) {
                Intrinsics.checkParameterIsNotNull(it2, "it");
                Object object = Regex.find$default(this.$regex, it2, 0, 2);
                return object != null && (object = object.getGroups()) != null && (object = object.get(1)) != null && (object = ((MatchGroup)object).getValue()) != null ? Integer.valueOf(StringsKt.toInt((String)object)) : null;
            }
            {
                this.$regex = regex;
                super(1);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Sequence<CompileService> walkDaemons(@NotNull File registryDir, @NotNull CompilerId compilerId, @NotNull Function2<? super File, ? super Integer, ? extends Boolean> filter, @NotNull Function2<? super DaemonReportCategory, ? super String, ? extends Unit> report2) {
        void destination;
        void $receiver;
        void $receiver2;
        Intrinsics.checkParameterIsNotNull(registryDir, "registryDir");
        Intrinsics.checkParameterIsNotNull(compilerId, "compilerId");
        Intrinsics.checkParameterIsNotNull(filter, "filter");
        Intrinsics.checkParameterIsNotNull(report2, "report");
        Iterable iterable = compilerId.getCompilerClasspath();
        void var6_5 = $receiver2;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver2, 10));
        for (Object item : $receiver) {
            void it2;
            String string = (String)item;
            void var14_10 = destination;
            String string2 = new File((String)it2).getAbsolutePath();
            var14_10.add(string2);
        }
        String classPathDigest = DaemonParamsKt.toHexString(DaemonParamsKt.distinctStringsDigest((List)destination));
        Function1<String, Integer> portExtractor = ClientUtilsKt.makePortFromRunFilenameExtractor(classPathDigest);
        return SequencesKt.mapNotNull(SequencesKt.filter(SequencesKt.map(FilesKt.walk$default(registryDir, null, 1), (Function1)new Function1<File, Pair<? extends File, ? extends Integer>>(portExtractor){
            final /* synthetic */ Function1 $portExtractor;

            @NotNull
            public final Pair<File, Integer> invoke(@NotNull File it2) {
                Intrinsics.checkParameterIsNotNull(it2, "it");
                String string = it2.getName();
                Intrinsics.checkExpressionValueIsNotNull(string, "it.name");
                return new Pair<File, Integer>(it2, (Integer)this.$portExtractor.invoke(string));
            }
            {
                this.$portExtractor = function1;
                super(1);
            }
        }), (Function1)new Function1<Pair<? extends File, ? extends Integer>, Boolean>(filter){
            final /* synthetic */ Function2 $filter;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean invoke(@NotNull Pair<? extends File, ? extends Integer> it2) {
                Intrinsics.checkParameterIsNotNull(it2, "it");
                if (it2.getSecond() == null) return false;
                File file = it2.getFirst();
                Integer n = it2.getSecond();
                if (n == null) {
                    Intrinsics.throwNpe();
                }
                if ((Boolean)this.$filter.invoke(file, n) == false) return false;
                return true;
            }
            {
                this.$filter = function2;
                super(1);
            }
        }), (Function1)new Function1<Pair<? extends File, ? extends Integer>, CompileService>(report2){
            final /* synthetic */ Function2 $report;

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final CompileService invoke(@NotNull Pair<? extends File, ? extends Integer> it) {
                block13: {
                    Intrinsics.checkParameterIsNotNull(it, "it");
                    v0 = it.getSecond();
                    if (v0 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (((Number)v0).intValue() <= 0) ** GOTO lbl-1000
                    v1 = it.getSecond();
                    if (v1 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (((Number)v1).intValue() < ClientUtilsKt.getMAX_PORT_NUMBER()) {
                        v2 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v2 = false;
                    }
                    PreconditionsKt.assert(v2);
                    this.$report.invoke(DaemonReportCategory.DEBUG, "found daemon on port " + it.getSecond() + ", trying to connect");
                    v3 = it.getSecond();
                    if (v3 == null) {
                        Intrinsics.throwNpe();
                    }
                    var3_2 = ((Number)v3).intValue();
                    var4_3 = this.$report;
                    try {
                        v4 = LocateRegistry.getRegistry(LoopbackNetworkInterface.INSTANCE.getLoopbackInetAddressName(), (int)port);
                        v5 = daemon = v4 != null ? v4.lookup(DaemonParamsKt.getCOMPILER_SERVICE_RMI_NAME()) : null;
                        if (daemon != null) {
                            v6 = daemon;
                            if (!(v6 instanceof CompileService)) {
                                v6 = null;
                            }
                            if ((v7 = (CompileService)v6) == null) {
                                throw (Throwable)new ClassCastException("Unable to cast compiler service, actual class received: " + daemon.getClass());
                            }
                            break block13;
                        }
                        report.invoke(DaemonReportCategory.EXCEPTION, "daemon not found");
                    }
                    catch (ConnectException e) {
                        v8 = new StringBuilder().append("cannot connect to registry: ");
                        v9 = e.getCause();
                        if (v9 == null || (v9 = v9.getMessage()) == null) {
                            v9 = v10 = e.getMessage();
                        }
                        if (v9 == null) {
                            v10 = "unknown exception";
                        }
                        report.invoke(DaemonReportCategory.EXCEPTION, v8.append(v10).toString());
                    }
                    v7 = daemon = (CompileService)null;
                }
                if (daemon == null && !it.getFirst().delete()) {
                    this.$report.invoke(DaemonReportCategory.INFO, "WARNING: unable to delete seemingly orphaned file '" + it.getFirst().getAbsolutePath() + "', cleanup recommended");
                }
                return var2_6;
            }
            {
                this.$report = function2;
                super(1);
            }
        });
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Sequence walkDaemons$default(File file, CompilerId compilerId, Function2 function2, Function2 function22, int n) {
        if ((n & 4) != 0) {
            function2 = walkDaemons.1.INSTANCE;
        }
        if ((n & 8) != 0) {
            function22 = walkDaemons.2.INSTANCE;
        }
        return ClientUtilsKt.walkDaemons(file, compilerId, function2, function22);
    }

    private static final CompileService tryConnectToDaemon(int port, Function2<? super DaemonReportCategory, ? super String, ? extends Unit> report2) {
        try {
            Remote daemon;
            Registry registry = LocateRegistry.getRegistry(LoopbackNetworkInterface.INSTANCE.getLoopbackInetAddressName(), port);
            Remote remote = daemon = registry != null ? registry.lookup(DaemonParamsKt.getCOMPILER_SERVICE_RMI_NAME()) : null;
            if (daemon != null) {
                Remote remote2 = daemon;
                if (!(remote2 instanceof CompileService)) {
                    remote2 = null;
                }
                CompileService compileService = (CompileService)remote2;
                if (compileService == null) {
                    throw (Throwable)new ClassCastException("Unable to cast compiler service, actual class received: " + daemon.getClass());
                }
                return compileService;
            }
            report2.invoke(DaemonReportCategory.EXCEPTION, "daemon not found");
        }
        catch (ConnectException e) {
            Object object;
            StringBuilder stringBuilder = new StringBuilder().append("cannot connect to registry: ");
            Object object2 = e.getCause();
            if (object2 == null || (object2 = ((Throwable)object2).getMessage()) == null) {
                object2 = object = e.getMessage();
            }
            if (object2 == null) {
                object = "unknown exception";
            }
            report2.invoke(DaemonReportCategory.EXCEPTION, stringBuilder.append(object).toString());
        }
        return null;
    }

    static {
        MAX_PORT_NUMBER = 65535;
    }

    @Nullable
    public static final /* synthetic */ CompileService access$tryConnectToDaemon(int port, @NotNull Function2 report2) {
        return ClientUtilsKt.tryConnectToDaemon(port, report2);
    }
}

