/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.inline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.CollectionsKt;
import kotlin.SetsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.inline.InlineUtilKt$WhenMappings;
import org.jetbrains.kotlin.load.kotlin.FileBasedKotlinClass;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.serialization.ClassData;
import org.jetbrains.kotlin.serialization.Flags;
import org.jetbrains.kotlin.serialization.PackageData;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;
import org.jetbrains.kotlin.serialization.deserialization.TypeTable;
import org.jetbrains.kotlin.serialization.jvm.BitEncoding;
import org.jetbrains.kotlin.serialization.jvm.JvmProtoBufUtil;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"/\u0015\u0001Q!\u0001\u0005\u0012\u000b\u0005Aq!\u0002\u0001\u0006\u0003!IQ!\u0001\u0003\u0002\u000b\u0005A\u0001#B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"AG\f\u0011\u0001iA!\u0003\u0002\n\u0003a\t\u0001\u0014A\r\u0004\u0011\u0007i\u0011\u0001\u0007\u0002U\u0007\u000biy\u0003B\u0001\t\u00015!\u0011BA\u0005\u00021\u0005A\n!\u0007\u0004\t\u00075!\u0011BA\u0005\u00021\u0011A:!G\u0002\t\n5\t\u0001$B\r\u0004\u0011\u0017i\u0011\u0001\u0007\u0004U\u0007\u000bi\u0019\u0002B\u0001\t\u000e5\t\u0001dB\r\u0004\u0011\u0007i\u0011\u0001\u0007\u0002U\u0007\u000b\u0001"}, strings={"inlineFunctionsJvmNames", "", "", "bytes", "", "InlineUtilKt", "functions", "", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Function;", "nameResolver", "Lorg/jetbrains/kotlin/serialization/deserialization/NameResolver;", "protoTypeTable", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$TypeTable;", "readKotlinHeader", "Lorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader;"}, moduleName="kotlin-compiler")
public final class InlineUtilKt {
    @NotNull
    public static final Set<String> inlineFunctionsJvmNames(@NotNull byte[] bytes) {
        Set<String> set;
        Intrinsics.checkParameterIsNotNull(bytes, "bytes");
        KotlinClassHeader header = InlineUtilKt.readKotlinHeader(bytes);
        String[] annotationData = header.getAnnotationData();
        String[] strings = header.getStrings();
        if (annotationData == null || strings == null) {
            return SetsKt.emptySet();
        }
        switch (InlineUtilKt$WhenMappings.$EnumSwitchMapping$0[header.getKind().ordinal()]) {
            case 1: {
                byte[] byArray = BitEncoding.decodeBytes(annotationData);
                Intrinsics.checkExpressionValueIsNotNull(byArray, "BitEncoding.decodeBytes(annotationData)");
                ClassData classData = JvmProtoBufUtil.readClassDataFrom(byArray, strings);
                List<ProtoBuf.Function> list = classData.getClassProto().getFunctionList();
                Intrinsics.checkExpressionValueIsNotNull(list, "classData.classProto.functionList");
                NameResolver nameResolver = classData.getNameResolver();
                ProtoBuf.TypeTable typeTable = classData.getClassProto().getTypeTable();
                Intrinsics.checkExpressionValueIsNotNull(typeTable, "classData.classProto.typeTable");
                set = InlineUtilKt.inlineFunctionsJvmNames(list, nameResolver, typeTable);
                break;
            }
            case 2: 
            case 3: {
                byte[] byArray = BitEncoding.decodeBytes(annotationData);
                Intrinsics.checkExpressionValueIsNotNull(byArray, "BitEncoding.decodeBytes(annotationData)");
                PackageData packageData = JvmProtoBufUtil.readPackageDataFrom(byArray, strings);
                List<ProtoBuf.Function> list = packageData.getPackageProto().getFunctionList();
                Intrinsics.checkExpressionValueIsNotNull(list, "packageData.packageProto.functionList");
                NameResolver nameResolver = packageData.getNameResolver();
                ProtoBuf.TypeTable typeTable = packageData.getPackageProto().getTypeTable();
                Intrinsics.checkExpressionValueIsNotNull(typeTable, "packageData.packageProto.typeTable");
                set = InlineUtilKt.inlineFunctionsJvmNames(list, nameResolver, typeTable);
                break;
            }
            default: {
                set = SetsKt.emptySet();
            }
        }
        return set;
    }

    /*
     * WARNING - void declaration
     */
    private static final Set<String> inlineFunctionsJvmNames(List<? extends ProtoBuf.Function> functions2, NameResolver nameResolver, ProtoBuf.TypeTable protoTypeTable) {
        void destination;
        void $receiver;
        void $receiver2;
        Iterable destination2;
        Object element2;
        Iterable $receiver3;
        void $receiver4;
        TypeTable typeTable = new TypeTable(protoTypeTable);
        Iterable iterable = functions2;
        void var6_5 = $receiver4;
        Collection collection = new ArrayList();
        for (Object element2 : $receiver3) {
            ProtoBuf.Function it2 = (ProtoBuf.Function)element2;
            if (!Flags.IS_INLINE.get(it2.getFlags()).booleanValue()) continue;
            destination2.add(element2);
        }
        List inlineFunctions = (List)destination2;
        $receiver3 = inlineFunctions;
        destination2 = $receiver3;
        Collection collection2 = new ArrayList();
        element2 = $receiver2;
        for (Object element3 : $receiver) {
            Boolean bl;
            Object element4 = element3;
            ProtoBuf.Function it3 = (ProtoBuf.Function)element4;
            if (JvmProtoBufUtil.INSTANCE.getJvmMethodSignature(it3, nameResolver, typeTable) != null) {
                void $receiver5;
                void it4 = $receiver5;
                bl = destination.add(it4);
                continue;
            }
            bl = null;
        }
        List jvmNames = (List)destination;
        return CollectionsKt.toSet(jvmNames);
    }

    /*
     * WARNING - void declaration
     */
    private static final KotlinClassHeader readKotlinHeader(byte[] bytes) {
        void header;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        FileBasedKotlinClass.create(bytes, new Function3((Ref.ObjectRef)header){
            final /* synthetic */ Ref.ObjectRef $header;

            @Nullable
            public final Void invoke(ClassId className, KotlinClassHeader classHeader, FileBasedKotlinClass.InnerClassesInfo innerClasses) {
                this.$header.element = classHeader;
                return null;
            }
            {
                this.$header = objectRef;
                super(3);
            }
        });
        if ((KotlinClassHeader)header.element == null) {
            throw (Throwable)((Object)new AssertionError((Object)"Could not read kotlin header from byte array"));
        }
        KotlinClassHeader kotlinClassHeader = (KotlinClassHeader)header.element;
        if (kotlinClassHeader == null) {
            Intrinsics.throwNpe();
        }
        return kotlinClassHeader;
    }
}

