/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointAndAreaListener;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeyedExtensionCollector<T, KeyT> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.KeyedExtensionCollector");
    private final Map<String, List<T>> myExplicitExtensions;
    private final ConcurrentMap<String, List<T>> myCache;
    @NonNls
    private final String lock;
    private ExtensionPoint<KeyedLazyInstance<T>> myPoint;
    private final String myEpName;
    private ExtensionPointAndAreaListener<KeyedLazyInstance<T>> myListener;
    private final List<ExtensionPointListener<T>> myListeners;

    public KeyedExtensionCollector(@NonNls @NotNull String epName) {
        if (epName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "epName", "com/intellij/openapi/util/KeyedExtensionCollector", "<init>"));
        }
        this.myExplicitExtensions = new THashMap<String, List<T>>();
        this.myCache = ContainerUtil.newConcurrentMap();
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myEpName = epName;
        this.lock = "lock for KeyedExtensionCollector " + epName;
        this.resetAreaListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetAreaListener() {
        String string = this.lock;
        synchronized (string) {
            this.myCache.clear();
            if (this.myPoint != null) {
                this.myPoint.removeExtensionPointListener(this.myListener);
                this.myPoint = null;
                this.myListener = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExplicitExtension(@NotNull KeyT key, @NotNull T t) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/util/KeyedExtensionCollector", "addExplicitExtension"));
        }
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/openapi/util/KeyedExtensionCollector", "addExplicitExtension"));
        }
        String string = this.lock;
        synchronized (string) {
            String skey = this.keyToString(key);
            List<T> list = this.myExplicitExtensions.get(skey);
            if (list == null) {
                list = new ArrayList<T>();
                this.myExplicitExtensions.put(skey, list);
            }
            list.add(t);
            this.myCache.remove(skey);
            for (ExtensionPointListener<T> listener : this.myListeners) {
                listener.extensionAdded(t, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExplicitExtension(@NotNull KeyT key, @NotNull T t) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/util/KeyedExtensionCollector", "removeExplicitExtension"));
        }
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/openapi/util/KeyedExtensionCollector", "removeExplicitExtension"));
        }
        String string = this.lock;
        synchronized (string) {
            String skey = this.keyToString(key);
            List<T> list = this.myExplicitExtensions.get(skey);
            if (list != null) {
                list.remove(t);
                this.myCache.remove(skey);
            }
            for (ExtensionPointListener<T> listener : this.myListeners) {
                listener.extensionRemoved(t, null);
            }
        }
    }

    @NotNull
    protected String keyToString(@NotNull KeyT key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/util/KeyedExtensionCollector", "keyToString"));
        }
        String string = key.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/KeyedExtensionCollector", "keyToString"));
        }
        return string;
    }

    @NotNull
    public List<T> forKey(@NotNull KeyT key) {
        List<T> cached;
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/util/KeyedExtensionCollector", "forKey"));
        }
        String stringKey = this.keyToString(key);
        boolean rebuild = this.myPoint == null && Extensions.getRootArea().hasExtensionPoint(this.myEpName);
        List<T> list = cached = rebuild ? null : (List<T>)this.myCache.get(stringKey);
        if (cached != null) {
            List<T> list2 = cached;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/KeyedExtensionCollector", "forKey"));
            }
            return list2;
        }
        cached = this.buildExtensions(stringKey, key);
        List<T> list3 = cached = ConcurrencyUtil.cacheOrGet(this.myCache, stringKey, cached);
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/KeyedExtensionCollector", "forKey"));
        }
        return list3;
    }

    public T findSingle(@NotNull KeyT key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/util/KeyedExtensionCollector", "findSingle"));
        }
        List<T> list = this.forKey(key);
        return list.isEmpty() ? null : (T)list.get(0);
    }

    @NotNull
    protected List<T> buildExtensions(@NotNull String stringKey, @NotNull KeyT key) {
        if (stringKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringKey", "com/intellij/openapi/util/KeyedExtensionCollector", "buildExtensions"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/util/KeyedExtensionCollector", "buildExtensions"));
        }
        List<T> list = this.buildExtensions(Collections.singleton(stringKey));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/KeyedExtensionCollector", "buildExtensions"));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    protected final List<T> buildExtensions(@NotNull Set<String> keys) {
        void var3_6;
        if (keys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keys", "com/intellij/openapi/util/KeyedExtensionCollector", "buildExtensions"));
        }
        String string = this.lock;
        // MONITORENTER : string
        Object var3_3 = null;
        for (Map.Entry<String, List<T>> entry : this.myExplicitExtensions.entrySet()) {
            void var3_4;
            String key = entry.getKey();
            if (!keys.contains(key)) continue;
            List<T> list = entry.getValue();
            if (var3_4 == null) {
                ArrayList<T> arrayList = new ArrayList<T>(list);
                continue;
            }
            var3_4.addAll(list);
        }
        ExtensionPoint<KeyedLazyInstance<T>> point = this.getPoint();
        if (point != null) {
            KeyedLazyInstance<T>[] beans;
            for (KeyedLazyInstance<T> bean : beans = point.getExtensions()) {
                T instance;
                if (!keys.contains(bean.getKey())) continue;
                try {
                    instance = bean.getInstance();
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.error(e);
                    continue;
                }
                catch (LinkageError e) {
                    LOG.error(e);
                    continue;
                }
                if (var3_6 == null) {
                    SmartList smartList = new SmartList();
                }
                var3_6.add(instance);
            }
        }
        Object object = var3_6 == null ? Collections.emptyList() : var3_6;
        // MONITOREXIT : string
        if (object != null) return object;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/KeyedExtensionCollector", "buildExtensions"));
    }

    @Nullable
    private ExtensionPoint<KeyedLazyInstance<T>> getPoint() {
        ExtensionPoint<KeyedLazyInstance<T>> point = this.myPoint;
        if (point == null && Extensions.getRootArea().hasExtensionPoint(this.myEpName)) {
            ExtensionPointName typesafe = ExtensionPointName.create(this.myEpName);
            point = Extensions.getRootArea().getExtensionPoint(typesafe);
            this.myPoint = point;
            this.myListener = new ExtensionPointAndAreaListener<KeyedLazyInstance<T>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void extensionAdded(@NotNull KeyedLazyInstance<T> bean, @Nullable PluginDescriptor pluginDescriptor) {
                    if (bean == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/openapi/util/KeyedExtensionCollector$1", "extensionAdded"));
                    }
                    String string = KeyedExtensionCollector.this.lock;
                    synchronized (string) {
                        if (bean.getKey() == null) {
                            if (pluginDescriptor != null) {
                                throw new PluginException("No key specified for extension of class " + bean.getInstance().getClass(), pluginDescriptor.getPluginId());
                            }
                            LOG.error("No key specified for extension of class " + bean.getInstance().getClass());
                            return;
                        }
                        KeyedExtensionCollector.this.myCache.remove(bean.getKey());
                        for (ExtensionPointListener listener : KeyedExtensionCollector.this.myListeners) {
                            listener.extensionAdded(bean.getInstance(), null);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void extensionRemoved(@NotNull KeyedLazyInstance<T> bean, @Nullable PluginDescriptor pluginDescriptor) {
                    if (bean == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/openapi/util/KeyedExtensionCollector$1", "extensionRemoved"));
                    }
                    String string = KeyedExtensionCollector.this.lock;
                    synchronized (string) {
                        KeyedExtensionCollector.this.myCache.remove(bean.getKey());
                        for (ExtensionPointListener listener : KeyedExtensionCollector.this.myListeners) {
                            listener.extensionRemoved(bean.getInstance(), null);
                        }
                    }
                }

                @Override
                public void areaReplaced(ExtensionsArea area) {
                    KeyedExtensionCollector.this.resetAreaListener();
                }
            };
            point.addExtensionPointListener(this.myListener);
        }
        return point;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAnyExtensions() {
        String string = this.lock;
        synchronized (string) {
            if (!this.myExplicitExtensions.isEmpty()) {
                return true;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var1_1
            ExtensionPoint<KeyedLazyInstance<T>> point = this.getPoint();
            return point != null && point.hasAnyExtensions();
        }
    }

    public void addListener(@NotNull ExtensionPointListener<T> listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/util/KeyedExtensionCollector", "addListener"));
        }
        this.myListeners.add(listener);
    }

    public void removeListener(@NotNull ExtensionPointListener<T> listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/util/KeyedExtensionCollector", "removeListener"));
        }
        this.myListeners.remove(listener);
    }
}

