/*
 * Decompiled with CFR 0.152.
 */
package kotlin.text;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.ReplaceWith;
import kotlin.Sequence;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.sequences.SequencesKt;
import kotlin.text.FlagEnum;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexJVMKt;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"c\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\t\u000f\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tR!\u0001\u0003\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0007\u0015\t\u00012B\u0003\u0001\u000b\u0005Ai!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0011\u0011)\u0001!B\u0001\r\u0003\u0015\tAQA\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005A\u0001#B\u0001\u0005\u00051\u0001\u0001SF\r\u00021\u0003i\nQFQ\b\t-I1\u0001C\u0001\u000e\u0003a\r\u0011kA\u0001\t\u0005\u0005^AaC\u0005\u0004\u0011\u0005i\u0011\u0001g\u0001\n\u0007!\u0015Q\"\u0001\r\u0004#\u000e\t\u0001rAQ\u000f\t-I1\u0001C\u0001\u000e\u0003a\r\u0011B\u0002\u0005\u0005\u001b\u0011I!!C\u0001\u0019\u0007a%\u0011kA\u0001\t\u000b\u0005>A\u0001A\u0005\u0004\u0011\u0017i\u0011\u0001\u0007\u0004R\u0007\u0005Ai!J\u0004\t\u00135\t\u00014C\r\u0004\u0011)i\u0011\u0001'\u0006&\u001b!YQB\u0001G\u00011/I2\u0001\u0003\u0006\u000e\u0003aU\u0011\u0004\u0002\u0003\u0002\u00111i\u0011\u0001'\u0007&\u001f!iQ\u0002B\u0005\u0003\u0013\u0005A:\u0002g\u0007\u001a\u0007!QQ\"\u0001M\u000b3\u0011!\u0011\u0001\u0003\u0007\u000e\u0003aeQ\u0005\u0003C\u0004\u00119i\u0011\u0001g\u0005\u001a\u0007!QQ\"\u0001M\u000bK9!9\u0001#\b\u000e\u00051\u0005\u0001tC\r\u0004\u0011)i\u0011\u0001'\u0006\u001a\t\u0011\t\u0001\u0002D\u0007\u000213)\u0003\u0003b\u0002\t\u001f5!\u0011BA\u0005\u00021/AZ\"G\u0002\t\u00155\t\u0001TC\r\u0005\t\u0005AA\"D\u0001\u0019\u001a\u0015B\u0001rD\u0007\u0003\u0019\u0003A:\"G\u0002\t\u00155\t\u0001TC\u0013\t\t\u000fA\u0001#D\u0001\u0019\"e\u0019\u0001BC\u0007\u00021+)s\u0001C\t\u000e\u0003aM\u0011d\u0001\u0005\u000b\u001b\u0005A*\"*\n\u0005\u0007BA\u0019#D\u0001\u0019\u0004e\u0019\u0001BC\u0007\u00021+I\u0012\u0002\u0003\n\u000e\u000f%\u0011\u0011\"\u0001M\f\u0013\tI\u0011\u0001'\u0006\u0019&\u0015Z\u00012E\u0007\u00021\u0007I2\u0001\u0003\u0006\u000e\u0003aU\u0011d\u0001\u0005\u0014\u001b\u0005A\u001a!J\u0006\t(5\t\u00014A\r\u0004\u0011)i\u0011\u0001'\u0006\u001a\u0007!\u0019R\"\u0001M\u0002K=AA#\u0004\u0003\n\u0005%\t\u00014\u0001M\u00153\rA!\"D\u0001\u0019\u0016e!A!\u0001\u0005\u0016\u001b\u0005AJ\"J\u0002\t,5\t\u0001DB\u0013\u0005\t-Aa#D\u0001\u0019\u0004%:A!\u0011\u0005\t\f5\t\u0001DB)\u0004\u0003\u0015\u0001\u0011&\u0004\u0003D\u0011!!Q\u0002B\u0005\u0003\u0013\u0005A2\u0001'\u0003R\u0007\u0011)\u0001!\u0004\u0002\u0005\u000f!=\u0011F\u0003\u0003D\u0011!\tQ\"\u0001M\u00029\r\n6aA\u0007\u0003\t!A\t\u0002"}, strings={"Lkotlin/text/Regex;", "", "pattern", "", "(Ljava/lang/String;)V", "option", "Lkotlin/text/RegexOption;", "(Ljava/lang/String;Lkotlin/text/RegexOption;)V", "options", "", "(Ljava/lang/String;Ljava/util/Set;)V", "nativePattern", "Ljava/util/regex/Pattern;", "(Ljava/util/regex/Pattern;)V", "getOptions", "()Ljava/util/Set;", "getPattern", "()Ljava/lang/String;", "containsMatchIn", "", "input", "", "find", "Lkotlin/text/MatchResult;", "startIndex", "", "findAll", "Lkotlin/Sequence;", "hasMatch", "match", "matchAll", "matchEntire", "matcher", "Ljava/util/regex/Matcher;", "matches", "replace", "transform", "Lkotlin/Function1;", "replacement", "replaceFirst", "split", "", "limit", "toPattern", "toString", "Companion"}, moduleName="kotlin-stdlib")
public final class Regex {
    @NotNull
    private final Set<RegexOption> options;
    private final Pattern nativePattern;
    public static final Companion Companion = kotlin.text.Regex$Companion.INSTANCE;

    @NotNull
    public final String getPattern() {
        String string = this.nativePattern.pattern();
        Intrinsics.checkExpressionValueIsNotNull(string, "nativePattern.pattern()");
        return string;
    }

    @NotNull
    public final Set<RegexOption> getOptions() {
        return this.options;
    }

    @Deprecated(message="To get the Matcher from java.util.regex.Pattern use toPattern to convert string to Pattern, or migrate to Regex API", replaceWith=@ReplaceWith(expression="toPattern().matcher(input)", imports={}), level=DeprecationLevel.ERROR)
    @NotNull
    public final Matcher matcher(@NotNull CharSequence input) {
        Intrinsics.checkParameterIsNotNull(input, "input");
        Matcher matcher = this.nativePattern.matcher(input);
        Intrinsics.checkExpressionValueIsNotNull(matcher, "nativePattern.matcher(input)");
        return matcher;
    }

    public final boolean matches(@NotNull CharSequence input) {
        Intrinsics.checkParameterIsNotNull(input, "input");
        return this.nativePattern.matcher(input).matches();
    }

    public final boolean containsMatchIn(@NotNull CharSequence input) {
        Intrinsics.checkParameterIsNotNull(input, "input");
        return this.nativePattern.matcher(input).find();
    }

    @Deprecated(message="Use containsMatchIn() or 'in' operator instead.", replaceWith=@ReplaceWith(expression="this in input", imports={}), level=DeprecationLevel.ERROR)
    public final boolean hasMatch(@NotNull CharSequence input) {
        Intrinsics.checkParameterIsNotNull(input, "input");
        return this.containsMatchIn(input);
    }

    @Nullable
    public final MatchResult find(@NotNull CharSequence input, int startIndex) {
        Intrinsics.checkParameterIsNotNull(input, "input");
        return RegexJVMKt.access$findNext(this.nativePattern.matcher(input), startIndex, input);
    }

    @Nullable
    public static /* bridge */ /* synthetic */ MatchResult find$default(Regex regex, CharSequence charSequence, int n, int n2) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return regex.find(charSequence, n);
    }

    @Deprecated(message="Use find() instead.", replaceWith=@ReplaceWith(expression="find(input, startIndex)", imports={}), level=DeprecationLevel.ERROR)
    @Nullable
    public final MatchResult match(@NotNull CharSequence input, int startIndex) {
        Intrinsics.checkParameterIsNotNull(input, "input");
        return this.find(input, startIndex);
    }

    @Deprecated(message="Use find() instead.", replaceWith=@ReplaceWith(expression="find(input, startIndex)", imports={}), level=DeprecationLevel.ERROR)
    @Nullable
    public static /* bridge */ /* synthetic */ MatchResult match$default(Regex regex, CharSequence charSequence, int n, int n2) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return regex.match(charSequence, n);
    }

    @NotNull
    public final Sequence<MatchResult> findAll(@NotNull CharSequence input, int startIndex) {
        Intrinsics.checkParameterIsNotNull(input, "input");
        return SequencesKt.sequence((Function0)new Function0<MatchResult>(this, input, startIndex){
            final /* synthetic */ Regex this$0;
            final /* synthetic */ CharSequence $input;
            final /* synthetic */ int $startIndex;

            @Nullable
            public final MatchResult invoke() {
                return this.this$0.find(this.$input, this.$startIndex);
            }
            {
                this.this$0 = regex;
                this.$input = charSequence;
                this.$startIndex = n;
                super(0);
            }
        }, (Function1)findAll.2.INSTANCE);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Sequence findAll$default(Regex regex, CharSequence charSequence, int n, int n2) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return regex.findAll(charSequence, n);
    }

    @Deprecated(message="Use findAll() instead.", replaceWith=@ReplaceWith(expression="findAll(input, startIndex)", imports={}), level=DeprecationLevel.ERROR)
    @NotNull
    public final Sequence<MatchResult> matchAll(@NotNull CharSequence input, int startIndex) {
        Intrinsics.checkParameterIsNotNull(input, "input");
        return this.findAll(input, startIndex);
    }

    @Deprecated(message="Use findAll() instead.", replaceWith=@ReplaceWith(expression="findAll(input, startIndex)", imports={}), level=DeprecationLevel.ERROR)
    @NotNull
    public static /* bridge */ /* synthetic */ Sequence matchAll$default(Regex regex, CharSequence charSequence, int n, int n2) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return regex.matchAll(charSequence, n);
    }

    @Nullable
    public final MatchResult matchEntire(@NotNull CharSequence input) {
        Intrinsics.checkParameterIsNotNull(input, "input");
        return RegexJVMKt.access$matchEntire(this.nativePattern.matcher(input), input);
    }

    @NotNull
    public final String replace(@NotNull CharSequence input, @NotNull String replacement) {
        Intrinsics.checkParameterIsNotNull(input, "input");
        Intrinsics.checkParameterIsNotNull(replacement, "replacement");
        String string = this.nativePattern.matcher(input).replaceAll(replacement);
        Intrinsics.checkExpressionValueIsNotNull(string, "nativePattern.matcher(in\u2026).replaceAll(replacement)");
        return string;
    }

    @NotNull
    public final String replace(@NotNull CharSequence input, @NotNull Function1<? super MatchResult, ? extends CharSequence> transform) {
        Intrinsics.checkParameterIsNotNull(input, "input");
        Intrinsics.checkParameterIsNotNull(transform, "transform");
        MatchResult matchResult = Regex.find$default(this, input, 0, 2);
        if (matchResult == null) {
            return ((Object)input).toString();
        }
        MatchResult match2 = matchResult;
        int lastStart = 0;
        int length = input.length();
        StringBuilder sb = new StringBuilder(length);
        do {
            MatchResult foundMatch;
            if (match2 == null) {
                Intrinsics.throwNpe();
            }
            sb.append(input, lastStart, ((Number)foundMatch.getRange().getStart()).intValue());
            sb.append(transform.invoke(foundMatch));
            lastStart = ((Number)foundMatch.getRange().getEndInclusive()).intValue() + 1;
            match2 = foundMatch.next();
        } while (lastStart < length && match2 != null);
        if (lastStart < length) {
            sb.append(input, lastStart, length);
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "sb.toString()");
        return string;
    }

    @NotNull
    public final String replaceFirst(@NotNull CharSequence input, @NotNull String replacement) {
        Intrinsics.checkParameterIsNotNull(input, "input");
        Intrinsics.checkParameterIsNotNull(replacement, "replacement");
        String string = this.nativePattern.matcher(input).replaceFirst(replacement);
        Intrinsics.checkExpressionValueIsNotNull(string, "nativePattern.matcher(in\u2026replaceFirst(replacement)");
        return string;
    }

    @NotNull
    public final List<String> split(@NotNull CharSequence input, int limit) {
        Intrinsics.checkParameterIsNotNull(input, "input");
        boolean value$iv = limit >= 0;
        if (!value$iv) {
            String message$iv = "Limit must be non-negative, but was " + limit;
            throw (Throwable)new IllegalArgumentException(message$iv.toString());
        }
        return ArraysKt.asList((Object[])this.nativePattern.split(input, limit == 0 ? -1 : limit));
    }

    @NotNull
    public static /* bridge */ /* synthetic */ List split$default(Regex regex, CharSequence charSequence, int n, int n2) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return regex.split(charSequence, n);
    }

    @NotNull
    public String toString() {
        String string = this.nativePattern.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "nativePattern.toString()");
        return string;
    }

    @NotNull
    public final Pattern toPattern() {
        return this.nativePattern;
    }

    /*
     * WARNING - void declaration
     */
    public Regex(@NotNull Pattern nativePattern) {
        void var3_4;
        void value$iv;
        Intrinsics.checkParameterIsNotNull(nativePattern, "nativePattern");
        this.nativePattern = nativePattern;
        int n = this.nativePattern.flags();
        Regex regex = this;
        EnumSet<RegexOption> $receiver$iv$iv = EnumSet.allOf(RegexOption.class);
        EnumSet<RegexOption> $receiver$iv = $receiver$iv$iv;
        CollectionsKt.retainAll((Iterable)$receiver$iv, (Function1)new Function1<T, Boolean>((int)value$iv){
            final /* synthetic */ int $value$inlined;

            public final boolean invoke(T it) {
                return (this.$value$inlined & ((FlagEnum)it).getMask()) == ((FlagEnum)it).getValue();
            }
            {
                this.$value$inlined = n;
                super(1);
            }
        });
        Set set = Collections.unmodifiableSet((Set)var3_4);
        Intrinsics.checkExpressionValueIsNotNull(set, "Collections.unmodifiable\u2026 == it.value }\n        })");
        Set set2 = set;
        regex.options = set2;
    }

    public Regex(@NotNull String pattern) {
        Intrinsics.checkParameterIsNotNull(pattern, "pattern");
        Pattern pattern2 = Pattern.compile(pattern);
        Intrinsics.checkExpressionValueIsNotNull(pattern2, "Pattern.compile(pattern)");
        this(pattern2);
    }

    public Regex(@NotNull String pattern, @NotNull RegexOption option) {
        Intrinsics.checkParameterIsNotNull(pattern, "pattern");
        Intrinsics.checkParameterIsNotNull(option, "option");
        Pattern pattern2 = Pattern.compile(pattern, Regex.Companion.ensureUnicodeCase(option.getValue()));
        Intrinsics.checkExpressionValueIsNotNull(pattern2, "Pattern.compile(pattern,\u2026nicodeCase(option.value))");
        this(pattern2);
    }

    public Regex(@NotNull String pattern, @NotNull Set<? extends RegexOption> options) {
        Intrinsics.checkParameterIsNotNull(pattern, "pattern");
        Intrinsics.checkParameterIsNotNull(options, "options");
        Pattern pattern2 = Pattern.compile(pattern, Regex.Companion.ensureUnicodeCase(RegexJVMKt.access$toInt(options)));
        Intrinsics.checkExpressionValueIsNotNull(pattern2, "Pattern.compile(pattern,\u2026odeCase(options.toInt()))");
        this(pattern2);
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"!\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!!Q!\u0001\u0003\u0002\u000b\u0005Aq!B\u0001\u0005\u0004\u0015\tA\"\u0001\u0003D\u00041\u0001\u0011$\u0001M\u0001C\u000f!\u0011!U\u0002\u0002\u0011\u0005)\u0003\u0002B\u0001\t\u00045\t\u0001DA\r\u0004\u0011\u000bi\u0011\u0001\u0007\u0002&\u000f!\u0019Q\"\u0001M\u00043\rAA!D\u0001\u0019\b\u0015:\u0001\u0012B\u0007\u00021\u000fI2\u0001\u0003\u0003\u000e\u0003a\u001dQe\u0002\u0005\u0006\u001b\u0005AZ!G\u0002\t\t5\t\u0001t\u0001"}, strings={"Lkotlin/text/Regex$Companion;", "", "()V", "ensureUnicodeCase", "", "flags", "escape", "", "literal", "escapeReplacement", "fromLiteral", "Lkotlin/text/Regex;"}, moduleName="kotlin-stdlib")
    public static final class Companion {
        public static final Companion INSTANCE;

        @NotNull
        public final Regex fromLiteral(@NotNull String literal) {
            Intrinsics.checkParameterIsNotNull(literal, "literal");
            return StringsKt.toRegex(literal, RegexOption.LITERAL);
        }

        @NotNull
        public final String escape(@NotNull String literal) {
            Intrinsics.checkParameterIsNotNull(literal, "literal");
            String string = Pattern.quote(literal);
            Intrinsics.checkExpressionValueIsNotNull(string, "Pattern.quote(literal)");
            return string;
        }

        @NotNull
        public final String escapeReplacement(@NotNull String literal) {
            Intrinsics.checkParameterIsNotNull(literal, "literal");
            String string = Matcher.quoteReplacement(literal);
            Intrinsics.checkExpressionValueIsNotNull(string, "Matcher.quoteReplacement(literal)");
            return string;
        }

        private final int ensureUnicodeCase(int flags) {
            return (flags & 2) != 0 ? flags | 0x40 : flags;
        }

        private Companion() {
            INSTANCE = this;
        }

        static {
            new Companion();
        }
    }
}

