/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import com.google.common.collect.LinkedListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.PreconditionsKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.inline.Interval;
import org.jetbrains.kotlin.codegen.inline.SplitPair;
import org.jetbrains.kotlin.codegen.inline.SplittableInterval;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"[\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\t\u0001\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u0003!\rR!\u0001C\u0002\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\tAaA\u0003\u0002\u0011\u0005)\u0011\u0001b\u0001\u0006\u0003!\u0005R!\u0001\u0005\u0011\u000b\u0005!\u0011!B\u0001\t\f\u0015\tA\u0011B\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001C\u0003\u0019\u0001)r\u0001\u0002\u0001\t\u0002U!\u0011BA\u0005\u0002I\u0003A\u0012!G\u0001\u0019\u0004\u0005\u0016\u0011kA\u0001\t\u0005\u0015N\u0001RC\u0007\u00021-I2\u0001c\u0006\u000e\u0003q\u0001\u0011kA\u0001\t\u0019\u0015j\u0002\u0012D\u0007\u0014\u0013\u0019IQ\u0001\u0005\u0005\u0016\u00051\u0005A\u0004\u0001\u000f\u0001!!)\u0012\"\u0003\u0004\n\u000bAAQC\u0001G\u00019\u0001a\u0002\u0001$\u0001\u0019\u001cai\u0011d\u0001\u0005\u000f\u001b\u0005Az!G\u0002\t\u001e5\t\u0001dD\u0013\f\u0011?i\u0011\u0001G\u0006\u001a\u0007!qQ\"\u0001M\b3\rA\u0001#D\u0001\u0019\u001f\u0015vA!\u0001E\u0011\u001b\u0005A2\"G\u0002\t#5\t\u0001tB\r\u0004\u0011Gi\u0011\u0001\b\u0001R\u0007\u0005A!#*\b\u0005\u0003!\u0015R\"\u0001\r\f3\rA1#D\u0001\u0019\u0010e\u0019\u00012E\u0007\u00029\u0001\t6!\u0001\u0005\u0013KSA9#\u0004\u0003\n\u0005%\tA\u0004\u0001\r\u00153\rAI#D\u0001\u001d\u0001e\u0019\u0001\"F\u0007\u00021WI2\u0001\u0003\f\u000e\u0003ay\u0011kA\u0001\t.\u0015&\u0002bF\u0007\u0005\u0013\tI\u0011\u0001\b\u0001\u0019)e\u0019\u0001\u0012F\u0007\u00029\u0001I2\u0001C\u000b\u000e\u0003a-\u0012d\u0001\u0005\u0017\u001b\u0005Ar\"U\u0002\u0002\u0011[)s\u0001c\f\u000e\u0003aY\u0011d\u0001\u0005\u0016\u001b\u0005AZ#J\t\t159\u0011\"B\u0005\u0005\u0013\tI\u0011\u0001\b\u0001\u0019)am\u0011d\u0001\u0005\u0016\u001b\u0005AZ#G\u0002\t-5\t\u0001dD\u0015\u000e\t\rC\u0001RA\u0007\u0005\u0013\tI\u0011\u0001\b\u0001\u0019\u0007E\u001bA!\u0002\u0001\u000e\u0005\u0011\u001d\u0001\u0002B\u0015\u000e\t\rC\u0001\u0012B\u0007\u0005\u0013\tI\u0011\u0001\b\u0001\u0019\u000bE\u001bA!\u0002\u0001\u000e\u0005\u0011-\u0001BB\u0015+\t\rC\u0001RB\u0007\"\u0013\u0019IQ\u0001\u0005\u0005\u0016\u00051\u0005\u0001t\u0002M\b\u0013\u0019IQ\u0001\u0005\u0005\u0016\u00051\u0005A\u0004\u0001\u000f\u0001!!)\u0002#\u0003\u0004\n\u000bAAQC\u0001G\u00011\u001fAz!\u0003\u0004\n\u000bAAQC\u0001G\u00019\u0001a\u0002\u0001$\u0001\u0019\u000fa9\u0011k\u0001\u0003\u0006\u00015\u0011A\u0011\u0003\u0005\nS)\"1\t\u0003E\n\u001b\u0005Ja!C\u0003\u0011\u0011U\u0011A\u0012\u0001M\b1\u001fIa!C\u0003\u0011\u0011U\u0011A\u0012\u0001\u000f\u00019\u0001\u0001\u0002\"\u0006\t\n\r%)\u0001\u0003C\u000b\u0003\u0019\u0003Az\u0001g\u0004\n\r%)\u0001\u0003C\u000b\u0003\u0019\u0003a\u0002\u0001\b\u0001\r\u0002a9\u0001dB)\u0004\t\u0015\u0001QB\u0001\u0003\u000b\u0011%\u0001"}, strings={"Lorg/jetbrains/kotlin/codegen/inline/IntervalMetaInfo;", "T", "Lorg/jetbrains/kotlin/codegen/inline/SplittableInterval;", "", "()V", "allIntervals", "Ljava/util/ArrayList;", "getAllIntervals", "()Ljava/util/ArrayList;", "currentIntervals", "", "getCurrentIntervals", "()Ljava/util/Set;", "intervalEnds", "Lcom/google/common/collect/LinkedListMultimap;", "Lorg/jetbrains/org/objectweb/asm/tree/LabelNode;", "kotlin.jvm.PlatformType", "getIntervalEnds", "()Lcom/google/common/collect/LinkedListMultimap;", "intervalStarts", "getIntervalStarts", "addNewInterval", "", "newInfo", "(Lorg/jetbrains/kotlin/codegen/inline/SplittableInterval;)V", "getInterval", "", "", "curIns", "isOpen", "", "processCurrent", "directOrder", "remapEndLabel", "oldEnd", "remapped", "(Lorg/jetbrains/org/objectweb/asm/tree/LabelNode;Lorg/jetbrains/kotlin/codegen/inline/SplittableInterval;)V", "remapStartLabel", "oldStart", "split", "Lorg/jetbrains/kotlin/codegen/inline/SplitPair;", "interval", "by", "Lorg/jetbrains/kotlin/codegen/inline/Interval;", "keepStart", "(Lorg/jetbrains/kotlin/codegen/inline/SplittableInterval;Lorg/jetbrains/kotlin/codegen/inline/Interval;Z)Lorg/jetbrains/kotlin/codegen/inline/SplitPair;", "splitAndRemoveInterval", "splitAndRemoveIntervalsFromCurrents", "splitCurrentIntervals"}, moduleName="kotlin-compiler")
public final class IntervalMetaInfo<T extends SplittableInterval<T>> {
    private final LinkedListMultimap<LabelNode, T> intervalStarts = LinkedListMultimap.create();
    private final LinkedListMultimap<LabelNode, T> intervalEnds = LinkedListMultimap.create();
    @NotNull
    private final ArrayList<T> allIntervals = CollectionsKt.arrayListOf(new SplittableInterval[0]);
    @NotNull
    private final Set<T> currentIntervals = SetsKt.linkedSetOf(new SplittableInterval[0]);

    public final LinkedListMultimap<LabelNode, T> getIntervalStarts() {
        return this.intervalStarts;
    }

    public final LinkedListMultimap<LabelNode, T> getIntervalEnds() {
        return this.intervalEnds;
    }

    @NotNull
    public final ArrayList<T> getAllIntervals() {
        return this.allIntervals;
    }

    @NotNull
    public final Set<T> getCurrentIntervals() {
        return this.currentIntervals;
    }

    public final void addNewInterval(@NotNull T newInfo) {
        Intrinsics.checkParameterIsNotNull(newInfo, "newInfo");
        this.intervalStarts.put(newInfo.getStartLabel(), newInfo);
        this.intervalEnds.put(newInfo.getEndLabel(), newInfo);
        this.allIntervals.add(newInfo);
    }

    private final void remapStartLabel(LabelNode oldStart, T remapped) {
        this.intervalStarts.remove(oldStart, remapped);
        this.intervalStarts.put(remapped.getStartLabel(), remapped);
    }

    private final void remapEndLabel(LabelNode oldEnd, T remapped) {
        this.intervalEnds.remove(oldEnd, remapped);
        this.intervalEnds.put(remapped.getEndLabel(), remapped);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<SplitPair<T>> splitCurrentIntervals(@NotNull Interval by, boolean keepStart) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(by, "by");
        Iterable $receiver$iv = this.currentIntervals;
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            SplittableInterval splittableInterval = (SplittableInterval)item$iv$iv;
            void var12_9 = destination$iv$iv;
            SplitPair<void> splitPair = this.split(it, by, keepStart);
            var12_9.add(splitPair);
        }
        return (List)destination$iv$iv;
    }

    public final void splitAndRemoveIntervalsFromCurrents(@NotNull Interval by) {
        Intrinsics.checkParameterIsNotNull(by, "by");
        ArrayList copies = new ArrayList(this.currentIntervals);
        Iterable $receiver$iv = copies;
        for (Object element$iv : $receiver$iv) {
            SplittableInterval it;
            SplittableInterval splittableInterval = it = (SplittableInterval)element$iv;
            Intrinsics.checkExpressionValueIsNotNull(splittableInterval, "it");
            this.splitAndRemoveInterval(splittableInterval, by, true);
        }
    }

    public final void processCurrent(@NotNull LabelNode curIns, boolean directOrder) {
        SplittableInterval it;
        Intrinsics.checkParameterIsNotNull(curIns, "curIns");
        Iterable $receiver$iv = this.getInterval(curIns, directOrder);
        for (Object element$iv : $receiver$iv) {
            Unit unit;
            SplittableInterval splittableInterval = it = (SplittableInterval)element$iv;
            Intrinsics.checkExpressionValueIsNotNull(splittableInterval, "it");
            boolean added = this.currentIntervals.add(splittableInterval);
            if (PreconditionsKt.getASSERTIONS_ENABLED()) {
                if (!added) {
                    String message$iv = "Wrong interval structure: " + curIns + ", " + it;
                    throw (Throwable)((Object)new AssertionError((Object)message$iv));
                }
                unit = Unit.INSTANCE;
                continue;
            }
            unit = Unit.INSTANCE;
        }
        $receiver$iv = this.getInterval(curIns, !directOrder);
        for (Object element$iv : $receiver$iv) {
            Unit unit;
            it = (SplittableInterval)element$iv;
            boolean removed = this.currentIntervals.remove(it);
            if (PreconditionsKt.getASSERTIONS_ENABLED()) {
                if (!removed) {
                    String message$iv = "Wrong interval structure: " + curIns + ", " + it;
                    throw (Throwable)((Object)new AssertionError((Object)message$iv));
                }
                unit = Unit.INSTANCE;
                continue;
            }
            unit = Unit.INSTANCE;
        }
    }

    @NotNull
    public final SplitPair<T> split(@NotNull T interval, @NotNull Interval by, boolean keepStart) {
        Intrinsics.checkParameterIsNotNull(interval, "interval");
        Intrinsics.checkParameterIsNotNull(by, "by");
        SplitPair split = interval.split(by, keepStart);
        if (!keepStart) {
            this.remapStartLabel(((SplittableInterval)split.getNewPart()).getStartLabel(), (SplittableInterval)split.getPatchedPart());
        } else {
            this.remapEndLabel(((SplittableInterval)split.getNewPart()).getEndLabel(), (SplittableInterval)split.getPatchedPart());
        }
        this.addNewInterval((SplittableInterval)split.getNewPart());
        return split;
    }

    @NotNull
    public final SplitPair<T> splitAndRemoveInterval(@NotNull T interval, @NotNull Interval by, boolean keepStart) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull(interval, "interval");
        Intrinsics.checkParameterIsNotNull(by, "by");
        SplitPair<T> splitPair = this.split(interval, by, keepStart);
        boolean removed = this.currentIntervals.remove(splitPair.getPatchedPart());
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            if (!removed) {
                String message$iv = "Wrong interval structure: " + splitPair;
                throw (Throwable)((Object)new AssertionError((Object)message$iv));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        return splitPair;
    }

    public final List<T> getInterval(@NotNull LabelNode curIns, boolean isOpen) {
        Intrinsics.checkParameterIsNotNull(curIns, "curIns");
        return isOpen ? this.intervalStarts.get((Object)curIns) : this.intervalEnds.get((Object)curIns);
    }
}

