/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin.nativeDeclarations;

import com.intellij.psi.PsiElement;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.load.kotlin.nativeDeclarations.NativeKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DeclarationChecker;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={")\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\r\u0001e\t\u0001\u0014AQ\u0003#\u000e\t\u0001\"A\u0013\u0015\t-A\u0019!D\u0001\u0019\u0005e\u0019\u0001RA\u0007\u00021\rI2\u0001c\u0002\u000e\u0003a!\u0011d\u0001E\u0005\u001b\u0005AR!G\u0002\t\f5\t\u0001D\u0002"}, strings={"Lorg/jetbrains/kotlin/load/kotlin/nativeDeclarations/NativeFunChecker;", "Lorg/jetbrains/kotlin/resolve/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;"}, moduleName="kotlin-compiler")
public final class NativeFunChecker
implements DeclarationChecker {
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext2) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        Intrinsics.checkParameterIsNotNull(bindingContext2, "bindingContext");
        if (!NativeKt.hasNativeAnnotation(descriptor2)) {
            return;
        }
        if (DescriptorUtils.isInterface(descriptor2.getContainingDeclaration())) {
            diagnosticHolder.report(ErrorsJvm.EXTERNAL_DECLARATION_IN_INTERFACE.on((KtDeclaration)((PsiElement)declaration)));
        } else if (descriptor2 instanceof CallableMemberDescriptor && Intrinsics.areEqual((Object)((CallableMemberDescriptor)descriptor2).getModality(), (Object)Modality.ABSTRACT)) {
            diagnosticHolder.report(ErrorsJvm.EXTERNAL_DECLARATION_CANNOT_BE_ABSTRACT.on((KtDeclaration)((PsiElement)declaration)));
        }
        if (!(descriptor2 instanceof ConstructorDescriptor) && declaration instanceof KtDeclarationWithBody && ((KtDeclarationWithBody)declaration).hasBody()) {
            diagnosticHolder.report(ErrorsJvm.EXTERNAL_DECLARATION_CANNOT_HAVE_BODY.on((KtDeclaration)((PsiElement)declaration)));
        }
        if (InlineUtil.isInline(descriptor2)) {
            diagnosticHolder.report(ErrorsJvm.EXTERNAL_DECLARATION_CANNOT_BE_INLINED.on((KtDeclaration)((PsiElement)declaration)));
        }
    }
}

