/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.context;

import com.google.dart.compiler.backend.js.ast.JsContext;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNode;
import com.google.dart.compiler.backend.js.ast.JsScope;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsVars;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.inline.util.RewriteUtilsKt;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012J\u000e\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000fJ\u000e\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016J\u001a\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000f2\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u0010J\u0016\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u0010R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/js/inline/context/NamingContext;", "", "scope", "Lcom/google/dart/compiler/backend/js/ast/JsScope;", "statementContext", "Lcom/google/dart/compiler/backend/js/ast/JsContext;", "Lcom/google/dart/compiler/backend/js/ast/JsStatement;", "(Lcom/google/dart/compiler/backend/js/ast/JsScope;Lcom/google/dart/compiler/backend/js/ast/JsContext;)V", "addedDeclarations", "", "declarations", "Ljava/util/ArrayList;", "Lcom/google/dart/compiler/backend/js/ast/JsVars;", "renamings", "Ljava/util/IdentityHashMap;", "Lcom/google/dart/compiler/backend/js/ast/JsName;", "Lcom/google/dart/compiler/backend/js/ast/JsExpression;", "applyRenameTo", "Lcom/google/dart/compiler/backend/js/ast/JsNode;", "target", "getFreshName", "candidate", "", "newVar", "", "name", "value", "replaceName", "replacement", "kotlin-compiler"})
public final class NamingContext {
    private final IdentityHashMap<JsName, JsExpression> renamings;
    private final ArrayList<JsVars> declarations;
    private boolean addedDeclarations;
    private final JsScope scope;
    private final JsContext<JsStatement> statementContext;

    @NotNull
    public final JsNode applyRenameTo(@NotNull JsNode target) {
        Intrinsics.checkParameterIsNotNull(target, "target");
        if (!this.addedDeclarations) {
            this.statementContext.addPrevious((List)this.declarations);
            this.addedDeclarations = true;
        }
        return RewriteUtilsKt.replaceNames(target, this.renamings);
    }

    public final void replaceName(@NotNull JsName name, @NotNull JsExpression replacement) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(replacement, "replacement");
        boolean value$iv = !this.renamings.containsKey(name);
        if (_Assertions.ENABLED) {
            if (!value$iv) {
                String message$iv = name + " has been renamed already";
                throw (Throwable)((Object)new AssertionError((Object)message$iv));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        this.renamings.put(name, replacement);
    }

    @NotNull
    public final JsName getFreshName(@NotNull String candidate) {
        Intrinsics.checkParameterIsNotNull(candidate, "candidate");
        JsName jsName = this.scope.declareFreshName(candidate);
        Intrinsics.checkExpressionValueIsNotNull(jsName, "scope.declareFreshName(candidate)");
        return jsName;
    }

    @NotNull
    public final JsName getFreshName(@NotNull JsName candidate) {
        Intrinsics.checkParameterIsNotNull(candidate, "candidate");
        String string = candidate.getIdent();
        Intrinsics.checkExpressionValueIsNotNull(string, "candidate.ident");
        return this.getFreshName(string);
    }

    public final void newVar(@NotNull JsName name, @Nullable JsExpression value) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        JsVars vars = JsAstUtils.newVar(name, value);
        this.declarations.add(vars);
    }

    public static /* bridge */ /* synthetic */ void newVar$default(NamingContext namingContext, JsName jsName, JsExpression jsExpression, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: newVar");
        }
        if ((n & 2) != 0) {
            jsExpression = null;
        }
        namingContext.newVar(jsName, jsExpression);
    }

    public NamingContext(@NotNull JsScope scope2, @NotNull JsContext<JsStatement> statementContext) {
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        Intrinsics.checkParameterIsNotNull(statementContext, "statementContext");
        this.scope = scope2;
        this.statementContext = statementContext;
        this.renamings = new IdentityHashMap();
        this.declarations = new ArrayList();
    }
}

