/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.QualifiedExpressionResolveUtilKt;
import org.jetbrains.kotlin.resolve.QualifiedExpressionResolver;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.CallExpressionElement;
import org.jetbrains.kotlin.resolve.calls.CallResolver;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CheckArgumentTypesMode;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.TemporaryTraceAndCache;
import org.jetbrains.kotlin.resolve.calls.model.DataFlowInfoForArgumentsImpl;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsUtil;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassQualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.PackageQualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.Qualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.QualifierReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.validation.SymbolUsageValidator;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.DataFlowAnalyzer;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;

public class CallExpressionResolver {
    @NotNull
    private final CallResolver callResolver;
    @NotNull
    private final ConstantExpressionEvaluator constantExpressionEvaluator;
    @NotNull
    private final DataFlowAnalyzer dataFlowAnalyzer;
    @NotNull
    private final KotlinBuiltIns builtIns;
    @NotNull
    private final QualifiedExpressionResolver qualifiedExpressionResolver;
    @NotNull
    private final SymbolUsageValidator symbolUsageValidator;
    private ExpressionTypingServices expressionTypingServices;

    public CallExpressionResolver(@NotNull CallResolver callResolver, @NotNull ConstantExpressionEvaluator constantExpressionEvaluator, @NotNull DataFlowAnalyzer dataFlowAnalyzer, @NotNull KotlinBuiltIns builtIns, @NotNull QualifiedExpressionResolver qualifiedExpressionResolver, @NotNull SymbolUsageValidator symbolUsageValidator) {
        if (callResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callResolver", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "<init>"));
        }
        if (constantExpressionEvaluator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constantExpressionEvaluator", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "<init>"));
        }
        if (dataFlowAnalyzer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowAnalyzer", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "<init>"));
        }
        if (builtIns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builtIns", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "<init>"));
        }
        if (qualifiedExpressionResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedExpressionResolver", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "<init>"));
        }
        if (symbolUsageValidator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbolUsageValidator", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "<init>"));
        }
        this.callResolver = callResolver;
        this.constantExpressionEvaluator = constantExpressionEvaluator;
        this.dataFlowAnalyzer = dataFlowAnalyzer;
        this.builtIns = builtIns;
        this.qualifiedExpressionResolver = qualifiedExpressionResolver;
        this.symbolUsageValidator = symbolUsageValidator;
    }

    @Inject
    public void setExpressionTypingServices(@NotNull ExpressionTypingServices expressionTypingServices) {
        if (expressionTypingServices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionTypingServices", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "setExpressionTypingServices"));
        }
        this.expressionTypingServices = expressionTypingServices;
    }

    @Nullable
    private ResolvedCall<FunctionDescriptor> getResolvedCallForFunction(@NotNull Call call, @NotNull ResolutionContext context, @NotNull CheckArgumentTypesMode checkArguments, @NotNull boolean[] result2, @NotNull DataFlowInfo initialDataFlowInfoForArguments) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getResolvedCallForFunction"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getResolvedCallForFunction"));
        }
        if (checkArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkArguments", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getResolvedCallForFunction"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getResolvedCallForFunction"));
        }
        if (initialDataFlowInfoForArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialDataFlowInfoForArguments", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getResolvedCallForFunction"));
        }
        OverloadResolutionResults<FunctionDescriptor> results = this.callResolver.resolveFunctionCall(BasicCallResolutionContext.create(context, call, checkArguments, new DataFlowInfoForArgumentsImpl(initialDataFlowInfoForArguments, call)));
        if (!results.isNothing()) {
            result2[0] = true;
            return OverloadResolutionResultsUtil.getResultingCall(results, context.contextDependency);
        }
        result2[0] = false;
        return null;
    }

    @Nullable
    private KotlinType getVariableType(@NotNull KtSimpleNameExpression nameExpression, @Nullable Receiver receiver, @Nullable ASTNode callOperationNode, @NotNull ExpressionTypingContext context, @NotNull boolean[] result2) {
        if (nameExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameExpression", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getVariableType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getVariableType"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getVariableType"));
        }
        TemporaryTraceAndCache temporaryForVariable = TemporaryTraceAndCache.create(context, "trace to resolve as local variable or property", nameExpression);
        Call call = CallMaker.makePropertyCall(receiver, callOperationNode, nameExpression);
        BasicCallResolutionContext contextForVariable = BasicCallResolutionContext.create(context.replaceTraceAndCache(temporaryForVariable), call, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS);
        OverloadResolutionResults<VariableDescriptor> resolutionResult = this.callResolver.resolveSimpleProperty(contextForVariable);
        boolean isLHSOfDot = KtPsiUtil.isLHSOfDot(nameExpression);
        if (!resolutionResult.isNothing() && resolutionResult.getResultCode() != OverloadResolutionResults.Code.CANDIDATES_WITH_WRONG_RECEIVER) {
            boolean isQualifier;
            boolean bl = isQualifier = isLHSOfDot && resolutionResult.isSingleResult() && resolutionResult.getResultingDescriptor() instanceof FakeCallableDescriptorForObject;
            if (!isQualifier) {
                result2[0] = true;
                temporaryForVariable.commit();
                return resolutionResult.isSingleResult() ? resolutionResult.getResultingDescriptor().getReturnType() : null;
            }
        }
        temporaryForVariable.commit();
        result2[0] = !resolutionResult.isNothing();
        return resolutionResult.isSingleResult() ? resolutionResult.getResultingDescriptor().getReturnType() : null;
    }

    @NotNull
    public KotlinTypeInfo getSimpleNameExpressionTypeInfo(@NotNull KtSimpleNameExpression nameExpression, @Nullable Receiver receiver, @Nullable ASTNode callOperationNode, @NotNull ExpressionTypingContext context) {
        if (nameExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameExpression", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getSimpleNameExpressionTypeInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getSimpleNameExpressionTypeInfo"));
        }
        KotlinTypeInfo kotlinTypeInfo = this.getSimpleNameExpressionTypeInfo(nameExpression, receiver, callOperationNode, context, context.dataFlowInfo);
        if (kotlinTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getSimpleNameExpressionTypeInfo"));
        }
        return kotlinTypeInfo;
    }

    @NotNull
    private KotlinTypeInfo getSimpleNameExpressionTypeInfo(@NotNull KtSimpleNameExpression nameExpression, @Nullable Receiver receiver, @Nullable ASTNode callOperationNode, @NotNull ExpressionTypingContext context, @NotNull DataFlowInfo initialDataFlowInfoForArguments) {
        TemporaryTraceAndCache temporaryForQualifier;
        ExpressionTypingContext contextForQualifier;
        Qualifier qualifier2;
        if (nameExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameExpression", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getSimpleNameExpressionTypeInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getSimpleNameExpressionTypeInfo"));
        }
        if (initialDataFlowInfoForArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialDataFlowInfoForArguments", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getSimpleNameExpressionTypeInfo"));
        }
        boolean[] result2 = new boolean[1];
        TemporaryTraceAndCache temporaryForVariable = TemporaryTraceAndCache.create(context, "trace to resolve as variable", nameExpression);
        KotlinType type2 = this.getVariableType(nameExpression, receiver, callOperationNode, (ExpressionTypingContext)context.replaceTraceAndCache(temporaryForVariable), result2);
        if (result2[0]) {
            temporaryForVariable.commit();
            KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.createTypeInfo(type2, initialDataFlowInfoForArguments);
            if (kotlinTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getSimpleNameExpressionTypeInfo"));
            }
            return kotlinTypeInfo;
        }
        Call call = CallMaker.makeCall(nameExpression, receiver, callOperationNode, nameExpression, Collections.emptyList());
        TemporaryTraceAndCache temporaryForFunction = TemporaryTraceAndCache.create(context, "trace to resolve as function", nameExpression);
        Object newContext = context.replaceTraceAndCache(temporaryForFunction);
        ResolvedCall<FunctionDescriptor> resolvedCall2 = this.getResolvedCallForFunction(call, (ResolutionContext)newContext, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS, result2, initialDataFlowInfoForArguments);
        if (result2[0]) {
            FunctionDescriptor functionDescriptor;
            FunctionDescriptor functionDescriptor2 = functionDescriptor = resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null;
            if (!(functionDescriptor instanceof ConstructorDescriptor)) {
                temporaryForFunction.commit();
                boolean hasValueParameters = functionDescriptor == null || functionDescriptor.getValueParameters().size() > 0;
                context.trace.report(Errors.FUNCTION_CALL_EXPECTED.on(nameExpression, nameExpression, hasValueParameters));
                type2 = functionDescriptor != null ? functionDescriptor.getReturnType() : null;
                KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.createTypeInfo(type2, context);
                if (kotlinTypeInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getSimpleNameExpressionTypeInfo"));
                }
                return kotlinTypeInfo;
            }
        }
        if ((qualifier2 = this.qualifiedExpressionResolver.resolveNameExpressionAsQualifierForDiagnostics(nameExpression, receiver, contextForQualifier = (ExpressionTypingContext)context.replaceTraceAndCache(temporaryForQualifier = TemporaryTraceAndCache.create(context, "trace to resolve as qualifier", nameExpression)))) != null) {
            QualifiedExpressionResolveUtilKt.resolveQualifierAsStandaloneExpression(qualifier2, contextForQualifier, this.symbolUsageValidator);
            temporaryForQualifier.commit();
            KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(context);
            if (kotlinTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getSimpleNameExpressionTypeInfo"));
            }
            return kotlinTypeInfo;
        }
        temporaryForVariable.commit();
        KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(context);
        if (kotlinTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getSimpleNameExpressionTypeInfo"));
        }
        return kotlinTypeInfo;
    }

    @NotNull
    public KotlinTypeInfo getCallExpressionTypeInfo(@NotNull KtCallExpression callExpression, @Nullable ReceiverValue receiver, @Nullable ASTNode callOperationNode, @NotNull ExpressionTypingContext context) {
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfo"));
        }
        KotlinTypeInfo typeInfo = this.getCallExpressionTypeInfoWithoutFinalTypeCheck(callExpression, receiver, callOperationNode, context, context.dataFlowInfo);
        if (context.contextDependency == ContextDependency.INDEPENDENT) {
            this.dataFlowAnalyzer.checkType(typeInfo.getType(), (KtExpression)callExpression, (ResolutionContext)context);
        }
        KotlinTypeInfo kotlinTypeInfo = typeInfo;
        if (kotlinTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfo"));
        }
        return kotlinTypeInfo;
    }

    @NotNull
    private KotlinTypeInfo getCallExpressionTypeInfoWithoutFinalTypeCheck(@NotNull KtCallExpression callExpression, @Nullable Receiver receiver, @Nullable ASTNode callOperationNode, @NotNull ExpressionTypingContext context, @NotNull DataFlowInfo initialDataFlowInfoForArguments) {
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfoWithoutFinalTypeCheck"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfoWithoutFinalTypeCheck"));
        }
        if (initialDataFlowInfoForArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialDataFlowInfoForArguments", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfoWithoutFinalTypeCheck"));
        }
        boolean[] result2 = new boolean[1];
        Call call = CallMaker.makeCall(receiver, callOperationNode, callExpression);
        TemporaryTraceAndCache temporaryForFunction = TemporaryTraceAndCache.create(context, "trace to resolve as function call", callExpression);
        ResolvedCall<FunctionDescriptor> resolvedCall2 = this.getResolvedCallForFunction(call, (ResolutionContext)context.replaceTraceAndCache(temporaryForFunction), CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS, result2, initialDataFlowInfoForArguments);
        if (result2[0]) {
            DataFlowInfo resultFlowInfo;
            FunctionDescriptor functionDescriptor = resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null;
            temporaryForFunction.commit();
            if (callExpression.getValueArgumentList() == null && callExpression.getLambdaArguments().isEmpty()) {
                boolean hasValueParameters = functionDescriptor == null || functionDescriptor.getValueParameters().size() > 0;
                context.trace.report(Errors.FUNCTION_CALL_EXPECTED.on(callExpression, callExpression, hasValueParameters));
            }
            if (functionDescriptor == null) {
                KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(context);
                if (kotlinTypeInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfoWithoutFinalTypeCheck"));
                }
                return kotlinTypeInfo;
            }
            if (functionDescriptor instanceof ConstructorDescriptor) {
                DeclarationDescriptor containingDescriptor = functionDescriptor.getContainingDeclaration();
                if (DescriptorUtils.isAnnotationClass(containingDescriptor) && !CallExpressionResolver.canInstantiateAnnotationClass(callExpression, context.trace)) {
                    context.trace.report(Errors.ANNOTATION_CLASS_CONSTRUCTOR_CALL.on(callExpression));
                }
                if (DescriptorUtils.isEnumClass(containingDescriptor)) {
                    context.trace.report(Errors.ENUM_CLASS_CONSTRUCTOR_CALL.on(callExpression));
                }
                if (containingDescriptor instanceof ClassDescriptor && ((ClassDescriptor)containingDescriptor).getModality() == Modality.SEALED) {
                    context.trace.report(Errors.SEALED_CLASS_CONSTRUCTOR_CALL.on(callExpression));
                }
            }
            KotlinType type2 = functionDescriptor.getReturnType();
            List<KtValueArgument> arguments2 = callExpression.getValueArguments();
            DataFlowInfo jumpFlowInfo = resultFlowInfo = resolvedCall2.getDataFlowInfoForArguments().getResultInfo();
            boolean jumpOutPossible = false;
            for (ValueArgument valueArgument : arguments2) {
                KotlinTypeInfo argTypeInfo = context.trace.get(BindingContext.EXPRESSION_TYPE_INFO, valueArgument.getArgumentExpression());
                if (argTypeInfo == null || !argTypeInfo.getJumpOutPossible()) continue;
                jumpOutPossible = true;
                jumpFlowInfo = argTypeInfo.getJumpFlowInfo();
                break;
            }
            KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.createTypeInfo(type2, resultFlowInfo, jumpOutPossible, jumpFlowInfo);
            if (kotlinTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfoWithoutFinalTypeCheck"));
            }
            return kotlinTypeInfo;
        }
        KtExpression calleeExpression = callExpression.getCalleeExpression();
        if (calleeExpression instanceof KtSimpleNameExpression && callExpression.getTypeArgumentList() == null) {
            TemporaryTraceAndCache temporaryForVariable = TemporaryTraceAndCache.create(context, "trace to resolve as variable with 'invoke' call", callExpression);
            KotlinType type3 = this.getVariableType((KtSimpleNameExpression)calleeExpression, receiver, callOperationNode, (ExpressionTypingContext)context.replaceTraceAndCache(temporaryForVariable), result2);
            Qualifier qualifier2 = temporaryForVariable.trace.get(BindingContext.QUALIFIER, calleeExpression);
            if (result2[0] && (qualifier2 == null || !(qualifier2 instanceof PackageQualifier))) {
                temporaryForVariable.commit();
                context.trace.report(Errors.FUNCTION_EXPECTED.on(calleeExpression, calleeExpression, type3 != null ? type3 : ErrorUtils.createErrorType("")));
                KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(context);
                if (kotlinTypeInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfoWithoutFinalTypeCheck"));
                }
                return kotlinTypeInfo;
            }
        }
        temporaryForFunction.commit();
        KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(context);
        if (kotlinTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfoWithoutFinalTypeCheck"));
        }
        return kotlinTypeInfo;
    }

    private static boolean canInstantiateAnnotationClass(@NotNull KtCallExpression expression, @NotNull BindingTrace trace) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "canInstantiateAnnotationClass"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "canInstantiateAnnotationClass"));
        }
        Object parent2 = PsiTreeUtil.getParentOfType((PsiElement)expression, KtValueArgument.class, KtParameter.class);
        if (parent2 instanceof KtValueArgument) {
            if (PsiTreeUtil.getParentOfType(parent2, KtAnnotationEntry.class) != null) {
                return true;
            }
            if ((parent2 = PsiTreeUtil.getParentOfType(parent2, KtParameter.class)) != null) {
                return CallExpressionResolver.isUnderAnnotationClassDeclaration(trace, parent2);
            }
        } else if (parent2 instanceof KtParameter) {
            return CallExpressionResolver.isUnderAnnotationClassDeclaration(trace, parent2);
        }
        return false;
    }

    private static boolean isUnderAnnotationClassDeclaration(@NotNull BindingTrace trace, PsiElement parent2) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "isUnderAnnotationClassDeclaration"));
        }
        KtClass ktClass = PsiTreeUtil.getParentOfType(parent2, KtClass.class);
        if (ktClass != null) {
            DeclarationDescriptor descriptor2 = trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, ktClass);
            return DescriptorUtils.isAnnotationClass(descriptor2);
        }
        return false;
    }

    @NotNull
    private KotlinTypeInfo getSelectorReturnTypeInfo(@NotNull Receiver receiver, @Nullable ASTNode callOperationNode, @Nullable KtExpression selectorExpression, @NotNull ExpressionTypingContext context, @NotNull DataFlowInfo initialDataFlowInfoForArguments) {
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getSelectorReturnTypeInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getSelectorReturnTypeInfo"));
        }
        if (initialDataFlowInfoForArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialDataFlowInfoForArguments", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getSelectorReturnTypeInfo"));
        }
        if (selectorExpression instanceof KtCallExpression) {
            KotlinTypeInfo kotlinTypeInfo = this.getCallExpressionTypeInfoWithoutFinalTypeCheck((KtCallExpression)selectorExpression, receiver, callOperationNode, context, initialDataFlowInfoForArguments);
            if (kotlinTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getSelectorReturnTypeInfo"));
            }
            return kotlinTypeInfo;
        }
        if (selectorExpression instanceof KtSimpleNameExpression) {
            KotlinTypeInfo kotlinTypeInfo = this.getSimpleNameExpressionTypeInfo((KtSimpleNameExpression)selectorExpression, receiver, callOperationNode, context, initialDataFlowInfoForArguments);
            if (kotlinTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getSelectorReturnTypeInfo"));
            }
            return kotlinTypeInfo;
        }
        if (selectorExpression != null) {
            this.expressionTypingServices.getTypeInfo(selectorExpression, context);
            context.trace.report(Errors.ILLEGAL_SELECTOR.on(selectorExpression, selectorExpression.getText()));
        }
        KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(context);
        if (kotlinTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getSelectorReturnTypeInfo"));
        }
        return kotlinTypeInfo;
    }

    public static void reportUnnecessarySafeCall(@NotNull BindingTrace trace, @NotNull KotlinType type2, @NotNull ASTNode callOperationNode, @Nullable Receiver explicitReceiver) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "reportUnnecessarySafeCall"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "reportUnnecessarySafeCall"));
        }
        if (callOperationNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callOperationNode", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "reportUnnecessarySafeCall"));
        }
        if (explicitReceiver instanceof ExpressionReceiver && ((ExpressionReceiver)explicitReceiver).getExpression() instanceof KtSuperExpression) {
            trace.report(Errors.UNEXPECTED_SAFE_CALL.on(callOperationNode.getPsi()));
        } else {
            trace.report(Errors.UNNECESSARY_SAFE_CALL.on(callOperationNode.getPsi(), type2));
        }
    }

    @NotNull
    public KotlinTypeInfo getQualifiedExpressionTypeInfo(@NotNull KtQualifiedExpression expression, final @NotNull ExpressionTypingContext context) {
        DataFlowInfo receiverDataFlowInfo;
        KotlinType receiverType;
        KotlinTypeInfo receiverTypeInfo;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getQualifiedExpressionTypeInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getQualifiedExpressionTypeInfo"));
        }
        ExpressionTypingContext currentContext = (ExpressionTypingContext)((ExpressionTypingContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        BindingTrace trace = currentContext.trace;
        Function1<KtSimpleNameExpression, Boolean> isValueFunction = new Function1<KtSimpleNameExpression, Boolean>(){

            @Override
            public Boolean invoke(KtSimpleNameExpression nameExpression) {
                TemporaryTraceAndCache temporaryForVariable = TemporaryTraceAndCache.create(context, "trace to resolve as local variable or property", nameExpression);
                Call call = CallMaker.makePropertyCall(null, null, nameExpression);
                BasicCallResolutionContext contextForVariable = BasicCallResolutionContext.create(context.replaceTraceAndCache(temporaryForVariable), call, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS);
                OverloadResolutionResults<VariableDescriptor> resolutionResult = CallExpressionResolver.this.callResolver.resolveSimpleProperty(contextForVariable);
                if (resolutionResult.isSingleResult() && resolutionResult.getResultingDescriptor() instanceof FakeCallableDescriptorForObject) {
                    return false;
                }
                OverloadResolutionResults.Code resultCode = resolutionResult.getResultCode();
                return resultCode != OverloadResolutionResults.Code.NAME_NOT_FOUND && resultCode != OverloadResolutionResults.Code.CANDIDATES_WITH_WRONG_RECEIVER;
            }
        };
        List<CallExpressionElement> elementChain = this.qualifiedExpressionResolver.resolveQualifierInExpressionAndUnroll(expression, context, (Function1<? super KtSimpleNameExpression, Boolean>)isValueFunction);
        CallExpressionElement firstElement = elementChain.iterator().next();
        KtExpression firstReceiver = firstElement.getReceiver();
        Qualifier firstQualifier = trace.get(BindingContext.QUALIFIER, firstReceiver);
        if (firstQualifier == null) {
            receiverTypeInfo = this.expressionTypingServices.getTypeInfo(firstReceiver, currentContext);
            receiverType = receiverTypeInfo.getType();
            receiverDataFlowInfo = receiverTypeInfo.getDataFlowInfo();
        } else {
            receiverType = null;
            receiverDataFlowInfo = currentContext.dataFlowInfo;
            receiverTypeInfo = new KotlinTypeInfo(receiverType, receiverDataFlowInfo);
        }
        KotlinTypeInfo resultTypeInfo = receiverTypeInfo;
        boolean unconditional = true;
        DataFlowInfo unconditionalDataFlowInfo = receiverDataFlowInfo;
        for (CallExpressionElement element : elementChain) {
            QualifierReceiver qualifierReceiver;
            if (receiverType == null) {
                receiverType = ErrorUtils.createErrorType("Type for " + expression.getText());
            }
            QualifierReceiver receiver = (qualifierReceiver = (QualifierReceiver)trace.get(BindingContext.QUALIFIER, element.getReceiver())) == null ? ExpressionReceiver.Companion.create(element.getReceiver(), receiverType, trace.getBindingContext()) : qualifierReceiver;
            boolean lastStage = element.getQualified() == expression;
            ExpressionTypingContext contextForSelector = lastStage ? context : currentContext;
            contextForSelector = TypeUtils.isNullableType(receiverType) && !element.getSafe() ? (ExpressionTypingContext)contextForSelector.replaceDataFlowInfo(unconditionalDataFlowInfo) : (ExpressionTypingContext)contextForSelector.replaceDataFlowInfo(receiverDataFlowInfo);
            DataFlowInfo initialDataFlowInfoForArguments = contextForSelector.dataFlowInfo;
            if (receiver instanceof ReceiverValue) {
                DataFlowValue receiverDataFlowValue = DataFlowValueFactory.createDataFlowValue((ReceiverValue)((Object)receiver), context);
                if (element.getSafe()) {
                    if (initialDataFlowInfoForArguments.getPredictableNullability(receiverDataFlowValue).canBeNull()) {
                        initialDataFlowInfoForArguments = initialDataFlowInfoForArguments.disequate(receiverDataFlowValue, DataFlowValue.nullValue(this.builtIns));
                    } else {
                        CallExpressionResolver.reportUnnecessarySafeCall(trace, receiverType, element.getNode(), receiver);
                    }
                }
            }
            KtExpression selectorExpression = element.getSelector();
            KotlinTypeInfo selectorReturnTypeInfo = this.getSelectorReturnTypeInfo(receiver, element.getNode(), selectorExpression, contextForSelector, initialDataFlowInfoForArguments);
            KotlinType selectorReturnType = selectorReturnTypeInfo.getType();
            if (qualifierReceiver != null) {
                this.resolveDeferredReceiverInQualifiedExpression(qualifierReceiver, element.getQualified(), contextForSelector);
            }
            CallExpressionResolver.checkNestedClassAccess(element.getQualified(), contextForSelector);
            boolean safeCall = element.getSafe();
            if (safeCall && selectorReturnType != null && TypeUtils.isNullableType(receiverType)) {
                selectorReturnType = TypeUtils.makeNullable(selectorReturnType);
                selectorReturnTypeInfo = selectorReturnTypeInfo.replaceType(selectorReturnType);
            }
            if (selectorExpression != null && selectorReturnType != null) {
                trace.recordType(selectorExpression, selectorReturnType);
            }
            resultTypeInfo = selectorReturnTypeInfo;
            CompileTimeConstant<?> value = this.constantExpressionEvaluator.evaluateExpression(element.getQualified(), trace, contextForSelector.expectedType);
            if (value != null && value.isPure()) {
                resultTypeInfo = this.dataFlowAnalyzer.createCompileTimeConstantTypeInfo(value, element.getQualified(), contextForSelector);
                if (lastStage) {
                    KotlinTypeInfo kotlinTypeInfo = resultTypeInfo;
                    if (kotlinTypeInfo == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getQualifiedExpressionTypeInfo"));
                    }
                    return kotlinTypeInfo;
                }
            }
            if (contextForSelector.contextDependency == ContextDependency.INDEPENDENT) {
                this.dataFlowAnalyzer.checkType(resultTypeInfo.getType(), (KtExpression)element.getQualified(), (ResolutionContext)contextForSelector);
            }
            receiverTypeInfo = selectorReturnTypeInfo;
            receiverType = selectorReturnType;
            receiverDataFlowInfo = receiverTypeInfo.getDataFlowInfo();
            if (safeCall) {
                unconditional = false;
            } else if (unconditional) {
                unconditionalDataFlowInfo = receiverDataFlowInfo;
            }
            if (lastStage || trace.get(BindingContext.PROCESSED, element.getQualified()).booleanValue()) continue;
            trace.record(BindingContext.PROCESSED, element.getQualified());
            trace.record(BindingContext.EXPRESSION_TYPE_INFO, element.getQualified(), resultTypeInfo.replaceDataFlowInfo(unconditionalDataFlowInfo));
            BindingContextUtilsKt.recordScope(trace, contextForSelector.scope, element.getQualified());
            BindingContextUtilsKt.recordDataFlowInfo(contextForSelector.replaceDataFlowInfo(unconditionalDataFlowInfo), element.getQualified());
        }
        KotlinTypeInfo kotlinTypeInfo = resultTypeInfo.replaceDataFlowInfo(unconditionalDataFlowInfo);
        if (kotlinTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getQualifiedExpressionTypeInfo"));
        }
        return kotlinTypeInfo;
    }

    private void resolveDeferredReceiverInQualifiedExpression(@NotNull QualifierReceiver qualifierReceiver, @NotNull KtQualifiedExpression qualifiedExpression, @NotNull ExpressionTypingContext context) {
        if (qualifierReceiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierReceiver", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "resolveDeferredReceiverInQualifiedExpression"));
        }
        if (qualifiedExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedExpression", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "resolveDeferredReceiverInQualifiedExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "resolveDeferredReceiverInQualifiedExpression"));
        }
        KtExpression calleeExpression = KtPsiUtil.deparenthesize(CallUtilKt.getCalleeExpressionIfAny(qualifiedExpression.getSelectorExpression()));
        DeclarationDescriptor selectorDescriptor = calleeExpression instanceof KtReferenceExpression ? context.trace.get(BindingContext.REFERENCE_TARGET, (KtReferenceExpression)calleeExpression) : null;
        QualifiedExpressionResolveUtilKt.resolveQualifierAsReceiverInExpression(qualifierReceiver, selectorDescriptor, context, this.symbolUsageValidator);
    }

    private static void checkNestedClassAccess(@NotNull KtQualifiedExpression expression, @NotNull ExpressionTypingContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "checkNestedClassAccess"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "checkNestedClassAccess"));
        }
        KtExpression selectorExpression = expression.getSelectorExpression();
        if (selectorExpression == null) {
            return;
        }
        Qualifier expressionQualifier = context.trace.get(BindingContext.QUALIFIER, expression);
        Qualifier receiverQualifier = context.trace.get(BindingContext.QUALIFIER, expression.getReceiverExpression());
        if (receiverQualifier == null && expressionQualifier != null) {
            assert (expressionQualifier instanceof ClassQualifier) : "Only class can (package cannot) be accessed by instance reference: " + expressionQualifier;
            context.trace.report(Errors.NESTED_CLASS_ACCESSED_VIA_INSTANCE_REFERENCE.on(selectorExpression, ((ClassQualifier)expressionQualifier).getClassifier()));
        }
    }
}

