/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LineTokenizer {
    private int myOffset;
    private int myLength;
    private int myLineSeparatorLength;
    private boolean atEnd;
    private final CharSequence myText;

    @NotNull
    public static String[] tokenize(CharSequence chars, boolean includeSeparators) {
        String[] stringArray = LineTokenizer.tokenize(chars, includeSeparators, true);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/LineTokenizer", "tokenize"));
        }
        return stringArray;
    }

    @NotNull
    private static String[] tokenize(CharSequence chars, boolean includeSeparators, boolean skipLastEmptyLine) {
        List<String> strings = LineTokenizer.tokenizeIntoList(chars, includeSeparators, skipLastEmptyLine);
        String[] stringArray = strings.isEmpty() ? ArrayUtil.EMPTY_STRING_ARRAY : ArrayUtil.toStringArray(strings);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/LineTokenizer", "tokenize"));
        }
        return stringArray;
    }

    @NotNull
    public static List<String> tokenizeIntoList(CharSequence chars, boolean includeSeparators, boolean skipLastEmptyLine) {
        if (chars == null || chars.length() == 0) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/LineTokenizer", "tokenizeIntoList"));
            }
            return list2;
        }
        LineTokenizer tokenizer = new LineTokenizer(chars);
        ArrayList<String> lines = new ArrayList<String>();
        while (!tokenizer.atEnd()) {
            int offset2 = tokenizer.getOffset();
            String line = includeSeparators ? chars.subSequence(offset2, offset2 + tokenizer.getLength() + tokenizer.getLineSeparatorLength()).toString() : chars.subSequence(offset2, offset2 + tokenizer.getLength()).toString();
            lines.add(line);
            tokenizer.advance();
        }
        if (!skipLastEmptyLine && LineTokenizer.stringEndsWithSeparator(tokenizer)) {
            lines.add("");
        }
        ArrayList<String> arrayList = lines;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/LineTokenizer", "tokenizeIntoList"));
        }
        return arrayList;
    }

    private static boolean stringEndsWithSeparator(@NotNull LineTokenizer tokenizer) {
        if (tokenizer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tokenizer", "com/intellij/openapi/util/text/LineTokenizer", "stringEndsWithSeparator"));
        }
        return tokenizer.getLineSeparatorLength() > 0;
    }

    public LineTokenizer(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/LineTokenizer", "<init>"));
        }
        this.myText = text;
        this.myOffset = 0;
        this.advance();
    }

    public final boolean atEnd() {
        return this.atEnd;
    }

    public final int getOffset() {
        return this.myOffset;
    }

    public final int getLength() {
        return this.myLength;
    }

    public final int getLineSeparatorLength() {
        return this.myLineSeparatorLength;
    }

    public void advance() {
        char c;
        int i = this.myOffset + this.myLength + this.myLineSeparatorLength;
        int textLength = this.myText.length();
        if (i >= textLength) {
            this.atEnd = true;
            return;
        }
        while (i < textLength && (c = this.myText.charAt(i)) != '\r' && c != '\n') {
            ++i;
        }
        this.myOffset += this.myLength + this.myLineSeparatorLength;
        this.myLength = i - this.myOffset;
        this.myLineSeparatorLength = 0;
        if (i == textLength) {
            return;
        }
        char first = this.myText.charAt(i);
        if (first == '\r' || first == '\n') {
            this.myLineSeparatorLength = 1;
        }
        if (++i == textLength) {
            return;
        }
        char second = this.myText.charAt(i);
        if (first == '\r' && second == '\n') {
            this.myLineSeparatorLength = 2;
        }
    }
}

