/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import java.util.HashSet;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.types.DelegatingType;
import org.jetbrains.kotlin.types.Flexibility;
import org.jetbrains.kotlin.types.FlexibleTypeCapabilities;
import org.jetbrains.kotlin.types.FlexibleTypeDelegation;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.NullAwareness;
import org.jetbrains.kotlin.types.SubtypingRepresentatives;
import org.jetbrains.kotlin.types.TypeCapability;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000 #2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001#B\u001f\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0014\u001a\u00020\fH\u0016J'\u0010\u0015\u001a\u0004\u0018\u0001H\u0016\"\b\b\u0000\u0010\u0016*\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0019H\u0016\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u0006H\u0014J\b\u0010\u001c\u001a\u00020\fH\u0016J\u0010\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\fH\u0016J\b\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\"H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0014\u0010\u0007\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000f\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/types/DelegatingFlexibleType;", "Lorg/jetbrains/kotlin/types/DelegatingType;", "Lorg/jetbrains/kotlin/types/NullAwareness;", "Lorg/jetbrains/kotlin/types/Flexibility;", "Lorg/jetbrains/kotlin/types/FlexibleTypeDelegation;", "lowerBound", "Lorg/jetbrains/kotlin/types/KotlinType;", "upperBound", "extraCapabilities", "Lorg/jetbrains/kotlin/types/FlexibleTypeCapabilities;", "(Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/types/FlexibleTypeCapabilities;)V", "assertionsDone", "", "delegateType", "getDelegateType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "getExtraCapabilities", "()Lorg/jetbrains/kotlin/types/FlexibleTypeCapabilities;", "getLowerBound", "getUpperBound", "computeIsNullable", "getCapability", "T", "Lorg/jetbrains/kotlin/types/TypeCapability;", "capabilityClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Lorg/jetbrains/kotlin/types/TypeCapability;", "getDelegate", "isMarkedNullable", "makeNullableAsSpecified", "nullable", "runAssertions", "", "toString", "", "Companion", "kotlin-compiler"})
public class DelegatingFlexibleType
extends DelegatingType
implements Flexibility,
FlexibleTypeDelegation,
NullAwareness {
    private boolean assertionsDone;
    @NotNull
    private final KotlinType lowerBound;
    @NotNull
    private final KotlinType upperBound;
    @NotNull
    private final FlexibleTypeCapabilities extraCapabilities;
    @NotNull
    private static final HashSet<Class<? extends TypeCapability>> capabilityClasses;
    @JvmField
    public static boolean RUN_SLOW_ASSERTIONS;
    public static final Companion Companion;

    private final void runAssertions() {
        Unit unit;
        Unit unit2;
        Unit unit3;
        Unit unit4;
        if (!RUN_SLOW_ASSERTIONS || this.assertionsDone) {
            return;
        }
        this.assertionsDone = true;
        boolean bl = !FlexibleTypesKt.isFlexible(this.getLowerBound());
        if (_Assertions.ENABLED) {
            if (!bl) {
                String string = "Lower bound of a flexible type can not be flexible: " + this.getLowerBound();
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            unit4 = Unit.INSTANCE;
        } else {
            unit4 = Unit.INSTANCE;
        }
        bl = !FlexibleTypesKt.isFlexible(this.getUpperBound());
        if (_Assertions.ENABLED) {
            if (!bl) {
                String string = "Upper bound of a flexible type can not be flexible: " + this.getUpperBound();
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            unit3 = Unit.INSTANCE;
        } else {
            unit3 = Unit.INSTANCE;
        }
        bl = Intrinsics.areEqual(this.getLowerBound(), this.getUpperBound()) ^ true;
        if (_Assertions.ENABLED) {
            if (!bl) {
                String string = "Lower and upper bounds are equal: " + this.getLowerBound() + " == " + this.getUpperBound();
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            unit2 = Unit.INSTANCE;
        } else {
            unit2 = Unit.INSTANCE;
        }
        bl = KotlinTypeChecker.DEFAULT.isSubtypeOf(this.getLowerBound(), this.getUpperBound());
        if (_Assertions.ENABLED) {
            if (!bl) {
                String string = "Lower bound " + this.getLowerBound() + " of a flexible type must be a subtype of the upper bound " + this.getUpperBound();
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
    }

    @Override
    @Nullable
    public <T extends TypeCapability> T getCapability(@NotNull Class<T> capabilityClass) {
        Intrinsics.checkParameterIsNotNull(capabilityClass, "capabilityClass");
        T extra = this.getExtraCapabilities().getCapability(capabilityClass, this, this);
        if (extra != null) {
            return extra;
        }
        if (Companion.getCapabilityClasses$kotlin_compiler().contains(capabilityClass)) {
            DelegatingFlexibleType delegatingFlexibleType = this;
            if (delegatingFlexibleType == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            return (T)delegatingFlexibleType;
        }
        return super.getCapability(capabilityClass);
    }

    @Override
    @NotNull
    public KotlinType makeNullableAsSpecified(boolean nullable2) {
        KotlinType kotlinType = TypeUtils.makeNullableAsSpecified(this.getLowerBound(), nullable2);
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "TypeUtils.makeNullableAs\u2026ied(lowerBound, nullable)");
        KotlinType kotlinType2 = TypeUtils.makeNullableAsSpecified(this.getUpperBound(), nullable2);
        Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "TypeUtils.makeNullableAs\u2026ied(upperBound, nullable)");
        return Companion.create(kotlinType, kotlinType2, this.getExtraCapabilities());
    }

    @Override
    public boolean computeIsNullable() {
        return this.getDelegateType().isMarkedNullable();
    }

    @Override
    public boolean isMarkedNullable() {
        NullAwareness nullAwareness = this.getCapability(NullAwareness.class);
        if (nullAwareness == null) {
            Intrinsics.throwNpe();
        }
        return nullAwareness.computeIsNullable();
    }

    @Override
    @NotNull
    public KotlinType getDelegateType() {
        this.runAssertions();
        return this.getLowerBound();
    }

    @Override
    @NotNull
    protected KotlinType getDelegate() {
        FlexibleTypeDelegation flexibleTypeDelegation = this.getCapability(FlexibleTypeDelegation.class);
        if (flexibleTypeDelegation == null) {
            Intrinsics.throwNpe();
        }
        return flexibleTypeDelegation.getDelegateType();
    }

    @Override
    @NotNull
    public String toString() {
        return "('" + this.getLowerBound() + "'..'" + this.getUpperBound() + "')";
    }

    @Override
    @NotNull
    public KotlinType getLowerBound() {
        return this.lowerBound;
    }

    @Override
    @NotNull
    public KotlinType getUpperBound() {
        return this.upperBound;
    }

    @Override
    @NotNull
    public FlexibleTypeCapabilities getExtraCapabilities() {
        return this.extraCapabilities;
    }

    protected DelegatingFlexibleType(@NotNull KotlinType lowerBound, @NotNull KotlinType upperBound, @NotNull FlexibleTypeCapabilities extraCapabilities) {
        Intrinsics.checkParameterIsNotNull(lowerBound, "lowerBound");
        Intrinsics.checkParameterIsNotNull(upperBound, "upperBound");
        Intrinsics.checkParameterIsNotNull(extraCapabilities, "extraCapabilities");
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.extraCapabilities = extraCapabilities;
    }

    static {
        Companion = new Companion(null);
        capabilityClasses = SetsKt.hashSetOf(NullAwareness.class, Flexibility.class, SubtypingRepresentatives.class, FlexibleTypeDelegation.class);
    }

    @Override
    @NotNull
    public KotlinType getSubTypeRepresentative() {
        return Flexibility.DefaultImpls.getSubTypeRepresentative(this);
    }

    @Override
    @NotNull
    public KotlinType getSuperTypeRepresentative() {
        return Flexibility.DefaultImpls.getSuperTypeRepresentative(this);
    }

    @Override
    public boolean sameTypeConstructor(@NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        return Flexibility.DefaultImpls.sameTypeConstructor(this, type2);
    }

    @JvmStatic
    @NotNull
    public static final KotlinType create(@NotNull KotlinType lowerBound, @NotNull KotlinType upperBound, @NotNull FlexibleTypeCapabilities extraCapabilities) {
        Intrinsics.checkParameterIsNotNull(lowerBound, "lowerBound");
        Intrinsics.checkParameterIsNotNull(upperBound, "upperBound");
        Intrinsics.checkParameterIsNotNull(extraCapabilities, "extraCapabilities");
        return Companion.create(lowerBound, upperBound, extraCapabilities);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007R\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/types/DelegatingFlexibleType$Companion;", "", "()V", "RUN_SLOW_ASSERTIONS", "", "capabilityClasses", "Ljava/util/HashSet;", "Ljava/lang/Class;", "Lorg/jetbrains/kotlin/types/TypeCapability;", "getCapabilityClasses$kotlin_compiler", "()Ljava/util/HashSet;", "create", "Lorg/jetbrains/kotlin/types/KotlinType;", "lowerBound", "upperBound", "extraCapabilities", "Lorg/jetbrains/kotlin/types/FlexibleTypeCapabilities;", "kotlin-compiler"})
    public static final class Companion {
        @NotNull
        public final HashSet<Class<? extends TypeCapability>> getCapabilityClasses$kotlin_compiler() {
            return capabilityClasses;
        }

        @JvmStatic
        @NotNull
        public final KotlinType create(@NotNull KotlinType lowerBound, @NotNull KotlinType upperBound, @NotNull FlexibleTypeCapabilities extraCapabilities) {
            Intrinsics.checkParameterIsNotNull(lowerBound, "lowerBound");
            Intrinsics.checkParameterIsNotNull(upperBound, "upperBound");
            Intrinsics.checkParameterIsNotNull(extraCapabilities, "extraCapabilities");
            if (Intrinsics.areEqual(lowerBound, upperBound)) {
                return lowerBound;
            }
            return new DelegatingFlexibleType(lowerBound, upperBound, extraCapabilities);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

