/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.ReadOnlyModificationException;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.openapi.editor.impl.LineSet;
import com.intellij.openapi.editor.impl.PersistentRangeMarker;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.ImmutableText;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocumentImpl
extends UserDataHolderBase
implements DocumentEx {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.editor.impl.DocumentImpl");
    private final Ref<DocumentListener[]> myCachedDocumentListeners;
    private final List<DocumentListener> myDocumentListeners;
    private final RangeMarkerTree<RangeMarkerEx> myRangeMarkers;
    private final RangeMarkerTree<RangeMarkerEx> myPersistentRangeMarkers;
    private final List<RangeMarker> myGuardedBlocks;
    private final Object myLineSetLock;
    private volatile LineSet myLineSet;
    private volatile ImmutableText myText;
    private volatile SoftReference<String> myTextString;
    private volatile FrozenDocument myFrozen;
    private boolean myIsReadOnly;
    private volatile boolean isStripTrailingSpacesEnabled;
    private volatile long myModificationStamp;
    private final PropertyChangeSupport myPropertyChangeSupport;
    private final List<Object> myReadOnlyListeners;
    private volatile boolean myMightContainTabs;
    private int myTabTrackingRequestors;
    private int myCheckGuardedBlocks;
    private boolean myGuardsSuppressed;
    private boolean myEventsHandling;
    private final boolean myAssertThreading;
    private volatile boolean myDoingBulkUpdate;
    private volatile boolean myAcceptSlashR;
    private boolean myChangeInProgress;
    private volatile int myBufferSize;
    private final CharSequence myMutableCharSequence;

    public DocumentImpl(@NotNull CharSequence chars) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/openapi/editor/impl/DocumentImpl", "<init>"));
        }
        this(chars, false);
    }

    public DocumentImpl(@NotNull CharSequence chars, boolean forUseInNonAWTThread) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/openapi/editor/impl/DocumentImpl", "<init>"));
        }
        this(chars, false, forUseInNonAWTThread);
    }

    public DocumentImpl(@NotNull CharSequence chars, boolean acceptSlashR, boolean forUseInNonAWTThread) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/openapi/editor/impl/DocumentImpl", "<init>"));
        }
        this.myCachedDocumentListeners = Ref.create(null);
        this.myDocumentListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myRangeMarkers = new RangeMarkerTree(this);
        this.myPersistentRangeMarkers = new RangeMarkerTree(this);
        this.myGuardedBlocks = new ArrayList<RangeMarker>();
        this.myLineSetLock = new String("line set lock");
        this.myIsReadOnly = false;
        this.isStripTrailingSpacesEnabled = true;
        this.myPropertyChangeSupport = new PropertyChangeSupport(this);
        this.myReadOnlyListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myMightContainTabs = true;
        this.myTabTrackingRequestors = 0;
        this.myCheckGuardedBlocks = 0;
        this.myGuardsSuppressed = false;
        this.myEventsHandling = false;
        this.myDoingBulkUpdate = false;
        this.myAcceptSlashR = false;
        this.myMutableCharSequence = new CharSequence(){

            @Override
            public int length() {
                return DocumentImpl.this.myText.length();
            }

            @Override
            public char charAt(int index2) {
                return DocumentImpl.this.myText.charAt(index2);
            }

            @Override
            public CharSequence subSequence(int start, int end) {
                return DocumentImpl.this.myText.subSequence(start, end);
            }

            @Override
            @NotNull
            public String toString() {
                String string = DocumentImpl.this.doGetText();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl$1", "toString"));
                }
                return string;
            }
        };
        this.setAcceptSlashR(acceptSlashR);
        this.assertValidSeparators(chars);
        this.myText = ImmutableText.valueOf((Object)chars);
        this.setCyclicBufferSize(0);
        this.setModificationStamp(LocalTimeCounter.currentTime());
        this.myAssertThreading = !forUseInNonAWTThread;
    }

    public boolean setAcceptSlashR(boolean accept) {
        try {
            boolean bl = this.myAcceptSlashR;
            return bl;
        }
        finally {
            this.myAcceptSlashR = accept;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LineSet getLineSet() {
        LineSet lineSet = this.myLineSet;
        if (lineSet == null) {
            Object object = this.myLineSetLock;
            synchronized (object) {
                lineSet = this.myLineSet;
                if (lineSet == null) {
                    this.myLineSet = lineSet = LineSet.createLineSet(this.myText);
                }
            }
        }
        return lineSet;
    }

    @Override
    public void setReadOnly(boolean isReadOnly) {
        if (this.myIsReadOnly != isReadOnly) {
            this.myIsReadOnly = isReadOnly;
            this.myPropertyChangeSupport.firePropertyChange("writable", !isReadOnly, isReadOnly);
        }
    }

    @Override
    public boolean isWritable() {
        return !this.myIsReadOnly;
    }

    private RangeMarkerTree<RangeMarkerEx> treeFor(@NotNull RangeMarkerEx rangeMarker) {
        if (rangeMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeMarker", "com/intellij/openapi/editor/impl/DocumentImpl", "treeFor"));
        }
        return rangeMarker instanceof PersistentRangeMarker ? this.myPersistentRangeMarkers : this.myRangeMarkers;
    }

    @Override
    public boolean removeRangeMarker(@NotNull RangeMarkerEx rangeMarker) {
        if (rangeMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeMarker", "com/intellij/openapi/editor/impl/DocumentImpl", "removeRangeMarker"));
        }
        return this.treeFor(rangeMarker).removeInterval(rangeMarker);
    }

    public RangeMarker getRangeGuard(int start, int end) {
        for (RangeMarker block : this.myGuardedBlocks) {
            if (!DocumentImpl.rangesIntersect(start, true, block.getStartOffset(), block.isGreedyToLeft(), end, true, block.getEndOffset(), block.isGreedyToRight())) continue;
            return block;
        }
        return null;
    }

    private static boolean rangesIntersect(int start0, boolean leftInclusive0, int start1, boolean leftInclusive1, int end0, boolean rightInclusive0, int end1, boolean rightInclusive1) {
        if (start0 > start1 || start0 == start1 && !leftInclusive0) {
            return DocumentImpl.rangesIntersect(start1, leftInclusive1, start0, leftInclusive0, end1, rightInclusive1, end0, rightInclusive0);
        }
        if (end0 == start1) {
            return leftInclusive1 && rightInclusive0;
        }
        return end0 > start1;
    }

    @Override
    public long getModificationStamp() {
        return this.myModificationStamp;
    }

    @Override
    public void setModificationStamp(long modificationStamp) {
        this.myModificationStamp = modificationStamp;
    }

    private void trimToSize() {
        if (this.myBufferSize != 0 && this.getTextLength() > this.myBufferSize) {
            this.deleteString(0, this.getTextLength() - this.myBufferSize);
        }
    }

    public void deleteString(int startOffset, int endOffset) {
        this.assertBounds(startOffset, endOffset);
        this.assertWriteAccess();
        if (!this.isWritable()) {
            throw new ReadOnlyModificationException(this);
        }
        if (startOffset == endOffset) {
            return;
        }
        RangeMarker marker = this.getRangeGuard(startOffset, endOffset);
        if (marker != null) {
            this.throwGuardedFragment(marker, startOffset, this.myText.subSequence(startOffset, endOffset).toString(), null);
        }
        this.myText = this.myText.ensureChunked();
        this.updateText(this.myText.delete(startOffset, endOffset), startOffset, this.myText.subtext(startOffset, endOffset), null, false, LocalTimeCounter.currentTime(), startOffset, endOffset - startOffset);
    }

    @Override
    public void replaceString(int startOffset, int endOffset, @NotNull CharSequence s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/editor/impl/DocumentImpl", "replaceString"));
        }
        this.replaceString(startOffset, endOffset, s, LocalTimeCounter.currentTime(), false);
    }

    private void replaceString(int startOffset, int endOffset, @NotNull CharSequence s, long newModificationStamp, boolean bl) {
        ImmutableText newText;
        boolean wholeTextReplaced;
        int newStartInString;
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/editor/impl/DocumentImpl", "replaceString"));
        }
        this.assertBounds(startOffset, endOffset);
        this.assertWriteAccess();
        this.assertValidSeparators(s);
        if (!this.isWritable()) {
            throw new ReadOnlyModificationException(this);
        }
        int initialStartOffset = startOffset;
        int initialOldLength = endOffset - startOffset;
        int newStringLength = s.length();
        ImmutableText chars = this.myText;
        int newEndInString = newStringLength;
        for (newStartInString = 0; newStartInString < newStringLength && startOffset < endOffset && s.charAt(newStartInString) == chars.charAt(startOffset); ++startOffset, ++newStartInString) {
        }
        while (endOffset > startOffset && newEndInString > newStartInString && s.charAt(newEndInString - 1) == chars.charAt(endOffset - 1)) {
            --newEndInString;
            --endOffset;
        }
        if (startOffset == 0 && endOffset == this.getTextLength()) {
            wholeTextReplaced = true;
        }
        CharSequence changedPart = s.subSequence(newStartInString, newEndInString);
        ImmutableText sToDelete = this.myText.subtext(startOffset, endOffset);
        RangeMarker guard = this.getRangeGuard(startOffset, endOffset);
        if (guard != null) {
            this.throwGuardedFragment(guard, startOffset, sToDelete.toString(), changedPart.toString());
        }
        if (wholeTextReplaced && s instanceof ImmutableText) {
            newText = (ImmutableText)s;
        } else {
            this.myText = this.myText.ensureChunked();
            newText = this.myText.delete(startOffset, endOffset).insert(startOffset, changedPart);
            changedPart = newText.subtext(startOffset, startOffset + changedPart.length());
        }
        this.updateText(newText, startOffset, sToDelete, changedPart, wholeTextReplaced, newModificationStamp, initialStartOffset, initialOldLength);
        this.trimToSize();
    }

    private void assertBounds(int startOffset, int endOffset) {
        if (startOffset < 0 || startOffset > this.getTextLength()) {
            throw new IndexOutOfBoundsException("Wrong startOffset: " + startOffset + "; documentLength: " + this.getTextLength());
        }
        if (endOffset < 0 || endOffset > this.getTextLength()) {
            throw new IndexOutOfBoundsException("Wrong endOffset: " + endOffset + "; documentLength: " + this.getTextLength());
        }
        if (endOffset < startOffset) {
            throw new IllegalArgumentException("endOffset < startOffset: " + endOffset + " < " + startOffset + "; documentLength: " + this.getTextLength());
        }
    }

    private void assertWriteAccess() {
        Application application;
        if (this.myAssertThreading && (application = ApplicationManager.getApplication()) != null) {
            application.assertWriteAccessAllowed();
        }
    }

    private void assertValidSeparators(@NotNull CharSequence s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/editor/impl/DocumentImpl", "assertValidSeparators"));
        }
        if (this.myAcceptSlashR) {
            return;
        }
        StringUtil.assertValidSeparators(s);
    }

    private void assertNotNestedModification() throws IllegalStateException {
        if (this.myChangeInProgress) {
            throw new IllegalStateException("Detected document modification from DocumentListener");
        }
    }

    private void throwGuardedFragment(@NotNull RangeMarker guard, int offset2, String oldString, String newString) {
        if (guard == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "guard", "com/intellij/openapi/editor/impl/DocumentImpl", "throwGuardedFragment"));
        }
        if (this.myCheckGuardedBlocks > 0 && !this.myGuardsSuppressed) {
            DocumentEventImpl event = new DocumentEventImpl(this, offset2, oldString, newString, this.myModificationStamp, false);
            throw new ReadOnlyFragmentModificationException(event, guard);
        }
    }

    @Override
    public void suppressGuardedExceptions() {
        this.myGuardsSuppressed = true;
    }

    @Override
    public void unSuppressGuardedExceptions() {
        this.myGuardsSuppressed = false;
    }

    @Override
    public boolean isInEventsHandling() {
        return this.myEventsHandling;
    }

    public void clearLineModificationFlags() {
        this.myLineSet = this.getLineSet().clearModificationFlags();
        this.myFrozen = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void updateText(@NotNull ImmutableText newText, int offset2, @Nullable CharSequence oldString, @Nullable CharSequence newString, boolean wholeTextReplaced, long newModificationStamp, int initialStartOffset, int n) {
        if (newText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newText", "com/intellij/openapi/editor/impl/DocumentImpl", "updateText"));
        }
        this.assertNotNestedModification();
        boolean enableRecursiveModifications = Registry.is("enable.recursive.document.changes");
        this.myChangeInProgress = true;
        try {
            void initialOldLength;
            DocumentEventImpl event = new DocumentEventImpl(this, offset2, oldString, newString, this.myModificationStamp, wholeTextReplaced, initialStartOffset, (int)initialOldLength);
            try {
                this.doBeforeChangedUpdate(event);
            }
            finally {
                if (enableRecursiveModifications) {
                    this.myChangeInProgress = false;
                }
            }
            this.myTextString = null;
            ImmutableText prevText = this.myText;
            this.myText = newText;
            this.changedUpdate(event, newModificationStamp, prevText);
        }
        finally {
            if (!enableRecursiveModifications) {
                this.myChangeInProgress = false;
            }
        }
    }

    private void doBeforeChangedUpdate(DocumentEvent event) {
        FileDocumentManager manager;
        VirtualFile file;
        Application app = ApplicationManager.getApplication();
        if (app != null && (file = (manager = FileDocumentManager.getInstance()).getFile(this)) != null && !file.isValid()) {
            LOG.error("File of this document has been deleted.");
        }
        this.assertInsideCommand();
        this.getLineSet();
        if (!ShutDownTracker.isShutdownHookRunning()) {
            DocumentListener[] listeners = this.getCachedListeners();
            for (int i = listeners.length - 1; i >= 0; --i) {
                try {
                    listeners[i].beforeDocumentChange(event);
                    continue;
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }
        this.myEventsHandling = true;
    }

    private void assertInsideCommand() {
        if (!this.myAssertThreading) {
            return;
        }
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        if (!commandProcessor.isUndoTransparentActionInProgress() && commandProcessor.getCurrentCommand() == null) {
            throw new IncorrectOperationException("Must not change document outside command or undo-transparent action. See com.intellij.openapi.command.WriteCommandAction or com.intellij.openapi.command.CommandProcessor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void changedUpdate(@NotNull DocumentEvent event, long newModificationStamp, ImmutableText immutableText) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/editor/impl/DocumentImpl", "changedUpdate"));
        }
        try {
            void prevText;
            if (LOG.isDebugEnabled()) {
                LOG.debug(event.toString());
            }
            this.myLineSet = this.getLineSet().update((CharSequence)prevText, event.getOffset(), event.getOffset() + event.getOldLength(), event.getNewFragment(), event.isWholeTextReplaced());
            this.myFrozen = null;
            if (this.myTabTrackingRequestors > 0) {
                this.updateMightContainTabs(event.getNewFragment());
            }
            this.setModificationStamp(newModificationStamp);
            if (!ShutDownTracker.isShutdownHookRunning()) {
                DocumentListener[] listeners;
                for (DocumentListener listener : listeners = this.getCachedListeners()) {
                    try {
                        listener.documentChanged(event);
                    }
                    catch (Throwable e) {
                        LOG.error(e);
                    }
                }
            }
        }
        finally {
            this.myEventsHandling = false;
        }
    }

    @Override
    @NotNull
    public String getText() {
        String string = ApplicationManager.getApplication().runReadAction(new Computable<String>(){

            @Override
            public String compute() {
                return DocumentImpl.this.doGetText();
            }
        });
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "getText"));
        }
        return string;
    }

    @NotNull
    private String doGetText() {
        String s = SoftReference.dereference(this.myTextString);
        if (s == null) {
            s = this.myText.toString();
            this.myTextString = new SoftReference<String>(s);
        }
        String string = s;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "doGetText"));
        }
        return string;
    }

    @Override
    public int getTextLength() {
        return this.myText.length();
    }

    @Override
    @NotNull
    public CharSequence getCharsSequence() {
        CharSequence charSequence = this.myMutableCharSequence;
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "getCharsSequence"));
        }
        return charSequence;
    }

    @Override
    @NotNull
    public CharSequence getImmutableCharSequence() {
        ImmutableText immutableText = this.myText;
        if (immutableText == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "getImmutableCharSequence"));
        }
        return immutableText;
    }

    @Override
    public void addDocumentListener(@NotNull DocumentListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/DocumentImpl", "addDocumentListener"));
        }
        this.myCachedDocumentListeners.set(null);
        if (this.myDocumentListeners.contains(listener)) {
            LOG.error("Already registered: " + listener);
        }
        boolean added = this.myDocumentListeners.add(listener);
        LOG.assertTrue(added, listener);
    }

    @Override
    public void removeDocumentListener(@NotNull DocumentListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/DocumentImpl", "removeDocumentListener"));
        }
        DocumentImpl.doRemoveDocumentListener(listener, this.myCachedDocumentListeners, this.myDocumentListeners);
    }

    private static void doRemoveDocumentListener(@NotNull DocumentListener listener, @NotNull Ref<DocumentListener[]> cachedDocumentListenersRef, @NotNull List<DocumentListener> documentListeners) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/DocumentImpl", "doRemoveDocumentListener"));
        }
        if (cachedDocumentListenersRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cachedDocumentListenersRef", "com/intellij/openapi/editor/impl/DocumentImpl", "doRemoveDocumentListener"));
        }
        if (documentListeners == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentListeners", "com/intellij/openapi/editor/impl/DocumentImpl", "doRemoveDocumentListener"));
        }
        cachedDocumentListenersRef.set(null);
        boolean success = documentListeners.remove(listener);
        if (!success) {
            LOG.error("Can't remove document listener (" + listener + "). Registered listeners: " + documentListeners);
        }
    }

    @Override
    public int getLineNumber(int offset2) {
        return this.getLineSet().findLineIndex(offset2);
    }

    @Override
    public final int getLineStartOffset(int line) {
        if (line == 0) {
            return 0;
        }
        return this.getLineSet().getLineStart(line);
    }

    @Override
    public final int getLineEndOffset(int line) {
        if (this.getTextLength() == 0 && line == 0) {
            return 0;
        }
        int result2 = this.getLineSet().getLineEnd(line) - this.getLineSeparatorLength(line);
        assert (result2 >= 0);
        return result2;
    }

    public final int getLineSeparatorLength(int line) {
        int separatorLength = this.getLineSet().getSeparatorLength(line);
        assert (separatorLength >= 0);
        return separatorLength;
    }

    @Override
    public final int getLineCount() {
        int lineCount = this.getLineSet().getLineCount();
        assert (lineCount >= 0);
        return lineCount;
    }

    @NotNull
    private DocumentListener[] getCachedListeners() {
        DocumentListener[] cachedListeners = this.myCachedDocumentListeners.get();
        if (cachedListeners == null) {
            DocumentListener[] listeners = ArrayUtil.stripTrailingNulls(this.myDocumentListeners.toArray(new DocumentListener[this.myDocumentListeners.size()]));
            Arrays.sort(listeners, PrioritizedDocumentListener.COMPARATOR);
            cachedListeners = listeners;
            this.myCachedDocumentListeners.set(cachedListeners);
        }
        if (cachedListeners == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "getCachedListeners"));
        }
        return cachedListeners;
    }

    public void setCyclicBufferSize(int bufferSize) {
        assert (bufferSize >= 0) : bufferSize;
        this.myBufferSize = bufferSize;
    }

    @Override
    public void setText(final @NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/DocumentImpl", "setText"));
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                DocumentImpl.this.replaceString(0, DocumentImpl.this.getTextLength(), text, LocalTimeCounter.currentTime(), true);
            }
        };
        if (CommandProcessor.getInstance().isUndoTransparentActionInProgress()) {
            runnable.run();
        } else {
            CommandProcessor.getInstance().executeCommand(null, runnable, "", DocCommandGroupId.noneGroupId(this));
        }
        this.clearLineModificationFlags();
    }

    @Override
    public final boolean isInBulkUpdate() {
        return this.myDoingBulkUpdate;
    }

    public String toString() {
        return "DocumentImpl[" + FileDocumentManager.getInstance().getFile(this) + "]";
    }

    private void updateMightContainTabs(CharSequence text) {
        if (!this.myMightContainTabs) {
            this.myMightContainTabs = StringUtil.contains(text, 0, text.length(), '\t');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public FrozenDocument freeze() {
        FrozenDocument frozen = this.myFrozen;
        if (frozen == null) {
            Object object = this.myLineSetLock;
            synchronized (object) {
                frozen = this.myFrozen;
                if (frozen == null) {
                    frozen = new FrozenDocument(this.myText, this.getLineSet(), this.myModificationStamp, SoftReference.dereference(this.myTextString));
                }
            }
        }
        FrozenDocument frozenDocument = frozen;
        if (frozenDocument == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "freeze"));
        }
        return frozenDocument;
    }
}

