/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.com.google.protobuf.MessageLite;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationWithTarget;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.serialization.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.serialization.SerializerExtensionProtocol;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AnnotatedCallableKind;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AnnotationAndConstantLoader;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AnnotationDeserializer;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.NotFoundClasses;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ProtoContainer;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AnnotationAndConstantLoaderImpl
implements AnnotationAndConstantLoader<AnnotationDescriptor, ConstantValue<?>, AnnotationWithTarget> {
    private final AnnotationDeserializer deserializer;
    private final NotFoundClasses notFoundClasses;
    private final SerializerExtensionProtocol protocol;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<AnnotationDescriptor> loadClassAnnotations(@NotNull ProtoBuf.Class classProto, @NotNull NameResolver nameResolver) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(classProto, "classProto");
        Intrinsics.checkParameterIsNotNull(nameResolver, "nameResolver");
        List<ProtoBuf.Annotation> list2 = classProto.getExtension(this.protocol.getClassAnnotation());
        List<ProtoBuf.Annotation> list3 = list2;
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        List<ProtoBuf.Annotation> annotations2 = list3;
        Iterable $receiver$iv = annotations2;
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void proto;
            ProtoBuf.Annotation annotation2 = (ProtoBuf.Annotation)item$iv$iv;
            void var10_10 = destination$iv$iv;
            AnnotationDescriptor annotationDescriptor = this.deserializer.deserializeAnnotation((ProtoBuf.Annotation)proto, nameResolver);
            var10_10.add(annotationDescriptor);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<AnnotationWithTarget> loadCallableAnnotations(@NotNull ProtoContainer container2, @NotNull MessageLite proto, @NotNull AnnotatedCallableKind kind) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        List<ProtoBuf.Annotation> list2;
        Intrinsics.checkParameterIsNotNull(container2, "container");
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        Intrinsics.checkParameterIsNotNull((Object)kind, "kind");
        Iterable<Object> iterable = proto;
        if (iterable instanceof ProtoBuf.Constructor) {
            list2 = ((ProtoBuf.Constructor)proto).getExtension(this.protocol.getConstructorAnnotation());
        } else if (iterable instanceof ProtoBuf.Function) {
            list2 = ((ProtoBuf.Function)proto).getExtension(this.protocol.getFunctionAnnotation());
        } else if (iterable instanceof ProtoBuf.Property) {
            list2 = ((ProtoBuf.Property)proto).getExtension(this.protocol.getPropertyAnnotation());
        } else {
            String string = "Unknown message: " + proto;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        iterable = list2;
        List list3 = iterable;
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        List annotations2 = list3;
        iterable = annotations2;
        void var5_6 = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void proto2;
            ProtoBuf.Annotation annotation2 = (ProtoBuf.Annotation)item$iv$iv;
            void var11_12 = destination$iv$iv;
            AnnotationWithTarget annotationWithTarget = new AnnotationWithTarget(this.deserializer.deserializeAnnotation((ProtoBuf.Annotation)proto2, container2.getNameResolver()), null);
            var11_12.add(annotationWithTarget);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<AnnotationDescriptor> loadEnumEntryAnnotations(@NotNull ProtoContainer container2, @NotNull ProtoBuf.EnumEntry proto) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(container2, "container");
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        List<ProtoBuf.Annotation> list2 = proto.getExtension(this.protocol.getEnumEntryAnnotation());
        List<ProtoBuf.Annotation> list3 = list2;
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        List<ProtoBuf.Annotation> annotations2 = list3;
        Iterable $receiver$iv = annotations2;
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void proto2;
            ProtoBuf.Annotation annotation2 = (ProtoBuf.Annotation)item$iv$iv;
            void var10_10 = destination$iv$iv;
            AnnotationDescriptor annotationDescriptor = this.deserializer.deserializeAnnotation((ProtoBuf.Annotation)proto2, container2.getNameResolver());
            var10_10.add(annotationDescriptor);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<AnnotationDescriptor> loadValueParameterAnnotations(@NotNull ProtoContainer container2, @NotNull MessageLite message, @NotNull AnnotatedCallableKind kind, int parameterIndex, @NotNull ProtoBuf.ValueParameter proto) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(container2, "container");
        Intrinsics.checkParameterIsNotNull(message, "message");
        Intrinsics.checkParameterIsNotNull((Object)kind, "kind");
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        Iterable<ProtoBuf.Annotation> iterable = proto.getExtension(this.protocol.getParameterAnnotation());
        List<ProtoBuf.Annotation> list2 = iterable;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        List<ProtoBuf.Annotation> annotations2 = list2;
        iterable = annotations2;
        void var8_8 = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void proto2;
            ProtoBuf.Annotation annotation2 = (ProtoBuf.Annotation)item$iv$iv;
            void var13_13 = destination$iv$iv;
            AnnotationDescriptor annotationDescriptor = this.deserializer.deserializeAnnotation((ProtoBuf.Annotation)proto2, container2.getNameResolver());
            var13_13.add(annotationDescriptor);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public List<AnnotationDescriptor> loadExtensionReceiverParameterAnnotations(@NotNull ProtoContainer container2, @NotNull MessageLite message, @NotNull AnnotatedCallableKind kind) {
        Intrinsics.checkParameterIsNotNull(container2, "container");
        Intrinsics.checkParameterIsNotNull(message, "message");
        Intrinsics.checkParameterIsNotNull((Object)kind, "kind");
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<AnnotationDescriptor> loadTypeAnnotations(@NotNull ProtoBuf.Type proto, @NotNull NameResolver nameResolver) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        Intrinsics.checkParameterIsNotNull(nameResolver, "nameResolver");
        List<ProtoBuf.Annotation> list2 = proto.getExtension(this.protocol.getTypeAnnotation());
        List<ProtoBuf.Annotation> list3 = list2;
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        Iterable $receiver$iv = list3;
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            ProtoBuf.Annotation annotation2 = (ProtoBuf.Annotation)item$iv$iv;
            void var9_9 = destination$iv$iv;
            AnnotationDescriptor annotationDescriptor = this.deserializer.deserializeAnnotation((ProtoBuf.Annotation)it, nameResolver);
            var9_9.add(annotationDescriptor);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<AnnotationDescriptor> loadTypeParameterAnnotations(@NotNull ProtoBuf.TypeParameter proto, @NotNull NameResolver nameResolver) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        Intrinsics.checkParameterIsNotNull(nameResolver, "nameResolver");
        List<ProtoBuf.Annotation> list2 = proto.getExtension(this.protocol.getTypeParameterAnnotation());
        List<ProtoBuf.Annotation> list3 = list2;
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        Iterable $receiver$iv = list3;
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            ProtoBuf.Annotation annotation2 = (ProtoBuf.Annotation)item$iv$iv;
            void var9_9 = destination$iv$iv;
            AnnotationDescriptor annotationDescriptor = this.deserializer.deserializeAnnotation((ProtoBuf.Annotation)it, nameResolver);
            var9_9.add(annotationDescriptor);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public ConstantValue<?> loadPropertyConstant(@NotNull ProtoContainer container2, @NotNull ProtoBuf.Property proto, @NotNull KotlinType expectedType) {
        ProtoBuf.Annotation.Argument.Value value;
        Intrinsics.checkParameterIsNotNull(container2, "container");
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        Intrinsics.checkParameterIsNotNull(expectedType, "expectedType");
        if (!proto.hasExtension(this.protocol.getCompileTimeValue())) {
            return null;
        }
        ProtoBuf.Annotation.Argument.Value value2 = value = proto.getExtension(this.protocol.getCompileTimeValue());
        Intrinsics.checkExpressionValueIsNotNull(value2, "value");
        return this.deserializer.resolveValue(expectedType, value2, container2.getNameResolver());
    }

    public AnnotationAndConstantLoaderImpl(@NotNull ModuleDescriptor module, @NotNull NotFoundClasses notFoundClasses, @NotNull SerializerExtensionProtocol protocol) {
        Intrinsics.checkParameterIsNotNull(module, "module");
        Intrinsics.checkParameterIsNotNull(notFoundClasses, "notFoundClasses");
        Intrinsics.checkParameterIsNotNull(protocol, "protocol");
        this.notFoundClasses = notFoundClasses;
        this.protocol = protocol;
        this.deserializer = new AnnotationDeserializer(module, this.notFoundClasses);
    }
}

