/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.typeEnhancement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.annotations.CompositeAnnotations;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.load.java.typeEnhancement.EnhancedTypeAnnotations;
import org.jetbrains.kotlin.load.java.typeEnhancement.EnhancementResult;
import org.jetbrains.kotlin.load.java.typeEnhancement.JavaTypeQualifiers;
import org.jetbrains.kotlin.load.java.typeEnhancement.MutabilityQualifier;
import org.jetbrains.kotlin.load.java.typeEnhancement.NotNullTypeParameterTypeCapability;
import org.jetbrains.kotlin.load.java.typeEnhancement.NullabilityQualifier;
import org.jetbrains.kotlin.load.java.typeEnhancement.Result;
import org.jetbrains.kotlin.load.java.typeEnhancement.TypeComponentPosition;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.platform.JavaToKotlinClassMap;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.CustomTypeVariable;
import org.jetbrains.kotlin.types.DelegatingFlexibleType;
import org.jetbrains.kotlin.types.Flexibility;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeImpl;
import org.jetbrains.kotlin.types.TypeCapabilities;
import org.jetbrains.kotlin.types.TypeCapabilitiesKt;
import org.jetbrains.kotlin.types.TypeCapability;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitution;
import org.jetbrains.kotlin.types.TypeSubstitutionKt;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a\u0012\u0010\u0003\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\u00040\u0005H\u0002\u001a \u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u001a0\u0010\f\u001a\u00020\r*\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\"\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012*\u00020\u00132\u0006\u0010\b\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a(\u0010\u0014\u001a\u00020\r*\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\u000e\u001a\u00020\nH\u0002\u001a\u001d\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0012\"\u0004\b\u0000\u0010\u0016*\u0002H\u0016H\u0002\u00a2\u0006\u0002\u0010\u0017\u001a\u001d\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0012\"\u0004\b\u0000\u0010\u0016*\u0002H\u0016H\u0002\u00a2\u0006\u0002\u0010\u0017\u001a\"\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0012*\u00020\u00072\u0006\u0010\b\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\n\u0010\u001b\u001a\u00020\u001a*\u00020\u0007\u001a\u001d\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0012\"\u0004\b\u0000\u0010\u0016*\u0002H\u0016H\u0002\u00a2\u0006\u0002\u0010\u0017\u001a\f\u0010\u001d\u001a\u00020\u001a*\u00020\u0010H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"ENHANCED_MUTABILITY_ANNOTATIONS", "Lorg/jetbrains/kotlin/load/java/typeEnhancement/EnhancedTypeAnnotations;", "ENHANCED_NULLABILITY_ANNOTATIONS", "compositeAnnotationsOrSingle", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "", "enhance", "Lorg/jetbrains/kotlin/types/KotlinType;", "qualifiers", "Lkotlin/Function1;", "", "Lorg/jetbrains/kotlin/load/java/typeEnhancement/JavaTypeQualifiers;", "enhanceInflexible", "Lorg/jetbrains/kotlin/load/java/typeEnhancement/Result;", "index", "position", "Lorg/jetbrains/kotlin/load/java/typeEnhancement/TypeComponentPosition;", "enhanceMutability", "Lorg/jetbrains/kotlin/load/java/typeEnhancement/EnhancementResult;", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "enhancePossiblyFlexible", "enhancedMutability", "T", "(Ljava/lang/Object;)Lorg/jetbrains/kotlin/load/java/typeEnhancement/EnhancementResult;", "enhancedNullability", "getEnhancedNullability", "", "hasEnhancedNullability", "noChange", "shouldEnhance", "kotlin-compiler"})
public final class TypeEnhancementKt {
    private static final EnhancedTypeAnnotations ENHANCED_NULLABILITY_ANNOTATIONS;
    private static final EnhancedTypeAnnotations ENHANCED_MUTABILITY_ANNOTATIONS;

    @Nullable
    public static final KotlinType enhance(@NotNull KotlinType $receiver, @NotNull Function1<? super Integer, JavaTypeQualifiers> qualifiers) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(qualifiers, "qualifiers");
        return TypeEnhancementKt.enhancePossiblyFlexible($receiver, qualifiers, 0).getTypeIfChanged();
    }

    public static final boolean hasEnhancedNullability(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Annotations annotations2 = $receiver.getAnnotations();
        FqName fqName2 = JvmAnnotationNames.ENHANCED_NULLABILITY_ANNOTATION;
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "JvmAnnotationNames.ENHANCED_NULLABILITY_ANNOTATION");
        return annotations2.findAnnotation(fqName2) != null;
    }

    private static final Result enhancePossiblyFlexible(@NotNull KotlinType $receiver, Function1<? super Integer, JavaTypeQualifiers> qualifiers, int index2) {
        Result result2;
        if ($receiver.isError()) {
            return new Result($receiver, 1, false);
        }
        if (FlexibleTypesKt.isFlexible($receiver)) {
            Unit unit;
            Flexibility flexibility = FlexibleTypesKt.flexibility($receiver);
            Flexibility $receiver2 = flexibility;
            Result lowerResult = TypeEnhancementKt.enhanceInflexible($receiver2.getLowerBound(), qualifiers, index2, TypeComponentPosition.FLEXIBLE_LOWER);
            Result upperResult = TypeEnhancementKt.enhanceInflexible($receiver2.getUpperBound(), qualifiers, index2, TypeComponentPosition.FLEXIBLE_UPPER);
            boolean bl = lowerResult.getSubtreeSize() == upperResult.getSubtreeSize();
            if (_Assertions.ENABLED) {
                if (!bl) {
                    String string = "Different tree sizes of bounds: " + ("lower = (" + $receiver2.getLowerBound() + ", " + lowerResult.getSubtreeSize() + "), ") + ("upper = (" + $receiver2.getUpperBound() + ", " + upperResult.getSubtreeSize() + ")");
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
            boolean wereChanges = lowerResult.getWereChanges() || upperResult.getWereChanges();
            result2 = new Result(wereChanges ? DelegatingFlexibleType.Companion.create(lowerResult.getType(), upperResult.getType(), $receiver2.getExtraCapabilities()) : $receiver, lowerResult.getSubtreeSize(), wereChanges);
        } else {
            result2 = TypeEnhancementKt.enhanceInflexible($receiver, qualifiers, index2, TypeComponentPosition.INFLEXIBLE);
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private static final Result enhanceInflexible(@NotNull KotlinType $receiver, Function1<? super Integer, JavaTypeQualifiers> qualifiers, int index2, TypeComponentPosition position) {
        void enhancedNullability;
        TypeCapabilities typeCapabilities2;
        void enhancedNullabilityAnnotations;
        void wereChanges;
        void globalArgIndex;
        EnhancementResult<Boolean> destination$iv$iv;
        Annotations $receiver$iv$iv;
        void $receiver$iv22;
        void enhancedMutabilityAnnotations;
        void enhancedClassifier;
        boolean shouldEnhance = TypeEnhancementKt.shouldEnhance(position);
        if (!shouldEnhance && $receiver.getArguments().isEmpty()) {
            return new Result($receiver, 1, false);
        }
        ClassifierDescriptor classifierDescriptor = $receiver.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            return new Result($receiver, 1, false);
        }
        ClassifierDescriptor originalClass = classifierDescriptor;
        JavaTypeQualifiers effectiveQualifiers = qualifiers.invoke((Integer)index2);
        EnhancementResult<ClassifierDescriptor> enhancementResult = TypeEnhancementKt.enhanceMutability(originalClass, effectiveQualifiers, position);
        ClassifierDescriptor classifierDescriptor2 = enhancementResult.component1();
        Annotations annotations2 = enhancementResult.component2();
        enhancementResult = null;
        TypeConstructor typeConstructor2 = enhancedClassifier.getTypeConstructor();
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = index2 + 1;
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = enhancedMutabilityAnnotations != null;
        Iterable iterable = $receiver.getArguments();
        void var14_14 = $receiver$iv22;
        Collection collection = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault($receiver$iv22, 10));
        int index$iv$iv = 0;
        for (Object item$iv$iv : $receiver$iv$iv) {
            TypeProjection typeProjection;
            void localArgIndex;
            void arg;
            int n = index$iv$iv++;
            TypeProjection typeProjection2 = (TypeProjection)item$iv$iv;
            int n2 = n;
            void var28_28 = destination$iv$iv;
            if (arg.isStarProjection()) {
                int n3 = globalArgIndex.element;
                globalArgIndex.element = n3 + 1;
                typeProjection = TypeUtils.makeStarProjection(enhancedClassifier.getTypeConstructor().getParameters().get((int)localArgIndex));
            } else {
                void enhancedType;
                void subtreeSize;
                void wasChangeInArgument;
                Result result2 = TypeEnhancementKt.enhancePossiblyFlexible(arg.getType(), qualifiers, globalArgIndex.element);
                KotlinType kotlinType = result2.component1();
                int n4 = result2.component2();
                boolean bl = result2.component3();
                result2 = null;
                wereChanges.element = wereChanges.element || wasChangeInArgument != false;
                globalArgIndex.element += subtreeSize;
                Variance variance = arg.getProjectionKind();
                Intrinsics.checkExpressionValueIsNotNull((Object)variance, "arg.projectionKind");
                typeProjection = TypeUtilsKt.createProjection((KotlinType)enhancedType, variance, typeConstructor2.getParameters().get((int)localArgIndex));
            }
            TypeProjection typeProjection3 = typeProjection;
            var28_28.add(typeProjection3);
        }
        List enhancedArguments = (List)((Object)destination$iv$iv);
        destination$iv$iv = TypeEnhancementKt.getEnhancedNullability($receiver, effectiveQualifiers, position);
        boolean $receiver$iv22 = destination$iv$iv.component1();
        $receiver$iv$iv = destination$iv$iv.component2();
        destination$iv$iv = null;
        wereChanges.element = wereChanges.element || enhancedNullabilityAnnotations != null;
        int subtreeSize = globalArgIndex.element - index2;
        if (!wereChanges.element) {
            return new Result($receiver, subtreeSize, false);
        }
        Annotations newAnnotations = TypeEnhancementKt.compositeAnnotationsOrSingle(kotlin.collections.CollectionsKt.filterNotNull((Iterable)kotlin.collections.CollectionsKt.listOf(new Annotations[]{$receiver.getAnnotations(), enhancedMutabilityAnnotations, enhancedNullabilityAnnotations})));
        TypeConstructor typeConstructor3 = typeConstructor2;
        Intrinsics.checkExpressionValueIsNotNull(typeConstructor3, "typeConstructor");
        TypeSubstitution newSubstitution = TypeSubstitutionKt.computeNewSubstitution($receiver, typeConstructor3, enhancedArguments);
        if (effectiveQualifiers.isNotNullTypeParameter$kotlin_compiler()) {
            typeCapabilities2 = TypeCapabilitiesKt.addCapability($receiver.getCapabilities(), CustomTypeVariable.class, (TypeCapability)NotNullTypeParameterTypeCapability.INSTANCE);
        } else {
            TypeCapabilities typeCapabilities3 = $receiver.getCapabilities();
            typeCapabilities2 = typeCapabilities3;
            Intrinsics.checkExpressionValueIsNotNull(typeCapabilities3, "capabilities");
        }
        TypeCapabilities newCapabilities = typeCapabilities2;
        TypeConstructor typeConstructor4 = typeConstructor2;
        Intrinsics.checkExpressionValueIsNotNull(typeConstructor4, "typeConstructor");
        MemberScope memberScope2 = enhancedClassifier instanceof ClassDescriptor ? ((ClassDescriptor)enhancedClassifier).getMemberScope(newSubstitution) : enhancedClassifier.getDefaultType().getMemberScope();
        Intrinsics.checkExpressionValueIsNotNull(memberScope2, "if (enhancedClassifier i\u2026ltType().getMemberScope()");
        KotlinTypeImpl enhancedType = KotlinTypeImpl.Companion.create(newAnnotations, typeConstructor4, (boolean)enhancedNullability, enhancedArguments, newSubstitution, memberScope2, newCapabilities);
        return new Result(enhancedType, subtreeSize, true);
    }

    private static final Annotations compositeAnnotationsOrSingle(@NotNull List<? extends Annotations> $receiver) {
        Annotations annotations2;
        switch ($receiver.size()) {
            case 0: {
                String string = "At least one Annotations object expected";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            case 1: {
                annotations2 = kotlin.collections.CollectionsKt.single($receiver);
                break;
            }
            default: {
                annotations2 = new CompositeAnnotations(CollectionsKt.toReadOnlyList((Collection)$receiver));
            }
        }
        return annotations2;
    }

    private static final boolean shouldEnhance(@NotNull TypeComponentPosition $receiver) {
        return Intrinsics.areEqual((Object)$receiver, (Object)TypeComponentPosition.INFLEXIBLE) ^ true;
    }

    private static final <T> EnhancementResult<T> noChange(T $receiver) {
        return new EnhancementResult<T>($receiver, null);
    }

    private static final <T> EnhancementResult<T> enhancedNullability(T $receiver) {
        return new EnhancementResult<T>($receiver, ENHANCED_NULLABILITY_ANNOTATIONS);
    }

    private static final <T> EnhancementResult<T> enhancedMutability(T $receiver) {
        return new EnhancementResult<T>($receiver, ENHANCED_MUTABILITY_ANNOTATIONS);
    }

    private static final EnhancementResult<ClassifierDescriptor> enhanceMutability(@NotNull ClassifierDescriptor $receiver, JavaTypeQualifiers qualifiers, TypeComponentPosition position) {
        if (!TypeEnhancementKt.shouldEnhance(position)) {
            return TypeEnhancementKt.noChange($receiver);
        }
        if (!($receiver instanceof ClassDescriptor)) {
            return TypeEnhancementKt.noChange($receiver);
        }
        JavaToKotlinClassMap mapping = JavaToKotlinClassMap.INSTANCE;
        MutabilityQualifier mutabilityQualifier = qualifiers.getMutability();
        if (Intrinsics.areEqual((Object)mutabilityQualifier, (Object)MutabilityQualifier.READ_ONLY)) {
            if (Intrinsics.areEqual((Object)position, (Object)TypeComponentPosition.FLEXIBLE_LOWER) && mapping.isMutable((ClassDescriptor)$receiver)) {
                return TypeEnhancementKt.enhancedMutability(mapping.convertMutableToReadOnly((ClassDescriptor)$receiver));
            }
        } else if (Intrinsics.areEqual((Object)mutabilityQualifier, (Object)MutabilityQualifier.MUTABLE) && Intrinsics.areEqual((Object)position, (Object)TypeComponentPosition.FLEXIBLE_UPPER) && mapping.isReadOnly((ClassDescriptor)$receiver)) {
            return TypeEnhancementKt.enhancedMutability(mapping.convertReadOnlyToMutable((ClassDescriptor)$receiver));
        }
        return TypeEnhancementKt.noChange($receiver);
    }

    private static final EnhancementResult<Boolean> getEnhancedNullability(@NotNull KotlinType $receiver, JavaTypeQualifiers qualifiers, TypeComponentPosition position) {
        if (!TypeEnhancementKt.shouldEnhance(position)) {
            return TypeEnhancementKt.noChange($receiver.isMarkedNullable());
        }
        NullabilityQualifier nullabilityQualifier = qualifiers.getNullability();
        return Intrinsics.areEqual((Object)nullabilityQualifier, (Object)NullabilityQualifier.NULLABLE) ? TypeEnhancementKt.enhancedNullability(true) : (Intrinsics.areEqual((Object)nullabilityQualifier, (Object)NullabilityQualifier.NOT_NULL) ? TypeEnhancementKt.enhancedNullability(false) : TypeEnhancementKt.noChange($receiver.isMarkedNullable()));
    }

    static {
        FqName fqName2 = JvmAnnotationNames.ENHANCED_NULLABILITY_ANNOTATION;
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "JvmAnnotationNames.ENHANCED_NULLABILITY_ANNOTATION");
        ENHANCED_NULLABILITY_ANNOTATIONS = new EnhancedTypeAnnotations(fqName2);
        FqName fqName3 = JvmAnnotationNames.ENHANCED_MUTABILITY_ANNOTATION;
        Intrinsics.checkExpressionValueIsNotNull(fqName3, "JvmAnnotationNames.ENHANCED_MUTABILITY_ANNOTATION");
        ENHANCED_MUTABILITY_ANNOTATIONS = new EnhancedTypeAnnotations(fqName3);
    }
}

