/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.inline;

import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.FunctionAnalyzerExtension;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;

public class InlineAnalyzerExtension
implements FunctionAnalyzerExtension.AnalyzerExtension {
    public static final InlineAnalyzerExtension INSTANCE = new InlineAnalyzerExtension();

    private InlineAnalyzerExtension() {
    }

    @Override
    public void process(final @NotNull FunctionDescriptor descriptor2, @NotNull KtNamedFunction function, final @NotNull BindingTrace trace) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/inline/InlineAnalyzerExtension", "process"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/resolve/inline/InlineAnalyzerExtension", "process"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/inline/InlineAnalyzerExtension", "process"));
        }
        assert (InlineUtil.isInline(descriptor2)) : "This method should be invoked on inline function: " + descriptor2;
        InlineAnalyzerExtension.checkDefaults(descriptor2, function, trace);
        InlineAnalyzerExtension.checkNotVirtual(descriptor2, function, trace);
        InlineAnalyzerExtension.checkHasInlinableAndNullability(descriptor2, function, trace);
        KtVisitorVoid visitor2 = new KtVisitorVoid(){

            @Override
            public void visitKtElement(@NotNull KtElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/resolve/inline/InlineAnalyzerExtension$1", "visitKtElement"));
                }
                super.visitKtElement(element);
                element.acceptChildren(this);
            }

            @Override
            public void visitClass(@NotNull KtClass klass) {
                if (klass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/kotlin/resolve/inline/InlineAnalyzerExtension$1", "visitClass"));
                }
                trace.report(Errors.NOT_YET_SUPPORTED_IN_INLINE.on(klass, klass, descriptor2));
            }

            @Override
            public void visitNamedFunction(@NotNull KtNamedFunction function) {
                if (function == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/resolve/inline/InlineAnalyzerExtension$1", "visitNamedFunction"));
                }
                if (function.getParent().getParent() instanceof KtObjectDeclaration) {
                    super.visitNamedFunction(function);
                } else {
                    trace.report(Errors.NOT_YET_SUPPORTED_IN_INLINE.on(function, function, descriptor2));
                }
            }
        };
        function.acceptChildren(visitor2);
    }

    private static void checkDefaults(@NotNull FunctionDescriptor functionDescriptor, @NotNull KtFunction function, @NotNull BindingTrace trace) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/resolve/inline/InlineAnalyzerExtension", "checkDefaults"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/resolve/inline/InlineAnalyzerExtension", "checkDefaults"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/inline/InlineAnalyzerExtension", "checkDefaults"));
        }
        List<KtParameter> jetParameters = function.getValueParameters();
        for (ValueParameterDescriptor parameter : functionDescriptor.getValueParameters()) {
            KtParameter jetParameter;
            if (!DescriptorUtilsKt.hasDefaultValue(parameter) || !InlineAnalyzerExtension.checkInlinableParameter(parameter, jetParameter = jetParameters.get(parameter.getIndex()), functionDescriptor, null) && parameter.declaresDefaultValue()) continue;
            trace.report(Errors.NOT_YET_SUPPORTED_IN_INLINE.on(jetParameter, jetParameter, functionDescriptor));
        }
    }

    private static void checkNotVirtual(@NotNull FunctionDescriptor functionDescriptor, @NotNull KtFunction function, @NotNull BindingTrace trace) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/resolve/inline/InlineAnalyzerExtension", "checkNotVirtual"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/resolve/inline/InlineAnalyzerExtension", "checkNotVirtual"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/inline/InlineAnalyzerExtension", "checkNotVirtual"));
        }
        if (Visibilities.isPrivate(functionDescriptor.getVisibility()) || functionDescriptor.getModality() == Modality.FINAL) {
            return;
        }
        if (functionDescriptor.getContainingDeclaration() instanceof PackageFragmentDescriptor) {
            return;
        }
        trace.report(Errors.DECLARATION_CANT_BE_INLINED.on(function));
    }

    private static void checkHasInlinableAndNullability(@NotNull FunctionDescriptor functionDescriptor, @NotNull KtFunction function, @NotNull BindingTrace trace) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/resolve/inline/InlineAnalyzerExtension", "checkHasInlinableAndNullability"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/resolve/inline/InlineAnalyzerExtension", "checkHasInlinableAndNullability"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/inline/InlineAnalyzerExtension", "checkHasInlinableAndNullability"));
        }
        boolean hasInlinable = false;
        List<ValueParameterDescriptor> parameters2 = functionDescriptor.getValueParameters();
        int index2 = 0;
        for (ValueParameterDescriptor parameter : parameters2) {
            hasInlinable |= InlineAnalyzerExtension.checkInlinableParameter(parameter, function.getValueParameters().get(index2++), functionDescriptor, trace);
        }
        if (!(hasInlinable |= InlineUtil.containsReifiedTypeParameters(functionDescriptor)) && !AnnotationUtilKt.isInlineOnlyOrReified(functionDescriptor)) {
            KtModifierList modifierList = function.getModifierList();
            PsiElement inlineModifier = modifierList == null ? null : modifierList.getModifier(KtTokens.INLINE_KEYWORD);
            PsiElement reportOn = inlineModifier == null ? function : inlineModifier;
            trace.report(Errors.NOTHING_TO_INLINE.on(reportOn, functionDescriptor));
        }
    }

    public static boolean checkInlinableParameter(@NotNull ParameterDescriptor parameter, @NotNull KtElement expression, @NotNull CallableDescriptor functionDescriptor, @Nullable BindingTrace trace) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/resolve/inline/InlineAnalyzerExtension", "checkInlinableParameter"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/inline/InlineAnalyzerExtension", "checkInlinableParameter"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/resolve/inline/InlineAnalyzerExtension", "checkInlinableParameter"));
        }
        if (InlineUtil.isInlineLambdaParameter(parameter)) {
            if (parameter.getType().isMarkedNullable()) {
                if (trace != null) {
                    trace.report(Errors.NULLABLE_INLINE_PARAMETER.on(expression, expression, functionDescriptor));
                }
            } else {
                return true;
            }
        }
        return false;
    }
}

