/* The following code was generated by JFlex 1.4.3 on 12/9/15 7:45 PM */

package org.jetbrains.kotlin.lexer;

import com.intellij.lexer.FlexLexer;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.Stack;


/**
 * This class is a scanner generated by
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.3
 * on 12/9/15 7:45 PM from the specification file
 * <tt>/home/user/projects/kotlin/compiler/frontend/src/org/jetbrains/kotlin/lexer/Kotlin.flex</tt>
 */
class _JetLexer implements FlexLexer {
  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int STRING = 2;
  public static final int BLOCK_COMMENT = 8;
  public static final int YYINITIAL = 0;
  public static final int LONG_TEMPLATE_ENTRY = 12;
  public static final int DOC_COMMENT = 10;
  public static final int RAW_STRING = 4;
  public static final int SHORT_TEMPLATE_ENTRY = 6;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = {
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  4,  4,  5, 5
  };

  /**
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED =
    "\11\0\1\3\1\7\1\0\1\3\23\0\1\3\1\13\1\27\1\12"+
    "\1\10\1\67\1\65\1\24\1\73\1\74\1\36\1\62\1\76\1\23"+
    "\1\20\1\11\1\14\11\1\1\70\1\75\1\63\1\60\1\64\1\61"+
    "\1\77\1\2\1\16\2\2\1\22\1\21\5\4\1\17\13\4\1\15"+
    "\2\4\1\71\1\25\1\72\1\0\1\4\1\6\1\42\1\53\1\47"+
    "\1\56\1\41\1\46\1\52\1\32\1\33\1\54\1\51\1\43\1\4"+
    "\1\44\1\50\1\40\1\4\1\45\1\34\1\31\1\26\1\57\1\55"+
    "\1\15\1\37\1\4\1\30\1\66\1\35\54\0\1\4\12\0\1\4"+
    "\4\0\1\4\5\0\27\4\1\0\37\4\1\0\u01ca\4\4\0\14\4"+
    "\16\0\5\4\7\0\1\4\1\0\1\4\201\0\5\4\1\0\2\4"+
    "\2\0\4\4\10\0\1\4\1\0\3\4\1\0\1\4\1\0\24\4"+
    "\1\0\123\4\1\0\213\4\10\0\236\4\11\0\46\4\2\0\1\4"+
    "\7\0\47\4\110\0\33\4\5\0\3\4\55\0\53\4\25\0\12\5"+
    "\4\0\2\4\1\0\143\4\1\0\1\4\17\0\2\4\7\0\2\4"+
    "\12\5\3\4\2\0\1\4\20\0\1\4\1\0\36\4\35\0\131\4"+
    "\13\0\1\4\16\0\12\5\41\4\11\0\2\4\4\0\1\4\5\0"+
    "\26\4\4\0\1\4\11\0\1\4\3\0\1\4\27\0\31\4\253\0"+
    "\66\4\3\0\1\4\22\0\1\4\7\0\12\4\4\0\12\5\1\0"+
    "\7\4\1\0\7\4\5\0\10\4\2\0\2\4\2\0\26\4\1\0"+
    "\7\4\1\0\1\4\3\0\4\4\3\0\1\4\20\0\1\4\15\0"+
    "\2\4\1\0\3\4\4\0\12\5\2\4\23\0\6\4\4\0\2\4"+
    "\2\0\26\4\1\0\7\4\1\0\2\4\1\0\2\4\1\0\2\4"+
    "\37\0\4\4\1\0\1\4\7\0\12\5\2\0\3\4\20\0\11\4"+
    "\1\0\3\4\1\0\26\4\1\0\7\4\1\0\2\4\1\0\5\4"+
    "\3\0\1\4\22\0\1\4\17\0\2\4\4\0\12\5\25\0\10\4"+
    "\2\0\2\4\2\0\26\4\1\0\7\4\1\0\2\4\1\0\5\4"+
    "\3\0\1\4\36\0\2\4\1\0\3\4\4\0\12\5\1\0\1\4"+
    "\21\0\1\4\1\0\6\4\3\0\3\4\1\0\4\4\3\0\2\4"+
    "\1\0\1\4\1\0\2\4\3\0\2\4\3\0\3\4\3\0\14\4"+
    "\26\0\1\4\25\0\12\5\25\0\10\4\1\0\3\4\1\0\27\4"+
    "\1\0\12\4\1\0\5\4\3\0\1\4\32\0\2\4\6\0\2\4"+
    "\4\0\12\5\25\0\10\4\1\0\3\4\1\0\27\4\1\0\12\4"+
    "\1\0\5\4\3\0\1\4\40\0\1\4\1\0\2\4\4\0\12\5"+
    "\1\0\2\4\22\0\10\4\1\0\3\4\1\0\51\4\2\0\1\4"+
    "\20\0\1\4\21\0\2\4\4\0\12\5\12\0\6\4\5\0\22\4"+
    "\3\0\30\4\1\0\11\4\1\0\1\4\2\0\7\4\72\0\60\4"+
    "\1\0\2\4\14\0\7\4\11\0\12\5\47\0\2\4\1\0\1\4"+
    "\2\0\2\4\1\0\1\4\2\0\1\4\6\0\4\4\1\0\7\4"+
    "\1\0\3\4\1\0\1\4\1\0\1\4\2\0\2\4\1\0\4\4"+
    "\1\0\2\4\11\0\1\4\2\0\5\4\1\0\1\4\11\0\12\5"+
    "\2\0\2\4\42\0\1\4\37\0\12\5\26\0\10\4\1\0\44\4"+
    "\33\0\5\4\163\0\53\4\24\0\1\4\12\5\6\0\6\4\4\0"+
    "\4\4\3\0\1\4\3\0\2\4\7\0\3\4\4\0\15\4\14\0"+
    "\1\4\1\0\12\5\6\0\46\4\12\0\53\4\1\0\1\4\3\0"+
    "\u0149\4\1\0\4\4\2\0\7\4\1\0\1\4\1\0\4\4\2\0"+
    "\51\4\1\0\4\4\2\0\41\4\1\0\4\4\2\0\7\4\1\0"+
    "\1\4\1\0\4\4\2\0\17\4\1\0\71\4\1\0\4\4\2\0"+
    "\103\4\45\0\20\4\20\0\125\4\14\0\u026c\4\2\0\21\4\1\0"+
    "\32\4\5\0\113\4\25\0\15\4\1\0\4\4\16\0\22\4\16\0"+
    "\22\4\16\0\15\4\1\0\3\4\17\0\64\4\43\0\1\4\4\0"+
    "\1\4\3\0\12\5\46\0\12\5\6\0\130\4\10\0\51\4\1\0"+
    "\1\4\5\0\106\4\12\0\35\4\51\0\12\5\36\4\2\0\5\4"+
    "\13\0\54\4\25\0\7\4\10\0\12\5\46\0\27\4\11\0\65\4"+
    "\53\0\12\5\6\0\12\5\15\0\1\4\135\0\57\4\21\0\7\4"+
    "\4\0\12\5\51\0\36\4\15\0\2\4\12\5\6\0\46\4\32\0"+
    "\44\4\34\0\12\5\3\0\3\4\12\5\44\4\153\0\4\4\1\0"+
    "\4\4\16\0\300\4\100\0\u0116\4\2\0\6\4\2\0\46\4\2\0"+
    "\6\4\2\0\10\4\1\0\1\4\1\0\1\4\1\0\1\4\1\0"+
    "\37\4\2\0\65\4\1\0\7\4\1\0\1\4\3\0\3\4\1\0"+
    "\7\4\3\0\4\4\2\0\6\4\4\0\15\4\5\0\3\4\1\0"+
    "\7\4\164\0\1\4\15\0\1\4\20\0\15\4\145\0\1\4\4\0"+
    "\1\4\2\0\12\4\1\0\1\4\3\0\5\4\6\0\1\4\1\0"+
    "\1\4\1\0\1\4\1\0\4\4\1\0\13\4\2\0\4\4\5\0"+
    "\5\4\4\0\1\4\64\0\2\4\u0a7b\0\57\4\1\0\57\4\1\0"+
    "\205\4\6\0\4\4\21\0\46\4\12\0\66\4\11\0\1\4\20\0"+
    "\27\4\11\0\7\4\1\0\7\4\1\0\7\4\1\0\7\4\1\0"+
    "\7\4\1\0\7\4\1\0\7\4\1\0\7\4\120\0\1\4\u01d5\0"+
    "\2\4\52\0\5\4\5\0\2\4\4\0\126\4\6\0\3\4\1\0"+
    "\132\4\1\0\4\4\5\0\51\4\3\0\136\4\21\0\33\4\65\0"+
    "\20\4\u0200\0\u19b6\4\112\0\u51cc\4\64\0\u048d\4\103\0\56\4\2\0"+
    "\u010d\4\3\0\20\4\12\5\2\4\24\0\57\4\20\0\31\4\10\0"+
    "\106\4\61\0\11\4\2\0\147\4\2\0\4\4\1\0\2\4\16\0"+
    "\12\4\120\0\10\4\1\0\3\4\1\0\4\4\1\0\27\4\35\0"+
    "\64\4\16\0\62\4\34\0\12\5\30\0\6\4\3\0\1\4\4\0"+
    "\12\5\34\4\12\0\27\4\31\0\35\4\7\0\57\4\34\0\1\4"+
    "\12\5\46\0\51\4\27\0\3\4\1\0\10\4\4\0\12\5\6\0"+
    "\27\4\3\0\1\4\5\0\60\4\1\0\1\4\3\0\2\4\2\0"+
    "\5\4\2\0\1\4\1\0\1\4\30\0\3\4\43\0\6\4\2\0"+
    "\6\4\2\0\6\4\11\0\7\4\1\0\7\4\221\0\43\4\15\0"+
    "\12\5\6\0\u2ba4\4\14\0\27\4\4\0\61\4\u2104\0\u012e\4\2\0"+
    "\76\4\2\0\152\4\46\0\7\4\14\0\5\4\5\0\1\4\1\0"+
    "\12\4\1\0\15\4\1\0\5\4\1\0\1\4\1\0\2\4\1\0"+
    "\2\4\1\0\154\4\41\0\u016b\4\22\0\100\4\2\0\66\4\50\0"+
    "\14\4\164\0\5\4\1\0\207\4\23\0\12\5\7\0\32\4\6\0"+
    "\32\4\13\0\131\4\3\0\6\4\2\0\6\4\2\0\6\4\2\0"+
    "\3\4\43\0";

  /**
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /**
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\6\0\1\1\1\2\1\3\1\4\2\1\1\5\1\6"+
    "\1\7\1\2\1\10\1\11\1\12\1\13\1\14\3\3"+
    "\1\15\1\16\15\3\1\17\1\20\1\21\1\22\1\23"+
    "\2\1\1\24\1\25\1\26\1\27\1\30\1\31\1\32"+
    "\1\33\1\34\1\35\1\36\1\35\1\1\1\37\2\35"+
    "\1\40\1\1\1\40\3\41\1\42\1\43\1\2\1\0"+
    "\2\44\1\0\1\45\1\0\1\46\1\47\1\50\1\51"+
    "\1\0\1\52\1\0\2\2\1\44\1\53\1\54\1\55"+
    "\1\56\2\12\1\0\3\3\1\57\1\60\1\61\1\3"+
    "\1\62\3\3\1\63\12\3\1\64\1\3\1\65\1\66"+
    "\1\67\1\70\1\71\1\72\1\73\1\74\1\75\1\76"+
    "\1\77\1\100\1\0\1\101\2\102\2\0\1\40\1\103"+
    "\1\104\1\0\1\105\1\44\1\3\1\0\1\106\1\107"+
    "\1\110\1\111\1\0\1\112\1\113\4\3\1\114\5\3"+
    "\1\115\2\3\1\116\1\3\1\117\6\3\1\120\1\121"+
    "\1\122\2\0\1\123\2\40\1\45\1\124\1\125\1\126"+
    "\2\3\1\127\4\3\1\130\1\131\7\3\1\132\1\100"+
    "\1\0\1\133\1\134\3\3\1\135\1\136\2\3\1\137"+
    "\1\140\2\3\1\141\1\142\1\0\1\3\1\143\2\3"+
    "\1\144\1\3\1\145\2\3\1\146\3\3\1\147\1\150"+
    "\1\151";

  private static int [] zzUnpackAction() {
    int [] result = new int[236];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\100\0\200\0\300\0\u0100\0\u0140\0\u0180\0\u01c0"+
    "\0\u0200\0\u0240\0\u0280\0\u02c0\0\u0300\0\u0340\0\u0380\0\u03c0"+
    "\0\u0400\0\u0440\0\u0480\0\u04c0\0\u0180\0\u0500\0\u0540\0\u0580"+
    "\0\u0180\0\u05c0\0\u0600\0\u0640\0\u0680\0\u06c0\0\u0700\0\u0740"+
    "\0\u0780\0\u07c0\0\u0800\0\u0840\0\u0880\0\u08c0\0\u0900\0\u0940"+
    "\0\u0180\0\u0980\0\u09c0\0\u0a00\0\u0a40\0\u0a80\0\u0ac0\0\u0b00"+
    "\0\u0180\0\u0180\0\u0180\0\u0180\0\u0b40\0\u0180\0\u0180\0\u0b80"+
    "\0\u0180\0\u0bc0\0\u0c00\0\u0180\0\u0180\0\u0c40\0\u0c80\0\u0cc0"+
    "\0\u0d00\0\u0180\0\u0d40\0\u0d80\0\u0180\0\u0180\0\u0dc0\0\u0e00"+
    "\0\u0180\0\u0e40\0\u0e80\0\u0ec0\0\u0f00\0\u0f40\0\u0f80\0\u0180"+
    "\0\u0fc0\0\u1000\0\u1040\0\u1080\0\u10c0\0\u1100\0\u1140\0\u1180"+
    "\0\u0180\0\u0180\0\u0180\0\u0180\0\u11c0\0\u1200\0\u1240\0\u1280"+
    "\0\u12c0\0\u0200\0\u1300\0\u0200\0\u1340\0\u0180\0\u1380\0\u13c0"+
    "\0\u1400\0\u1440\0\u1480\0\u14c0\0\u1500\0\u1540\0\u1580\0\u15c0"+
    "\0\u1600\0\u1640\0\u1680\0\u16c0\0\u0200\0\u1700\0\u1740\0\u0180"+
    "\0\u0180\0\u0180\0\u0180\0\u0180\0\u0180\0\u0180\0\u0180\0\u0180"+
    "\0\u0180\0\u1780\0\u17c0\0\u0180\0\u0180\0\u1800\0\u1840\0\u1880"+
    "\0\u18c0\0\u0180\0\u0180\0\u1900\0\u0180\0\u1940\0\u0180\0\u1980"+
    "\0\u19c0\0\u1a00\0\u1a00\0\u0180\0\u1a40\0\u0180\0\u0180\0\u1a80"+
    "\0\u1ac0\0\u1b00\0\u1b40\0\u0200\0\u1b80\0\u1bc0\0\u1c00\0\u1c40"+
    "\0\u1c80\0\u0180\0\u1cc0\0\u1d00\0\u0200\0\u1d40\0\u0200\0\u1d80"+
    "\0\u1dc0\0\u1e00\0\u1e40\0\u1e80\0\u1ec0\0\u0200\0\u0200\0\u0180"+
    "\0\u1f00\0\u1f40\0\u1840\0\u0180\0\u1f80\0\u0180\0\u0180\0\u0180"+
    "\0\u0200\0\u1fc0\0\u2000\0\u0200\0\u2040\0\u2080\0\u20c0\0\u2100"+
    "\0\u0200\0\u0200\0\u2140\0\u2180\0\u21c0\0\u2200\0\u2240\0\u2280"+
    "\0\u22c0\0\u0200\0\u0180\0\u2300\0\u0c80\0\u0200\0\u2340\0\u2380"+
    "\0\u23c0\0\u0200\0\u0200\0\u2400\0\u2440\0\u0200\0\u0200\0\u2480"+
    "\0\u24c0\0\u0200\0\u0200\0\u2500\0\u2540\0\u0200\0\u2580\0\u25c0"+
    "\0\u0200\0\u2600\0\u0200\0\u2640\0\u2680\0\u0200\0\u26c0\0\u2700"+
    "\0\u2740\0\u0200\0\u0200\0\u0200";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[236];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /**
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\7\1\10\1\11\1\12\1\11\1\7\1\13\1\12"+
    "\1\14\1\15\1\16\1\17\1\20\3\11\1\21\2\11"+
    "\1\22\1\23\1\7\1\11\1\24\1\25\1\26\1\11"+
    "\1\27\1\30\1\31\1\32\1\33\1\34\1\35\1\36"+
    "\1\11\1\37\1\40\1\41\1\42\1\43\2\11\1\44"+
    "\1\11\1\45\1\46\1\47\1\50\1\51\1\52\1\53"+
    "\1\54\1\55\1\56\1\57\1\60\1\61\1\62\1\63"+
    "\1\64\1\65\1\66\1\67\7\70\1\71\1\72\14\70"+
    "\1\73\1\70\1\74\57\70\1\75\1\72\14\70\1\75"+
    "\1\70\1\76\50\70\2\7\1\77\1\7\1\77\1\7"+
    "\1\100\1\0\5\7\3\77\1\7\2\77\3\7\1\77"+
    "\2\7\1\101\3\77\2\7\21\77\20\7\11\102\1\103"+
    "\24\102\1\104\41\102\1\7\1\10\1\11\1\12\1\11"+
    "\1\7\1\13\1\12\1\14\1\15\1\16\1\17\1\20"+
    "\3\11\1\21\2\11\1\22\1\23\1\7\1\11\1\24"+
    "\1\105\1\26\1\11\1\27\1\30\1\106\1\32\1\33"+
    "\1\34\1\35\1\36\1\11\1\37\1\40\1\41\1\42"+
    "\1\43\2\11\1\44\1\11\1\45\1\46\1\47\1\50"+
    "\1\51\1\52\1\53\1\54\1\55\1\56\1\57\1\60"+
    "\1\61\1\62\1\63\1\64\1\65\1\66\1\67\101\0"+
    "\1\10\12\0\1\10\2\0\1\107\1\110\1\111\1\112"+
    "\16\0\1\112\1\0\1\107\2\0\1\111\32\0\2\11"+
    "\1\0\2\11\6\0\4\11\1\0\2\11\3\0\1\11"+
    "\2\0\4\11\2\0\21\11\23\0\1\12\3\0\1\12"+
    "\70\0\6\113\2\0\70\113\2\0\1\114\1\0\1\114"+
    "\1\0\1\115\6\0\3\114\1\0\2\114\3\0\1\114"+
    "\2\0\4\114\2\0\21\114\31\0\1\116\24\0\1\117"+
    "\21\0\1\120\32\0\1\121\117\0\1\122\24\0\1\123"+
    "\20\0\1\124\12\0\1\124\1\125\1\126\1\107\1\110"+
    "\1\111\1\112\16\0\1\112\1\0\1\107\2\0\1\111"+
    "\4\0\1\126\25\0\1\127\12\0\1\127\3\0\1\130"+
    "\102\0\1\131\34\0\1\132\3\0\1\133\13\0\7\23"+
    "\1\0\14\23\1\134\1\135\52\23\27\0\1\136\51\0"+
    "\2\11\1\0\2\11\6\0\4\11\1\0\2\11\3\0"+
    "\1\11\2\0\1\11\1\137\2\11\2\0\1\140\5\11"+
    "\1\141\12\11\21\0\2\11\1\0\2\11\6\0\4\11"+
    "\1\0\2\11\3\0\1\11\2\0\3\11\1\142\2\0"+
    "\5\11\1\143\1\11\1\144\11\11\21\0\2\11\1\0"+
    "\2\11\6\0\4\11\1\0\2\11\3\0\1\145\2\0"+
    "\4\11\2\0\21\11\100\0\1\146\20\0\2\11\1\0"+
    "\2\11\6\0\4\11\1\0\2\11\3\0\1\11\2\0"+
    "\2\11\1\147\1\11\2\0\21\11\21\0\2\11\1\0"+
    "\2\11\6\0\4\11\1\0\2\11\3\0\1\11\2\0"+
    "\4\11\2\0\3\11\1\150\15\11\21\0\2\11\1\0"+
    "\2\11\6\0\4\11\1\0\2\11\3\0\1\11\2\0"+
    "\4\11\2\0\4\11\1\151\14\11\21\0\2\11\1\0"+
    "\2\11\6\0\4\11\1\0\2\11\3\0\1\11\2\0"+
    "\3\11\1\152\2\0\21\11\21\0\2\11\1\0\2\11"+
    "\6\0\4\11\1\0\2\11\3\0\1\153\2\0\4\11"+
    "\2\0\21\11\21\0\2\11\1\0\2\11\6\0\4\11"+
    "\1\0\2\11\3\0\1\11\2\0\4\11\2\0\2\11"+
    "\1\154\16\11\21\0\2\11\1\0\2\11\6\0\4\11"+
    "\1\0\2\11\3\0\1\155\2\0\4\11\2\0\3\11"+
    "\1\156\5\11\1\157\7\11\21\0\2\11\1\0\2\11"+
    "\6\0\4\11\1\0\2\11\3\0\1\11\2\0\4\11"+
    "\2\0\4\11\1\160\4\11\1\161\7\11\21\0\2\11"+
    "\1\0\2\11\6\0\4\11\1\0\2\11\3\0\1\11"+
    "\2\0\4\11\2\0\14\11\1\162\4\11\21\0\2\11"+
    "\1\0\2\11\6\0\4\11\1\0\2\11\3\0\1\11"+
    "\2\0\4\11\2\0\6\11\1\163\12\11\21\0\2\11"+
    "\1\0\2\11\6\0\4\11\1\0\2\11\3\0\1\11"+
    "\2\0\1\11\1\164\2\11\2\0\21\11\21\0\2\11"+
    "\1\0\2\11\6\0\4\11\1\0\2\11\3\0\1\11"+
    "\2\0\4\11\2\0\11\11\1\165\7\11\21\0\2\11"+
    "\1\0\2\11\6\0\4\11\1\0\2\11\3\0\1\11"+
    "\2\0\4\11\2\0\3\11\1\166\15\11\100\0\1\167"+
    "\3\0\1\170\73\0\1\171\1\0\1\172\75\0\1\173"+
    "\77\0\1\174\104\0\1\175\100\0\1\176\71\0\1\177"+
    "\107\0\1\200\104\0\1\201\2\0\7\70\2\0\14\70"+
    "\1\0\1\70\1\0\50\70\2\0\1\202\1\0\1\202"+
    "\1\0\1\203\6\0\3\202\1\0\2\202\3\0\1\202"+
    "\1\0\1\204\4\202\2\0\21\202\20\0\7\205\1\0"+
    "\16\205\1\206\51\205\27\0\1\207\51\0\2\77\1\0"+
    "\2\77\6\0\4\77\1\0\2\77\3\0\1\77\2\0"+
    "\4\77\2\0\21\77\20\0\6\210\2\0\70\210\1\0"+
    "\2\77\1\0\2\77\6\0\4\77\1\0\2\77\3\0"+
    "\1\77\2\0\1\77\1\211\2\77\2\0\21\77\56\0"+
    "\1\212\52\0\1\213\106\0\1\214\60\0\1\127\12\0"+
    "\1\127\3\0\1\215\60\0\1\216\12\0\1\216\4\0"+
    "\1\111\1\0\1\216\22\0\1\111\13\0\1\216\15\0"+
    "\6\113\1\217\1\0\70\113\1\0\2\114\1\0\2\114"+
    "\6\0\4\114\1\0\2\114\3\0\1\114\2\0\4\114"+
    "\2\0\21\114\20\0\6\220\2\0\70\220\7\116\1\0"+
    "\70\116\36\0\1\221\41\0\7\121\1\0\70\121\34\0"+
    "\1\222\7\0\1\223\113\0\1\224\20\0\1\124\12\0"+
    "\1\124\3\0\1\225\1\111\1\112\16\0\1\112\4\0"+
    "\1\111\32\0\2\125\11\0\1\125\1\0\1\125\1\107"+
    "\1\214\2\125\16\0\2\125\1\107\2\0\2\125\3\0"+
    "\1\125\2\0\1\125\22\0\1\126\12\0\1\126\2\0"+
    "\1\107\1\214\22\0\1\107\35\0\1\127\12\0\1\127"+
    "\4\0\1\111\1\112\16\0\1\112\4\0\1\111\51\0"+
    "\1\226\57\0\7\23\1\0\70\23\27\0\1\227\51\0"+
    "\2\11\1\0\2\11\6\0\4\11\1\0\2\11\3\0"+
    "\1\11\2\0\2\11\1\230\1\11\2\0\6\11\1\231"+
    "\12\11\21\0\2\11\1\0\2\11\6\0\4\11\1\0"+
    "\2\11\3\0\1\11\2\0\4\11\2\0\1\11\1\232"+
    "\17\11\21\0\2\11\1\0\2\11\6\0\4\11\1\0"+
    "\2\11\3\0\1\233\2\0\4\11\2\0\1\234\20\11"+
    "\21\0\2\11\1\0\2\11\6\0\4\11\1\0\2\11"+
    "\3\0\1\11\2\0\1\235\3\11\2\0\21\11\21\0"+
    "\2\11\1\0\2\11\6\0\4\11\1\0\2\11\3\0"+
    "\1\11\2\0\4\11\2\0\1\11\1\236\17\11\21\0"+
    "\2\11\1\0\2\11\6\0\4\11\1\0\2\11\3\0"+
    "\1\11\2\0\4\11\2\0\2\11\1\237\16\11\21\0"+
    "\2\11\1\0\2\11\6\0\4\11\1\0\2\11\3\0"+
    "\1\11\2\0\4\11\2\0\10\11\1\240\10\11\21\0"+
    "\2\11\1\0\2\11\6\0\4\11\1\0\2\11\3\0"+
    "\1\11\2\0\3\11\1\241\2\0\21\11\21\0\2\11"+
    "\1\0\2\11\6\0\4\11\1\0\2\11\3\0\1\11"+
    "\2\0\4\11\2\0\21\11\1\0\1\242\17\0\2\11"+
    "\1\0\2\11\6\0\4\11\1\0\2\11\3\0\1\11"+
    "\2\0\4\11\2\0\4\11\1\243\14\11\21\0\2\11"+
    "\1\0\2\11\6\0\4\11\1\0\2\11\3\0\1\11"+
    "\2\0\1\244\3\11\2\0\21\11\21\0\2\11\1\0"+
    "\2\11\6\0\4\11\1\0\2\11\3\0\1\11\2\0"+
    "\4\11\2\0\5\11\1\245\13\11\21\0\2\11\1\0"+
    "\2\11\6\0\4\11\1\0\2\11\3\0\1\11\2\0"+
    "\4\11\2\0\4\11\1\246\14\11\21\0\2\11\1\0"+
    "\2\11\6\0\4\11\1\0\2\11\3\0\1\11\2\0"+
    "\4\11\2\0\6\11\1\247\12\11\21\0\2\11\1\0"+
    "\2\11\6\0\4\11\1\0\2\11\3\0\1\11\2\0"+
    "\4\11\2\0\3\11\1\250\15\11\21\0\2\11\1\0"+
    "\2\11\6\0\4\11\1\0\2\11\3\0\1\11\2\0"+
    "\4\11\2\0\5\11\1\251\13\11\21\0\2\11\1\0"+
    "\2\11\6\0\4\11\1\0\2\11\3\0\1\11\2\0"+
    "\4\11\2\0\15\11\1\252\3\11\21\0\2\11\1\0"+
    "\2\11\6\0\4\11\1\0\2\11\3\0\1\11\2\0"+
    "\4\11\2\0\2\11\1\253\16\11\21\0\2\11\1\0"+
    "\2\11\6\0\4\11\1\0\2\11\3\0\1\11\2\0"+
    "\2\11\1\254\1\11\2\0\2\11\1\255\16\11\21\0"+
    "\2\11\1\0\2\11\6\0\4\11\1\0\2\11\3\0"+
    "\1\11\2\0\4\11\2\0\4\11\1\256\1\11\1\257"+
    "\12\11\100\0\1\260\20\0\2\202\1\0\2\202\6\0"+
    "\4\202\1\0\2\202\3\0\1\202\2\0\4\202\2\0"+
    "\21\202\20\0\6\261\2\0\70\261\1\0\2\262\11\0"+
    "\1\262\1\0\1\262\2\0\2\262\16\0\2\262\3\0"+
    "\2\262\3\0\1\262\2\0\1\262\50\0\1\263\50\0"+
    "\6\210\1\264\1\0\70\210\1\0\2\77\1\0\2\77"+
    "\6\0\4\77\1\0\2\77\3\0\1\77\2\0\2\77"+
    "\1\265\1\77\2\0\21\77\40\0\1\215\60\0\1\216"+
    "\12\0\1\216\4\0\1\111\24\0\1\111\31\0\6\220"+
    "\1\266\1\0\70\220\11\0\1\267\67\0\2\270\1\0"+
    "\2\270\6\0\4\270\1\0\2\270\3\0\1\270\2\0"+
    "\4\270\2\0\21\270\21\0\1\127\12\0\1\127\64\0"+
    "\2\11\1\0\2\11\6\0\4\11\1\0\2\11\3\0"+
    "\1\11\2\0\3\11\1\271\2\0\21\11\21\0\2\11"+
    "\1\0\2\11\6\0\4\11\1\0\2\11\3\0\1\11"+
    "\2\0\4\11\2\0\11\11\1\272\7\11\21\0\2\11"+
    "\1\0\2\11\6\0\4\11\1\0\2\11\3\0\1\11"+
    "\2\0\4\11\2\0\2\11\1\273\16\11\21\0\2\11"+
    "\1\0\2\11\6\0\4\11\1\0\2\11\3\0\1\11"+
    "\2\0\4\11\2\0\2\11\1\274\16\11\21\0\2\11"+
    "\1\0\2\11\6\0\4\11\1\0\2\11\3\0\1\11"+
    "\2\0\4\11\2\0\2\11\1\275\16\11\21\0\2\11"+
    "\1\0\2\11\6\0\4\11\1\0\2\11\3\0\1\11"+
    "\2\0\4\11\2\0\2\11\1\276\16\11\21\0\2\11"+
    "\1\0\2\11\6\0\4\11\1\0\2\11\3\0\1\11"+
    "\2\0\4\11\2\0\4\11\1\277\14\11\21\0\2\11"+
    "\1\0\2\11\6\0\4\11\1\0\2\11\3\0\1\11"+
    "\2\0\4\11\2\0\12\11\1\300\6\11\21\0\2\11"+
    "\1\0\2\11\6\0\4\11\1\0\2\11\3\0\1\11"+
    "\2\0\4\11\2\0\2\11\1\301\16\11\21\0\2\11"+
    "\1\0\2\11\6\0\4\11\1\0\2\11\3\0\1\11"+
    "\2\0\4\11\2\0\4\11\1\302\14\11\21\0\2\11"+
    "\1\0\2\11\6\0\4\11\1\0\2\11\3\0\1\303"+
    "\2\0\4\11\2\0\21\11\21\0\2\11\1\0\2\11"+
    "\6\0\4\11\1\0\2\11\3\0\1\11\2\0\3\11"+
    "\1\304\2\0\21\11\21\0\2\11\1\0\2\11\6\0"+
    "\4\11\1\0\2\11\3\0\1\11\2\0\3\11\1\305"+
    "\2\0\21\11\21\0\2\11\1\0\2\11\6\0\4\11"+
    "\1\0\2\11\3\0\1\11\2\0\1\306\3\11\2\0"+
    "\21\11\21\0\2\11\1\0\2\11\6\0\4\11\1\0"+
    "\2\11\3\0\1\11\2\0\4\11\2\0\2\11\1\307"+
    "\16\11\21\0\2\11\1\0\2\11\6\0\4\11\1\0"+
    "\2\11\3\0\1\11\2\0\4\11\2\0\3\11\1\310"+
    "\15\11\21\0\2\11\1\0\2\11\6\0\4\11\1\0"+
    "\2\11\3\0\1\11\2\0\4\11\2\0\4\11\1\311"+
    "\14\11\21\0\2\11\1\0\2\11\6\0\4\11\1\0"+
    "\2\11\3\0\1\11\2\0\4\11\2\0\5\11\1\312"+
    "\13\11\20\0\6\261\1\313\1\0\70\261\1\0\2\314"+
    "\11\0\1\314\1\0\1\314\2\0\2\314\16\0\2\314"+
    "\3\0\2\314\3\0\1\314\2\0\1\314\22\0\2\77"+
    "\1\0\2\77\6\0\4\77\1\0\2\77\3\0\1\77"+
    "\2\0\3\77\1\315\2\0\21\77\21\0\2\11\1\0"+
    "\2\11\6\0\4\11\1\0\2\11\3\0\1\11\2\0"+
    "\4\11\2\0\16\11\1\316\2\11\21\0\2\11\1\0"+
    "\2\11\6\0\4\11\1\0\2\11\3\0\1\11\2\0"+
    "\4\11\2\0\3\11\1\317\5\11\1\320\7\11\21\0"+
    "\2\11\1\0\2\11\6\0\4\11\1\0\2\11\3\0"+
    "\1\11\2\0\4\11\2\0\6\11\1\321\12\11\21\0"+
    "\2\11\1\0\2\11\6\0\4\11\1\0\2\11\3\0"+
    "\1\11\2\0\4\11\2\0\6\11\1\322\12\11\21\0"+
    "\2\11\1\0\2\11\6\0\4\11\1\0\2\11\3\0"+
    "\1\11\2\0\4\11\2\0\17\11\1\323\1\11\21\0"+
    "\2\11\1\0\2\11\6\0\4\11\1\0\2\11\3\0"+
    "\1\11\2\0\4\11\2\0\3\11\1\324\15\11\21\0"+
    "\2\11\1\0\2\11\6\0\4\11\1\0\2\11\3\0"+
    "\1\11\2\0\4\11\2\0\6\11\1\325\12\11\21\0"+
    "\2\11\1\0\2\11\6\0\4\11\1\0\2\11\3\0"+
    "\1\11\2\0\4\11\2\0\2\11\1\326\16\11\21\0"+
    "\2\11\1\0\2\11\6\0\4\11\1\0\2\11\3\0"+
    "\1\11\2\0\3\11\1\327\2\0\21\11\21\0\2\11"+
    "\1\0\2\11\6\0\4\11\1\0\2\11\3\0\1\11"+
    "\2\0\2\11\1\330\1\11\2\0\21\11\21\0\2\11"+
    "\1\0\2\11\6\0\4\11\1\0\2\11\3\0\1\11"+
    "\2\0\4\11\2\0\10\11\1\331\10\11\21\0\2\11"+
    "\1\0\2\11\6\0\4\11\1\0\2\11\3\0\1\11"+
    "\2\0\4\11\2\0\12\11\1\332\6\11\21\0\2\11"+
    "\1\0\2\11\6\0\4\11\1\0\2\11\3\0\1\11"+
    "\2\0\4\11\2\0\2\11\1\333\16\11\21\0\2\334"+
    "\11\0\1\334\1\0\1\334\2\0\2\334\16\0\2\334"+
    "\3\0\2\334\3\0\1\334\2\0\1\334\22\0\2\11"+
    "\1\0\2\11\6\0\4\11\1\0\2\11\3\0\1\11"+
    "\2\0\4\11\2\0\4\11\1\335\14\11\21\0\2\11"+
    "\1\0\2\11\6\0\4\11\1\0\2\11\3\0\1\11"+
    "\2\0\4\11\2\0\7\11\1\336\11\11\21\0\2\11"+
    "\1\0\2\11\6\0\4\11\1\0\2\11\3\0\1\11"+
    "\2\0\4\11\2\0\7\11\1\337\11\11\21\0\2\11"+
    "\1\0\2\11\6\0\4\11\1\0\2\11\3\0\1\11"+
    "\2\0\4\11\2\0\13\11\1\340\5\11\21\0\2\11"+
    "\1\0\2\11\6\0\4\11\1\0\2\11\3\0\1\11"+
    "\2\0\4\11\2\0\5\11\1\341\13\11\21\0\2\11"+
    "\1\0\2\11\6\0\4\11\1\0\2\11\3\0\1\11"+
    "\2\0\4\11\2\0\5\11\1\342\13\11\21\0\2\11"+
    "\1\0\2\11\6\0\4\11\1\0\2\11\3\0\1\11"+
    "\2\0\1\343\3\11\2\0\21\11\21\0\2\205\11\0"+
    "\1\205\1\0\1\205\2\0\2\205\16\0\2\205\3\0"+
    "\2\205\3\0\1\205\2\0\1\205\22\0\2\11\1\0"+
    "\2\11\6\0\4\11\1\0\2\11\3\0\1\11\2\0"+
    "\2\11\1\344\1\11\2\0\21\11\21\0\2\11\1\0"+
    "\2\11\6\0\4\11\1\0\2\11\3\0\1\11\2\0"+
    "\4\11\2\0\3\11\1\345\15\11\21\0\2\11\1\0"+
    "\2\11\6\0\4\11\1\0\2\11\3\0\1\11\2\0"+
    "\4\11\2\0\2\11\1\346\16\11\21\0\2\11\1\0"+
    "\2\11\6\0\4\11\1\0\2\11\3\0\1\347\2\0"+
    "\4\11\2\0\21\11\21\0\2\11\1\0\2\11\6\0"+
    "\4\11\1\0\2\11\3\0\1\11\2\0\4\11\2\0"+
    "\3\11\1\350\15\11\21\0\2\11\1\0\2\11\6\0"+
    "\4\11\1\0\2\11\3\0\1\11\2\0\4\11\2\0"+
    "\10\11\1\351\10\11\21\0\2\11\1\0\2\11\6\0"+
    "\4\11\1\0\2\11\3\0\1\11\2\0\4\11\2\0"+
    "\2\11\1\352\16\11\21\0\2\11\1\0\2\11\6\0"+
    "\4\11\1\0\2\11\3\0\1\11\2\0\3\11\1\353"+
    "\2\0\21\11\21\0\2\11\1\0\2\11\6\0\4\11"+
    "\1\0\2\11\3\0\1\11\2\0\4\11\2\0\2\11"+
    "\1\354\16\11\20\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[10112];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;
  private static final char[] EMPTY_BUFFER = new char[0];
  private static final int YYEOF = -1;
  private static java.io.Reader zzReader = null; // Fake

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\6\0\1\11\15\1\1\11\3\1\1\11\17\1\1\11"+
    "\7\1\4\11\1\1\2\11\1\1\1\11\2\1\2\11"+
    "\4\1\1\11\2\1\2\11\1\1\1\0\1\11\1\1"+
    "\1\0\1\1\1\0\2\1\1\11\1\1\1\0\1\1"+
    "\1\0\4\1\4\11\1\1\1\0\7\1\1\11\21\1"+
    "\12\11\1\1\1\0\2\11\1\1\2\0\1\1\2\11"+
    "\1\0\1\11\1\1\1\11\1\0\3\1\1\11\1\0"+
    "\2\11\12\1\1\11\15\1\1\11\2\0\1\1\1\11"+
    "\1\1\3\11\22\1\1\11\1\0\17\1\1\0\20\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[236];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private CharSequence zzBuffer = "";

  /** this buffer may contains the current text array to be matched when it is cheap to acquire it */
  private char[] zzBufferArray;

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the textposition at the last state to be included in yytext */
  private int zzPushbackPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /**
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */
    private static final class State {
        final int lBraceCount;
        final int state;

        public State(int state, int lBraceCount) {
            this.state = state;
            this.lBraceCount = lBraceCount;
        }

        @Override
        public String toString() {
            return "yystate = " + state + (lBraceCount == 0 ? "" : "lBraceCount = " + lBraceCount);
        }
    }

    private final Stack<State> states = new Stack<State>();
    private int lBraceCount;

    private int commentStart;
    private int commentDepth;

    private void pushState(int state) {
        states.push(new State(yystate(), lBraceCount));
        lBraceCount = 0;
        yybegin(state);
    }

    private void popState() {
        State state = states.pop();
        lBraceCount = state.lBraceCount;
        yybegin(state.state);
    }

    private IElementType commentStateToTokenType(int state) {
        switch (state) {
            case BLOCK_COMMENT:
                return KtTokens.BLOCK_COMMENT;
            case DOC_COMMENT:
                return KtTokens.DOC_COMMENT;
            default:
                throw new IllegalArgumentException("Unexpected state: " + state);
        }
    }


  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  _JetLexer(java.io.Reader in) {
    this.zzReader = in;
  }


  /**
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 1704) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }

  public final int getTokenStart(){
    return zzStartRead;
  }

  public final int getTokenEnd(){
    return getTokenStart() + yylength();
  }

  public void reset(CharSequence buffer, int start, int end,int initialState){
    zzBuffer = buffer;
    zzBufferArray = com.intellij.util.text.CharArrayUtil.fromSequenceWithoutCopying(buffer);
    zzCurrentPos = zzMarkedPos = zzStartRead = start;
    zzPushbackPos = 0;
    zzAtEOF  = false;
    zzAtBOL = true;
    zzEndRead = end;
    yybegin(initialState);
  }

  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   *
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {
    return true;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final CharSequence yytext() {
    return zzBuffer.subSequence(zzStartRead, zzMarkedPos);
  }


  /**
   * Returns the character at position <tt>pos</tt> from the
   * matched text.
   *
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch.
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBufferArray != null ? zzBufferArray[zzStartRead+pos]:zzBuffer.charAt(zzStartRead+pos);
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of
   * yypushback(int) and a match-all fallback rule) this method
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) throws KotlinLexerException {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new KotlinLexerException(message + "\n at '" + yytext() + "'\n" + zzBuffer);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  throws KotlinLexerException {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() {
    if (!zzEOFDone) {
      zzEOFDone = true;
      return;

    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public IElementType advance() throws java.io.IOException, KotlinLexerException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    CharSequence zzBufferL = zzBuffer;
    char[] zzBufferArrayL = zzBufferArray;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = ZZ_LEXSTATE[zzLexicalState];


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL)
            zzInput = (zzBufferArrayL != null ? zzBufferArrayL[zzCurrentPosL++] : zzBufferL.charAt(zzCurrentPosL++));
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = (zzBufferArrayL != null ? zzBufferArrayL[zzCurrentPosL++] : zzBufferL.charAt(zzCurrentPosL++));
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 22: 
          { return KtTokens.LBRACKET  ;
          }
        case 106: break;
        case 78: 
          { return KtTokens.FUN_KEYWORD ;
          }
        case 107: break;
        case 48: 
          { return KtTokens.IN_KEYWORD ;
          }
        case 108: break;
        case 58: 
          { return KtTokens.GTEQ      ;
          }
        case 109: break;
        case 87: 
          { return KtTokens.TRUE_KEYWORD ;
          }
        case 110: break;
        case 13: 
          { return KtTokens.RBRACE    ;
          }
        case 111: break;
        case 10: 
          { return KtTokens.CHARACTER_LITERAL;
          }
        case 112: break;
        case 7: 
          { return KtTokens.EXCL      ;
          }
        case 113: break;
        case 80: 
          { return KtTokens.VAL_KEYWORD ;
          }
        case 114: break;
        case 42: 
          { return KtTokens.EXCLEQ    ;
          }
        case 115: break;
        case 45: 
          { return KtTokens.MINUSEQ   ;
          }
        case 116: break;
        case 36: 
          { return KtTokens.FLOAT_LITERAL;
          }
        case 117: break;
        case 51: 
          { return KtTokens.AS_KEYWORD ;
          }
        case 118: break;
        case 90: 
          { return KtTokens.WHEN_KEYWORD ;
          }
        case 119: break;
        case 16: 
          { return KtTokens.QUEST     ;
          }
        case 120: break;
        case 95: 
          { return KtTokens.FALSE_KEYWORD ;
          }
        case 121: break;
        case 34: 
          { lBraceCount++; return KtTokens.LBRACE;
          }
        case 122: break;
        case 44: 
          { return KtTokens.MINUSMINUS;
          }
        case 123: break;
        case 66: 
          { return KtTokens.ESCAPE_SEQUENCE;
          }
        case 124: break;
        case 5: 
          { return KtTokens.DIV       ;
          }
        case 125: break;
        case 79: 
          { return KtTokens.FOR_KEYWORD ;
          }
        case 126: break;
        case 30: 
          { popState(); yypushback(1); return KtTokens.DANGLING_NEWLINE;
          }
        case 127: break;
        case 52: 
          { return KtTokens.DO_KEYWORD ;
          }
        case 128: break;
        case 103: 
          { return KtTokens.CONTINUE_KEYWORD ;
          }
        case 129: break;
        case 105: 
          { return KtTokens.INTERFACE_KEYWORD ;
          }
        case 130: break;
        case 75: 
          { pushState(RAW_STRING); return KtTokens.OPEN_QUOTE;
          }
        case 131: break;
        case 4: 
          { return KtTokens.WHITE_SPACE;
          }
        case 132: break;
        case 97: 
          { return KtTokens.BREAK_KEYWORD ;
          }
        case 133: break;
        case 85: 
          { yypushback(3); return KtTokens.EXCL;
          }
        case 134: break;
        case 60: 
          { return KtTokens.OROR      ;
          }
        case 135: break;
        case 20: 
          { return KtTokens.PERC      ;
          }
        case 136: break;
        case 73: 
          { return KtTokens.EXCLEQEQEQ;
          }
        case 137: break;
        case 61: 
          { return KtTokens.PERCEQ    ;
          }
        case 138: break;
        case 43: 
          { return KtTokens.RANGE     ;
          }
        case 139: break;
        case 54: 
          { return KtTokens.DOUBLE_ARROW;
          }
        case 140: break;
        case 38: 
          { return KtTokens.EOL_COMMENT;
          }
        case 141: break;
        case 31: 
          { popState(); return KtTokens.CLOSING_QUOTE;
          }
        case 142: break;
        case 14: 
          { return KtTokens.MUL       ;
          }
        case 143: break;
        case 23: 
          { return KtTokens.RBRACKET  ;
          }
        case 144: break;
        case 56: 
          { return KtTokens.PLUSPLUS  ;
          }
        case 145: break;
        case 101: 
          { return KtTokens.OBJECT_KEYWORD ;
          }
        case 146: break;
        case 68: 
          { if (commentDepth > 0) {
            commentDepth--;
        }
        else {
             int state = yystate();
             popState();
             zzStartRead = commentStart;
             return commentStateToTokenType(state);
        }
          }
        case 147: break;
        case 8: 
          { return KtTokens.DOT       ;
          }
        case 148: break;
        case 26: 
          { return KtTokens.SEMICOLON ;
          }
        case 149: break;
        case 94: 
          { return KtTokens.YIELD_KEYWORD ;
          }
        case 150: break;
        case 69: 
          { yypushback(2); return KtTokens.INTEGER_LITERAL;
          }
        case 151: break;
        case 32: 
          { popState(); return KtTokens.IDENTIFIER;
          }
        case 152: break;
        case 81: 
          { return KtTokens.VAR_KEYWORD ;
          }
        case 153: break;
        case 104: 
          { return KtTokens.TYPE_ALIAS_KEYWORD ;
          }
        case 154: break;
        case 100: 
          { return KtTokens.RETURN_KEYWORD ;
          }
        case 155: break;
        case 37: 
          { return KtTokens.FIELD_IDENTIFIER;
          }
        case 156: break;
        case 15: 
          { return KtTokens.EQ        ;
          }
        case 157: break;
        case 28: 
          { return KtTokens.AT        ;
          }
        case 158: break;
        case 76: 
          { return KtTokens.TRY_KEYWORD ;
          }
        case 159: break;
        case 24: 
          { return KtTokens.LPAR      ;
          }
        case 160: break;
        case 9: 
          { return KtTokens.MINUS     ;
          }
        case 161: break;
        case 70: 
          { pushState(DOC_COMMENT);
    commentDepth = 0;
    commentStart = getTokenStart();
          }
        case 162: break;
        case 86: 
          { return KtTokens.THIS_KEYWORD ;
          }
        case 163: break;
        case 1: 
          { return TokenType.BAD_CHARACTER;
          }
        case 164: break;
        case 98: 
          { return KtTokens.WHILE_KEYWORD ;
          }
        case 165: break;
        case 99: 
          { return KtTokens.TYPEOF_KEYWORD ;
          }
        case 166: break;
        case 40: 
          { return KtTokens.DIVEQ     ;
          }
        case 167: break;
        case 96: 
          { return KtTokens.CLASS_KEYWORD ;
          }
        case 168: break;
        case 53: 
          { return KtTokens.EQEQ      ;
          }
        case 169: break;
        case 82: 
          { return KtTokens.EQEQEQ    ;
          }
        case 170: break;
        case 83: 
          { int length = yytext().length();
                                    if (length <= 3) { // closing """
                                        popState();
                                        return KtTokens.CLOSING_QUOTE;
                                    }
                                    else { // some quotes at the end of a string, e.g. """ "foo""""
                                        yypushback(3); // return the closing quotes (""") to the stream
                                        return KtTokens.REGULAR_STRING_PART;
                                    }
          }
        case 171: break;
        case 50: 
          { return KtTokens.MULTEQ    ;
          }
        case 172: break;
        case 65: 
          { pushState(LONG_TEMPLATE_ENTRY); return KtTokens.LONG_TEMPLATE_ENTRY_START;
          }
        case 173: break;
        case 12: 
          { return KtTokens.LBRACE    ;
          }
        case 174: break;
        case 39: 
          { pushState(BLOCK_COMMENT);
    commentDepth = 0;
    commentStart = getTokenStart();
          }
        case 175: break;
        case 92: 
          { return KtTokens.THROW_KEYWORD ;
          }
        case 176: break;
        case 93: 
          { return KtTokens.SUPER_KEYWORD ;
          }
        case 177: break;
        case 62: 
          { return KtTokens.COLONCOLON;
          }
        case 178: break;
        case 72: 
          { return KtTokens.NOT_IN;
          }
        case 179: break;
        case 63: 
          { return KtTokens.DOUBLE_SEMICOLON;
          }
        case 180: break;
        case 6: 
          { return KtTokens.HASH      ;
          }
        case 181: break;
        case 3: 
          { return KtTokens.IDENTIFIER;
          }
        case 182: break;
        case 2: 
          { return KtTokens.INTEGER_LITERAL;
          }
        case 183: break;
        case 88: 
          { return KtTokens.ELSE_KEYWORD ;
          }
        case 184: break;
        case 11: 
          { pushState(STRING); return KtTokens.OPEN_QUOTE;
          }
        case 185: break;
        case 102: 
          { return KtTokens.PACKAGE_KEYWORD ;
          }
        case 186: break;
        case 49: 
          { return KtTokens.IF_KEYWORD ;
          }
        case 187: break;
        case 18: 
          { return KtTokens.LT        ;
          }
        case 188: break;
        case 17: 
          { return KtTokens.PLUS      ;
          }
        case 189: break;
        case 55: 
          { return KtTokens.PLUSEQ    ;
          }
        case 190: break;
        case 74: 
          { return KtTokens.RESERVED  ;
          }
        case 191: break;
        case 67: 
          { commentDepth++;
          }
        case 192: break;
        case 27: 
          { return KtTokens.COMMA     ;
          }
        case 193: break;
        case 19: 
          { return KtTokens.GT        ;
          }
        case 194: break;
        case 77: 
          { return KtTokens.AS_SAFE;
          }
        case 195: break;
        case 25: 
          { return KtTokens.RPAR      ;
          }
        case 196: break;
        case 71: 
          { return KtTokens.NOT_IS;
          }
        case 197: break;
        case 89: 
          { return KtTokens.NULL_KEYWORD ;
          }
        case 198: break;
        case 59: 
          { return KtTokens.ANDAND    ;
          }
        case 199: break;
        case 35: 
          { if (lBraceCount == 0) {
                                             popState();
                                             return KtTokens.LONG_TEMPLATE_ENTRY_END;
                                           }
                                           lBraceCount--;
                                           return KtTokens.RBRACE;
          }
        case 200: break;
        case 84: 
          { return KtTokens.BLOCK_COMMENT;
          }
        case 201: break;
        case 41: 
          { if (zzCurrentPos == 0) {
                return KtTokens.SHEBANG_COMMENT;
            }
            else {
                yypushback(yylength() - 1);
                return KtTokens.HASH;
            }
          }
        case 202: break;
        case 29: 
          { return KtTokens.REGULAR_STRING_PART;
          }
        case 203: break;
        case 47: 
          { return KtTokens.IS_KEYWORD ;
          }
        case 204: break;
        case 91: 
          { popState(); return KtTokens.THIS_KEYWORD;
          }
        case 205: break;
        case 21: 
          { return KtTokens.COLON     ;
          }
        case 206: break;
        case 57: 
          { return KtTokens.LTEQ      ;
          }
        case 207: break;
        case 33: 
          { 
          }
        case 208: break;
        case 64: 
          { pushState(SHORT_TEMPLATE_ENTRY);
                                                        yypushback(yylength() - 1);
                                                        return KtTokens.SHORT_TEMPLATE_ENTRY_START;
          }
        case 209: break;
        case 46: 
          { return KtTokens.ARROW     ;
          }
        case 210: break;
        default:
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            zzDoEOF();
            switch (zzLexicalState) {
            case BLOCK_COMMENT: {
              int state = yystate();
        popState();
        zzStartRead = commentStart;
        return commentStateToTokenType(state);
            }
            case 237: break;
            case DOC_COMMENT: {
              int state = yystate();
        popState();
        zzStartRead = commentStart;
        return commentStateToTokenType(state);
            }
            case 238: break;
            default:
            return null;
            }
          }
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
