/*
 * Copyright 2010-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.kotlin.incremental

import org.jetbrains.kotlin.name.ClassId
import org.jetbrains.kotlin.serialization.ProtoBuf
import org.jetbrains.kotlin.serialization.deserialization.NameResolver
import org.jetbrains.kotlin.serialization.jvm.JvmProtoBuf
import org.jetbrains.kotlin.utils.Interner
import java.util.*

/** This file is generated by org.jetbrains.kotlin.generators.protobuf.GenerateProtoBufCompare. DO NOT MODIFY MANUALLY */

open class ProtoCompareGenerated(val oldNameResolver: NameResolver, val newNameResolver: NameResolver) {
    private val strings = Interner<String>()
    val oldStringIndexesMap: MutableMap<Int, Int> = hashMapOf()
    val newStringIndexesMap: MutableMap<Int, Int> = hashMapOf()
    val oldClassIdIndexesMap: MutableMap<Int, Int> = hashMapOf()
    val newClassIdIndexesMap: MutableMap<Int, Int> = hashMapOf()

    private val classIds = Interner<ClassId>()

    open fun checkEquals(old: ProtoBuf.Package, new: ProtoBuf.Package): Boolean {
        if (!checkEqualsPackageFunction(old, new)) return false

        if (!checkEqualsPackageProperty(old, new)) return false

        if (old.hasTypeTable() != new.hasTypeTable()) return false
        if (old.hasTypeTable()) {
            if (!checkEquals(old.typeTable, new.typeTable)) return false
        }

        if (old.hasSinceKotlinInfoTable() != new.hasSinceKotlinInfoTable()) return false
        if (old.hasSinceKotlinInfoTable()) {
            if (!checkEquals(old.sinceKotlinInfoTable, new.sinceKotlinInfoTable)) return false
        }

        if (old.hasExtension(JvmProtoBuf.packageModuleName) != new.hasExtension(JvmProtoBuf.packageModuleName)) return false
        if (old.hasExtension(JvmProtoBuf.packageModuleName)) {
            if (!checkStringEquals(old.getExtension(JvmProtoBuf.packageModuleName), new.getExtension(JvmProtoBuf.packageModuleName))) return false
        }

        return true
    }
    enum class ProtoBufPackageKind {
        FUNCTION_LIST,
        PROPERTY_LIST,
        TYPE_TABLE,
        SINCE_KOTLIN_INFO_TABLE,
        PACKAGE_MODULE_NAME
    }

    fun difference(old: ProtoBuf.Package, new: ProtoBuf.Package): EnumSet<ProtoBufPackageKind> {
        val result = EnumSet.noneOf(ProtoBufPackageKind::class.java)

        if (!checkEqualsPackageFunction(old, new)) result.add(ProtoBufPackageKind.FUNCTION_LIST)

        if (!checkEqualsPackageProperty(old, new)) result.add(ProtoBufPackageKind.PROPERTY_LIST)

        if (old.hasTypeTable() != new.hasTypeTable()) result.add(ProtoBufPackageKind.TYPE_TABLE)
        if (old.hasTypeTable()) {
            if (!checkEquals(old.typeTable, new.typeTable)) result.add(ProtoBufPackageKind.TYPE_TABLE)
        }

        if (old.hasSinceKotlinInfoTable() != new.hasSinceKotlinInfoTable()) result.add(ProtoBufPackageKind.SINCE_KOTLIN_INFO_TABLE)
        if (old.hasSinceKotlinInfoTable()) {
            if (!checkEquals(old.sinceKotlinInfoTable, new.sinceKotlinInfoTable)) result.add(ProtoBufPackageKind.SINCE_KOTLIN_INFO_TABLE)
        }

        if (old.hasExtension(JvmProtoBuf.packageModuleName) != new.hasExtension(JvmProtoBuf.packageModuleName)) result.add(ProtoBufPackageKind.PACKAGE_MODULE_NAME)
        if (old.hasExtension(JvmProtoBuf.packageModuleName)) {
            if (!checkStringEquals(old.getExtension(JvmProtoBuf.packageModuleName), new.getExtension(JvmProtoBuf.packageModuleName))) result.add(ProtoBufPackageKind.PACKAGE_MODULE_NAME)
        }

        return result
    }

    open fun checkEquals(old: ProtoBuf.Class, new: ProtoBuf.Class): Boolean {
        if (old.hasFlags() != new.hasFlags()) return false
        if (old.hasFlags()) {
            if (old.flags != new.flags) return false
        }

        if (!checkClassIdEquals(old.fqName, new.fqName)) return false

        if (old.hasCompanionObjectName() != new.hasCompanionObjectName()) return false
        if (old.hasCompanionObjectName()) {
            if (!checkStringEquals(old.companionObjectName, new.companionObjectName)) return false
        }

        if (!checkEqualsClassTypeParameter(old, new)) return false

        if (!checkEqualsClassSupertype(old, new)) return false

        if (!checkEqualsClassSupertypeId(old, new)) return false

        if (!checkEqualsClassNestedClassName(old, new)) return false

        if (!checkEqualsClassConstructor(old, new)) return false

        if (!checkEqualsClassFunction(old, new)) return false

        if (!checkEqualsClassProperty(old, new)) return false

        if (!checkEqualsClassEnumEntry(old, new)) return false

        if (old.hasTypeTable() != new.hasTypeTable()) return false
        if (old.hasTypeTable()) {
            if (!checkEquals(old.typeTable, new.typeTable)) return false
        }

        if (old.hasSinceKotlinInfo() != new.hasSinceKotlinInfo()) return false
        if (old.hasSinceKotlinInfo()) {
            if (old.sinceKotlinInfo != new.sinceKotlinInfo) return false
        }

        if (old.hasSinceKotlinInfoTable() != new.hasSinceKotlinInfoTable()) return false
        if (old.hasSinceKotlinInfoTable()) {
            if (!checkEquals(old.sinceKotlinInfoTable, new.sinceKotlinInfoTable)) return false
        }

        if (old.hasExtension(JvmProtoBuf.classModuleName) != new.hasExtension(JvmProtoBuf.classModuleName)) return false
        if (old.hasExtension(JvmProtoBuf.classModuleName)) {
            if (!checkStringEquals(old.getExtension(JvmProtoBuf.classModuleName), new.getExtension(JvmProtoBuf.classModuleName))) return false
        }

        return true
    }
    enum class ProtoBufClassKind {
        FLAGS,
        FQ_NAME,
        COMPANION_OBJECT_NAME,
        TYPE_PARAMETER_LIST,
        SUPERTYPE_LIST,
        SUPERTYPE_ID_LIST,
        NESTED_CLASS_NAME_LIST,
        CONSTRUCTOR_LIST,
        FUNCTION_LIST,
        PROPERTY_LIST,
        ENUM_ENTRY_LIST,
        TYPE_TABLE,
        SINCE_KOTLIN_INFO,
        SINCE_KOTLIN_INFO_TABLE,
        CLASS_MODULE_NAME
    }

    fun difference(old: ProtoBuf.Class, new: ProtoBuf.Class): EnumSet<ProtoBufClassKind> {
        val result = EnumSet.noneOf(ProtoBufClassKind::class.java)

        if (old.hasFlags() != new.hasFlags()) result.add(ProtoBufClassKind.FLAGS)
        if (old.hasFlags()) {
            if (old.flags != new.flags) result.add(ProtoBufClassKind.FLAGS)
        }

        if (!checkClassIdEquals(old.fqName, new.fqName)) result.add(ProtoBufClassKind.FQ_NAME)

        if (old.hasCompanionObjectName() != new.hasCompanionObjectName()) result.add(ProtoBufClassKind.COMPANION_OBJECT_NAME)
        if (old.hasCompanionObjectName()) {
            if (!checkStringEquals(old.companionObjectName, new.companionObjectName)) result.add(ProtoBufClassKind.COMPANION_OBJECT_NAME)
        }

        if (!checkEqualsClassTypeParameter(old, new)) result.add(ProtoBufClassKind.TYPE_PARAMETER_LIST)

        if (!checkEqualsClassSupertype(old, new)) result.add(ProtoBufClassKind.SUPERTYPE_LIST)

        if (!checkEqualsClassSupertypeId(old, new)) result.add(ProtoBufClassKind.SUPERTYPE_ID_LIST)

        if (!checkEqualsClassNestedClassName(old, new)) result.add(ProtoBufClassKind.NESTED_CLASS_NAME_LIST)

        if (!checkEqualsClassConstructor(old, new)) result.add(ProtoBufClassKind.CONSTRUCTOR_LIST)

        if (!checkEqualsClassFunction(old, new)) result.add(ProtoBufClassKind.FUNCTION_LIST)

        if (!checkEqualsClassProperty(old, new)) result.add(ProtoBufClassKind.PROPERTY_LIST)

        if (!checkEqualsClassEnumEntry(old, new)) result.add(ProtoBufClassKind.ENUM_ENTRY_LIST)

        if (old.hasTypeTable() != new.hasTypeTable()) result.add(ProtoBufClassKind.TYPE_TABLE)
        if (old.hasTypeTable()) {
            if (!checkEquals(old.typeTable, new.typeTable)) result.add(ProtoBufClassKind.TYPE_TABLE)
        }

        if (old.hasSinceKotlinInfo() != new.hasSinceKotlinInfo()) result.add(ProtoBufClassKind.SINCE_KOTLIN_INFO)
        if (old.hasSinceKotlinInfo()) {
            if (old.sinceKotlinInfo != new.sinceKotlinInfo) result.add(ProtoBufClassKind.SINCE_KOTLIN_INFO)
        }

        if (old.hasSinceKotlinInfoTable() != new.hasSinceKotlinInfoTable()) result.add(ProtoBufClassKind.SINCE_KOTLIN_INFO_TABLE)
        if (old.hasSinceKotlinInfoTable()) {
            if (!checkEquals(old.sinceKotlinInfoTable, new.sinceKotlinInfoTable)) result.add(ProtoBufClassKind.SINCE_KOTLIN_INFO_TABLE)
        }

        if (old.hasExtension(JvmProtoBuf.classModuleName) != new.hasExtension(JvmProtoBuf.classModuleName)) result.add(ProtoBufClassKind.CLASS_MODULE_NAME)
        if (old.hasExtension(JvmProtoBuf.classModuleName)) {
            if (!checkStringEquals(old.getExtension(JvmProtoBuf.classModuleName), new.getExtension(JvmProtoBuf.classModuleName))) result.add(ProtoBufClassKind.CLASS_MODULE_NAME)
        }

        return result
    }

    open fun checkEquals(old: ProtoBuf.Function, new: ProtoBuf.Function): Boolean {
        if (old.hasFlags() != new.hasFlags()) return false
        if (old.hasFlags()) {
            if (old.flags != new.flags) return false
        }

        if (old.hasOldFlags() != new.hasOldFlags()) return false
        if (old.hasOldFlags()) {
            if (old.oldFlags != new.oldFlags) return false
        }

        if (!checkStringEquals(old.name, new.name)) return false

        if (old.hasReturnType() != new.hasReturnType()) return false
        if (old.hasReturnType()) {
            if (!checkEquals(old.returnType, new.returnType)) return false
        }

        if (old.hasReturnTypeId() != new.hasReturnTypeId()) return false
        if (old.hasReturnTypeId()) {
            if (old.returnTypeId != new.returnTypeId) return false
        }

        if (!checkEqualsFunctionTypeParameter(old, new)) return false

        if (old.hasReceiverType() != new.hasReceiverType()) return false
        if (old.hasReceiverType()) {
            if (!checkEquals(old.receiverType, new.receiverType)) return false
        }

        if (old.hasReceiverTypeId() != new.hasReceiverTypeId()) return false
        if (old.hasReceiverTypeId()) {
            if (old.receiverTypeId != new.receiverTypeId) return false
        }

        if (!checkEqualsFunctionValueParameter(old, new)) return false

        if (old.hasTypeTable() != new.hasTypeTable()) return false
        if (old.hasTypeTable()) {
            if (!checkEquals(old.typeTable, new.typeTable)) return false
        }

        if (old.hasSinceKotlinInfo() != new.hasSinceKotlinInfo()) return false
        if (old.hasSinceKotlinInfo()) {
            if (old.sinceKotlinInfo != new.sinceKotlinInfo) return false
        }

        if (old.hasExtension(JvmProtoBuf.methodSignature) != new.hasExtension(JvmProtoBuf.methodSignature)) return false
        if (old.hasExtension(JvmProtoBuf.methodSignature)) {
            if (!checkEquals(old.getExtension(JvmProtoBuf.methodSignature), new.getExtension(JvmProtoBuf.methodSignature))) return false
        }

        return true
    }

    open fun checkEquals(old: ProtoBuf.Property, new: ProtoBuf.Property): Boolean {
        if (old.hasFlags() != new.hasFlags()) return false
        if (old.hasFlags()) {
            if (old.flags != new.flags) return false
        }

        if (old.hasOldFlags() != new.hasOldFlags()) return false
        if (old.hasOldFlags()) {
            if (old.oldFlags != new.oldFlags) return false
        }

        if (!checkStringEquals(old.name, new.name)) return false

        if (old.hasReturnType() != new.hasReturnType()) return false
        if (old.hasReturnType()) {
            if (!checkEquals(old.returnType, new.returnType)) return false
        }

        if (old.hasReturnTypeId() != new.hasReturnTypeId()) return false
        if (old.hasReturnTypeId()) {
            if (old.returnTypeId != new.returnTypeId) return false
        }

        if (!checkEqualsPropertyTypeParameter(old, new)) return false

        if (old.hasReceiverType() != new.hasReceiverType()) return false
        if (old.hasReceiverType()) {
            if (!checkEquals(old.receiverType, new.receiverType)) return false
        }

        if (old.hasReceiverTypeId() != new.hasReceiverTypeId()) return false
        if (old.hasReceiverTypeId()) {
            if (old.receiverTypeId != new.receiverTypeId) return false
        }

        if (old.hasSetterValueParameter() != new.hasSetterValueParameter()) return false
        if (old.hasSetterValueParameter()) {
            if (!checkEquals(old.setterValueParameter, new.setterValueParameter)) return false
        }

        if (old.hasGetterFlags() != new.hasGetterFlags()) return false
        if (old.hasGetterFlags()) {
            if (old.getterFlags != new.getterFlags) return false
        }

        if (old.hasSetterFlags() != new.hasSetterFlags()) return false
        if (old.hasSetterFlags()) {
            if (old.setterFlags != new.setterFlags) return false
        }

        if (old.hasSinceKotlinInfo() != new.hasSinceKotlinInfo()) return false
        if (old.hasSinceKotlinInfo()) {
            if (old.sinceKotlinInfo != new.sinceKotlinInfo) return false
        }

        if (old.hasExtension(JvmProtoBuf.propertySignature) != new.hasExtension(JvmProtoBuf.propertySignature)) return false
        if (old.hasExtension(JvmProtoBuf.propertySignature)) {
            if (!checkEquals(old.getExtension(JvmProtoBuf.propertySignature), new.getExtension(JvmProtoBuf.propertySignature))) return false
        }

        return true
    }

    open fun checkEquals(old: ProtoBuf.TypeTable, new: ProtoBuf.TypeTable): Boolean {
        if (!checkEqualsTypeTableType(old, new)) return false

        if (old.hasFirstNullable() != new.hasFirstNullable()) return false
        if (old.hasFirstNullable()) {
            if (old.firstNullable != new.firstNullable) return false
        }

        return true
    }

    open fun checkEquals(old: ProtoBuf.SinceKotlinInfoTable, new: ProtoBuf.SinceKotlinInfoTable): Boolean {
        if (!checkEqualsSinceKotlinInfoTableInfo(old, new)) return false

        return true
    }

    open fun checkEquals(old: ProtoBuf.TypeParameter, new: ProtoBuf.TypeParameter): Boolean {
        if (old.id != new.id) return false

        if (!checkStringEquals(old.name, new.name)) return false

        if (old.hasReified() != new.hasReified()) return false
        if (old.hasReified()) {
            if (old.reified != new.reified) return false
        }

        if (old.hasVariance() != new.hasVariance()) return false
        if (old.hasVariance()) {
            if (old.variance != new.variance) return false
        }

        if (!checkEqualsTypeParameterUpperBound(old, new)) return false

        if (!checkEqualsTypeParameterUpperBoundId(old, new)) return false

        if (old.getExtensionCount(JvmProtoBuf.typeParameterAnnotation) != new.getExtensionCount(JvmProtoBuf.typeParameterAnnotation)) return false

        for(i in 0..old.getExtensionCount(JvmProtoBuf.typeParameterAnnotation) - 1) {
            if (!checkEquals(old.getExtension(JvmProtoBuf.typeParameterAnnotation, i), new.getExtension(JvmProtoBuf.typeParameterAnnotation, i))) return false
        }

        return true
    }

    open fun checkEquals(old: ProtoBuf.Type, new: ProtoBuf.Type): Boolean {
        if (!checkEqualsTypeArgument(old, new)) return false

        if (old.hasNullable() != new.hasNullable()) return false
        if (old.hasNullable()) {
            if (old.nullable != new.nullable) return false
        }

        if (old.hasFlexibleTypeCapabilitiesId() != new.hasFlexibleTypeCapabilitiesId()) return false
        if (old.hasFlexibleTypeCapabilitiesId()) {
            if (!checkStringEquals(old.flexibleTypeCapabilitiesId, new.flexibleTypeCapabilitiesId)) return false
        }

        if (old.hasFlexibleUpperBound() != new.hasFlexibleUpperBound()) return false
        if (old.hasFlexibleUpperBound()) {
            if (!checkEquals(old.flexibleUpperBound, new.flexibleUpperBound)) return false
        }

        if (old.hasFlexibleUpperBoundId() != new.hasFlexibleUpperBoundId()) return false
        if (old.hasFlexibleUpperBoundId()) {
            if (old.flexibleUpperBoundId != new.flexibleUpperBoundId) return false
        }

        if (old.hasClassName() != new.hasClassName()) return false
        if (old.hasClassName()) {
            if (!checkClassIdEquals(old.className, new.className)) return false
        }

        if (old.hasTypeParameter() != new.hasTypeParameter()) return false
        if (old.hasTypeParameter()) {
            if (old.typeParameter != new.typeParameter) return false
        }

        if (old.hasTypeParameterName() != new.hasTypeParameterName()) return false
        if (old.hasTypeParameterName()) {
            if (!checkStringEquals(old.typeParameterName, new.typeParameterName)) return false
        }

        if (old.hasOuterType() != new.hasOuterType()) return false
        if (old.hasOuterType()) {
            if (!checkEquals(old.outerType, new.outerType)) return false
        }

        if (old.hasOuterTypeId() != new.hasOuterTypeId()) return false
        if (old.hasOuterTypeId()) {
            if (old.outerTypeId != new.outerTypeId) return false
        }

        if (old.getExtensionCount(JvmProtoBuf.typeAnnotation) != new.getExtensionCount(JvmProtoBuf.typeAnnotation)) return false

        for(i in 0..old.getExtensionCount(JvmProtoBuf.typeAnnotation) - 1) {
            if (!checkEquals(old.getExtension(JvmProtoBuf.typeAnnotation, i), new.getExtension(JvmProtoBuf.typeAnnotation, i))) return false
        }

        if (old.hasExtension(JvmProtoBuf.isRaw) != new.hasExtension(JvmProtoBuf.isRaw)) return false
        if (old.hasExtension(JvmProtoBuf.isRaw)) {
            if (old.getExtension(JvmProtoBuf.isRaw) != new.getExtension(JvmProtoBuf.isRaw)) return false
        }

        return true
    }

    open fun checkEquals(old: ProtoBuf.Constructor, new: ProtoBuf.Constructor): Boolean {
        if (old.hasFlags() != new.hasFlags()) return false
        if (old.hasFlags()) {
            if (old.flags != new.flags) return false
        }

        if (!checkEqualsConstructorValueParameter(old, new)) return false

        if (old.hasSinceKotlinInfo() != new.hasSinceKotlinInfo()) return false
        if (old.hasSinceKotlinInfo()) {
            if (old.sinceKotlinInfo != new.sinceKotlinInfo) return false
        }

        if (old.hasExtension(JvmProtoBuf.constructorSignature) != new.hasExtension(JvmProtoBuf.constructorSignature)) return false
        if (old.hasExtension(JvmProtoBuf.constructorSignature)) {
            if (!checkEquals(old.getExtension(JvmProtoBuf.constructorSignature), new.getExtension(JvmProtoBuf.constructorSignature))) return false
        }

        return true
    }

    open fun checkEquals(old: ProtoBuf.EnumEntry, new: ProtoBuf.EnumEntry): Boolean {
        if (old.hasName() != new.hasName()) return false
        if (old.hasName()) {
            if (!checkStringEquals(old.name, new.name)) return false
        }

        return true
    }

    open fun checkEquals(old: ProtoBuf.ValueParameter, new: ProtoBuf.ValueParameter): Boolean {
        if (old.hasFlags() != new.hasFlags()) return false
        if (old.hasFlags()) {
            if (old.flags != new.flags) return false
        }

        if (!checkStringEquals(old.name, new.name)) return false

        if (old.hasType() != new.hasType()) return false
        if (old.hasType()) {
            if (!checkEquals(old.type, new.type)) return false
        }

        if (old.hasTypeId() != new.hasTypeId()) return false
        if (old.hasTypeId()) {
            if (old.typeId != new.typeId) return false
        }

        if (old.hasVarargElementType() != new.hasVarargElementType()) return false
        if (old.hasVarargElementType()) {
            if (!checkEquals(old.varargElementType, new.varargElementType)) return false
        }

        if (old.hasVarargElementTypeId() != new.hasVarargElementTypeId()) return false
        if (old.hasVarargElementTypeId()) {
            if (old.varargElementTypeId != new.varargElementTypeId) return false
        }

        return true
    }

    open fun checkEquals(old: JvmProtoBuf.JvmMethodSignature, new: JvmProtoBuf.JvmMethodSignature): Boolean {
        if (old.hasName() != new.hasName()) return false
        if (old.hasName()) {
            if (!checkStringEquals(old.name, new.name)) return false
        }

        if (old.hasDesc() != new.hasDesc()) return false
        if (old.hasDesc()) {
            if (!checkStringEquals(old.desc, new.desc)) return false
        }

        return true
    }

    open fun checkEquals(old: JvmProtoBuf.JvmPropertySignature, new: JvmProtoBuf.JvmPropertySignature): Boolean {
        if (old.hasField() != new.hasField()) return false
        if (old.hasField()) {
            if (!checkEquals(old.field, new.field)) return false
        }

        if (old.hasSyntheticMethod() != new.hasSyntheticMethod()) return false
        if (old.hasSyntheticMethod()) {
            if (!checkEquals(old.syntheticMethod, new.syntheticMethod)) return false
        }

        if (old.hasGetter() != new.hasGetter()) return false
        if (old.hasGetter()) {
            if (!checkEquals(old.getter, new.getter)) return false
        }

        if (old.hasSetter() != new.hasSetter()) return false
        if (old.hasSetter()) {
            if (!checkEquals(old.setter, new.setter)) return false
        }

        return true
    }

    open fun checkEquals(old: ProtoBuf.SinceKotlinInfo, new: ProtoBuf.SinceKotlinInfo): Boolean {
        if (old.hasVersion() != new.hasVersion()) return false
        if (old.hasVersion()) {
            if (old.version != new.version) return false
        }

        if (old.hasVersionFull() != new.hasVersionFull()) return false
        if (old.hasVersionFull()) {
            if (old.versionFull != new.versionFull) return false
        }

        if (old.hasLevel() != new.hasLevel()) return false
        if (old.hasLevel()) {
            if (old.level != new.level) return false
        }

        if (old.hasErrorCode() != new.hasErrorCode()) return false
        if (old.hasErrorCode()) {
            if (old.errorCode != new.errorCode) return false
        }

        if (old.hasMessage() != new.hasMessage()) return false
        if (old.hasMessage()) {
            if (!checkStringEquals(old.message, new.message)) return false
        }

        return true
    }

    open fun checkEquals(old: ProtoBuf.Annotation, new: ProtoBuf.Annotation): Boolean {
        if (!checkClassIdEquals(old.id, new.id)) return false

        if (!checkEqualsAnnotationArgument(old, new)) return false

        return true
    }

    open fun checkEquals(old: ProtoBuf.Type.Argument, new: ProtoBuf.Type.Argument): Boolean {
        if (old.hasProjection() != new.hasProjection()) return false
        if (old.hasProjection()) {
            if (old.projection != new.projection) return false
        }

        if (old.hasType() != new.hasType()) return false
        if (old.hasType()) {
            if (!checkEquals(old.type, new.type)) return false
        }

        if (old.hasTypeId() != new.hasTypeId()) return false
        if (old.hasTypeId()) {
            if (old.typeId != new.typeId) return false
        }

        return true
    }

    open fun checkEquals(old: JvmProtoBuf.JvmFieldSignature, new: JvmProtoBuf.JvmFieldSignature): Boolean {
        if (old.hasName() != new.hasName()) return false
        if (old.hasName()) {
            if (!checkStringEquals(old.name, new.name)) return false
        }

        if (old.hasDesc() != new.hasDesc()) return false
        if (old.hasDesc()) {
            if (!checkStringEquals(old.desc, new.desc)) return false
        }

        return true
    }

    open fun checkEquals(old: ProtoBuf.Annotation.Argument, new: ProtoBuf.Annotation.Argument): Boolean {
        if (!checkStringEquals(old.nameId, new.nameId)) return false

        if (!checkEquals(old.value, new.value)) return false

        return true
    }

    open fun checkEquals(old: ProtoBuf.Annotation.Argument.Value, new: ProtoBuf.Annotation.Argument.Value): Boolean {
        if (old.hasType() != new.hasType()) return false
        if (old.hasType()) {
            if (old.type != new.type) return false
        }

        if (old.hasIntValue() != new.hasIntValue()) return false
        if (old.hasIntValue()) {
            if (old.intValue != new.intValue) return false
        }

        if (old.hasFloatValue() != new.hasFloatValue()) return false
        if (old.hasFloatValue()) {
            if (old.floatValue != new.floatValue) return false
        }

        if (old.hasDoubleValue() != new.hasDoubleValue()) return false
        if (old.hasDoubleValue()) {
            if (old.doubleValue != new.doubleValue) return false
        }

        if (old.hasStringValue() != new.hasStringValue()) return false
        if (old.hasStringValue()) {
            if (!checkStringEquals(old.stringValue, new.stringValue)) return false
        }

        if (old.hasClassId() != new.hasClassId()) return false
        if (old.hasClassId()) {
            if (!checkClassIdEquals(old.classId, new.classId)) return false
        }

        if (old.hasEnumValueId() != new.hasEnumValueId()) return false
        if (old.hasEnumValueId()) {
            if (!checkStringEquals(old.enumValueId, new.enumValueId)) return false
        }

        if (old.hasAnnotation() != new.hasAnnotation()) return false
        if (old.hasAnnotation()) {
            if (!checkEquals(old.annotation, new.annotation)) return false
        }

        if (!checkEqualsAnnotationArgumentValueArrayElement(old, new)) return false

        return true
    }

    open fun checkEqualsPackageFunction(old: ProtoBuf.Package, new: ProtoBuf.Package): Boolean {
        if (old.functionCount != new.functionCount) return false

        for(i in 0..old.functionCount - 1) {
            if (!checkEquals(old.getFunction(i), new.getFunction(i))) return false
        }

        return true
    }

    open fun checkEqualsPackageProperty(old: ProtoBuf.Package, new: ProtoBuf.Package): Boolean {
        if (old.propertyCount != new.propertyCount) return false

        for(i in 0..old.propertyCount - 1) {
            if (!checkEquals(old.getProperty(i), new.getProperty(i))) return false
        }

        return true
    }

    open fun checkEqualsClassTypeParameter(old: ProtoBuf.Class, new: ProtoBuf.Class): Boolean {
        if (old.typeParameterCount != new.typeParameterCount) return false

        for(i in 0..old.typeParameterCount - 1) {
            if (!checkEquals(old.getTypeParameter(i), new.getTypeParameter(i))) return false
        }

        return true
    }

    open fun checkEqualsClassSupertype(old: ProtoBuf.Class, new: ProtoBuf.Class): Boolean {
        if (old.supertypeCount != new.supertypeCount) return false

        for(i in 0..old.supertypeCount - 1) {
            if (!checkEquals(old.getSupertype(i), new.getSupertype(i))) return false
        }

        return true
    }

    open fun checkEqualsClassSupertypeId(old: ProtoBuf.Class, new: ProtoBuf.Class): Boolean {
        if (old.supertypeIdCount != new.supertypeIdCount) return false

        for(i in 0..old.supertypeIdCount - 1) {
            if (old.getSupertypeId(i) != new.getSupertypeId(i)) return false
        }

        return true
    }

    open fun checkEqualsClassNestedClassName(old: ProtoBuf.Class, new: ProtoBuf.Class): Boolean {
        if (old.nestedClassNameCount != new.nestedClassNameCount) return false

        for(i in 0..old.nestedClassNameCount - 1) {
            if (!checkStringEquals(old.getNestedClassName(i), new.getNestedClassName(i))) return false
        }

        return true
    }

    open fun checkEqualsClassConstructor(old: ProtoBuf.Class, new: ProtoBuf.Class): Boolean {
        if (old.constructorCount != new.constructorCount) return false

        for(i in 0..old.constructorCount - 1) {
            if (!checkEquals(old.getConstructor(i), new.getConstructor(i))) return false
        }

        return true
    }

    open fun checkEqualsClassFunction(old: ProtoBuf.Class, new: ProtoBuf.Class): Boolean {
        if (old.functionCount != new.functionCount) return false

        for(i in 0..old.functionCount - 1) {
            if (!checkEquals(old.getFunction(i), new.getFunction(i))) return false
        }

        return true
    }

    open fun checkEqualsClassProperty(old: ProtoBuf.Class, new: ProtoBuf.Class): Boolean {
        if (old.propertyCount != new.propertyCount) return false

        for(i in 0..old.propertyCount - 1) {
            if (!checkEquals(old.getProperty(i), new.getProperty(i))) return false
        }

        return true
    }

    open fun checkEqualsClassEnumEntry(old: ProtoBuf.Class, new: ProtoBuf.Class): Boolean {
        if (old.enumEntryCount != new.enumEntryCount) return false

        for(i in 0..old.enumEntryCount - 1) {
            if (!checkEquals(old.getEnumEntry(i), new.getEnumEntry(i))) return false
        }

        return true
    }

    open fun checkEqualsFunctionTypeParameter(old: ProtoBuf.Function, new: ProtoBuf.Function): Boolean {
        if (old.typeParameterCount != new.typeParameterCount) return false

        for(i in 0..old.typeParameterCount - 1) {
            if (!checkEquals(old.getTypeParameter(i), new.getTypeParameter(i))) return false
        }

        return true
    }

    open fun checkEqualsFunctionValueParameter(old: ProtoBuf.Function, new: ProtoBuf.Function): Boolean {
        if (old.valueParameterCount != new.valueParameterCount) return false

        for(i in 0..old.valueParameterCount - 1) {
            if (!checkEquals(old.getValueParameter(i), new.getValueParameter(i))) return false
        }

        return true
    }

    open fun checkEqualsPropertyTypeParameter(old: ProtoBuf.Property, new: ProtoBuf.Property): Boolean {
        if (old.typeParameterCount != new.typeParameterCount) return false

        for(i in 0..old.typeParameterCount - 1) {
            if (!checkEquals(old.getTypeParameter(i), new.getTypeParameter(i))) return false
        }

        return true
    }

    open fun checkEqualsTypeTableType(old: ProtoBuf.TypeTable, new: ProtoBuf.TypeTable): Boolean {
        if (old.typeCount != new.typeCount) return false

        for(i in 0..old.typeCount - 1) {
            if (!checkEquals(old.getType(i), new.getType(i))) return false
        }

        return true
    }

    open fun checkEqualsSinceKotlinInfoTableInfo(old: ProtoBuf.SinceKotlinInfoTable, new: ProtoBuf.SinceKotlinInfoTable): Boolean {
        if (old.infoCount != new.infoCount) return false

        for(i in 0..old.infoCount - 1) {
            if (!checkEquals(old.getInfo(i), new.getInfo(i))) return false
        }

        return true
    }

    open fun checkEqualsTypeParameterUpperBound(old: ProtoBuf.TypeParameter, new: ProtoBuf.TypeParameter): Boolean {
        if (old.upperBoundCount != new.upperBoundCount) return false

        for(i in 0..old.upperBoundCount - 1) {
            if (!checkEquals(old.getUpperBound(i), new.getUpperBound(i))) return false
        }

        return true
    }

    open fun checkEqualsTypeParameterUpperBoundId(old: ProtoBuf.TypeParameter, new: ProtoBuf.TypeParameter): Boolean {
        if (old.upperBoundIdCount != new.upperBoundIdCount) return false

        for(i in 0..old.upperBoundIdCount - 1) {
            if (old.getUpperBoundId(i) != new.getUpperBoundId(i)) return false
        }

        return true
    }

    open fun checkEqualsTypeArgument(old: ProtoBuf.Type, new: ProtoBuf.Type): Boolean {
        if (old.argumentCount != new.argumentCount) return false

        for(i in 0..old.argumentCount - 1) {
            if (!checkEquals(old.getArgument(i), new.getArgument(i))) return false
        }

        return true
    }

    open fun checkEqualsConstructorValueParameter(old: ProtoBuf.Constructor, new: ProtoBuf.Constructor): Boolean {
        if (old.valueParameterCount != new.valueParameterCount) return false

        for(i in 0..old.valueParameterCount - 1) {
            if (!checkEquals(old.getValueParameter(i), new.getValueParameter(i))) return false
        }

        return true
    }

    open fun checkEqualsAnnotationArgument(old: ProtoBuf.Annotation, new: ProtoBuf.Annotation): Boolean {
        if (old.argumentCount != new.argumentCount) return false

        for(i in 0..old.argumentCount - 1) {
            if (!checkEquals(old.getArgument(i), new.getArgument(i))) return false
        }

        return true
    }

    open fun checkEqualsAnnotationArgumentValueArrayElement(old: ProtoBuf.Annotation.Argument.Value, new: ProtoBuf.Annotation.Argument.Value): Boolean {
        if (old.arrayElementCount != new.arrayElementCount) return false

        for(i in 0..old.arrayElementCount - 1) {
            if (!checkEquals(old.getArrayElement(i), new.getArrayElement(i))) return false
        }

        return true
    }

    fun oldGetIndexOfString(index: Int): Int = getIndexOfString(index, oldStringIndexesMap, oldNameResolver)
    fun newGetIndexOfString(index: Int): Int = getIndexOfString(index, newStringIndexesMap, newNameResolver)

    fun getIndexOfString(index: Int, map: MutableMap<Int, Int>, nameResolver: NameResolver): Int {
        map[index]?.let { return it }

        val result = strings.intern(nameResolver.getString(index))
        map[index] = result
        return result
    }

    fun oldGetIndexOfClassId(index: Int): Int = getIndexOfClassId(index, oldClassIdIndexesMap, oldNameResolver)
    fun newGetIndexOfClassId(index: Int): Int = getIndexOfClassId(index, newClassIdIndexesMap, newNameResolver)

    fun getIndexOfClassId(index: Int, map: MutableMap<Int, Int>, nameResolver: NameResolver): Int {
        map[index]?.let { return it }

        val result = classIds.intern(nameResolver.getClassId(index))
        map[index] = result
        return result
    }

    private fun checkStringEquals(old: Int, new: Int): Boolean {
       return oldGetIndexOfString(old) == newGetIndexOfString(new)
    }

    private fun checkClassIdEquals(old: Int, new: Int): Boolean {
       return oldGetIndexOfClassId(old) == newGetIndexOfClassId(new)
    }
}

fun ProtoBuf.Package.hashCode(stringIndexes: (Int) -> Int, fqNameIndexes: (Int) -> Int): Int {
    var hashCode = 1

    for(i in 0..functionCount - 1) {
        hashCode = 31 * hashCode + getFunction(i).hashCode(stringIndexes, fqNameIndexes)
    }

    for(i in 0..propertyCount - 1) {
        hashCode = 31 * hashCode + getProperty(i).hashCode(stringIndexes, fqNameIndexes)
    }

    if (hasTypeTable()) {
        hashCode = 31 * hashCode + typeTable.hashCode(stringIndexes, fqNameIndexes)
    }

    if (hasSinceKotlinInfoTable()) {
        hashCode = 31 * hashCode + sinceKotlinInfoTable.hashCode(stringIndexes, fqNameIndexes)
    }

    if (hasExtension(JvmProtoBuf.packageModuleName)) {
        hashCode = 31 * hashCode + stringIndexes(getExtension(JvmProtoBuf.packageModuleName))
    }

    return hashCode
}

fun ProtoBuf.Class.hashCode(stringIndexes: (Int) -> Int, fqNameIndexes: (Int) -> Int): Int {
    var hashCode = 1

    if (hasFlags()) {
        hashCode = 31 * hashCode + flags
    }

    hashCode = 31 * hashCode + fqNameIndexes(fqName)

    if (hasCompanionObjectName()) {
        hashCode = 31 * hashCode + stringIndexes(companionObjectName)
    }

    for(i in 0..typeParameterCount - 1) {
        hashCode = 31 * hashCode + getTypeParameter(i).hashCode(stringIndexes, fqNameIndexes)
    }

    for(i in 0..supertypeCount - 1) {
        hashCode = 31 * hashCode + getSupertype(i).hashCode(stringIndexes, fqNameIndexes)
    }

    for(i in 0..supertypeIdCount - 1) {
        hashCode = 31 * hashCode + getSupertypeId(i)
    }

    for(i in 0..nestedClassNameCount - 1) {
        hashCode = 31 * hashCode + stringIndexes(getNestedClassName(i))
    }

    for(i in 0..constructorCount - 1) {
        hashCode = 31 * hashCode + getConstructor(i).hashCode(stringIndexes, fqNameIndexes)
    }

    for(i in 0..functionCount - 1) {
        hashCode = 31 * hashCode + getFunction(i).hashCode(stringIndexes, fqNameIndexes)
    }

    for(i in 0..propertyCount - 1) {
        hashCode = 31 * hashCode + getProperty(i).hashCode(stringIndexes, fqNameIndexes)
    }

    for(i in 0..enumEntryCount - 1) {
        hashCode = 31 * hashCode + getEnumEntry(i).hashCode(stringIndexes, fqNameIndexes)
    }

    if (hasTypeTable()) {
        hashCode = 31 * hashCode + typeTable.hashCode(stringIndexes, fqNameIndexes)
    }

    if (hasSinceKotlinInfo()) {
        hashCode = 31 * hashCode + sinceKotlinInfo
    }

    if (hasSinceKotlinInfoTable()) {
        hashCode = 31 * hashCode + sinceKotlinInfoTable.hashCode(stringIndexes, fqNameIndexes)
    }

    if (hasExtension(JvmProtoBuf.classModuleName)) {
        hashCode = 31 * hashCode + stringIndexes(getExtension(JvmProtoBuf.classModuleName))
    }

    return hashCode
}

fun ProtoBuf.Function.hashCode(stringIndexes: (Int) -> Int, fqNameIndexes: (Int) -> Int): Int {
    var hashCode = 1

    if (hasFlags()) {
        hashCode = 31 * hashCode + flags
    }

    if (hasOldFlags()) {
        hashCode = 31 * hashCode + oldFlags
    }

    hashCode = 31 * hashCode + stringIndexes(name)

    if (hasReturnType()) {
        hashCode = 31 * hashCode + returnType.hashCode(stringIndexes, fqNameIndexes)
    }

    if (hasReturnTypeId()) {
        hashCode = 31 * hashCode + returnTypeId
    }

    for(i in 0..typeParameterCount - 1) {
        hashCode = 31 * hashCode + getTypeParameter(i).hashCode(stringIndexes, fqNameIndexes)
    }

    if (hasReceiverType()) {
        hashCode = 31 * hashCode + receiverType.hashCode(stringIndexes, fqNameIndexes)
    }

    if (hasReceiverTypeId()) {
        hashCode = 31 * hashCode + receiverTypeId
    }

    for(i in 0..valueParameterCount - 1) {
        hashCode = 31 * hashCode + getValueParameter(i).hashCode(stringIndexes, fqNameIndexes)
    }

    if (hasTypeTable()) {
        hashCode = 31 * hashCode + typeTable.hashCode(stringIndexes, fqNameIndexes)
    }

    if (hasSinceKotlinInfo()) {
        hashCode = 31 * hashCode + sinceKotlinInfo
    }

    if (hasExtension(JvmProtoBuf.methodSignature)) {
        hashCode = 31 * hashCode + getExtension(JvmProtoBuf.methodSignature).hashCode(stringIndexes, fqNameIndexes)
    }

    return hashCode
}

fun ProtoBuf.Property.hashCode(stringIndexes: (Int) -> Int, fqNameIndexes: (Int) -> Int): Int {
    var hashCode = 1

    if (hasFlags()) {
        hashCode = 31 * hashCode + flags
    }

    if (hasOldFlags()) {
        hashCode = 31 * hashCode + oldFlags
    }

    hashCode = 31 * hashCode + stringIndexes(name)

    if (hasReturnType()) {
        hashCode = 31 * hashCode + returnType.hashCode(stringIndexes, fqNameIndexes)
    }

    if (hasReturnTypeId()) {
        hashCode = 31 * hashCode + returnTypeId
    }

    for(i in 0..typeParameterCount - 1) {
        hashCode = 31 * hashCode + getTypeParameter(i).hashCode(stringIndexes, fqNameIndexes)
    }

    if (hasReceiverType()) {
        hashCode = 31 * hashCode + receiverType.hashCode(stringIndexes, fqNameIndexes)
    }

    if (hasReceiverTypeId()) {
        hashCode = 31 * hashCode + receiverTypeId
    }

    if (hasSetterValueParameter()) {
        hashCode = 31 * hashCode + setterValueParameter.hashCode(stringIndexes, fqNameIndexes)
    }

    if (hasGetterFlags()) {
        hashCode = 31 * hashCode + getterFlags
    }

    if (hasSetterFlags()) {
        hashCode = 31 * hashCode + setterFlags
    }

    if (hasSinceKotlinInfo()) {
        hashCode = 31 * hashCode + sinceKotlinInfo
    }

    if (hasExtension(JvmProtoBuf.propertySignature)) {
        hashCode = 31 * hashCode + getExtension(JvmProtoBuf.propertySignature).hashCode(stringIndexes, fqNameIndexes)
    }

    return hashCode
}

fun ProtoBuf.TypeTable.hashCode(stringIndexes: (Int) -> Int, fqNameIndexes: (Int) -> Int): Int {
    var hashCode = 1

    for(i in 0..typeCount - 1) {
        hashCode = 31 * hashCode + getType(i).hashCode(stringIndexes, fqNameIndexes)
    }

    if (hasFirstNullable()) {
        hashCode = 31 * hashCode + firstNullable
    }

    return hashCode
}

fun ProtoBuf.SinceKotlinInfoTable.hashCode(stringIndexes: (Int) -> Int, fqNameIndexes: (Int) -> Int): Int {
    var hashCode = 1

    for(i in 0..infoCount - 1) {
        hashCode = 31 * hashCode + getInfo(i).hashCode(stringIndexes, fqNameIndexes)
    }

    return hashCode
}

fun ProtoBuf.TypeParameter.hashCode(stringIndexes: (Int) -> Int, fqNameIndexes: (Int) -> Int): Int {
    var hashCode = 1

    hashCode = 31 * hashCode + id

    hashCode = 31 * hashCode + stringIndexes(name)

    if (hasReified()) {
        hashCode = 31 * hashCode + reified.hashCode()
    }

    if (hasVariance()) {
        hashCode = 31 * hashCode + variance.hashCode()
    }

    for(i in 0..upperBoundCount - 1) {
        hashCode = 31 * hashCode + getUpperBound(i).hashCode(stringIndexes, fqNameIndexes)
    }

    for(i in 0..upperBoundIdCount - 1) {
        hashCode = 31 * hashCode + getUpperBoundId(i)
    }

    for(i in 0..getExtensionCount(JvmProtoBuf.typeParameterAnnotation) - 1) {
        hashCode = 31 * hashCode + getExtension(JvmProtoBuf.typeParameterAnnotation, i).hashCode(stringIndexes, fqNameIndexes)
    }

    return hashCode
}

fun ProtoBuf.Type.hashCode(stringIndexes: (Int) -> Int, fqNameIndexes: (Int) -> Int): Int {
    var hashCode = 1

    for(i in 0..argumentCount - 1) {
        hashCode = 31 * hashCode + getArgument(i).hashCode(stringIndexes, fqNameIndexes)
    }

    if (hasNullable()) {
        hashCode = 31 * hashCode + nullable.hashCode()
    }

    if (hasFlexibleTypeCapabilitiesId()) {
        hashCode = 31 * hashCode + stringIndexes(flexibleTypeCapabilitiesId)
    }

    if (hasFlexibleUpperBound()) {
        hashCode = 31 * hashCode + flexibleUpperBound.hashCode(stringIndexes, fqNameIndexes)
    }

    if (hasFlexibleUpperBoundId()) {
        hashCode = 31 * hashCode + flexibleUpperBoundId
    }

    if (hasClassName()) {
        hashCode = 31 * hashCode + fqNameIndexes(className)
    }

    if (hasTypeParameter()) {
        hashCode = 31 * hashCode + typeParameter
    }

    if (hasTypeParameterName()) {
        hashCode = 31 * hashCode + stringIndexes(typeParameterName)
    }

    if (hasOuterType()) {
        hashCode = 31 * hashCode + outerType.hashCode(stringIndexes, fqNameIndexes)
    }

    if (hasOuterTypeId()) {
        hashCode = 31 * hashCode + outerTypeId
    }

    for(i in 0..getExtensionCount(JvmProtoBuf.typeAnnotation) - 1) {
        hashCode = 31 * hashCode + getExtension(JvmProtoBuf.typeAnnotation, i).hashCode(stringIndexes, fqNameIndexes)
    }

    if (hasExtension(JvmProtoBuf.isRaw)) {
        hashCode = 31 * hashCode + getExtension(JvmProtoBuf.isRaw).hashCode()
    }

    return hashCode
}

fun ProtoBuf.Constructor.hashCode(stringIndexes: (Int) -> Int, fqNameIndexes: (Int) -> Int): Int {
    var hashCode = 1

    if (hasFlags()) {
        hashCode = 31 * hashCode + flags
    }

    for(i in 0..valueParameterCount - 1) {
        hashCode = 31 * hashCode + getValueParameter(i).hashCode(stringIndexes, fqNameIndexes)
    }

    if (hasSinceKotlinInfo()) {
        hashCode = 31 * hashCode + sinceKotlinInfo
    }

    if (hasExtension(JvmProtoBuf.constructorSignature)) {
        hashCode = 31 * hashCode + getExtension(JvmProtoBuf.constructorSignature).hashCode(stringIndexes, fqNameIndexes)
    }

    return hashCode
}

fun ProtoBuf.EnumEntry.hashCode(stringIndexes: (Int) -> Int, fqNameIndexes: (Int) -> Int): Int {
    var hashCode = 1

    if (hasName()) {
        hashCode = 31 * hashCode + stringIndexes(name)
    }

    return hashCode
}

fun ProtoBuf.ValueParameter.hashCode(stringIndexes: (Int) -> Int, fqNameIndexes: (Int) -> Int): Int {
    var hashCode = 1

    if (hasFlags()) {
        hashCode = 31 * hashCode + flags
    }

    hashCode = 31 * hashCode + stringIndexes(name)

    if (hasType()) {
        hashCode = 31 * hashCode + type.hashCode(stringIndexes, fqNameIndexes)
    }

    if (hasTypeId()) {
        hashCode = 31 * hashCode + typeId
    }

    if (hasVarargElementType()) {
        hashCode = 31 * hashCode + varargElementType.hashCode(stringIndexes, fqNameIndexes)
    }

    if (hasVarargElementTypeId()) {
        hashCode = 31 * hashCode + varargElementTypeId
    }

    return hashCode
}

fun JvmProtoBuf.JvmMethodSignature.hashCode(stringIndexes: (Int) -> Int, fqNameIndexes: (Int) -> Int): Int {
    var hashCode = 1

    if (hasName()) {
        hashCode = 31 * hashCode + stringIndexes(name)
    }

    if (hasDesc()) {
        hashCode = 31 * hashCode + stringIndexes(desc)
    }

    return hashCode
}

fun JvmProtoBuf.JvmPropertySignature.hashCode(stringIndexes: (Int) -> Int, fqNameIndexes: (Int) -> Int): Int {
    var hashCode = 1

    if (hasField()) {
        hashCode = 31 * hashCode + field.hashCode(stringIndexes, fqNameIndexes)
    }

    if (hasSyntheticMethod()) {
        hashCode = 31 * hashCode + syntheticMethod.hashCode(stringIndexes, fqNameIndexes)
    }

    if (hasGetter()) {
        hashCode = 31 * hashCode + getter.hashCode(stringIndexes, fqNameIndexes)
    }

    if (hasSetter()) {
        hashCode = 31 * hashCode + setter.hashCode(stringIndexes, fqNameIndexes)
    }

    return hashCode
}

fun ProtoBuf.SinceKotlinInfo.hashCode(stringIndexes: (Int) -> Int, fqNameIndexes: (Int) -> Int): Int {
    var hashCode = 1

    if (hasVersion()) {
        hashCode = 31 * hashCode + version
    }

    if (hasVersionFull()) {
        hashCode = 31 * hashCode + versionFull
    }

    if (hasLevel()) {
        hashCode = 31 * hashCode + level.hashCode()
    }

    if (hasErrorCode()) {
        hashCode = 31 * hashCode + errorCode
    }

    if (hasMessage()) {
        hashCode = 31 * hashCode + stringIndexes(message)
    }

    return hashCode
}

fun ProtoBuf.Annotation.hashCode(stringIndexes: (Int) -> Int, fqNameIndexes: (Int) -> Int): Int {
    var hashCode = 1

    hashCode = 31 * hashCode + fqNameIndexes(id)

    for(i in 0..argumentCount - 1) {
        hashCode = 31 * hashCode + getArgument(i).hashCode(stringIndexes, fqNameIndexes)
    }

    return hashCode
}

fun ProtoBuf.Type.Argument.hashCode(stringIndexes: (Int) -> Int, fqNameIndexes: (Int) -> Int): Int {
    var hashCode = 1

    if (hasProjection()) {
        hashCode = 31 * hashCode + projection.hashCode()
    }

    if (hasType()) {
        hashCode = 31 * hashCode + type.hashCode(stringIndexes, fqNameIndexes)
    }

    if (hasTypeId()) {
        hashCode = 31 * hashCode + typeId
    }

    return hashCode
}

fun JvmProtoBuf.JvmFieldSignature.hashCode(stringIndexes: (Int) -> Int, fqNameIndexes: (Int) -> Int): Int {
    var hashCode = 1

    if (hasName()) {
        hashCode = 31 * hashCode + stringIndexes(name)
    }

    if (hasDesc()) {
        hashCode = 31 * hashCode + stringIndexes(desc)
    }

    return hashCode
}

fun ProtoBuf.Annotation.Argument.hashCode(stringIndexes: (Int) -> Int, fqNameIndexes: (Int) -> Int): Int {
    var hashCode = 1

    hashCode = 31 * hashCode + stringIndexes(nameId)

    hashCode = 31 * hashCode + value.hashCode(stringIndexes, fqNameIndexes)

    return hashCode
}

fun ProtoBuf.Annotation.Argument.Value.hashCode(stringIndexes: (Int) -> Int, fqNameIndexes: (Int) -> Int): Int {
    var hashCode = 1

    if (hasType()) {
        hashCode = 31 * hashCode + type.hashCode()
    }

    if (hasIntValue()) {
        hashCode = 31 * hashCode + intValue.hashCode()
    }

    if (hasFloatValue()) {
        hashCode = 31 * hashCode + floatValue.hashCode()
    }

    if (hasDoubleValue()) {
        hashCode = 31 * hashCode + doubleValue.hashCode()
    }

    if (hasStringValue()) {
        hashCode = 31 * hashCode + stringIndexes(stringValue)
    }

    if (hasClassId()) {
        hashCode = 31 * hashCode + fqNameIndexes(classId)
    }

    if (hasEnumValueId()) {
        hashCode = 31 * hashCode + stringIndexes(enumValueId)
    }

    if (hasAnnotation()) {
        hashCode = 31 * hashCode + annotation.hashCode(stringIndexes, fqNameIndexes)
    }

    for(i in 0..arrayElementCount - 1) {
        hashCode = 31 * hashCode + getArrayElement(i).hashCode(stringIndexes, fqNameIndexes)
    }

    return hashCode
}
