/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.serialization.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.Deserialization;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationComponents;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationContext;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializedType;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ProtoTypeTableUtilKt;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedTypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.storage.NotNullLazyValue;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.StarProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeBasedStarProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeDeserializer {
    private final Function1<Integer, ClassDescriptor> classDescriptors;
    private final NotNullLazyValue<Map<Integer, TypeParameterDescriptor>> typeParameterDescriptors;
    private final DeserializationContext c;
    private final TypeDeserializer parent;
    private final List<ProtoBuf.TypeParameter> typeParameterProtos;
    private final String debugName;

    @NotNull
    public final List<TypeParameterDescriptor> getOwnTypeParameters() {
        return kotlin.reflect.jvm.internal.impl.utils.CollectionsKt.toReadOnlyList(((Map)this.typeParameterDescriptors.invoke()).values());
    }

    @NotNull
    public final KotlinType type(@NotNull ProtoBuf.Type proto, @NotNull Annotations additionalAnnotations) {
        KotlinType localClassifierType;
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        Intrinsics.checkParameterIsNotNull(additionalAnnotations, "additionalAnnotations");
        if (proto.hasFlexibleTypeCapabilitiesId()) {
            String id = this.c.getNameResolver().getString(proto.getFlexibleTypeCapabilitiesId());
            FlexibleTypeFactory flexibleTypeFactory = this.c.getComponents().getFlexibleTypeFactory();
            if (Intrinsics.areEqual(flexibleTypeFactory.getId(), id) ^ true) {
                KotlinType kotlinType = ErrorUtils.createErrorType(new DeserializedType(this.c, proto, null, 4, null) + ": " + ("Unexpected flexible type factory. Expected: " + flexibleTypeFactory.getId() + " Actual: " + id));
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "ErrorUtils.createErrorTy\u2026Factory.id} Actual: $id\")");
                return kotlinType;
            }
            KotlinType kotlinType = new DeserializedType(this.c, proto, null, 4, null);
            ProtoBuf.Type type2 = ProtoTypeTableUtilKt.flexibleUpperBound(proto, this.c.getTypeTable());
            if (type2 == null) {
                Intrinsics.throwNpe();
            }
            return flexibleTypeFactory.create(kotlinType, new DeserializedType(this.c, type2, null, 4, null));
        }
        KotlinType kotlinType = localClassifierType = proto.hasClassName() ? this.computeLocalClassifierReplacementType(proto.getClassName()) : (KotlinType)null;
        if (localClassifierType != null) {
            return localClassifierType;
        }
        return new DeserializedType(this.c, proto, additionalAnnotations);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ KotlinType type$default(TypeDeserializer typeDeserializer, ProtoBuf.Type type2, Annotations annotations2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: type");
        }
        if ((n & 2) != 0) {
            annotations2 = Annotations.Companion.getEMPTY();
        }
        return typeDeserializer.type(type2, annotations2);
    }

    @NotNull
    public final TypeConstructor typeConstructor(@NotNull ProtoBuf.Type proto) {
        Object object;
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        if (proto.hasClassName()) {
            object = this.classDescriptors.invoke(proto.getClassName());
            if (object == null || (object = object.getTypeConstructor()) == null) {
                object = this.c.getComponents().getNotFoundClasses().get(proto, this.c.getNameResolver(), this.c.getTypeTable());
            }
        } else if (proto.hasTypeParameter()) {
            object = this.typeParameterTypeConstructor(proto.getTypeParameter());
            if (object == null) {
                TypeConstructor typeConstructor2 = ErrorUtils.createErrorType("Unknown type parameter " + proto.getTypeParameter()).getConstructor();
                object = typeConstructor2;
                Intrinsics.checkExpressionValueIsNotNull(typeConstructor2, "ErrorUtils.createErrorTy\u2026eParameter}\").constructor");
            }
        } else if (proto.hasTypeParameterName()) {
            TypeParameterDescriptor parameter;
            Object v5;
            String name;
            DeclarationDescriptor container;
            block14: {
                List<Object> list2;
                container = this.c.getContainingDeclaration();
                DeclarationDescriptor declarationDescriptor = container;
                if (declarationDescriptor instanceof ClassDescriptor) {
                    List<TypeParameterDescriptor> list3 = ((ClassDescriptor)container).getTypeConstructor().getParameters();
                    list2 = list3;
                    Intrinsics.checkExpressionValueIsNotNull(list3, "container.typeConstructor.parameters");
                } else if (declarationDescriptor instanceof CallableDescriptor) {
                    List<TypeParameterDescriptor> list4 = ((CallableDescriptor)container).getTypeParameters();
                    list2 = list4;
                    Intrinsics.checkExpressionValueIsNotNull(list4, "container.typeParameters");
                } else {
                    list2 = CollectionsKt.emptyList();
                }
                List<Object> typeParameters = list2;
                name = this.c.getNameResolver().getString(proto.getTypeParameterName());
                Iterable iterable = typeParameters;
                Iterable iterable2 = iterable;
                for (Object t : iterable2) {
                    TypeParameterDescriptor it = (TypeParameterDescriptor)t;
                    if (!Intrinsics.areEqual(it.getName().asString(), name)) continue;
                    v5 = t;
                    break block14;
                }
                v5 = null;
            }
            if ((object = (parameter = (TypeParameterDescriptor)v5)) == null || (object = object.getTypeConstructor()) == null) {
                TypeConstructor typeConstructor3 = ErrorUtils.createErrorType("Deserialized type parameter " + name + " in " + container).getConstructor();
                object = typeConstructor3;
                Intrinsics.checkExpressionValueIsNotNull(typeConstructor3, "ErrorUtils.createErrorTy\u2026 $container\").constructor");
            }
        } else {
            TypeConstructor typeConstructor4 = ErrorUtils.createErrorType("Unknown type").getConstructor();
            object = typeConstructor4;
            Intrinsics.checkExpressionValueIsNotNull(typeConstructor4, "ErrorUtils.createErrorTy\u2026nknown type\").constructor");
        }
        return object;
    }

    private final TypeConstructor typeParameterTypeConstructor(int typeParameterId) {
        Object object = (TypeParameterDescriptor)((Map)this.typeParameterDescriptors.invoke()).get(typeParameterId);
        if (object == null || (object = object.getTypeConstructor()) == null) {
            TypeDeserializer typeDeserializer = this.parent;
            object = typeDeserializer != null ? typeDeserializer.typeParameterTypeConstructor(typeParameterId) : null;
        }
        return object;
    }

    private final ClassDescriptor computeClassDescriptor(int fqNameIndex) {
        ClassId id = this.c.getNameResolver().getClassId(fqNameIndex);
        if (id.isLocal()) {
            DeserializationComponents deserializationComponents = this.c.getComponents();
            ClassId classId = id;
            Intrinsics.checkExpressionValueIsNotNull(classId, "id");
            return deserializationComponents.deserializeClass(classId);
        }
        ModuleDescriptor moduleDescriptor = this.c.getComponents().getModuleDescriptor();
        ClassId classId = id;
        Intrinsics.checkExpressionValueIsNotNull(classId, "id");
        return FindClassInModuleKt.findClassAcrossModuleDependencies(moduleDescriptor, classId);
    }

    private final KotlinType computeLocalClassifierReplacementType(int className2) {
        if (this.c.getNameResolver().getClassId(className2).isLocal()) {
            return this.c.getComponents().getLocalClassifierTypeSettings().getReplacementTypeForLocalClassifiers();
        }
        return null;
    }

    @NotNull
    public final TypeProjection typeArgument(@Nullable TypeParameterDescriptor parameter, @NotNull ProtoBuf.Type.Argument typeArgumentProto) {
        Intrinsics.checkParameterIsNotNull(typeArgumentProto, "typeArgumentProto");
        if (Intrinsics.areEqual(typeArgumentProto.getProjection(), ProtoBuf.Type.Argument.Projection.STAR)) {
            TypeProjection typeProjection;
            if (parameter == null) {
                KotlinType kotlinType = this.c.getComponents().getModuleDescriptor().getBuiltIns().getNullableAnyType();
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "c.components.moduleDescr\u2026.builtIns.nullableAnyType");
                typeProjection = new TypeBasedStarProjectionImpl(kotlinType);
            } else {
                typeProjection = new StarProjectionImpl(parameter);
            }
            return typeProjection;
        }
        ProtoBuf.Type.Argument.Projection projection = typeArgumentProto.getProjection();
        Intrinsics.checkExpressionValueIsNotNull(projection, "typeArgumentProto.projection");
        Variance variance = Deserialization.variance(projection);
        ProtoBuf.Type type2 = ProtoTypeTableUtilKt.type(typeArgumentProto, this.c.getTypeTable());
        if (type2 == null) {
            return new TypeProjectionImpl(ErrorUtils.createErrorType("No type recorded"));
        }
        ProtoBuf.Type type3 = type2;
        return new TypeProjectionImpl(variance, TypeDeserializer.type$default(this, type3, null, 2, null));
    }

    @NotNull
    public String toString() {
        return this.debugName + (this.parent == null ? "" : ". Child of " + this.parent.debugName);
    }

    public TypeDeserializer(@NotNull DeserializationContext c, @Nullable TypeDeserializer parent2, @NotNull List<ProtoBuf.TypeParameter> typeParameterProtos, @NotNull String debugName) {
        Intrinsics.checkParameterIsNotNull(c, "c");
        Intrinsics.checkParameterIsNotNull(typeParameterProtos, "typeParameterProtos");
        Intrinsics.checkParameterIsNotNull(debugName, "debugName");
        this.c = c;
        this.parent = parent2;
        this.typeParameterProtos = typeParameterProtos;
        this.debugName = debugName;
        this.classDescriptors = this.c.getStorageManager().createMemoizedFunctionWithNullableValues((Function1)new Function1<Integer, ClassDescriptor>(this){
            final /* synthetic */ TypeDeserializer this$0;

            @Nullable
            public final ClassDescriptor invoke(int fqNameIndex) {
                return TypeDeserializer.access$computeClassDescriptor(this.this$0, fqNameIndex);
            }
            {
                this.this$0 = typeDeserializer;
                super(1);
            }
        });
        this.typeParameterDescriptors = this.c.getStorageManager().createLazyValue((Function0)new Function0<Map<Integer, ? extends TypeParameterDescriptor>>(this){
            final /* synthetic */ TypeDeserializer this$0;

            @NotNull
            public final Map<Integer, TypeParameterDescriptor> invoke() {
                Map map2;
                if (TypeDeserializer.access$getTypeParameterProtos$p(this.this$0).isEmpty()) {
                    map2 = MapsKt.emptyMap();
                } else {
                    LinkedHashMap<K, V> result2 = new LinkedHashMap<K, V>();
                    for (IndexedValue<T> indexedValue : CollectionsKt.withIndex(TypeDeserializer.access$getTypeParameterProtos$p(this.this$0))) {
                        int index2 = indexedValue.component1();
                        ProtoBuf.TypeParameter proto = (ProtoBuf.TypeParameter)indexedValue.component2();
                        Map map3 = result2;
                        Integer n = proto.getId();
                        DeserializedTypeParameterDescriptor deserializedTypeParameterDescriptor = new DeserializedTypeParameterDescriptor(TypeDeserializer.access$getC$p(this.this$0), proto, index2);
                        map3.put(n, deserializedTypeParameterDescriptor);
                    }
                    map2 = result2;
                }
                return map2;
            }
            {
                this.this$0 = typeDeserializer;
                super(0);
            }
        });
    }

    @Nullable
    public static final /* synthetic */ ClassDescriptor access$computeClassDescriptor(TypeDeserializer $this, int fqNameIndex) {
        return $this.computeClassDescriptor(fqNameIndex);
    }

    @NotNull
    public static final /* synthetic */ List access$getTypeParameterProtos$p(TypeDeserializer $this) {
        return $this.typeParameterProtos;
    }

    @NotNull
    public static final /* synthetic */ DeserializationContext access$getC$p(TypeDeserializer $this) {
        return $this.c;
    }
}

