/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.rmi.registry.Registry;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.js.K2JSCompiler;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.daemon.CompileServiceImpl;
import org.jetbrains.kotlin.daemon.CompilerSelector;
import org.jetbrains.kotlin.daemon.KotlinCompileDaemon;
import org.jetbrains.kotlin.daemon.KotlinCompileDaemon$WhenMappings;
import org.jetbrains.kotlin.daemon.LogStream;
import org.jetbrains.kotlin.daemon.common.CompileService;
import org.jetbrains.kotlin.daemon.common.CompilerId;
import org.jetbrains.kotlin.daemon.common.DaemonJVMOptions;
import org.jetbrains.kotlin.daemon.common.DaemonOptions;
import org.jetbrains.kotlin.daemon.common.DaemonParamsKt;
import org.jetbrains.kotlin.daemon.common.NetworkUtilsKt;
import org.jetbrains.kotlin.daemon.common.OptionsGroup;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\u001b\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fH\u0007\u00a2\u0006\u0002\u0010\u0010R\u001f\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048F\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/daemon/KotlinCompileDaemon;", "", "()V", "log", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Ljava/util/logging/Logger;", "log$delegate", "Lkotlin/Lazy;", "loadVersionFromResource", "", "main", "", "args", "", "([Ljava/lang/String;)V", "kotlin-compiler"})
public final class KotlinCompileDaemon {
    private static final Lazy log$delegate;
    private static final /* synthetic */ KProperty[] $$delegatedProperties;
    public static final KotlinCompileDaemon INSTANCE;

    public final Logger getLog() {
        Lazy lazy = log$delegate;
        KotlinCompileDaemon kotlinCompileDaemon = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (Logger)lazy.getValue();
    }

    private final String loadVersionFromResource() {
        block4: {
            Object object;
            ClassLoader classLoader = KotlinCompileDaemon.class.getClassLoader();
            if (!(classLoader instanceof URLClassLoader)) {
                classLoader = null;
            }
            if ((object = (URLClassLoader)classLoader) == null || (object = ((URLClassLoader)object).findResource("META-INF/MANIFEST.MF")) == null) break block4;
            Object object2 = object;
            URL it = (URL)object2;
            try {
                String string = new Manifest(it.openStream()).getMainAttributes().getValue("Implementation-Version");
                if (string == null) {
                    string = null;
                }
                return string;
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkParameterIsNotNull(args, "args");
        Logger logger = INSTANCE.getLog();
        StringBuilder stringBuilder = new StringBuilder().append("Kotlin compiler daemon version ");
        String string = INSTANCE.loadVersionFromResource();
        if (string == null) {
            string = "<unknown>";
        }
        logger.info(stringBuilder.append((Object)string).toString());
        INSTANCE.getLog().info("daemon JVM args: " + CollectionsKt.joinToString$default(ManagementFactory.getRuntimeMXBean().getInputArguments(), " ", null, null, 0, null, null, 62, null));
        INSTANCE.getLog().info("daemon args: " + ArraysKt.joinToString$default(args, (CharSequence)" ", null, null, 0, null, null, 62, null));
        INSTANCE.getLog().info("daemon process name: " + ManagementFactory.getRuntimeMXBean().getName());
        CompilerId compilerId = new CompilerId(null, null, 3, null);
        DaemonOptions daemonOptions = new DaemonOptions(null, 0L, 0, 0, 0L, 0L, false, false, 255, null);
        try {
            void port;
            void registry;
            Object helpLine;
            String[] stringArray = new String[]{};
            boolean bl = true;
            boolean bl2 = true;
            DaemonJVMOptions daemonJVMOptions = DaemonParamsKt.configureDaemonJVMOptions(stringArray, bl2, bl);
            OptionsGroup[] optionsGroupArray = new OptionsGroup[]{compilerId, daemonOptions};
            String string2 = DaemonParamsKt.getCOMPILE_DAEMON_CMDLINE_OPTIONS_PREFIX();
            Iterable<String> filteredArgs = DaemonParamsKt.filterExtractProps(ArraysKt.asIterable((Object[])args), optionsGroupArray, string2);
            if (CollectionsKt.any(filteredArgs)) {
                helpLine = "usage: <daemon> <compilerId options> <daemon options>";
                INSTANCE.getLog().info((String)helpLine);
                System.out.println(helpLine);
                throw (Throwable)new IllegalArgumentException("Unknown arguments: " + CollectionsKt.joinToString$default(filteredArgs, " ", null, null, 0, null, null, 62, null));
            }
            INSTANCE.getLog().info("starting daemon");
            Pair<Registry, Integer> pair = NetworkUtilsKt.findPortAndCreateRegistry(DaemonParamsKt.getCOMPILE_DAEMON_FIND_PORT_ATTEMPTS(), DaemonParamsKt.getCOMPILE_DAEMON_PORTS_RANGE_START(), DaemonParamsKt.getCOMPILE_DAEMON_PORTS_RANGE_END());
            helpLine = pair.component1();
            int n = ((Number)pair.component2()).intValue();
            pair = null;
            CompilerSelector compilerSelector2 = new CompilerSelector(){
                private final Lazy jvm$delegate;
                private final Lazy js$delegate;
                private static final /* synthetic */ KProperty[] $$delegatedProperties;

                private final K2JVMCompiler getJvm() {
                    Lazy lazy = this.jvm$delegate;
                    main.compilerSelector.1 var2_2 = this;
                    KProperty kProperty = $$delegatedProperties[0];
                    return (K2JVMCompiler)lazy.getValue();
                }

                private final K2JSCompiler getJs() {
                    Lazy lazy = this.js$delegate;
                    main.compilerSelector.1 var2_2 = this;
                    KProperty kProperty = $$delegatedProperties[1];
                    return (K2JSCompiler)lazy.getValue();
                }

                @NotNull
                public CLICompiler<?> get(@NotNull CompileService.TargetPlatform targetPlatform) {
                    CLICompiler cLICompiler;
                    Intrinsics.checkParameterIsNotNull(targetPlatform, "targetPlatform");
                    switch (KotlinCompileDaemon$WhenMappings.$EnumSwitchMapping$0[targetPlatform.ordinal()]) {
                        case 1: {
                            cLICompiler = this.getJvm();
                            break;
                        }
                        case 2: {
                            cLICompiler = this.getJs();
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    return cLICompiler;
                }
                {
                    this.jvm$delegate = LazyKt.lazy(main.compilerSelector.jvm.2.INSTANCE);
                    this.js$delegate = LazyKt.lazy(main.compilerSelector.js.2.INSTANCE);
                }

                static {
                    $$delegatedProperties = new KProperty[]{Reflection.property1(new PropertyReference1Impl(Reflection.getOrCreateKotlinClass(main.compilerSelector.1.class), "jvm", "getJvm()Lorg/jetbrains/kotlin/cli/jvm/K2JVMCompiler;")), Reflection.property1(new PropertyReference1Impl(Reflection.getOrCreateKotlinClass(main.compilerSelector.1.class), "js", "getJs()Lorg/jetbrains/kotlin/cli/js/K2JSCompiler;"))};
                }
            };
            Timer timer = new Timer(true);
            CompileServiceImpl compilerService2 = new CompileServiceImpl((Registry)registry, compilerSelector2, compilerId, daemonOptions, daemonJVMOptions, (int)port, timer, new Function0<Unit>(daemonOptions, timer){
                final /* synthetic */ DaemonOptions $daemonOptions;
                final /* synthetic */ Timer $timer;

                public final void invoke() {
                    if (this.$daemonOptions.getForceShutdownTimeoutMilliseconds() != DaemonParamsKt.getCOMPILE_DAEMON_TIMEOUT_INFINITE_MS()) {
                        Timer timer = this.$timer;
                        long l = this.$daemonOptions.getForceShutdownTimeoutMilliseconds();
                        TimerTask timerTask2 = new TimerTask(){

                            public void run() {
                                TimerTask $receiver = this;
                                $receiver.cancel();
                                KotlinCompileDaemon.INSTANCE.getLog().info("force JVM shutdown");
                                System.exit(0);
                            }
                        };
                        timer.schedule(timerTask2, l);
                    } else {
                        this.$timer.cancel();
                    }
                }
                {
                    this.$daemonOptions = daemonOptions;
                    this.$timer = timer;
                    super(0);
                }
            });
            String string3 = DaemonParamsKt.getCOMPILE_DAEMON_IS_READY_MESSAGE();
            System.out.println((Object)string3);
            INSTANCE.getLog().info("daemon is listening on port: " + (int)port);
            System.out.close();
            System.err.close();
            System.setErr(new PrintStream(new LogStream("stderr")));
            System.setOut(new PrintStream(new LogStream("stdout")));
        }
        catch (Exception e) {
            System.err.println("Exception: " + e.getMessage());
            Throwable throwable = e;
            PrintStream printStream = System.err;
            Intrinsics.checkExpressionValueIsNotNull(printStream, "System.err");
            PrintStream printStream2 = printStream;
            Throwable throwable2 = throwable;
            if (throwable2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.Throwable");
            }
            throwable2.printStackTrace(printStream2);
            INSTANCE.getLog().log(Level.INFO, "Exception: ", e);
            throw (Throwable)e;
        }
    }

    /*
     * WARNING - void declaration
     */
    private KotlinCompileDaemon() {
        ByteArrayInputStream byteArrayInputStream;
        void logPath;
        void fileIsGiven;
        String cfg;
        Pair<String, Boolean> pair;
        String string;
        INSTANCE = this;
        String string2 = new SimpleDateFormat("yyyy-MM-dd.HH-mm-ss-SSS").format(new Date());
        Intrinsics.checkExpressionValueIsNotNull(string2, "SimpleDateFormat(\"yyyy-M\u2026m-ss-SSS\").format(Date())");
        String logTime = string2;
        String string3 = System.getProperty(DaemonParamsKt.getCOMPILE_DAEMON_LOG_PATH_PROPERTY());
        if (string3 != null && (string3 = DaemonParamsKt.trimQuotes(string3)) != null) {
            string = string3;
            String it = string;
            pair = new Pair<String, Boolean>(it, new File(it).isFile());
        } else {
            pair = new Pair<String, Boolean>("%t", false);
        }
        Pair<String, Boolean> pair2 = pair;
        String string4 = pair2.component1();
        boolean bl = pair2.component2();
        pair2 = null;
        string = cfg = "handlers = java.util.logging.FileHandler\njava.util.logging.FileHandler.level     = ALL\njava.util.logging.FileHandler.formatter = java.util.logging.SimpleFormatter\njava.util.logging.FileHandler.encoding  = UTF-8\n" + ("java.util.logging.FileHandler.limit     = " + (fileIsGiven != false ? 0 : 0x100000) + "\n") + ("java.util.logging.FileHandler.count     = " + (fileIsGiven != false ? 1 : 3) + "\n") + ("java.util.logging.FileHandler.append    = " + (boolean)fileIsGiven + "\n") + ("java.util.logging.FileHandler.pattern   = " + (String)(fileIsGiven != false ? logPath : (String)logPath + File.separator + (DaemonParamsKt.getCOMPILE_DAEMON_DEFAULT_FILES_PREFIX() + "." + logTime + ".%u%g.log")) + "\n") + "java.util.logging.SimpleFormatter.format = %1$tF %1$tT.%1$tL [%3$s] %4$s: %5$s%n\n";
        Charset charset = null;
        boolean bl2 = true;
        String string5 = null;
        LogManager logManager = LogManager.getLogManager();
        if (string5 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: byteInputStream");
        }
        if (bl2 & true) {
            charset = Charsets.UTF_8;
        }
        string5 = string;
        ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream;
        ByteArrayInputStream byteArrayInputStream3 = byteArrayInputStream;
        String string6 = string5;
        if (string6 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string6.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull(byArray, "(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        byteArrayInputStream2(byArray2);
        ByteArrayInputStream byteArrayInputStream4 = byteArrayInputStream3;
        logManager.readConfiguration(byteArrayInputStream4);
        log$delegate = LazyKt.lazy(log.2.INSTANCE);
    }

    static {
        $$delegatedProperties = new KProperty[]{Reflection.property1(new PropertyReference1Impl(Reflection.getOrCreateKotlinClass(KotlinCompileDaemon.class), "log", "getLog()Ljava/util/logging/Logger;"))};
        new KotlinCompileDaemon();
    }
}

