/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.preprocessor;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.preprocessor.CollectModificationsVisitor;
import org.jetbrains.kotlin.preprocessor.Conditional;
import org.jetbrains.kotlin.preprocessor.ConditionalKt;
import org.jetbrains.kotlin.preprocessor.Evaluator;
import org.jetbrains.kotlin.preprocessor.Logger;
import org.jetbrains.kotlin.preprocessor.Modification;
import org.jetbrains.kotlin.preprocessor.ModificationsKt;
import org.jetbrains.kotlin.preprocessor.Preprocessor;
import org.jetbrains.kotlin.preprocessor.PreprocessorKt;
import org.jetbrains.kotlin.preprocessor.Profile;
import org.jetbrains.kotlin.preprocessor.SystemOutLogger;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001dB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0016\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001cR\u0019\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/preprocessor/Preprocessor;", "", "logger", "Lorg/jetbrains/kotlin/preprocessor/Logger;", "(Lorg/jetbrains/kotlin/preprocessor/Logger;)V", "fileType", "Lorg/jetbrains/kotlin/idea/KotlinFileType;", "kotlin.jvm.PlatformType", "getFileType", "()Lorg/jetbrains/kotlin/idea/KotlinFileType;", "jetPsiFactory", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "getJetPsiFactory", "()Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "getLogger", "()Lorg/jetbrains/kotlin/preprocessor/Logger;", "processDirectorySingleEvaluator", "", "sourceRoot", "Ljava/io/File;", "targetRoot", "evaluator", "Lorg/jetbrains/kotlin/preprocessor/Evaluator;", "processFileSingleEvaluator", "Lorg/jetbrains/kotlin/preprocessor/Preprocessor$FileProcessingResult;", "sourceFile", "processSources", "profile", "Lorg/jetbrains/kotlin/preprocessor/Profile;", "FileProcessingResult", "kotlin-compiler"})
public final class Preprocessor {
    private final KotlinFileType fileType;
    @NotNull
    private final KtPsiFactory jetPsiFactory;
    @NotNull
    private final Logger logger;

    public final KotlinFileType getFileType() {
        return this.fileType;
    }

    @NotNull
    public final KtPsiFactory getJetPsiFactory() {
        return this.jetPsiFactory;
    }

    public final void processSources(@NotNull File sourceRoot, @NotNull Profile profile) {
        Intrinsics.checkParameterIsNotNull(sourceRoot, "sourceRoot");
        Intrinsics.checkParameterIsNotNull(profile, "profile");
        this.processDirectorySingleEvaluator(sourceRoot, profile.getTargetRoot(), profile.getEvaluator());
    }

    private final FileProcessingResult processFileSingleEvaluator(File sourceFile, Evaluator evaluator) {
        if (Intrinsics.areEqual(FilesKt.getExtension(sourceFile), this.fileType.getDefaultExtension()) ^ true) {
            return FileProcessingResult.Copy.INSTANCE;
        }
        String sourceText = PreprocessorKt.convertLineSeparators(FilesKt.readText$default(sourceFile, null, 1, null));
        String string = sourceFile.getName();
        Intrinsics.checkExpressionValueIsNotNull(string, "sourceFile.name");
        KtFile psiFile = this.jetPsiFactory.createFile(string, sourceText);
        List<Conditional> fileAnnotations = ConditionalKt.parseConditionalAnnotations(psiFile);
        if (!((Boolean)evaluator.invoke(fileAnnotations)).booleanValue()) {
            return FileProcessingResult.Skip.INSTANCE;
        }
        CollectModificationsVisitor visitor2 = new CollectModificationsVisitor(CollectionsKt.listOf(evaluator));
        psiFile.accept(visitor2);
        List list2 = (List)CollectionsKt.single((Iterable)visitor2.getElementModifications().values());
        Collection collection = list2;
        return !collection.isEmpty() ? (FileProcessingResult)new FileProcessingResult.Modify(sourceText, list2) : (FileProcessingResult)FileProcessingResult.Copy.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private final void processDirectorySingleEvaluator(File sourceRoot, File targetRoot, Evaluator evaluator) {
        void sourceDirectories;
        void sourceFiles2;
        Collection element$iv;
        void $receiver$iv;
        Object[] objectArray = sourceRoot.listFiles();
        ArrayList<void> first$iv = new ArrayList<void>();
        ArrayList<void> second$iv = new ArrayList<void>();
        for (int i = 0; i < ((void)$receiver$iv).length; ++i) {
            element$iv = $receiver$iv[i];
            File it = (File)((Object)element$iv);
            if (!it.isDirectory()) {
                first$iv.add((void)element$iv);
                continue;
            }
            second$iv.add((void)element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List list2 = pair.component1();
        List list3 = pair.component2();
        pair = null;
        HashSet<File> processedFiles = SetsKt.hashSetOf(new File[0]);
        Iterator iterator2 = sourceFiles2.iterator();
        while (iterator2.hasNext()) {
            File sourceFile;
            File file = sourceFile = (File)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(file, "sourceFile");
            FileProcessingResult result2 = this.processFileSingleEvaluator(file, evaluator);
            this.logger.debug(result2 + ": " + sourceFile);
            if (result2 instanceof FileProcessingResult.Skip) continue;
            File targetFile = PreprocessorKt.makeRelativeTo(sourceFile, sourceRoot, targetRoot);
            element$iv = processedFiles;
            element$iv.add(targetFile);
            if (targetFile.exists() && targetFile.isDirectory()) {
                FilesKt.deleteRecursively(targetFile);
            }
            if (result2 instanceof FileProcessingResult.Copy) {
                FileUtil.copy(sourceFile, targetFile);
                continue;
            }
            if (!(result2 instanceof FileProcessingResult.Modify)) continue;
            String resultText = ((FileProcessingResult.Modify)result2).getModifiedText();
            if (targetFile.exists() && PreprocessorKt.isTextEqualTo(targetFile, resultText)) continue;
            this.logger.info("Rewriting modified " + targetFile);
            FilesKt.writeText$default(targetFile, resultText, null, 2, null);
        }
        for (File sourceDir : sourceDirectories) {
            File targetDir = PreprocessorKt.makeRelativeTo(sourceDir, sourceRoot, targetRoot);
            if (targetDir.exists() && !targetDir.isDirectory()) {
                targetDir.delete();
            }
            PreprocessorKt.mkdirsOrFail(targetDir);
            File file = sourceDir;
            Intrinsics.checkExpressionValueIsNotNull(file, "sourceDir");
            this.processDirectorySingleEvaluator(file, targetDir, evaluator);
            Collection collection = processedFiles;
            collection.add(targetDir);
        }
        File[] fileArray = targetRoot.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            Object v2;
            Iterable iterable;
            Collection collection;
            File targetFile;
            block10: {
                targetFile = fileArray[i];
                collection = processedFiles;
                iterable = processedFiles;
                Iterable iterable2 = iterable;
                for (Object t : iterable2) {
                    File it = (File)t;
                    if (!FileUtil.filesEqual(it, targetFile)) continue;
                    v2 = t;
                    break block10;
                }
                v2 = null;
            }
            iterable = v2;
            Collection collection2 = collection;
            if (collection2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableCollection<T>");
            }
            if (TypeIntrinsics.asMutableCollection(collection2).remove(iterable)) continue;
            this.logger.info("Deleting skipped " + targetFile);
            FilesKt.deleteRecursively(targetFile);
        }
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    public Preprocessor(@NotNull Logger logger) {
        Intrinsics.checkParameterIsNotNull(logger, "logger");
        this.logger = logger;
        this.fileType = KotlinFileType.INSTANCE;
        CompilerConfiguration configuration = new CompilerConfiguration();
        KotlinCoreEnvironment environment2 = KotlinCoreEnvironment.Companion.createForProduction(environment.1.INSTANCE, configuration, CollectionsKt.<String>emptyList());
        Project project = environment2.getProject();
        this.jetPsiFactory = new KtPsiFactory(project);
    }

    public /* synthetic */ Preprocessor(Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            logger = SystemOutLogger.INSTANCE;
        }
        this(logger);
    }

    public Preprocessor() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b6\u0018\u00002\u00020\u0001:\u0003\u0006\u0007\bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/preprocessor/Preprocessor$FileProcessingResult;", "", "()V", "toString", "", "kotlin.jvm.PlatformType", "Copy", "Modify", "Skip", "kotlin-compiler"})
    public static abstract class FileProcessingResult {
        public String toString() {
            return this.getClass().getSimpleName();
        }

        private FileProcessingResult() {
        }

        public /* synthetic */ FileProcessingResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/preprocessor/Preprocessor$FileProcessingResult$Skip;", "Lorg/jetbrains/kotlin/preprocessor/Preprocessor$FileProcessingResult;", "()V", "kotlin-compiler"})
        public static final class Skip
        extends FileProcessingResult {
            public static final Skip INSTANCE;

            private Skip() {
                super(null);
                INSTANCE = this;
            }

            static {
                new Skip();
            }
        }

        @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/preprocessor/Preprocessor$FileProcessingResult$Copy;", "Lorg/jetbrains/kotlin/preprocessor/Preprocessor$FileProcessingResult;", "()V", "kotlin-compiler"})
        public static final class Copy
        extends FileProcessingResult {
            public static final Copy INSTANCE;

            private Copy() {
                super(null);
                INSTANCE = this;
            }

            static {
                new Copy();
            }
        }

        @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\f\u001a\u00020\u0003J\b\u0010\r\u001a\u00020\u0003H\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/preprocessor/Preprocessor$FileProcessingResult$Modify;", "Lorg/jetbrains/kotlin/preprocessor/Preprocessor$FileProcessingResult;", "sourceText", "", "modifications", "", "Lorg/jetbrains/kotlin/preprocessor/Modification;", "(Ljava/lang/String;Ljava/util/List;)V", "getModifications", "()Ljava/util/List;", "getSourceText", "()Ljava/lang/String;", "getModifiedText", "toString", "kotlin-compiler"})
        public static final class Modify
        extends FileProcessingResult {
            @NotNull
            private final String sourceText;
            @NotNull
            private final List<Modification> modifications;

            @NotNull
            public final String getModifiedText() {
                return ModificationsKt.applyTo(this.modifications, this.sourceText);
            }

            @Override
            @NotNull
            public String toString() {
                return "Modify(" + this.modifications.size() + ")";
            }

            @NotNull
            public final String getSourceText() {
                return this.sourceText;
            }

            @NotNull
            public final List<Modification> getModifications() {
                return this.modifications;
            }

            public Modify(@NotNull String sourceText, @NotNull List<Modification> modifications) {
                Intrinsics.checkParameterIsNotNull(sourceText, "sourceText");
                Intrinsics.checkParameterIsNotNull(modifications, "modifications");
                super(null);
                this.sourceText = sourceText;
                this.modifications = modifications;
            }
        }
    }
}

