/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ElementPatternCondition;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PatternConditionPlus;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.ValuePatternCondition;
import com.intellij.util.InstanceofCheckerGenerator;
import com.intellij.util.PairProcessor;
import com.intellij.util.ProcessingContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ObjectPattern<T, Self extends ObjectPattern<T, Self>>
implements ElementPattern<T>,
Cloneable {
    private InitialPatternCondition<T> myInitialCondition;
    private Object myConditions;

    protected ObjectPattern(@NotNull InitialPatternCondition<T> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/patterns/ObjectPattern", "<init>"));
        }
        this.myInitialCondition = condition;
        this.myConditions = null;
    }

    protected ObjectPattern(final Class<T> aClass2) {
        this(new InitialPatternCondition<T>(aClass2){
            final Condition<Object> checker;
            {
                super(aAcceptedClass);
                this.checker = InstanceofCheckerGenerator.getInstance().getInstanceofChecker(aClass2);
            }

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                return this.checker.value(o);
            }
        });
    }

    @Override
    public final boolean accepts(@Nullable Object t) {
        return this.accepts(t, new ProcessingContext());
    }

    @Override
    public boolean accepts(@Nullable Object o, ProcessingContext context) {
        if (!this.myInitialCondition.accepts(o, context)) {
            return false;
        }
        if (this.myConditions == null) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.myConditions instanceof PatternCondition) {
            return ((PatternCondition)this.myConditions).accepts(o, context);
        }
        List list2 = (List)this.myConditions;
        int listSize = list2.size();
        for (int i = 0; i < listSize; ++i) {
            if (((PatternCondition)list2.get(i)).accepts(o, context)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final ElementPatternCondition<T> getCondition() {
        if (this.myConditions == null) {
            return new ElementPatternCondition<T>(this.myInitialCondition);
        }
        if (this.myConditions instanceof PatternCondition) {
            PatternCondition singleCondition = (PatternCondition)this.myConditions;
            return new ElementPatternCondition(this.myInitialCondition, Collections.singletonList(singleCondition));
        }
        return new ElementPatternCondition<T>(this.myInitialCondition, (List)this.myConditions);
    }

    public Self andNot(ElementPattern pattern) {
        Capture not = StandardPatterns.not(pattern);
        return this.and(not);
    }

    public Self andOr(ElementPattern ... patterns) {
        if (patterns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patterns", "com/intellij/patterns/ObjectPattern", "andOr"));
        }
        ElementPattern or = StandardPatterns.or(patterns);
        return this.and(or);
    }

    public Self and(ElementPattern pattern) {
        return this.with(new PatternConditionPlus<T, T>("and", pattern){

            @Override
            public boolean processValues(T t, ProcessingContext context, PairProcessor<T, ProcessingContext> processor) {
                return processor.process((ProcessingContext)t, context);
            }
        });
    }

    public Self equalTo(final @NotNull T o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/patterns/ObjectPattern", "equalTo"));
        }
        return this.with(new ValuePatternCondition<T>("equalTo"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/ObjectPattern$3", "accepts"));
                }
                return t.equals(o);
            }

            @Override
            public Collection<T> getValues() {
                return Collections.singletonList(o);
            }
        });
    }

    @NotNull
    public Self oneOf(T ... values2) {
        int length = values2.length;
        final Collection<T> list2 = length == 1 ? Collections.singletonList(values2[0]) : (length >= 11 ? new HashSet<T>(Arrays.asList(values2)) : Arrays.asList(values2));
        Self Self = this.with(new ValuePatternCondition<T>("oneOf"){

            @Override
            public Collection<T> getValues() {
                return list2;
            }

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/ObjectPattern$4", "accepts"));
                }
                return list2.contains(t);
            }
        });
        if (Self == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/ObjectPattern", "oneOf"));
        }
        return Self;
    }

    @NotNull
    public Self oneOf(final Collection<T> set) {
        Self Self = this.with(new ValuePatternCondition<T>("oneOf"){

            @Override
            public Collection<T> getValues() {
                return set;
            }

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/ObjectPattern$5", "accepts"));
                }
                return set.contains(t);
            }
        });
        if (Self == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/ObjectPattern", "oneOf"));
        }
        return Self;
    }

    public Self isNull() {
        return this.adapt(new ElementPatternCondition(new InitialPatternCondition(Object.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                return o == null;
            }
        }));
    }

    public Self notNull() {
        return this.adapt(new ElementPatternCondition(new InitialPatternCondition(Object.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                return o != null;
            }
        }));
    }

    public Self save(final Key<? super T> key) {
        return this.with(new PatternCondition<T>("save"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/ObjectPattern$8", "accepts"));
                }
                context.put(key, t);
                return true;
            }
        });
    }

    public Self save(final @NonNls String key) {
        return this.with(new PatternCondition<T>("save"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/ObjectPattern$9", "accepts"));
                }
                context.put(key, t);
                return true;
            }
        });
    }

    public Self with(PatternCondition<? super T> pattern) {
        ElementPatternCondition<? super T> condition = this.getCondition().append(pattern);
        return this.adapt(condition);
    }

    private Self adapt(ElementPatternCondition<T> condition) {
        try {
            ObjectPattern s = (ObjectPattern)this.clone();
            s.myInitialCondition = condition.getInitialCondition();
            List<PatternCondition<T>> conditions = condition.getConditions();
            s.myConditions = conditions.isEmpty() ? null : (conditions.size() == 1 ? conditions.get(0) : conditions);
            return (Self)s;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public Self without(final PatternCondition<? super T> pattern) {
        return this.with(new PatternCondition<T>("without"){

            @Override
            public boolean accepts(@NotNull T o, ProcessingContext context) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/patterns/ObjectPattern$10", "accepts"));
                }
                return !pattern.accepts(o, context);
            }
        });
    }

    public String toString() {
        return this.getCondition().toString();
    }

    public static class Capture<T>
    extends ObjectPattern<T, Capture<T>> {
        public Capture(Class<T> aClass2) {
            super(aClass2);
        }

        public Capture(@NotNull InitialPatternCondition<T> condition) {
            if (condition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/patterns/ObjectPattern$Capture", "<init>"));
            }
            super(condition);
        }
    }
}

