/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.fixStack;

import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtil;
import org.jetbrains.kotlin.codegen.optimization.common.MethodAnalyzer;
import org.jetbrains.kotlin.codegen.optimization.common.OptimizationBasicInterpreter;
import org.jetbrains.kotlin.codegen.optimization.fixStack.FixStackContext;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsn;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnNode;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;
import org.jetbrains.org.objectweb.asm.tree.analysis.Value;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 %2\u00020\u0001:\u0002%&B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001b2\u0006\u0010\u001d\u001a\u00020\u0010J\u000e\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u0010J\u0016\u0010\u001f\u001a\b\u0018\u00010 R\u00020\n2\u0006\u0010\u001d\u001a\u00020\u0010H\u0002J\u000e\u0010!\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u0010J\u0016\u0010\"\u001a\b\u0018\u00010 R\u00020\n2\u0006\u0010\u001d\u001a\u00020\u0010H\u0002J\u0016\u0010#\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001b2\u0006\u0010\u001d\u001a\u00020\u0010J\b\u0010$\u001a\u00020\u0019H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR*\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000ej\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer;", "", "owner", "", "method", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "context", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackContext;", "(Ljava/lang/String;Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackContext;)V", "analyzer", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer$InternalAnalyzer;", "getContext", "()Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackContext;", "expectedStackNode", "Ljava/util/HashMap;", "Lorg/jetbrains/org/objectweb/asm/tree/LabelNode;", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "Lkotlin/collections/HashMap;", "maxExtraStackSize", "", "getMaxExtraStackSize", "()I", "getMethod", "()Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "analyze", "", "getActualStack", "", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "location", "getActualStackSize", "getExpectedStackFrame", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer$InternalAnalyzer$FixStackFrame;", "getExpectedStackSize", "getFrame", "getStackToSpill", "preprocess", "Companion", "InternalAnalyzer", "kotlin-compiler"})
public final class FixStackAnalyzer {
    private final HashMap<LabelNode, AbstractInsnNode> expectedStackNode;
    private final InternalAnalyzer analyzer;
    @NotNull
    private final MethodNode method;
    @NotNull
    private final FixStackContext context;
    public static final int DEAD_CODE_STACK_SIZE = -1;
    public static final Companion Companion = new Companion(null);

    public final int getMaxExtraStackSize() {
        return this.analyzer.getMaxExtraStackSize();
    }

    @Nullable
    public final List<BasicValue> getStackToSpill(@NotNull AbstractInsnNode location2) {
        Intrinsics.checkParameterIsNotNull(location2, "location");
        return this.analyzer.getSpilledStacks().get(location2);
    }

    @Nullable
    public final List<BasicValue> getActualStack(@NotNull AbstractInsnNode location2) {
        Intrinsics.checkParameterIsNotNull(location2, "location");
        InternalAnalyzer.FixStackFrame fixStackFrame = this.getFrame(location2);
        return fixStackFrame != null ? fixStackFrame.getStackContent() : null;
    }

    public final int getActualStackSize(@NotNull AbstractInsnNode location2) {
        Intrinsics.checkParameterIsNotNull(location2, "location");
        InternalAnalyzer.FixStackFrame fixStackFrame = this.getFrame(location2);
        return fixStackFrame != null ? fixStackFrame.getStackSizeWithExtra() : -1;
    }

    public final int getExpectedStackSize(@NotNull AbstractInsnNode location2) {
        Intrinsics.checkParameterIsNotNull(location2, "location");
        InternalAnalyzer.FixStackFrame fixStackFrame = this.getExpectedStackFrame(location2);
        return fixStackFrame != null ? fixStackFrame.getStackSizeWithExtra() : -1;
    }

    private final InternalAnalyzer.FixStackFrame getExpectedStackFrame(AbstractInsnNode location2) {
        Map map2 = this.expectedStackNode;
        FixStackAnalyzer fixStackAnalyzer = this;
        Map map3 = map2;
        if (map3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, V>");
        }
        Object v = map3.get(location2);
        AbstractInsnNode abstractInsnNode = (AbstractInsnNode)v;
        if (abstractInsnNode == null) {
            abstractInsnNode = location2;
        }
        return fixStackAnalyzer.getFrame(abstractInsnNode);
    }

    private final InternalAnalyzer.FixStackFrame getFrame(AbstractInsnNode location2) {
        Frame frame = this.analyzer.getFrame(location2);
        if (!(frame instanceof InternalAnalyzer.FixStackFrame)) {
            frame = null;
        }
        return (InternalAnalyzer.FixStackFrame)frame;
    }

    public final void analyze() {
        this.preprocess();
        this.analyzer.analyze();
    }

    private final void preprocess() {
        for (AbstractInsnNode marker : this.context.getFakeAlwaysFalseIfeqMarkers()) {
            LabelNode labelNode;
            AbstractInsnNode next = marker.getNext();
            if (!(next instanceof JumpInsnNode)) continue;
            InsnNode nop = new InsnNode(0);
            Map map2 = this.expectedStackNode;
            Intrinsics.checkExpressionValueIsNotNull(((JumpInsnNode)next).label, "next.label");
            InsnNode insnNode = nop;
            map2.put(labelNode, insnNode);
            this.method.instructions.insert(next, nop);
            this.method.instructions.remove(marker);
            this.method.instructions.remove(next);
            this.context.getNodesToRemoveOnCleanup().add(nop);
        }
        this.context.getFakeAlwaysFalseIfeqMarkers().clear();
    }

    @NotNull
    public final MethodNode getMethod() {
        return this.method;
    }

    @NotNull
    public final FixStackContext getContext() {
        return this.context;
    }

    public FixStackAnalyzer(@NotNull String owner, @NotNull MethodNode method, @NotNull FixStackContext context) {
        Intrinsics.checkParameterIsNotNull(owner, "owner");
        Intrinsics.checkParameterIsNotNull(method, "method");
        Intrinsics.checkParameterIsNotNull(context, "context");
        this.method = method;
        this.context = context;
        FixStackAnalyzer fixStackAnalyzer = this;
        HashMap hashMap = new HashMap();
        fixStackAnalyzer.expectedStackNode = hashMap;
        this.analyzer = new InternalAnalyzer(owner, this.method, this.context);
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001+B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u0015H\u0002J\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\rH\u0014J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\rH\u0014J\u0018\u0010$\u001a\u00020%*\u00060&R\u00020\u00002\u0006\u0010\"\u001a\u00020\u0015H\u0002J\u0018\u0010'\u001a\u00020%*\u00060&R\u00020\u00002\u0006\u0010\"\u001a\u00020\u0015H\u0002J\u0018\u0010(\u001a\u00020%*\u00060&R\u00020\u00002\u0006\u0010\"\u001a\u00020\u0015H\u0002J\u0018\u0010)\u001a\u00020%*\u00060&R\u00020\u00002\u0006\u0010\"\u001a\u00020\u0015H\u0002J\u0018\u0010*\u001a\u00020%*\u00060&R\u00020\u00002\u0006\u0010\"\u001a\u00020\u0015H\u0002R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR$\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R9\u0010\u0013\u001a*\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00160\u0014j\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u0016`\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer$InternalAnalyzer;", "Lorg/jetbrains/kotlin/codegen/optimization/common/MethodAnalyzer;", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "owner", "", "method", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "context", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackContext;", "(Ljava/lang/String;Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackContext;)V", "getContext", "()Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackContext;", "<set-?>", "", "maxExtraStackSize", "getMaxExtraStackSize", "()I", "setMaxExtraStackSize", "(I)V", "spilledStacks", "Ljava/util/HashMap;", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "", "Lkotlin/collections/HashMap;", "getSpilledStacks", "()Ljava/util/HashMap;", "indexOf", "node", "newFrame", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "nLocals", "nStack", "visitControlFlowEdge", "", "insn", "successor", "executeAfterInlineCallMarker", "", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer$InternalAnalyzer$FixStackFrame;", "executeBeforeInlineCallMarker", "executeRestoreStackInTryCatch", "executeSaveStackBeforeTry", "saveStackAndClear", "FixStackFrame", "kotlin-compiler"})
    private static final class InternalAnalyzer
    extends MethodAnalyzer<BasicValue> {
        @NotNull
        private final HashMap<AbstractInsnNode, List<BasicValue>> spilledStacks;
        private int maxExtraStackSize;
        @NotNull
        private final FixStackContext context;

        @NotNull
        public final HashMap<AbstractInsnNode, List<BasicValue>> getSpilledStacks() {
            return this.spilledStacks;
        }

        public final int getMaxExtraStackSize() {
            return this.maxExtraStackSize;
        }

        @Override
        protected boolean visitControlFlowEdge(int insn, int successor) {
            AbstractInsnNode insnNode = this.getInstructions().get(insn);
            return !(insnNode instanceof JumpInsnNode) || !this.context.getBreakContinueGotoNodes().contains(insnNode);
        }

        @Override
        @NotNull
        protected Frame<BasicValue> newFrame(int nLocals, int nStack) {
            return new FixStackFrame(nLocals, nStack);
        }

        private final int indexOf(AbstractInsnNode node) {
            return this.getMethod().instructions.indexOf(node);
        }

        private final void executeBeforeInlineCallMarker(@NotNull FixStackFrame $receiver, AbstractInsnNode insn) {
            this.saveStackAndClear($receiver, insn);
        }

        private final void saveStackAndClear(@NotNull FixStackFrame $receiver, AbstractInsnNode insn) {
            List<BasicValue> savedValues = $receiver.getStackContent();
            Map map2 = this.spilledStacks;
            List<BasicValue> list2 = savedValues;
            map2.put(insn, list2);
            $receiver.clearStack();
        }

        private final void executeAfterInlineCallMarker(@NotNull FixStackFrame $receiver, AbstractInsnNode insn) {
            AbstractInsnNode beforeInlineMarker = this.context.getOpeningInlineMethodMarker().get(insn);
            if ($receiver.getStackSize() > 0) {
                List savedValues;
                Map map2;
                BasicValue returnValue = $receiver.pop();
                $receiver.clearStack();
                Map map3 = map2 = (Map)this.spilledStacks;
                if (map3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, V>");
                }
                List list2 = savedValues = (List)map3.get(beforeInlineMarker);
                if (list2 == null) {
                    Intrinsics.throwNpe();
                }
                $receiver.pushAll(list2);
                $receiver.push(returnValue);
            } else {
                List savedValues;
                Map map4;
                Map map5 = map4 = (Map)this.spilledStacks;
                if (map5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, V>");
                }
                List list3 = savedValues = (List)map5.get(beforeInlineMarker);
                if (list3 == null) {
                    Intrinsics.throwNpe();
                }
                $receiver.pushAll(list3);
            }
        }

        private final void executeRestoreStackInTryCatch(@NotNull FixStackFrame $receiver, AbstractInsnNode insn) {
            AbstractInsnNode saveNode = this.context.getSaveStackMarkerForRestoreMarker().get(insn);
            Map map2 = this.spilledStacks;
            AbstractInsnNode abstractInsnNode = saveNode;
            if (abstractInsnNode == null) {
                Intrinsics.throwNpe();
            }
            AbstractInsnNode abstractInsnNode2 = abstractInsnNode;
            Object v = map2.get(abstractInsnNode2);
            if (v == null) {
                throw (Throwable)((Object)new AssertionError((Object)(this.indexOf(insn) + ": Restore stack is unavailable for " + this.indexOf(saveNode))));
            }
            List savedValues = (List)v;
            $receiver.pushAll(savedValues);
        }

        private final void executeSaveStackBeforeTry(@NotNull FixStackFrame $receiver, AbstractInsnNode insn) {
            this.saveStackAndClear($receiver, insn);
        }

        @NotNull
        public final FixStackContext getContext() {
            return this.context;
        }

        public InternalAnalyzer(@NotNull String owner, @NotNull MethodNode method, @NotNull FixStackContext context) {
            Intrinsics.checkParameterIsNotNull(owner, "owner");
            Intrinsics.checkParameterIsNotNull(method, "method");
            Intrinsics.checkParameterIsNotNull(context, "context");
            super(owner, method, new OptimizationBasicInterpreter());
            this.context = context;
            InternalAnalyzer internalAnalyzer = this;
            HashMap hashMap = new HashMap();
            internalAnalyzer.spilledStacks = hashMap;
        }

        public static final /* synthetic */ int access$getMaxExtraStackSize$p(InternalAnalyzer $this) {
            return $this.maxExtraStackSize;
        }

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0000\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0004H\u0016J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u000e\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0001H\u0016J\b\u0010\u001b\u001a\u00020\u0002H\u0016J\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u0002H\u0016J\u0014\u0010\u001e\u001a\u00020\u000f2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020 R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer$InternalAnalyzer$FixStackFrame;", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "nLocals", "", "nStack", "(Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer$InternalAnalyzer;II)V", "extraStack", "Lcom/intellij/util/containers/Stack;", "getExtraStack", "()Lcom/intellij/util/containers/Stack;", "stackSizeWithExtra", "getStackSizeWithExtra", "()I", "clearStack", "", "execute", "insn", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "interpreter", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Interpreter;", "getStack", "i", "getStackContent", "", "init", "src", "pop", "push", "value", "pushAll", "values", "", "kotlin-compiler"})
        public final class FixStackFrame
        extends Frame<BasicValue> {
            @NotNull
            private final Stack<BasicValue> extraStack;

            @NotNull
            public final Stack<BasicValue> getExtraStack() {
                return this.extraStack;
            }

            @Override
            @NotNull
            public Frame<BasicValue> init(@NotNull Frame<? extends BasicValue> src) {
                Intrinsics.checkParameterIsNotNull(src, "src");
                this.extraStack.clear();
                Frame<? extends BasicValue> frame = src;
                if (frame == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.codegen.optimization.fixStack.FixStackAnalyzer.InternalAnalyzer.FixStackFrame");
                }
                this.extraStack.addAll((Collection)((FixStackFrame)frame).extraStack);
                Frame<BasicValue> frame2 = super.init(src);
                Intrinsics.checkExpressionValueIsNotNull(frame2, "super.init(src)");
                return frame2;
            }

            @Override
            public void clearStack() {
                this.extraStack.clear();
                super.clearStack();
            }

            @Override
            public void execute(@NotNull AbstractInsnNode insn, @NotNull Interpreter<BasicValue> interpreter) {
                Intrinsics.checkParameterIsNotNull(insn, "insn");
                Intrinsics.checkParameterIsNotNull(interpreter, "interpreter");
                if (PseudoInsn.SAVE_STACK_BEFORE_TRY.isa(insn)) {
                    InternalAnalyzer.this.executeSaveStackBeforeTry(this, insn);
                } else if (PseudoInsn.RESTORE_STACK_IN_TRY_CATCH.isa(insn)) {
                    InternalAnalyzer.this.executeRestoreStackInTryCatch(this, insn);
                } else if (InlineCodegenUtil.isBeforeInlineMarker(insn)) {
                    InternalAnalyzer.this.executeBeforeInlineCallMarker(this, insn);
                } else if (InlineCodegenUtil.isAfterInlineMarker(insn)) {
                    InternalAnalyzer.this.executeAfterInlineCallMarker(this, insn);
                } else if (InlineCodegenUtil.isMarkedReturn(insn) && insn.getOpcode() == 177) {
                    return;
                }
                super.execute(insn, interpreter);
            }

            public final int getStackSizeWithExtra() {
                return super.getStackSize() + this.extraStack.size();
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<BasicValue> getStackContent() {
                ArrayList savedStack = new ArrayList();
                Iterable $receiver$iv = new IntRange(0, super.getStackSize() - 1);
                Iterator iterator2 = $receiver$iv.iterator();
                while (iterator2.hasNext()) {
                    void it;
                    int item$iv;
                    int n = item$iv = ((IntIterator)iterator2).nextInt();
                    Collection collection = savedStack;
                    Object v = super.getStack((int)it);
                    Intrinsics.checkExpressionValueIsNotNull(v, "super.getStack(it)");
                    BasicValue basicValue = (BasicValue)v;
                    collection.add(basicValue);
                }
                savedStack.addAll((Collection)this.extraStack);
                return savedStack;
            }

            @Override
            public void push(@NotNull BasicValue value) {
                Intrinsics.checkParameterIsNotNull(value, "value");
                if (super.getStackSize() < this.getMaxStackSize()) {
                    super.push((Value)value);
                } else {
                    this.extraStack.add(value);
                    InternalAnalyzer.this.maxExtraStackSize = Math.max(InternalAnalyzer.this.getMaxExtraStackSize(), this.extraStack.size());
                }
            }

            public final void pushAll(@NotNull Collection<? extends BasicValue> values2) {
                Intrinsics.checkParameterIsNotNull(values2, "values");
                Iterable $receiver$iv = values2;
                for (Object element$iv : $receiver$iv) {
                    BasicValue it = (BasicValue)element$iv;
                    this.push(it);
                }
            }

            @Override
            @NotNull
            public BasicValue pop() {
                Collection collection = this.extraStack;
                if (!collection.isEmpty()) {
                    BasicValue basicValue = this.extraStack.pop();
                    Intrinsics.checkExpressionValueIsNotNull(basicValue, "extraStack.pop()");
                    return basicValue;
                }
                Object v = super.pop();
                Intrinsics.checkExpressionValueIsNotNull(v, "super.pop()");
                return (BasicValue)v;
            }

            @Override
            @NotNull
            public BasicValue getStack(int i) {
                if (i < super.getMaxStackSize()) {
                    Object v = super.getStack(i);
                    Intrinsics.checkExpressionValueIsNotNull(v, "super.getStack(i)");
                    return (BasicValue)v;
                }
                Object e = this.extraStack.get(i - this.getMaxStackSize());
                Intrinsics.checkExpressionValueIsNotNull(e, "extraStack[i - maxStackSize]");
                return (BasicValue)e;
            }

            public FixStackFrame(int nLocals, int nStack) {
                super(nLocals, nStack);
                this.extraStack = new Stack();
            }
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer$Companion;", "", "()V", "DEAD_CODE_STACK_SIZE", "", "kotlin-compiler"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

