/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.checkers.SimpleDeclarationChecker;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eH\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsInheritanceChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/SimpleDeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "findFakeMethodOverridingExternalWithOptionalParams", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "cls", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "isOverridingExternalWithOptionalParams", "", "function", "kotlin-compiler"})
public final class JsInheritanceChecker
implements SimpleDeclarationChecker {
    public static final JsInheritanceChecker INSTANCE;

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext) {
        FunctionDescriptor fakeOverriddenMethod;
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        if (descriptor2 instanceof FunctionDescriptor && !DescriptorUtils.isEffectivelyExternal((MemberDescriptor)descriptor2) && this.isOverridingExternalWithOptionalParams((FunctionDescriptor)descriptor2)) {
            diagnosticHolder.report(ErrorsJs.OVERRIDING_EXTERNAL_FUN_WITH_OPTIONAL_PARAMS.on((KtElement)((PsiElement)declaration)));
        } else if (descriptor2 instanceof ClassDescriptor && !DescriptorUtils.isEffectivelyExternal((MemberDescriptor)descriptor2) && (fakeOverriddenMethod = this.findFakeMethodOverridingExternalWithOptionalParams((ClassDescriptor)descriptor2)) != null) {
            diagnosticHolder.report(ErrorsJs.OVERRIDING_EXTERNAL_FUN_WITH_OPTIONAL_PARAMS_WITH_FAKE.on((KtElement)((PsiElement)declaration), fakeOverriddenMethod));
        }
        if (descriptor2 instanceof ClassDescriptor) {
            boolean bl;
            block7: {
                Iterable $receiver$iv = TypeUtilsKt.immediateSupertypes(((ClassDescriptor)descriptor2).getDefaultType());
                for (Object element$iv : $receiver$iv) {
                    KotlinType it = (KotlinType)element$iv;
                    if (!FunctionTypesKt.isBuiltinFunctionalTypeOrSubtype(it)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
            if (bl) {
                KtDeclaration ktDeclaration = declaration;
                if (ktDeclaration == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClassOrObject");
                }
                diagnosticHolder.report(ErrorsJs.IMPLEMENTING_FUNCTION_INTERFACE.on((KtClassOrObject)((PsiElement)((KtClassOrObject)ktDeclaration))));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isOverridingExternalWithOptionalParams(FunctionDescriptor function2) {
        void $receiver$iv$iv;
        if (!function2.getKind().isReal() && Intrinsics.areEqual((Object)function2.getModality(), (Object)Modality.ABSTRACT)) {
            return false;
        }
        Iterable $receiver$iv = function2.getOverriddenDescriptors();
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            FunctionDescriptor it = (FunctionDescriptor)element$iv$iv;
            if (!DescriptorUtils.isEffectivelyExternal(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (FunctionDescriptor overriddenFunction : (List)destination$iv$iv) {
            boolean bl;
            block4: {
                $receiver$iv = overriddenFunction.getValueParameters();
                for (Object element$iv : $receiver$iv) {
                    ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
                    if (!DescriptorUtilsKt.hasDefaultValue(it)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    private final FunctionDescriptor findFakeMethodOverridingExternalWithOptionalParams(ClassDescriptor cls) {
        Object v1;
        block4: {
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv = ResolutionScope.DefaultImpls.getContributedDescriptors$default(cls.getUnsubstitutedMemberScope(), DescriptorKindFilter.CALLABLES, null, 2, null);
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            Iterator $receiver$iv$iv$iv = $receiver$iv$iv;
            Iterator iterator2 = $receiver$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                FunctionDescriptor functionDescriptor;
                Object element$iv$iv$iv = iterator2.next();
                Object element$iv$iv = element$iv$iv$iv;
                DeclarationDescriptor it = (DeclarationDescriptor)element$iv$iv;
                DeclarationDescriptor declarationDescriptor = it;
                if (!(declarationDescriptor instanceof FunctionDescriptor)) {
                    declarationDescriptor = null;
                }
                if ((FunctionDescriptor)declarationDescriptor == null) continue;
                FunctionDescriptor it$iv$iv = functionDescriptor;
                destination$iv$iv.add(it$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                FunctionDescriptor it = (FunctionDescriptor)element$iv$iv;
                if (!(Intrinsics.areEqual(it.getContainingDeclaration(), cls) && !it.getKind().isReal() && it.getOverriddenDescriptors().size() > 1)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List members2 = (List)destination$iv$iv;
            $receiver$iv = members2;
            for (Object element$iv : $receiver$iv) {
                FunctionDescriptor it = (FunctionDescriptor)element$iv;
                if (!INSTANCE.isOverridingExternalWithOptionalParams(it)) continue;
                v1 = element$iv;
                break block4;
            }
            v1 = null;
        }
        return v1;
    }

    private JsInheritanceChecker() {
        INSTANCE = this;
    }

    static {
        new JsInheritanceChecker();
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        Intrinsics.checkParameterIsNotNull(languageVersionSettings, "languageVersionSettings");
        SimpleDeclarationChecker.DefaultImpls.check(this, declaration, descriptor2, diagnosticHolder, bindingContext, languageVersionSettings);
    }
}

