/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsNumberLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsPostfixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsRegExp;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsVisitor;

class JsPrecedenceVisitor
extends JsVisitor {
    private int answer = -1;

    private JsPrecedenceVisitor() {
    }

    public static int exec(JsExpression expression) {
        JsPrecedenceVisitor visitor2 = new JsPrecedenceVisitor();
        visitor2.accept(expression);
        if (visitor2.answer < 0) {
            throw new RuntimeException("Precedence must be >= 0!");
        }
        return visitor2.answer;
    }

    @Override
    public void visitArrayAccess(@NotNull JsArrayAccess x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "org/jetbrains/kotlin/js/backend/JsPrecedenceVisitor", "visitArrayAccess"));
        }
        this.answer = 16;
    }

    @Override
    public void visitArray(@NotNull JsArrayLiteral x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "org/jetbrains/kotlin/js/backend/JsPrecedenceVisitor", "visitArray"));
        }
        this.answer = 17;
    }

    @Override
    public void visitBinaryExpression(@NotNull JsBinaryOperation x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "org/jetbrains/kotlin/js/backend/JsPrecedenceVisitor", "visitBinaryExpression"));
        }
        this.answer = x.getOperator().getPrecedence();
    }

    @Override
    public void visitBoolean(@NotNull JsLiteral.JsBooleanLiteral x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "org/jetbrains/kotlin/js/backend/JsPrecedenceVisitor", "visitBoolean"));
        }
        this.answer = 17;
    }

    @Override
    public void visitConditional(@NotNull JsConditional x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "org/jetbrains/kotlin/js/backend/JsPrecedenceVisitor", "visitConditional"));
        }
        this.answer = 3;
    }

    @Override
    public void visitFunction(@NotNull JsFunction x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "org/jetbrains/kotlin/js/backend/JsPrecedenceVisitor", "visitFunction"));
        }
        this.answer = 17;
    }

    @Override
    public void visitInvocation(@NotNull JsInvocation invocation) {
        if (invocation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "invocation", "org/jetbrains/kotlin/js/backend/JsPrecedenceVisitor", "visitInvocation"));
        }
        this.answer = 16;
    }

    @Override
    public void visitNameRef(@NotNull JsNameRef nameRef) {
        if (nameRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameRef", "org/jetbrains/kotlin/js/backend/JsPrecedenceVisitor", "visitNameRef"));
        }
        this.answer = nameRef.isLeaf() ? 17 : 16;
    }

    @Override
    public void visitNew(@NotNull JsNew x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "org/jetbrains/kotlin/js/backend/JsPrecedenceVisitor", "visitNew"));
        }
        this.answer = 15;
    }

    @Override
    public void visitNull(@NotNull JsNullLiteral x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "org/jetbrains/kotlin/js/backend/JsPrecedenceVisitor", "visitNull"));
        }
        this.answer = 17;
    }

    @Override
    public void visitInt(@NotNull JsNumberLiteral.JsIntLiteral x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "org/jetbrains/kotlin/js/backend/JsPrecedenceVisitor", "visitInt"));
        }
        this.answer = 17;
    }

    @Override
    public void visitDouble(@NotNull JsNumberLiteral.JsDoubleLiteral x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "org/jetbrains/kotlin/js/backend/JsPrecedenceVisitor", "visitDouble"));
        }
        this.answer = 17;
    }

    @Override
    public void visitObjectLiteral(@NotNull JsObjectLiteral x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "org/jetbrains/kotlin/js/backend/JsPrecedenceVisitor", "visitObjectLiteral"));
        }
        this.answer = 17;
    }

    @Override
    public void visitPostfixOperation(@NotNull JsPostfixOperation x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "org/jetbrains/kotlin/js/backend/JsPrecedenceVisitor", "visitPostfixOperation"));
        }
        this.answer = x.getOperator().getPrecedence();
    }

    @Override
    public void visitPrefixOperation(@NotNull JsPrefixOperation x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "org/jetbrains/kotlin/js/backend/JsPrecedenceVisitor", "visitPrefixOperation"));
        }
        this.answer = x.getOperator().getPrecedence();
    }

    @Override
    public void visitPropertyInitializer(@NotNull JsPropertyInitializer x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "org/jetbrains/kotlin/js/backend/JsPrecedenceVisitor", "visitPropertyInitializer"));
        }
        this.answer = 17;
    }

    @Override
    public void visitRegExp(@NotNull JsRegExp x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "org/jetbrains/kotlin/js/backend/JsPrecedenceVisitor", "visitRegExp"));
        }
        this.answer = 17;
    }

    @Override
    public void visitString(@NotNull JsStringLiteral x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "org/jetbrains/kotlin/js/backend/JsPrecedenceVisitor", "visitString"));
        }
        this.answer = 17;
    }

    @Override
    public void visitThis(@NotNull JsLiteral.JsThisRef x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "org/jetbrains/kotlin/js/backend/JsPrecedenceVisitor", "visitThis"));
        }
        this.answer = 17;
    }

    @Override
    protected void visitElement(@NotNull JsNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/js/backend/JsPrecedenceVisitor", "visitElement"));
        }
        throw new RuntimeException("Only expressions have precedence.");
    }
}

