/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import com.intellij.extapi.psi.ASTDelegatePsiElement;
import com.intellij.psi.PsiElement;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt;
import org.jetbrains.kotlin.js.inline.util.rewriters.NameReplacingVisitor;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.context.UsageTracker;
import org.jetbrains.kotlin.js.translate.context.UsageTrackerKt;
import org.jetbrains.kotlin.js.translate.expression.DestructuringDeclarationTranslator;
import org.jetbrains.kotlin.js.translate.expression.FunctionTranslatorKt;
import org.jetbrains.kotlin.js.translate.expression.LiteralFunctionTranslatorKt;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.FunctionBodyTranslator;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001a\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rJ\u0012\u0010\u0005\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/js/translate/expression/LiteralFunctionTranslator;", "Lorg/jetbrains/kotlin/js/translate/general/AbstractTranslator;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "(Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)V", "translate", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "fillCoroutineMetadata", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars;", "Lorg/jetbrains/kotlin/descriptors/impl/ValueParameterDescriptorImpl$WithDestructuringDeclaration;", "kotlin-compiler"})
public final class LiteralFunctionTranslator
extends AbstractTranslator {
    @NotNull
    public final JsExpression translate(@NotNull KtDeclarationWithBody declaration) {
        UsageTracker tracker;
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        TranslationContext invokingContext = this.context();
        FunctionDescriptor descriptor2 = BindingUtils.getFunctionDescriptor(invokingContext.bindingContext(), declaration);
        JsFunction lambda2 = invokingContext.getFunctionObject(descriptor2);
        Map aliases = new LinkedHashMap();
        if (DescriptorUtilsKt.isCoroutineLambda(descriptor2)) {
            FunctionDescriptor functionDescriptor = descriptor2;
            Intrinsics.checkExpressionValueIsNotNull(functionDescriptor, "descriptor");
            JsExpression jsExpression = JsAstUtils.stateMachineReceiver();
            Intrinsics.checkExpressionValueIsNotNull(jsExpression, "JsAstUtils.stateMachineReceiver()");
            aliases.put(functionDescriptor, jsExpression);
        }
        TranslationContext translationContext = invokingContext.newFunctionBodyWithUsageTracker(lambda2, descriptor2).innerContextWithDescriptorsAliased(aliases);
        FunctionDescriptor functionDescriptor = descriptor2;
        Intrinsics.checkExpressionValueIsNotNull(functionDescriptor, "descriptor");
        List<JsParameter> list2 = lambda2.getParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, "lambda.parameters");
        TranslationContext functionContext = FunctionTranslatorKt.translateAndAliasParameters(translationContext, functionDescriptor, list2);
        Iterable $receiver$iv = descriptor2.getValueParameters();
        for (Object element$iv : $receiver$iv) {
            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
            if (!(it instanceof ValueParameterDescriptorImpl.WithDestructuringDeclaration)) continue;
            lambda2.getBody().getStatements().add(this.translate((ValueParameterDescriptorImpl.WithDestructuringDeclaration)it, functionContext));
        }
        $receiver$iv = lambda2.getBody().getStatements();
        List<JsStatement> list3 = FunctionBodyTranslator.setDefaultValueForArguments(descriptor2, functionContext);
        Intrinsics.checkExpressionValueIsNotNull(list3, "setDefaultValueForArgume\u2026criptor, functionContext)");
        Object object = list3;
        CollectionsKt.addAll($receiver$iv, object);
        $receiver$iv = lambda2.getBody().getStatements();
        object = FunctionBodyTranslator.translateFunctionBody(descriptor2, declaration, functionContext);
        $receiver$iv.add(object);
        MetadataProperties.setFunctionDescriptor(lambda2, descriptor2);
        UsageTracker usageTracker = functionContext.usageTracker();
        if (usageTracker == null) {
            Intrinsics.throwNpe();
        }
        if (UsageTrackerKt.hasCapturedExceptContaining(tracker = usageTracker)) {
            JsFunction lambdaCreator = TranslationUtils.simpleReturnFunction(invokingContext.scope(), lambda2);
            lambdaCreator.setName(invokingContext.getInnerNameForDescriptor(descriptor2));
            MetadataProperties.setLocal(lambdaCreator, true);
            if (tracker.getCapturedDescriptors().contains(descriptor2) && !DescriptorUtilsKt.isCoroutineLambda(descriptor2)) {
                FunctionDescriptor functionDescriptor2 = descriptor2;
                Intrinsics.checkExpressionValueIsNotNull(functionDescriptor2, "descriptor");
                lambda2.setName(UsageTrackerKt.getNameForCapturedDescriptor(tracker, functionDescriptor2));
            }
            MetadataProperties.setStaticRef(lambdaCreator.getName(), lambdaCreator);
            TranslationContext translationContext2 = invokingContext;
            Intrinsics.checkExpressionValueIsNotNull(translationContext2, "invokingContext");
            FunctionDescriptor functionDescriptor3 = descriptor2;
            Intrinsics.checkExpressionValueIsNotNull(functionDescriptor3, "descriptor");
            this.fillCoroutineMetadata(lambdaCreator, translationContext2, functionDescriptor3);
            FunctionDescriptor functionDescriptor4 = descriptor2;
            Intrinsics.checkExpressionValueIsNotNull(functionDescriptor4, "descriptor");
            CallableMemberDescriptor callableMemberDescriptor = functionDescriptor4;
            TranslationContext translationContext3 = LiteralFunctionTranslatorKt.access$wrapContextForCoroutineIfNecessary(descriptor2, functionContext);
            TranslationContext translationContext4 = invokingContext;
            Intrinsics.checkExpressionValueIsNotNull(translationContext4, "invokingContext");
            return LiteralFunctionTranslatorKt.withCapturedParameters(lambdaCreator, callableMemberDescriptor, translationContext3, translationContext4);
        }
        lambda2.setName(invokingContext.getInnerNameForDescriptor(descriptor2));
        if (tracker.getCapturedDescriptors().contains(descriptor2)) {
            FunctionDescriptor functionDescriptor5 = descriptor2;
            Intrinsics.checkExpressionValueIsNotNull(functionDescriptor5, "descriptor");
            JsName jsName = UsageTrackerKt.getNameForCapturedDescriptor(tracker, functionDescriptor5);
            if (jsName == null) {
                Intrinsics.throwNpe();
            }
            JsName capturedName = jsName;
            JsName globalName = invokingContext.getInnerNameForDescriptor(descriptor2);
            NameReplacingVisitor replacingVisitor = new NameReplacingVisitor(MapsKt.mapOf(TuplesKt.to(capturedName, JsAstUtils.pureFqn(globalName, null))));
            replacingVisitor.accept((JsNode)lambda2);
        }
        MetadataProperties.setLocal(lambda2, true);
        invokingContext.addDeclarationStatement(lambda2.makeStmt());
        TranslationContext translationContext5 = invokingContext;
        Intrinsics.checkExpressionValueIsNotNull(translationContext5, "invokingContext");
        FunctionDescriptor functionDescriptor6 = descriptor2;
        Intrinsics.checkExpressionValueIsNotNull(functionDescriptor6, "descriptor");
        this.fillCoroutineMetadata(lambda2, translationContext5, functionDescriptor6);
        MetadataProperties.setStaticRef(lambda2.getName(), lambda2);
        TranslationContext translationContext6 = invokingContext;
        Intrinsics.checkExpressionValueIsNotNull(translationContext6, "invokingContext");
        FunctionDescriptor functionDescriptor7 = descriptor2;
        Intrinsics.checkExpressionValueIsNotNull(functionDescriptor7, "descriptor");
        CallableMemberDescriptor callableMemberDescriptor = functionDescriptor7;
        JsName jsName = lambda2.getName();
        Intrinsics.checkExpressionValueIsNotNull(jsName, "lambda.name");
        return LiteralFunctionTranslatorKt.access$getReferenceToLambda(translationContext6, callableMemberDescriptor, jsName);
    }

    public final void fillCoroutineMetadata(@NotNull JsFunction $receiver, @NotNull TranslationContext context, @NotNull FunctionDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        if (!descriptor2.isSuspend()) {
            return;
        }
        UtilsKt.fillCoroutineMetadata($receiver, context, descriptor2, descriptor2.getExtensionReceiverParameter() != null, true);
    }

    @NotNull
    public final JsVars translate(@NotNull ValueParameterDescriptorImpl.WithDestructuringDeclaration $receiver, @NotNull TranslationContext context) {
        ASTDelegatePsiElement aSTDelegatePsiElement;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context, "context");
        PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration($receiver);
        if (!(psiElement instanceof KtParameter)) {
            psiElement = null;
        }
        if ((aSTDelegatePsiElement = (KtParameter)psiElement) == null || (aSTDelegatePsiElement = aSTDelegatePsiElement.getDestructuringDeclaration()) == null) {
            String string = "Destructuring declaration for descriptor " + $receiver + " not found";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        ASTDelegatePsiElement destructuringDeclaration = aSTDelegatePsiElement;
        JsParameter jsParameter = new JsParameter(context.getNameForDescriptor($receiver));
        JsVars jsVars = DestructuringDeclarationTranslator.translate((KtDestructuringDeclaration)destructuringDeclaration, jsParameter.getName(), null, context);
        Intrinsics.checkExpressionValueIsNotNull(jsVars, "DestructuringDeclaration\u2026eter.name, null, context)");
        return jsVars;
    }

    public LiteralFunctionTranslator(@NotNull TranslationContext context) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        super(context);
    }
}

