/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.utils.DFS;

public class BoundsSubstitutor {
    private static final Function<TypeProjection, KotlinType> PROJECTIONS_TO_TYPES = new Function<TypeProjection, KotlinType>(){

        @Override
        public KotlinType apply(TypeProjection projection) {
            return projection.getType();
        }
    };

    private BoundsSubstitutor() {
    }

    @NotNull
    public static <D extends CallableDescriptor> D substituteBounds(@NotNull D functionDescriptor) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/types/BoundsSubstitutor", "substituteBounds"));
        }
        List<TypeParameterDescriptor> typeParameters2 = functionDescriptor.getTypeParameters();
        if (typeParameters2.isEmpty()) {
            D d = functionDescriptor;
            if (d == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/BoundsSubstitutor", "substituteBounds"));
            }
            return d;
        }
        CallableDescriptor substitutedFunction = functionDescriptor.substitute(BoundsSubstitutor.createUpperBoundsSubstitutor(typeParameters2));
        assert (substitutedFunction != null) : "Substituting upper bounds should always be legal";
        CallableDescriptor callableDescriptor = substitutedFunction;
        if (callableDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/BoundsSubstitutor", "substituteBounds"));
        }
        return (D)callableDescriptor;
    }

    @NotNull
    public static <D extends CallableDescriptor> TypeSubstitutor createUpperBoundsSubstitutor(@NotNull D callableDescriptor) {
        if (callableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callableDescriptor", "org/jetbrains/kotlin/types/BoundsSubstitutor", "createUpperBoundsSubstitutor"));
        }
        TypeSubstitutor typeSubstitutor2 = BoundsSubstitutor.createUpperBoundsSubstitutor(callableDescriptor.getTypeParameters());
        if (typeSubstitutor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/BoundsSubstitutor", "createUpperBoundsSubstitutor"));
        }
        return typeSubstitutor2;
    }

    @NotNull
    private static TypeSubstitutor createUpperBoundsSubstitutor(@NotNull List<TypeParameterDescriptor> typeParameters2) {
        if (typeParameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/kotlin/types/BoundsSubstitutor", "createUpperBoundsSubstitutor"));
        }
        HashMap<TypeConstructor, TypeProjection> mutableSubstitution = new HashMap<TypeConstructor, TypeProjection>();
        TypeSubstitutor substitutor2 = TypeSubstitutor.create(mutableSubstitution);
        for (TypeParameterDescriptor descriptor2 : BoundsSubstitutor.topologicallySortTypeParameters(typeParameters2)) {
            KotlinType upperBoundsAsType = TypeIntersector.getUpperBoundsAsType(descriptor2);
            KotlinType substitutedUpperBoundsAsType = substitutor2.substitute(upperBoundsAsType, Variance.INVARIANT);
            mutableSubstitution.put(descriptor2.getTypeConstructor(), new TypeProjectionImpl(substitutedUpperBoundsAsType));
        }
        TypeSubstitutor typeSubstitutor2 = substitutor2;
        if (typeSubstitutor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/BoundsSubstitutor", "createUpperBoundsSubstitutor"));
        }
        return typeSubstitutor2;
    }

    @NotNull
    private static List<TypeParameterDescriptor> topologicallySortTypeParameters(final @NotNull List<TypeParameterDescriptor> typeParameters2) {
        if (typeParameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/kotlin/types/BoundsSubstitutor", "topologicallySortTypeParameters"));
        }
        List<TypeParameterDescriptor> topOrder = DFS.topologicalOrder(typeParameters2, new DFS.Neighbors<TypeParameterDescriptor>(){

            @Override
            @NotNull
            public Iterable<TypeParameterDescriptor> getNeighbors(TypeParameterDescriptor current) {
                List list2 = BoundsSubstitutor.getTypeParametersFromUpperBounds(current, typeParameters2);
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/BoundsSubstitutor$2", "getNeighbors"));
                }
                return list2;
            }
        });
        assert (topOrder.size() == typeParameters2.size()) : "All type parameters must be visited, but only " + topOrder + " were";
        Collections.reverse(topOrder);
        List<TypeParameterDescriptor> list2 = topOrder;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/BoundsSubstitutor", "topologicallySortTypeParameters"));
        }
        return list2;
    }

    @NotNull
    private static List<TypeParameterDescriptor> getTypeParametersFromUpperBounds(@NotNull TypeParameterDescriptor current, final @NotNull List<TypeParameterDescriptor> typeParameters2) {
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "org/jetbrains/kotlin/types/BoundsSubstitutor", "getTypeParametersFromUpperBounds"));
        }
        if (typeParameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/kotlin/types/BoundsSubstitutor", "getTypeParametersFromUpperBounds"));
        }
        List list2 = DFS.dfs(current.getUpperBounds(), new DFS.Neighbors<KotlinType>(){

            @Override
            @NotNull
            public Iterable<KotlinType> getNeighbors(KotlinType current) {
                Collection<KotlinType> collection = Collections2.transform(current.getArguments(), PROJECTIONS_TO_TYPES);
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/BoundsSubstitutor$3", "getNeighbors"));
                }
                return collection;
            }
        }, new DFS.NodeHandlerWithListResult<KotlinType, TypeParameterDescriptor>(){

            @Override
            public boolean beforeChildren(KotlinType current) {
                ClassifierDescriptor declarationDescriptor = current.getConstructor().getDeclarationDescriptor();
                if (typeParameters2.contains(declarationDescriptor)) {
                    ((LinkedList)this.result).add((TypeParameterDescriptor)declarationDescriptor);
                }
                return true;
            }
        });
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/BoundsSubstitutor", "getTypeParametersFromUpperBounds"));
        }
        return list2;
    }
}

