/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.impl.JavaClassImpl;
import org.jetbrains.kotlin.load.kotlin.KotlinBinaryClassCache;
import org.jetbrains.kotlin.load.kotlin.KotlinClassFinder;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.VirtualFileFinderFactory;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000bH&\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/load/kotlin/VirtualFileFinder;", "Lorg/jetbrains/kotlin/load/kotlin/KotlinClassFinder;", "()V", "classFileName", "", "jClass", "Lorg/jetbrains/kotlin/load/java/structure/JavaClass;", "findKotlinClass", "Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass;", "javaClass", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "findVirtualFileWithHeader", "Lcom/intellij/openapi/vfs/VirtualFile;", "SERVICE", "kotlin-compiler"})
public abstract class VirtualFileFinder
implements KotlinClassFinder {
    public static final SERVICE SERVICE = new SERVICE(null);

    @Nullable
    public abstract VirtualFile findVirtualFileWithHeader(@NotNull ClassId var1);

    @Override
    @Nullable
    public KotlinJvmBinaryClass findKotlinClass(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        VirtualFile virtualFile = this.findVirtualFileWithHeader(classId);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file2 = virtualFile;
        return KotlinBinaryClassCache.Companion.getKotlinBinaryClass$default(KotlinBinaryClassCache.Companion, file2, null, 2, null);
    }

    @Override
    @Nullable
    public KotlinJvmBinaryClass findKotlinClass(@NotNull JavaClass javaClass) {
        Intrinsics.checkParameterIsNotNull(javaClass, "javaClass");
        UserDataHolder userDataHolder = ((PsiClass)((JavaClassImpl)javaClass).getPsi()).getContainingFile();
        if (userDataHolder == null || (userDataHolder = userDataHolder.getVirtualFile()) == null) {
            return null;
        }
        UserDataHolder file2 = userDataHolder;
        if (((JavaClassImpl)javaClass).getOuterClass() != null) {
            VirtualFile $receiver$iv;
            VirtualFile virtualFile = ((VirtualFile)file2).getParent();
            if (virtualFile == null) {
                Intrinsics.throwNpe();
            }
            VirtualFile virtualFile2 = $receiver$iv = virtualFile.findChild(this.classFileName(javaClass) + ".class");
            if (virtualFile2 == null) {
                AssertionError assertionError;
                AssertionError assertionError2 = assertionError;
                AssertionError assertionError3 = assertionError;
                String string = "Virtual file not found for " + javaClass;
                assertionError2((Object)string);
                throw (Throwable)((Object)assertionError3);
            }
            Intrinsics.checkExpressionValueIsNotNull(virtualFile2, "file.parent!!.findChild(\u2026t found for $javaClass\" }");
            file2 = virtualFile2;
        }
        return KotlinBinaryClassCache.Companion.getKotlinBinaryClass$default(KotlinBinaryClassCache.Companion, (VirtualFile)file2, null, 2, null);
    }

    private final String classFileName(JavaClass jClass) {
        String simpleName2 = jClass.getName().asString();
        JavaClass javaClass = jClass.getOuterClass();
        if (javaClass == null) {
            String string = simpleName2;
            Intrinsics.checkExpressionValueIsNotNull(string, "simpleName");
            return string;
        }
        JavaClass outerClass = javaClass;
        return this.classFileName(outerClass) + "$" + simpleName2;
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/load/kotlin/VirtualFileFinder$SERVICE;", "", "()V", "getInstance", "Lorg/jetbrains/kotlin/load/kotlin/VirtualFileFinder;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin-compiler"})
    public static final class SERVICE {
        @NotNull
        public final VirtualFileFinder getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull(project, "project");
            VirtualFileFinderFactory virtualFileFinderFactory = VirtualFileFinderFactory.SERVICE.getInstance(project);
            GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope(project);
            Intrinsics.checkExpressionValueIsNotNull(globalSearchScope, "GlobalSearchScope.allScope(project)");
            return virtualFileFinderFactory.create(globalSearchScope);
        }

        private SERVICE() {
        }

        public /* synthetic */ SERVICE(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

