/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.SystemProperties;
import com.intellij.util.keyFMap.KeyFMap;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.UIUtil;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.Icon;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBUI {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.ui.JBUI");
    private static final PropertyChangeSupport PCS = new PropertyChangeSupport(new JBUI());
    private static final Float SYSTEM_SCALE_FACTOR = Float.valueOf(JBUI.sysScale());
    private static float userScaleFactor;

    public static void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        PCS.addPropertyChangeListener(propertyName, listener);
    }

    public static float sysScale() {
        if (SYSTEM_SCALE_FACTOR != null) {
            return SYSTEM_SCALE_FACTOR.floatValue();
        }
        if (UIUtil.isJreHiDPIEnabled()) {
            GraphicsDevice gd = null;
            try {
                gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            }
            catch (HeadlessException headlessException) {
                // empty catch block
            }
            if (gd != null) {
                return JBUI.sysScale(gd.getDefaultConfiguration());
            }
            return 1.0f;
        }
        if (SystemProperties.has("hidpi") && !SystemProperties.is("hidpi")) {
            return 1.0f;
        }
        UIUtil.initSystemFontData();
        Pair<String, Integer> fdata = UIUtil.getSystemFontData();
        int size = fdata == null ? Fonts.label().getSize() : fdata.getSecond().intValue();
        return (float)size / 12.0f;
    }

    public static float sysScale(JBUIScaleTrackable trackable) {
        if (UIUtil.isJreHiDPIEnabled() && trackable != null) {
            return trackable.getJBUIScale(ScaleType.SYS);
        }
        return JBUI.sysScale();
    }

    public static float sysScale(@Nullable GraphicsConfiguration gc) {
        if (UIUtil.isJreHiDPIEnabled() && gc != null && gc.getDevice().getType() == 0) {
            if (SystemInfo.isMac && UIUtil.isJreHiDPI_earlierVersion()) {
                return UIUtil.DetectRetinaKit.isOracleMacRetinaDevice(gc.getDevice()) ? 2.0f : 1.0f;
            }
            return (float)gc.getDefaultTransform().getScaleX();
        }
        return JBUI.sysScale();
    }

    public static float sysScale(@Nullable Graphics2D g) {
        if (UIUtil.isJreHiDPIEnabled() && g != null) {
            GraphicsConfiguration gc = g.getDeviceConfiguration();
            if (gc == null || gc.getDevice().getType() == 2 || gc.getDevice().getType() == 1) {
                return (float)g.getTransform().getScaleX();
            }
            return JBUI.sysScale(gc);
        }
        return JBUI.sysScale();
    }

    public static float pixScale(@NotNull JBUIScaleTrackable trackable) {
        if (trackable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trackable", "com/intellij/util/ui/JBUI", "pixScale"));
        }
        return UIUtil.isJreHiDPIEnabled() ? JBUI.sysScale(trackable) * trackable.getJBUIScale(ScaleType.USR) : trackable.getJBUIScale(ScaleType.USR);
    }

    private static void setUserScaleFactorProperty(float scale) {
        Float f = Float.valueOf(userScaleFactor);
        userScaleFactor = scale;
        PCS.firePropertyChange("JBUI.userScaleFactor", f, Float.valueOf(userScaleFactor));
        LOG.info("User scale factor: " + userScaleFactor);
    }

    public static void setUserScaleFactor(float scale) {
        if (SystemProperties.has("hidpi") && !SystemProperties.is("hidpi")) {
            JBUI.setUserScaleFactorProperty(1.0f);
            return;
        }
        scale = scale < 1.25f ? 1.0f : (scale < 1.5f ? 1.25f : (scale < 1.75f ? 1.5f : (scale < 2.0f ? 1.75f : 2.0f)));
        if (SystemInfo.isLinux && scale == 1.25f) {
            scale = 1.0f;
        }
        if (userScaleFactor == scale) {
            return;
        }
        JBUI.setUserScaleFactorProperty(scale);
    }

    public static float scale(float f) {
        return f * userScaleFactor;
    }

    public static int scale(int i) {
        return Math.round(userScaleFactor * (float)i);
    }

    public static <T extends JBIcon> T scale(T icon) {
        return (T)icon.withJBUIPreScaled(false);
    }

    public static boolean isHiDPI(float scale) {
        return scale > 1.0f;
    }

    static {
        JBUI.setUserScaleFactor(UIUtil.isJreHiDPIEnabled() ? 1.0f : SYSTEM_SCALE_FACTOR.floatValue());
        LOG.info("System scale factor: " + SYSTEM_SCALE_FACTOR + " (" + (UIUtil.isJreHiDPIEnabled() ? "JRE-managed" : "IDE-managed") + " HiDPI)");
    }

    public static abstract class AuxScalableJBIcon
    extends CachingScalableJBIcon
    implements JBUIScaleTrackable {
        private final JBUIScaleTracker myJBUIScaleDelegate = new JBUIScaleTracker();

        protected AuxScalableJBIcon() {
        }

        protected AuxScalableJBIcon(AuxScalableJBIcon icon) {
            super(icon);
        }

        public boolean updateJBUIScale() {
            return this.myJBUIScaleDelegate.updateJBUIScale();
        }

        @Override
        public float getJBUIScale(ScaleType type2) {
            return this.myJBUIScaleDelegate.getJBUIScale(type2);
        }
    }

    public static abstract class AuxJBIcon
    extends JBIcon
    implements JBUIScaleTrackable {
        private final JBUIScaleTracker myJBUIScaleDelegate = new JBUIScaleTracker();

        public boolean updateJBUIScale(@Nullable Graphics2D g) {
            return this.myJBUIScaleDelegate.updateJBUIScale(g);
        }

        public boolean needUpdateJBUIScale(@Nullable Graphics2D g) {
            return this.myJBUIScaleDelegate.needUpdateJBUIScale(g);
        }

        @Override
        public float getJBUIScale(ScaleType type2) {
            return this.myJBUIScaleDelegate.getJBUIScale(type2);
        }
    }

    private static class JBUIScaleTracker
    implements JBUIScaleTrackable {
        KeyFMap myTrackedJBUIScale = KeyFMap.EMPTY_MAP;

        private JBUIScaleTracker() {
            this.put(ScaleType.USR.key, Float.valueOf(JBIcon.currentJBUIScale()));
            this.put(ScaleType.SYS.key, Float.valueOf(JBUI.sysScale()));
        }

        private void put(Key<Float> key, Float value) {
            this.myTrackedJBUIScale = this.myTrackedJBUIScale.plus(key, value);
        }

        public boolean updateJBUIScale() {
            return this.updateJBUIScale(JBIcon.currentJBUIScale(), ScaleType.USR);
        }

        private boolean updateJBUIScale(float scale, ScaleType type2) {
            if (this.needUpdateJBUIScale(scale, type2)) {
                this.put(type2.key, Float.valueOf(scale));
                return true;
            }
            return false;
        }

        public boolean updateJBUIScale(@Nullable Graphics2D g) {
            boolean res2 = this.updateJBUIScale();
            if (g != null) {
                res2 = res2 || this.updateJBUIScale(JBUI.sysScale(g), ScaleType.SYS);
            }
            return res2;
        }

        public boolean needUpdateJBUIScale() {
            return this.needUpdateJBUIScale(JBIcon.currentJBUIScale(), ScaleType.USR);
        }

        private boolean needUpdateJBUIScale(float scale, ScaleType type2) {
            return this.getJBUIScale(type2) != scale;
        }

        public boolean needUpdateJBUIScale(@Nullable Graphics2D g) {
            return this.needUpdateJBUIScale() || g != null && this.needUpdateJBUIScale(JBUI.sysScale(g), ScaleType.SYS);
        }

        @Override
        public float getJBUIScale(ScaleType type2) {
            return type2 == ScaleType.PIX ? JBUI.pixScale(this) : ((Float)this.myTrackedJBUIScale.get(type2.key)).floatValue();
        }
    }

    public static interface JBUIScaleTrackable {
        public float getJBUIScale(ScaleType var1);
    }

    public static abstract class CachingScalableJBIcon<T extends CachingScalableJBIcon>
    extends ScalableJBIcon {
        private CachingScalableJBIcon myScaledIconCache;

        protected CachingScalableJBIcon() {
        }

        protected CachingScalableJBIcon(CachingScalableJBIcon icon) {
            super(icon);
            this.myScaledIconCache = null;
        }

        @Override
        public Icon scale(float scale) {
            if (scale == this.getScale()) {
                return this;
            }
            if (this.myScaledIconCache == null || this.myScaledIconCache.getScale() != scale) {
                this.myScaledIconCache = this.copy();
                this.myScaledIconCache.setScale(scale);
            }
            return this.myScaledIconCache;
        }

        @NotNull
        protected abstract T copy();
    }

    public static abstract class ScalableJBIcon
    extends JBIcon
    implements ScalableIcon {
        private float myScale = 1.0f;

        protected ScalableJBIcon() {
        }

        protected ScalableJBIcon(ScalableJBIcon icon) {
            super(icon);
            this.myScale = icon.myScale;
        }

        public float getScale() {
            return this.myScale;
        }

        protected void setScale(float scale) {
            this.myScale = scale;
        }

        @Override
        public int scaleVal(int value) {
            return this.scaleVal(value, Scale.EFFECTIVE);
        }

        @Override
        public float scaleVal(float value) {
            return this.scaleVal(value, Scale.EFFECTIVE);
        }

        public int scaleVal(int value, Scale type2) {
            return (int)this.scaleVal((float)value, type2);
        }

        public float scaleVal(float value, Scale type2) {
            switch (type2) {
                case JBUI: {
                    return super.scaleVal(value);
                }
                case INSTANCE: {
                    return value * this.myScale;
                }
            }
            return super.scaleVal(value * this.myScale);
        }

        public static enum Scale {
            JBUI,
            INSTANCE,
            EFFECTIVE;

        }
    }

    public static abstract class JBIcon
    implements Icon {
        private float myInitialJBUIScale = JBIcon.currentJBUIScale();

        protected JBIcon() {
        }

        protected JBIcon(JBIcon icon) {
            this.myInitialJBUIScale = icon.myInitialJBUIScale;
        }

        static float currentJBUIScale() {
            return UIUtil.isJreHiDPIEnabled() ? 1.0f : JBUI.scale(1.0f);
        }

        private float getAligningScale() {
            return JBIcon.currentJBUIScale() / this.myInitialJBUIScale;
        }

        protected boolean isJBUIPreScaled() {
            return this.myInitialJBUIScale != 1.0f;
        }

        protected void setJBUIPreScaled(boolean preScaled) {
            this.myInitialJBUIScale = preScaled ? JBIcon.currentJBUIScale() : 1.0f;
        }

        public JBIcon withJBUIPreScaled(boolean preScaled) {
            this.setJBUIPreScaled(preScaled);
            return this;
        }

        public int scaleVal(int value) {
            return (int)this.scaleVal((float)value);
        }

        public float scaleVal(float value) {
            return value * this.getAligningScale();
        }
    }

    public static class Fonts {
        public static JBFont label() {
            return JBFont.create(UIManager.getFont("Label.font"), false);
        }
    }

    public static enum ScaleType {
        USR,
        SYS,
        PIX;

        private final Key<Float> key = Key.create(this.name());
    }
}

