/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compilerRunner;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ComparatorUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.parser.com.sampullara.cli.Argument;

public class ArgumentUtils {
    private ArgumentUtils() {
    }

    @NotNull
    public static List<String> convertArgumentsToStringList(@NotNull CommonCompilerArguments arguments2) throws InstantiationException, IllegalAccessException {
        if (arguments2 == null) {
            ArgumentUtils.$$$reportNull$$$0(0);
        }
        ArrayList<String> result2 = new ArrayList<String>();
        ArgumentUtils.convertArgumentsToStringList(arguments2, (CommonCompilerArguments)arguments2.getClass().newInstance(), arguments2.getClass(), result2);
        result2.addAll(arguments2.freeArgs);
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            ArgumentUtils.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static void convertArgumentsToStringList(@NotNull CommonCompilerArguments arguments2, @NotNull CommonCompilerArguments defaultArguments, @NotNull Class<?> clazz, @NotNull List<String> result2) throws IllegalAccessException, InstantiationException {
        if (arguments2 == null) {
            ArgumentUtils.$$$reportNull$$$0(2);
        }
        if (defaultArguments == null) {
            ArgumentUtils.$$$reportNull$$$0(3);
        }
        if (clazz == null) {
            ArgumentUtils.$$$reportNull$$$0(4);
        }
        if (result2 == null) {
            ArgumentUtils.$$$reportNull$$$0(5);
        }
        for (Field field : clazz.getDeclaredFields()) {
            Class<?> fieldType;
            Object defaultValue;
            Object value;
            Argument argument = field.getAnnotation(Argument.class);
            if (argument == null) continue;
            try {
                value = field.get(arguments2);
                defaultValue = field.get(defaultArguments);
            }
            catch (IllegalAccessException ignored) {
                continue;
            }
            if (ComparatorUtil.equalsNullable(value, defaultValue)) continue;
            String name = ArgumentUtils.getAlias(argument);
            if (name == null) {
                name = ArgumentUtils.getName(argument, field);
            }
            if ((fieldType = field.getType()).isArray()) {
                Object[] values2 = (Object[])value;
                if (values2.length == 0) continue;
                value = StringUtil.join(values2, Function.TO_STRING, argument.delimiter());
            }
            result2.add(argument.prefix() + name);
            if (fieldType == Boolean.TYPE || fieldType == Boolean.class) continue;
            result2.add(value.toString());
        }
        Class<?> superClazz = clazz.getSuperclass();
        if (superClazz != null) {
            ArgumentUtils.convertArgumentsToStringList(arguments2, defaultArguments, superClazz, result2);
        }
    }

    private static String getAlias(Argument argument) {
        String alias = argument.alias();
        return alias.isEmpty() ? null : alias;
    }

    private static String getName(Argument argument, Field field) {
        String name = argument.value();
        return name.isEmpty() ? field.getName() : name;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/compilerRunner/ArgumentUtils";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultArguments";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/compilerRunner/ArgumentUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "convertArgumentsToStringList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertArgumentsToStringList";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

