/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclarationStub;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinScriptStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import org.jetbrains.kotlin.script.KotlinScriptDefinition;
import org.jetbrains.kotlin.script.KotlinScriptDefinitionProviderKt;

public class KtScript
extends KtNamedDeclarationStub<KotlinScriptStub>
implements KtDeclarationContainer {
    private KotlinScriptDefinition kotlinScriptDefinitionField;
    private boolean kotlinScriptDefinitionInitialized;

    private KotlinScriptDefinition getKotlinScriptDefinition() {
        if (!this.kotlinScriptDefinitionInitialized) {
            KtFile ktFile = this.getContainingKtFile();
            this.kotlinScriptDefinitionField = KotlinScriptDefinitionProviderKt.getScriptDefinition(ktFile);
            this.kotlinScriptDefinitionInitialized = true;
            assert (this.kotlinScriptDefinitionField != null) : "Should not parse a script without definition: " + ktFile.toString();
        }
        return this.kotlinScriptDefinitionField;
    }

    public KtScript(@NotNull ASTNode node) {
        if (node == null) {
            KtScript.$$$reportNull$$$0(0);
        }
        super(node);
        this.kotlinScriptDefinitionField = null;
        this.kotlinScriptDefinitionInitialized = false;
    }

    public KtScript(@NotNull KotlinScriptStub stub) {
        if (stub == null) {
            KtScript.$$$reportNull$$$0(1);
        }
        super(stub, KtStubElementTypes.SCRIPT);
        this.kotlinScriptDefinitionField = null;
        this.kotlinScriptDefinitionInitialized = false;
    }

    @Override
    @NotNull
    public FqName getFqName() {
        KotlinScriptStub stub = (KotlinScriptStub)this.getStub();
        if (stub != null) {
            FqName fqName2 = stub.getFqName();
            if (fqName2 == null) {
                KtScript.$$$reportNull$$$0(2);
            }
            return fqName2;
        }
        KtFile containingKtFile = this.getContainingKtFile();
        FqName fqName3 = containingKtFile.getPackageFqName().child(this.getKotlinScriptDefinition().getScriptName(this));
        if (fqName3 == null) {
            KtScript.$$$reportNull$$$0(3);
        }
        return fqName3;
    }

    @Override
    public String getName() {
        return this.getFqName().shortName().asString();
    }

    @NotNull
    public KtBlockExpression getBlockExpression() {
        KtBlockExpression ktBlockExpression = this.findNotNullChildByClass(KtBlockExpression.class);
        if (ktBlockExpression == null) {
            KtScript.$$$reportNull$$$0(4);
        }
        return ktBlockExpression;
    }

    @Override
    @NotNull
    public List<KtDeclaration> getDeclarations() {
        List<KtDeclaration> list2 = PsiTreeUtil.getChildrenOfTypeAsList(this.getBlockExpression(), KtDeclaration.class);
        if (list2 == null) {
            KtScript.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data2) {
        if (visitor2 == null) {
            KtScript.$$$reportNull$$$0(6);
        }
        return visitor2.visitScript(this, data2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/psi/KtScript";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/psi/KtScript";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFqName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBlockExpression";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

