/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.ConstantExpressionVisitor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaConstantExpressionEvaluator
extends JavaRecursiveElementWalkingVisitor {
    private final Factory<ConcurrentMap<PsiElement, Object>> myMapFactory;
    private final Project myProject;
    private static final Key<CachedValue<ConcurrentMap<PsiElement, Object>>> CONSTANT_VALUE_WO_OVERFLOW_MAP_KEY = Key.create("CONSTANT_VALUE_WO_OVERFLOW_MAP_KEY");
    private static final Key<CachedValue<ConcurrentMap<PsiElement, Object>>> CONSTANT_VALUE_WITH_OVERFLOW_MAP_KEY = Key.create("CONSTANT_VALUE_WITH_OVERFLOW_MAP_KEY");
    private static final Object NO_VALUE = ObjectUtils.NULL;
    private final ConstantExpressionVisitor myConstantExpressionVisitor;
    private static final CachedValueProvider<ConcurrentMap<PsiElement, Object>> PROVIDER = () -> {
        ConcurrentMap value = ContainerUtil.createConcurrentSoftMap();
        return CachedValueProvider.Result.create(value, PsiModificationTracker.MODIFICATION_COUNT);
    };

    private JavaConstantExpressionEvaluator(Set<PsiVariable> visitedVars, final boolean throwExceptionOnOverflow, @NotNull Project project, PsiConstantEvaluationHelper.AuxEvaluator auxEvaluator) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/JavaConstantExpressionEvaluator", "<init>"));
        }
        this.myMapFactory = auxEvaluator == null ? new Factory<ConcurrentMap<PsiElement, Object>>(){

            @Override
            public ConcurrentMap<PsiElement, Object> create() {
                Key key = throwExceptionOnOverflow ? CONSTANT_VALUE_WITH_OVERFLOW_MAP_KEY : CONSTANT_VALUE_WO_OVERFLOW_MAP_KEY;
                return (ConcurrentMap)CachedValuesManager.getManager(JavaConstantExpressionEvaluator.this.myProject).getCachedValue(JavaConstantExpressionEvaluator.this.myProject, key, PROVIDER, false);
            }
        } : () -> auxEvaluator.getCacheMap(throwExceptionOnOverflow);
        this.myProject = project;
        this.myConstantExpressionVisitor = new ConstantExpressionVisitor(visitedVars, throwExceptionOnOverflow, auxEvaluator);
    }

    @Override
    protected void elementFinished(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/JavaConstantExpressionEvaluator", "elementFinished"));
        }
        Object value = this.getCached(element);
        if (value == null) {
            Object result2 = this.myConstantExpressionVisitor.handle(element);
            this.cache(element, result2);
        }
    }

    @Override
    public void visitElement(PsiElement element) {
        Object value = this.getCached(element);
        if (value == null) {
            super.visitElement(element);
        } else {
            ConstantExpressionVisitor.store(element, value == NO_VALUE ? null : value);
        }
    }

    private Object getCached(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/JavaConstantExpressionEvaluator", "getCached"));
        }
        return this.map().get(element);
    }

    private Object cache(@NotNull PsiElement element, @Nullable Object value) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/JavaConstantExpressionEvaluator", "cache"));
        }
        value = ConcurrencyUtil.cacheOrGet(this.map(), element, value == null ? NO_VALUE : value);
        if (value == NO_VALUE) {
            value = null;
        }
        return value;
    }

    @NotNull
    private ConcurrentMap<PsiElement, Object> map() {
        ConcurrentMap<PsiElement, Object> concurrentMap = this.myMapFactory.create();
        if (concurrentMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaConstantExpressionEvaluator", "map"));
        }
        return concurrentMap;
    }

    public static Object computeConstantExpression(@Nullable PsiExpression expression, @Nullable Set<PsiVariable> visitedVars, boolean throwExceptionOnOverflow) {
        return JavaConstantExpressionEvaluator.computeConstantExpression(expression, visitedVars, throwExceptionOnOverflow, null);
    }

    public static Object computeConstantExpression(@Nullable PsiExpression expression, @Nullable Set<PsiVariable> visitedVars, boolean throwExceptionOnOverflow, PsiConstantEvaluationHelper.AuxEvaluator auxEvaluator) {
        if (expression == null) {
            return null;
        }
        if (expression instanceof PsiLiteralExpression) {
            return ((PsiLiteralExpression)expression).getValue();
        }
        JavaConstantExpressionEvaluator evaluator2 = new JavaConstantExpressionEvaluator(visitedVars, throwExceptionOnOverflow, expression.getProject(), auxEvaluator);
        if (expression instanceof PsiCompiledElement) {
            if (expression instanceof PsiPrefixExpression) {
                PsiExpression operand = ((PsiPrefixExpression)expression).getOperand();
                if (operand == null) {
                    return null;
                }
                Object value = evaluator2.myConstantExpressionVisitor.handle(operand);
                ConstantExpressionVisitor.store(operand, value);
            }
            return evaluator2.myConstantExpressionVisitor.handle(expression);
        }
        expression.accept(evaluator2);
        Object cached = evaluator2.getCached(expression);
        return cached == NO_VALUE ? null : cached;
    }

    public static Object computeConstantExpression(@Nullable PsiExpression expression, boolean throwExceptionOnOverflow) {
        return JavaConstantExpressionEvaluator.computeConstantExpression(expression, null, throwExceptionOnOverflow);
    }
}

