/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.messages;

import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.PlainTextMessageRenderer;
import org.jetbrains.kotlin.cli.common.messages.XmlMessageRenderer;
import org.jetbrains.kotlin.utils.fileUtils.FileUtilsKt;

public interface MessageRenderer {
    public static final MessageRenderer XML = new XmlMessageRenderer();
    public static final MessageRenderer WITHOUT_PATHS = new PlainTextMessageRenderer(){

        @Override
        @Nullable
        protected String getPath(@NotNull CompilerMessageLocation location2) {
            if (location2 == null) {
                1.$$$reportNull$$$0(0);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/kotlin/cli/common/messages/MessageRenderer$1", "getPath"));
        }
    };
    public static final MessageRenderer PLAIN_FULL_PATHS = new PlainTextMessageRenderer(){

        @Override
        @Nullable
        protected String getPath(@NotNull CompilerMessageLocation location2) {
            if (location2 == null) {
                2.$$$reportNull$$$0(0);
            }
            return location2.getPath();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/kotlin/cli/common/messages/MessageRenderer$2", "getPath"));
        }
    };
    public static final MessageRenderer PLAIN_RELATIVE_PATHS = new PlainTextMessageRenderer(){
        @NotNull
        private final File cwd = new File(".").getAbsoluteFile();

        @Override
        @Nullable
        protected String getPath(@NotNull CompilerMessageLocation location2) {
            String path;
            if (location2 == null) {
                3.$$$reportNull$$$0(0);
            }
            return (path = location2.getPath()) == null ? path : FileUtilsKt.descendantRelativeTo(new File(path), this.cwd).getPath();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/kotlin/cli/common/messages/MessageRenderer$3", "getPath"));
        }
    };

    public String renderPreamble();

    public String render(@NotNull CompilerMessageSeverity var1, @NotNull String var2, @NotNull CompilerMessageLocation var3);

    public String renderConclusion();
}

