/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.DataExternalizer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.GeneratedFile;
import org.jetbrains.kotlin.incremental.ICReporter;
import org.jetbrains.kotlin.incremental.IncrementalCacheImpl;
import org.jetbrains.kotlin.incremental.IncrementalCacheImplKt;
import org.jetbrains.kotlin.incremental.snapshots.FileSnapshotMap;
import org.jetbrains.kotlin.incremental.storage.BasicMap;
import org.jetbrains.kotlin.incremental.storage.BasicStringMap;
import org.jetbrains.kotlin.incremental.storage.LazyStorage;
import org.jetbrains.kotlin.incremental.storage.PathStringDescriptor;
import org.jetbrains.kotlin.incremental.storage.StringCollectionExternalizer;
import org.jetbrains.kotlin.modules.TargetId;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0003\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u001a\u001bB'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0012\u001a\u00020\u00132\u0010\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00160\u0015J\u0014\u0010\u0017\u001a\u00020\u00132\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u0019R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0018\u0010\u000e\u001a\u00060\u000fR\u00020\u0000X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/incremental/GradleIncrementalCacheImpl;", "Lorg/jetbrains/kotlin/incremental/IncrementalCacheImpl;", "Lorg/jetbrains/kotlin/modules/TargetId;", "targetDataRoot", "Ljava/io/File;", "targetOutputDir", "target", "reporter", "Lorg/jetbrains/kotlin/incremental/ICReporter;", "(Ljava/io/File;Ljava/io/File;Lorg/jetbrains/kotlin/modules/TargetId;Lorg/jetbrains/kotlin/incremental/ICReporter;)V", "sourceSnapshotMap", "Lorg/jetbrains/kotlin/incremental/snapshots/FileSnapshotMap;", "getSourceSnapshotMap$kotlin_compiler", "()Lorg/jetbrains/kotlin/incremental/snapshots/FileSnapshotMap;", "sourceToOutputMap", "Lorg/jetbrains/kotlin/incremental/GradleIncrementalCacheImpl$SourceToOutputFilesMap;", "getSourceToOutputMap$kotlin_compiler", "()Lorg/jetbrains/kotlin/incremental/GradleIncrementalCacheImpl$SourceToOutputFilesMap;", "registerOutputForSourceFiles", "", "generatedFiles", "", "Lorg/jetbrains/kotlin/build/GeneratedFile;", "removeOutputForSourceFiles", "sources", "", "Companion", "SourceToOutputFilesMap", "kotlin-compiler"})
public final class GradleIncrementalCacheImpl
extends IncrementalCacheImpl<TargetId> {
    @NotNull
    private final SourceToOutputFilesMap sourceToOutputMap;
    @NotNull
    private final FileSnapshotMap sourceSnapshotMap;
    private final ICReporter reporter;
    private static final String SOURCE_TO_OUTPUT_FILES = "source-to-output";
    private static final String SOURCE_SNAPSHOTS = "source-snapshot";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final SourceToOutputFilesMap getSourceToOutputMap$kotlin_compiler() {
        return this.sourceToOutputMap;
    }

    @NotNull
    public final FileSnapshotMap getSourceSnapshotMap$kotlin_compiler() {
        return this.sourceSnapshotMap;
    }

    public final void registerOutputForSourceFiles(@NotNull List<? extends GeneratedFile<?>> generatedFiles2) {
        Intrinsics.checkParameterIsNotNull(generatedFiles2, "generatedFiles");
        MultiMap<File, File> sourceToOutput = new MultiMap<File, File>();
        for (GeneratedFile<?> generatedFile : generatedFiles2) {
            for (File source : generatedFile.getSourceFiles()) {
                sourceToOutput.putValue(source, generatedFile.getOutputFile());
            }
        }
        Iterator<Object> iterator2 = sourceToOutput.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry;
            File source;
            Map.Entry entry2 = entry = (Map.Entry)iterator2.next();
            source = (File)entry2.getKey();
            entry2 = entry;
            Collection outputs = (Collection)entry2.getValue();
            File file2 = source;
            Intrinsics.checkExpressionValueIsNotNull(file2, "source");
            Collection collection = outputs;
            Intrinsics.checkExpressionValueIsNotNull(collection, "outputs");
            this.sourceToOutputMap.set(file2, collection);
        }
    }

    public final void removeOutputForSourceFiles(@NotNull Iterable<? extends File> sources) {
        Intrinsics.checkParameterIsNotNull(sources, "sources");
        Iterable<? extends File> $receiver$iv = sources;
        Iterator<? extends File> iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            File element$iv;
            File it = element$iv = iterator2.next();
            this.sourceToOutputMap.remove(it);
        }
    }

    public GradleIncrementalCacheImpl(@NotNull File targetDataRoot, @Nullable File targetOutputDir, @NotNull TargetId target, @NotNull ICReporter reporter) {
        Intrinsics.checkParameterIsNotNull(targetDataRoot, "targetDataRoot");
        Intrinsics.checkParameterIsNotNull(target, "target");
        Intrinsics.checkParameterIsNotNull(reporter, "reporter");
        super(targetDataRoot, targetOutputDir, target);
        this.reporter = reporter;
        this.sourceToOutputMap = (SourceToOutputFilesMap)this.registerMap((BasicMap)new SourceToOutputFilesMap(this.getStorageFile(GradleIncrementalCacheImpl.Companion.getSOURCE_TO_OUTPUT_FILES())));
        this.sourceSnapshotMap = (FileSnapshotMap)this.registerMap((BasicMap)new FileSnapshotMap(this.getStorageFile(GradleIncrementalCacheImpl.Companion.getSOURCE_SNAPSHOTS())));
    }

    static {
        SOURCE_TO_OUTPUT_FILES = SOURCE_TO_OUTPUT_FILES;
        SOURCE_SNAPSHOTS = SOURCE_SNAPSHOTS;
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\u00032\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0014J\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u00022\u0006\u0010\n\u001a\u00020\u0005H\u0086\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005J\u001f\u0010\u000e\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u00052\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0002H\u0086\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/incremental/GradleIncrementalCacheImpl$SourceToOutputFilesMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/incremental/GradleIncrementalCacheImpl;Ljava/io/File;)V", "dumpValue", "value", "get", "sourceFile", "remove", "", "file", "set", "outputFiles", "kotlin-compiler"})
    public final class SourceToOutputFilesMap
    extends BasicStringMap<Collection<? extends String>> {
        /*
         * WARNING - void declaration
         */
        public final void set(@NotNull File sourceFile, @NotNull Collection<? extends File> outputFiles) {
            Collection<String> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull(sourceFile, "sourceFile");
            Intrinsics.checkParameterIsNotNull(outputFiles, "outputFiles");
            LazyStorage<String, List> lazyStorage = this.getStorage();
            String string = sourceFile.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull(string, "sourceFile.absolutePath");
            Iterable iterable = outputFiles;
            String string2 = string;
            LazyStorage<String, List> lazyStorage2 = lazyStorage;
            void var4_6 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                File file2 = (File)item$iv$iv;
                collection = destination$iv$iv;
                String string3 = it.getAbsolutePath();
                collection.add(string3);
            }
            collection = (List)destination$iv$iv;
            lazyStorage2.set(string2, (List)collection);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Collection<File> get(@NotNull File sourceFile) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Intrinsics.checkParameterIsNotNull(sourceFile, "sourceFile");
            LazyStorage lazyStorage = this.getStorage();
            String string = sourceFile.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull(string, "sourceFile.absolutePath");
            Collection collection = (Collection)lazyStorage.get(string);
            Collection collection2 = collection;
            if (collection2 == null) {
                collection2 = CollectionsKt.emptyList();
            }
            Iterable iterable = $receiver$iv = (Iterable)collection2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void p1;
                String string2 = (String)item$iv$iv;
                Collection collection3 = destination$iv$iv;
                File file2 = new File((String)p1);
                collection3.add(file2);
            }
            return (List)destination$iv$iv;
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull Collection<String> value) {
            Intrinsics.checkParameterIsNotNull(value, "value");
            return IncrementalCacheImplKt.dumpCollection(value);
        }

        public final void remove(@NotNull File file2) {
            Intrinsics.checkParameterIsNotNull(file2, "file");
            Iterable $receiver$iv = this.get(file2);
            for (Object element$iv : $receiver$iv) {
                File it = (File)element$iv;
                GradleIncrementalCacheImpl.this.reporter.report(new Function0<String>(it, this, file2){
                    final /* synthetic */ File $it;
                    final /* synthetic */ SourceToOutputFilesMap this$0;
                    final /* synthetic */ File $file$inlined;
                    {
                        this.$it = file2;
                        this.this$0 = sourceToOutputFilesMap;
                        this.$file$inlined = file3;
                        super(0);
                    }

                    public final String invoke() {
                        return "Deleting " + this.$it + " on clearing cache for " + this.$file$inlined;
                    }
                });
                it.delete();
            }
            LazyStorage lazyStorage = this.getStorage();
            String string = file2.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull(string, "file.absolutePath");
            lazyStorage.remove(string);
        }

        public SourceToOutputFilesMap(@NotNull File storageFile) {
            Intrinsics.checkParameterIsNotNull(storageFile, "storageFile");
            super(storageFile, PathStringDescriptor.INSTANCE, (DataExternalizer)StringCollectionExternalizer.INSTANCE);
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/incremental/GradleIncrementalCacheImpl$Companion;", "", "()V", "SOURCE_SNAPSHOTS", "", "getSOURCE_SNAPSHOTS", "()Ljava/lang/String;", "SOURCE_TO_OUTPUT_FILES", "getSOURCE_TO_OUTPUT_FILES", "kotlin-compiler"})
    public static final class Companion {
        private final String getSOURCE_TO_OUTPUT_FILES() {
            return SOURCE_TO_OUTPUT_FILES;
        }

        private final String getSOURCE_SNAPSHOTS() {
            return SOURCE_SNAPSHOTS;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

